;################################################################################
;#										#
;# UPROG2 universal programmer for linux					#
;#										#
;# copyright (c) 2012-2016 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

prg_exec_jtab1:	jmp	prg_exec_e1		;code 00 unknown
		jmp	avr_init		;code 01 AVR init
		jmp	avr_setfast		;code 02 AVR set SPI speed to fast
		jmp	avr_readid		;code 03 AVR read ID and fuses
		jmp	avr_merase		;code 04 AVR mass erase
		jmp	avr_fprog		;code 05 AVR program flash
		jmp	avr_fread		;code 06 AVR read flash
		jmp	avr_eprog		;code 07 AVR program EEPROM
		jmp	avr_eread		;code 08 AVR read EEPROM
		jmp	avr_wfuse_l		;code 09 AVR write LOW fuse
		jmp	avr_wfuse_h		;code 0a AVR write HIGH fuse
		jmp	avr_wfuse_e		;code 0b AVR write EXT fuse
		jmp	avr_wlock		;code 0c AVR write lock bits
		jmp	avr_exit		;code 0d AVR exit
		jmp	start_device		;code 0e start device
		jmp	stop_device		;code 0f stop device

		jmp	init_bdm		;code 10 BDM entry
		jmp	exit_bdm		;code 11 BDM exit
		jmp	s08_fdiv		;code 12 set clock divider
		jmp	s08_exec		;code 13 exec
		jmp	s08_merase		;code 14 mass erase
		jmp	s08_unsecure		;code 15 unsecure
		jmp	s08_prog		;code 16 program
		jmp	s08_read		;code 17 read
		jmp	s08_write		;code 18 write non flash memory
		jmp	prg_exec_e2		;code 19 reserved command
		jmp	prg_exec_e2		;code 1a reserved command
		jmp	prg_exec_e2		;code 1b reserved command
		jmp	prg_exec_e2		;code 1c reserved command
		jmp	prg_exec_e2		;code 1d reserved command
		jmp	prg_exec_e1		;code 1e unknown
		jmp	bdm_setfreq		;code 1f re-init BDM

		jmp	r8c_init		;code 20 R8C init and read BL version
		jmp	r8c_exec		;code 21 R8C exec code
		jmp	r8c_unlock		;code 22 R8C unlock
		jmp	r8c_exit		;code 23 R8C progmode exit
		jmp	r8c_prog		;code 24 R8C program
		jmp	r8c_read		;code 25 R8C read
		jmp	r8c_erase		;code 26 R8C erase blocks
		jmp	r8c_blank		;code 27 R8C blank check device
		jmp	r8c_version		;code 28 R8C get BL version
		jmp	prg_exec_e2		;code 29 reserved command
		jmp	prg_exec_e2		;code 2a reserved command
		jmp	s08_trim		;code 2b BDM sync pulse measure
		jmp	sercomm1		;code 2c sercomm 9K6
		jmp	sercomm2		;code 2d sercomm 38K4
		jmp	sercomm3		;code 2e sercomm 115K
		jmp	sercomm4		;code 2f sercomm 500k

		jmp	s12xd_fdiv		;code 30 s12xd set fclkdiv
		jmp	s12x_exec		;code 31 s12 exec in RAM
		jmp	s12x_execw		;code 32 s12 exec in RAM and wait for end
		jmp	s12xd_merase		;code 33 s12xd FLASH erase
		jmp	s12xd_unsec		;code 34 s12xd unsecure
		jmp	s12xd_fprog		;code 35 s12xd program 1k flash
		jmp	s12xd_eprog		;code 36 s12xd program 1k EEPROM
		jmp	s12xd_read		;code 37 s12xd read 1k memory
		jmp	s12xd_eerase		;code 38 s12xd erase EEPROM
		jmp	s12x_active		;code 39 s12 goto active bdm mode
		jmp	s12x_wram		;code 3a s12xd write to RAM
		jmp	s12xd_setpll		;code 3b s12xd set PLL
		jmp	s12xd_read_eep		;code 3c s12xd read 1K EEPROM memory page
		jmp	r8c_exec2		;code 3d R8C transfer first block to exec
		jmp	r8c_exec3		;code 3e R8C transfer additional data to exec
		jmp	prg_exec_e2		;code 3f reserved command

		jmp	s12xe_fdiv		;code 40 s12xe set fclkdiv
		jmp	prg_exec_e1		;code 41 unknown
		jmp	prg_exec_e1		;code 42 unknown
		jmp	s12xe_erase		;code 43 s12xe mass erase
		jmp	s12xe_unsec		;code 44 s12xe unsecure
		jmp	s12xe_pprog		;code 45 s12xe program PFLASH
		jmp	s12xe_read		;code 46 s12xe read memory
		jmp	prg_exec_e1		;code 47 unknown
		jmp	s12xe_dprog		;code 48 s12xe program DFLASH
		jmp	prg_exec_e1		;code 49 unknown
		jmp	prg_exec_e1		;code 4a unknown
		jmp	s12xe_setpll		;code 4b s12xe set PLL
		jmp	s12xe_merase		;code 4c s12xe main erase
		jmp	s12xe_derase		;code 4d s12xe dflash erase
		jmp	swd32_erase1		;code 4e erase STM32F0/F1/F2/F3
		jmp	swd32_readregs		;code 4f unknown

		jmp	init_swim		;code 50 STM8 SWIM init
		jmp	exit_swim		;code 51 STM8 SWIM exit
		jmp	swim_config		;code 52 configure SWIM and release reset
		jmp	swim_sequence		;code 53 SWIM do sequence
		jmp	swim_wram		;code 54 write data to STM8 RAM
		jmp	swim_exec		;code 55 exec STM8 CODE
		jmp	swim_read		;code 56 read data from STM8 memory
		jmp	prg_exec_e1		;code 57 unknown
		jmp	prg_exec_e1		;code 58 unknown
		jmp	swd32_cmd		;code 59 STM32 send command to bootcode
		jmp	init_icc		;code 5a ST7 ICC init (devices without ICCSEL)
		jmp	exit_icc		;code 5b ST7 ICC exit
		jmp	icc_write_mem		;code 5c ST7 ICC write to memory and exec
		jmp	prg_exec_e1		;code 5d unknown
		jmp	prg_exec_e1		;code 5e unknown
		jmp	rl78_getsec		;code 5f RL78 get security

		jmp	nec2_init		;code 60 NEC 78K0R init
		jmp	nec2_cerase		;code 61 NEC 78K0R mass erase
		jmp	nec2_berase		;code 62 NEC 78K0R block erase
		jmp	nec2_bprog		;code 63 NEC 78K0R block program
		jmp	nec2_bvfy		;code 64 NEC 78K0R block verify
		jmp	nec2_exit		;code 65 NEC 78K0R exit
		jmp	prg_exec_e2		;code 66 reserved command
		jmp	prg_exec_e2		;code 67 reserved command
		jmp	rl78_init		;code 68 RL78 init
		jmp	rl78_exit		;code 69 RL78 exit
		jmp	rl78_erase		;code 6a RL78 erase blocks
		jmp	rl78_bprog		;code 6b RL78 program block
		jmp	rl78_bvfy		;code 6c RL78 verify block
		jmp	rl78_secrel		;code 6d RL78 release security
		jmp	rl78_readsig		;code 6e RL78 read silicon signature
		jmp	rl78_bcheck		;code 6f RL78 blank check

		jmp	pic_hvinit		;code 70 init HV ICSP for PIC
		jmp	pic_hvexit		;code 71 exit HV ICSP mode
		jmp	pic1_readid		;code 72 read device ID
		jmp	pic1_merase		;code 73 pic16 mass erase
		jmp	pic1_perase		;code 74 pic16 program flash erase
		jmp	pic1_derase		;code 75 pic16 data flash erase
		jmp	pic1_pprog		;code 76 pic16 prog program flash (4-word)
		jmp	pic1_pread		;code 77 pic16 read program flash
		jmp	pic1_dprog		;code 78 pic16 prog data flash
		jmp	pic1_dread		;code 79 pic16 read data flash
		jmp	pic1_cprog		;code 7a pic16 prog user ID
		jmp	pic1_cread		;code 7b pic16 read user ID
		jmp	pic1_merase2		;code 7c pic16 bulk erase [2]
		jmp	pic1_perase2		;code 7d pic16 program flash erase [2]
		jmp	pic1_derase2		;code 7e pic16 data flash erase [2]
		jmp	pic1_pprog2		;code 7f pic16 prog program flash [2]

		jmp	pic1_dprog2		;code 80 pic16 prog data flash [2]
		jmp	pic1_cprog2		;code 81 pic16 prog user ID [2]
		jmp	pic2_init		;code 82 pic18/dspic init
		jmp	prg_exec_e1		;code 83 unknown
		jmp	icc_boot		;code 84 boot st7flite
		jmp	st7_fprog		;code 85 ST7FLITE0 prog flash
		jmp	st7_fread		;code 86 ST7FLITE0 read
		jmp	st7_eprog		;code 87 ST7FLITE0 prog eeprom
		jmp	st7_oprog		;code 88 ST7FLITE0 prog option bytes
		jmp	st7_oread		;code 89 ST7FLITE0 read option bytes
		jmp	pic2_erase		;code 8a PIC18 erase (div. modes)
		jmp	pic2_readf		;code 8b PIC18 readout (flash)
		jmp	pic2_reade		;code 8c PIC18 readout (eeprom)
		jmp	pic2_progf		;code 8d PIC18 flash program
		jmp	pic2_readb		;code 8e PIC18 read bytes (UID / config / ID)
		jmp	pic2_proge		;code 8f PIC18 eeprom program

		jmp	ppcbam_init		;code 90 init PPC ESCI BAM (8M)
		jmp	ppcbam_exit		;code 91 exit PPC ESCI BAM
		jmp	ppcbam_send		;code 92 PPC send boot data
		jmp	ppcbam_read		;code 93 PPC read
		jmp	ppcbam_cprog		;code 94 PPC prog CFLASH
		jmp	ppcbam_cerase		;code 95 PPC erase CFLASH
		jmp	ppcbam_dprog		;code 96 PPC prog DFLASH
		jmp	ppcbam_derase		;code 97 PPC erase DFLASH
		jmp	ppcbam_sprog		;code 98 PPC prog SHADOW
		jmp	ppcbam_serase		;code 99 PPC erase SHADOW
		jmp	swd32_exit_debug	;code 9a STM32 leave debug mode
		jmp	prg_exec_e1		;code 9b unknown
		jmp	prg_exec_e1		;code 9c unknown 
		jmp	prg_exec_e1		;code 9d unknown
		jmp	act_reset		;code 9e activate reset
		jmp	rel_reset		;code 9f release reset

		jmp	i2c_init		;code a0 I2C init
		jmp	i2c_exit		;code a1 I2C exit
		jmp	i2c_read		;code a2 I2C eeprom read
		jmp	i2c_write		;code a3 I2C eeprom write
		jmp	prg_exec_e1		;code a4 unknown
		jmp	prg_exec_e1		;code a5 unknown
		jmp	prg_exec_e2		;code a6 reserved command
		jmp	prg_exec_e2		;code a7 reserved command
		jmp	prg_exec_e2		;code a8 reserved command
		jmp	prg_exec_e2		;code a9 reserved command
		jmp	prg_exec_e2		;code aa reserved command
		jmp	prg_exec_e2		;code ab reserved command
		jmp	prg_exec_e2		;code ac reserved command
		jmp	prg_exec_e2		;code ad reserved command
		jmp	prg_exec_e2		;code ae reserved command
		jmp	prg_exec_e2		;code af reserved command

		jmp	pic2_progu		;code b0 PIC18 uid program
		jmp	pic2_progc		;code b1 PIC18 config program
		jmp	swd32_write		;code b2 STM32 write memory block
		jmp	swd32_go		;code b3 STM32 run code
		jmp	ccxx_init		;code b4 CC25xx init and read ID
		jmp	ccxx_cerase		;code b5 CC25xx erase chip
		jmp	ccxx_prog		;code b6 CC25xx program 1K
		jmp	ccxx_read		;code b7 CC25xx read 1K
		jmp	psoc4_init		;code b8 SWD init and read ID
		jmp	psoc4_check_sid		;code b9 SWD check silicon ID
		jmp	psoc4_unprot		;code ba SWD unprotect
		jmp	psoc4_erase		;code bb SWD erase
		jmp	psoc4_readout		;code bc SWD readout
		jmp	psoc4_prog		;code bd SWD prog
		jmp	swd32_init		;code be STM32 init SWD
		jmp	swd32_read		;code bf STM32 read memory block

		jmp	dspic_init		;code c0 dspic33 init
		jmp	dspic_exit		;code c1 dspic33 exit
		jmp	dspic_readid		;code c2 dspic33 read device + app ID
		jmp	dspic_exera		;code c3 dspic33 erase executive memory
		jmp	dspic_exprog		;code c4 dspic33 program executive memory
		jmp	psoc4_protect		;code c5 PSOC4 set to protected mode
		jmp	dspic_erall		;code c6 dspic33 erase all
		jmp	dspic_defconf		;code c7 dspic33 set config registers to default value
		jmp	dspic_einit		;code c8 dspic33 init in EICSP-mode
		jmp	dspic_scheck		;code c9 dspic33 EICSP sanity check
		jmp	dspic_eraseb		;code ca dspic33 EICSP bulk erase
		jmp	dspic_progp2		;code cb dspic33 EICSP program flash
		jmp	dspic_progc		;code cc dspic33 EICSP program config
		jmp	dspic_readp		;code cd dspic33 EICSP read flash
		jmp	dspic_readc		;code ce dspic33 EICSP read config
		jmp	dspic_qblank		;code cf dspic33 EICSP blank check

		jmp	sbw_init2		;code d0 init MSP430F5/6 for sbw
		jmp	sbw_exit1		;code d1 exit sbw
		jmp	sbw_read2		;code d2 read memory from MSP430F5/6
		jmp	sbw_bwrite2		;code d3 write memory for MSP430F5/6 (bytes)
		jmp	sbw_wwrite2		;code d4 write memory for MSP430F5/6 (words)
		jmp	sbw_run2		;code d5 run code for MSP430F5/6
		jmp	prg_exec_e1		;code d6 main erase for MSP430F5/6
		jmp	prg_exec_e1		;code d7 flash for MSP430F5/6
		jmp	sbw_init1		;code d8 init MSP430F1/2/3/4 for sbw
		jmp	sbw_exit1		;code d9 exit sbw
		jmp	sbw_read1		;code da read memory from MSP430F1/2/3/4
		jmp	sbw_bwrite1		;code db write memory for MSP430F1/2/3/4 (bytes)
		jmp	sbw_wwrite1		;code dc write memory for MSP430F1/2/3/4 (words)
		jmp	sbw_run1		;code dd run code for MSP430F1/2/3/4
		jmp	sbw_erase1		;code de main erase for MSP430F1/2/3/4
		jmp	sbw_flash1		;code df flash for MSP430F1/2/3/4

		jmp	prg_exec_e2		;code e0 reserved command
		jmp	prg_exec_e2		;code e1 reserved command
		jmp	prg_exec_e2		;code e2 reserved command
		jmp	prg_exec_e2		;code e3 reserved command
		jmp	prg_exec_e2		;code e4 reserved command
		jmp	prg_exec_e2		;code e5 reserved command
		jmp	prg_exec_e2		;code e6 reserved command
		jmp	prg_exec_e2		;code e7 reserved command
		jmp	prg_exec_e2		;code e8 reserved command
		jmp	prg_exec_e2		;code e9 reserved command
		jmp	prg_exec_e2		;code ea reserved command
		jmp	prg_exec_e2		;code eb reserved command
		jmp	prg_exec_e2		;code ec reserved command
		jmp	prg_exec_e2		;code ed reserved command
		jmp	prg_exec_e1		;code ee unknown
		jmp	prg_exec_e1		;code ef unknown

		.db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		.db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

prg_exec_jtab2:
		jmp	spiflash_init		;code 00
		jmp	spiflash_exit		;code 01
		jmp	spiflash_read		;code 02 read spi flash 
		jmp	spiflash_write		;code 03 write spi flash
		jmp	spiflash_erase_bulk	;code 04 erase SPI flash
		jmp	spiflash_getstat	;code 05 get code protection etc
		jmp	spiflash_setstat	;code 06 set code protection etc
		jmp	spiflash_set_bank	;code 07 set bank (for devices > 16M)
		jmp	xc9500_erase		;code 08 XC9500 erase
		jmp	xc9500xl_erase		;code 09 XC9500XL erase
		jmp	xc9500_prog_start	;code 0a XC9500 start program
		jmp	xc9500_prog		;code 0b XC9500 program block
		jmp	xc9500_prog_end		;code 0c XC9500 end program
		jmp	xc9500_init		;code 0d XC9500 init JTAG and get device ID
		jmp	xc9500_exit		;code 0e XC9500 exit
		jmp	prg_exec_e1		;code 0f UNKNOWN

		jmp	dataflash_init		;code 10 atmel dataflash init
		jmp	dataflash_exit		;code 11 atmel dataflash exit
		jmp	dataflash_read		;code 12 atmel dataflash read pages
		jmp	dataflash_write		;code 13 atmel dataflash program pages
		jmp	dataflash_erase		;code 14 atmel dataflash erase
		jmp	dataflash_getstat	;code 15 atmel dataflash get status
		jmp	dataflash_param		;code 16 atmel dataflash set page parameters (size)
		jmp	dataflash_fread		;code 17 atmel dataflash read full pages
		jmp	dataflash_fwrite	;code 18 atmel dataflash program full pages
		jmp	prg_exec_e1		;code 19 unknown
		jmp	xc9500xl_prog_start	;code 1a XC9500 start program
		jmp	xc9500xl_prog		;code 1b XC9500 program block
		jmp	xc9500xl_prog_end	;code 1c XC9500 end program
		jmp	prg_exec_e1		;code 1d unknown
		jmp	prg_exec_e1		;code 1e unknown
		jmp	r8c_lock		;code 1f r8c read/write lock

		jmp	prg_exec_e1		;code 20 unknown
		jmp	prg_exec_e1		;code 21 unknown
		jmp	prg_exec_e1		;code 22 unknown
		jmp	prg_exec_e1		;code 23 unknown
		jmp	prg_exec_e1		;code 24 unknown
		jmp	prg_exec_e1		;code 25 unknown
		jmp	prg_exec_e1		;code 26 unknown
		jmp	prg_exec_e1		;code 27 unknown
		jmp	swd32_prepare		;code 28 STM32 write SP/PC
		jmp	swd32_step		;code 29 STM32 single step
		jmp	swd32_readregs		;code 2a STM32 read registers
		jmp	swd32_sgo		;code 2b STM32 run
		jmp	prg_exec_e1		;code 2c unknown
		jmp	prg_exec_e1		;code 2d unknown
		jmp	prg_exec_e1		;code 2e unknown
		jmp	prg_exec_e1		;code 2f unknown

		jmp	pdi_init		;code 30 pdi init
		jmp	prg_exec_e1		;code 31 pdi re-init
		jmp	pdi_exit		;code 32 pdi exit
		jmp	pdi_read_mem		;code 33 pdi read memory
		jmp	pdi_read_fuses		;code 34 pdi read fuses
		jmp	prg_exec_e1		;code 35 pdi chip erase
		jmp	pdi_erase_main		;code 36 pdi appl erase
		jmp	pdi_erase_boot		;code 37 pdi boot erase
		jmp	pdi_erase_eeprom	;code 38 pdi eeprom erase
		jmp	prg_exec_e1		;code 39 pdi usersig erase
		jmp	pdi_prog_main		;code 3a pdi prog appl. flash
		jmp	pdi_prog_boot		;code 3b pdi prog boot section
		jmp	pdi_prog_eeprom		;code 3c unknown
		jmp	prg_exec_e1		;code 3d unknown
		jmp	pdi_prog_fuse		;code 3e unknown
		jmp	prg_exec_e1		;code 3f unknown

		jmp	prg_exec_e1		;code 40 unknown
		jmp	prg_exec_e1		;code 41 unknown
		jmp	prg_exec_e1		;code 42 unknown
		jmp	prg_exec_e1		;code 43 unknown
		jmp	prg_exec_e1		;code 44 unknown
		jmp	prg_exec_e1		;code 45 unknown
		jmp	prg_exec_e1		;code 46 unknown
		jmp	prg_exec_e1		;code 47 unknown
		jmp	prg_exec_e1		;code 48 unknown
		jmp	prg_exec_e1		;code 49 unknown
		jmp	prg_exec_e1		;code 4a unknown
		jmp	prg_exec_e1		;code 4b unknown
		jmp	prg_exec_e1		;code 4c unknown
		jmp	prg_exec_e1		;code 4d unknown
		jmp	prg_exec_e1		;code 4e unknown
		jmp	prg_exec_e1		;code 4f unknown

		jmp	prg_exec_e1		;code 50 unknown
		jmp	prg_exec_e1		;code 51 unknown
		jmp	prg_exec_e1		;code 52 unknown
		jmp	prg_exec_e1		;code 53 unknown
		jmp	prg_exec_e1		;code 54 unknown
		jmp	prg_exec_e1		;code 55 unknown
		jmp	prg_exec_e1		;code 56 unknown
		jmp	prg_exec_e1		;code 57 unknown
		jmp	prg_exec_e1		;code 58 unknown
		jmp	prg_exec_e1		;code 59 unknown
		jmp	prg_exec_e1		;code 5a unknown
		jmp	prg_exec_e1		;code 5b unknown
		jmp	prg_exec_e1		;code 5c unknown
		jmp	prg_exec_e1		;code 5d unknown
		jmp	prg_exec_e1		;code 5e unknown
		jmp	prg_exec_e1		;code 5f unknown

		jmp	prg_exec_e1		;code 60 unknown
		jmp	prg_exec_e1		;code 61 unknown
		jmp	prg_exec_e1		;code 62 unknown
		jmp	prg_exec_e1		;code 63 unknown
		jmp	prg_exec_e1		;code 64 unknown
		jmp	prg_exec_e1		;code 65 unknown
		jmp	prg_exec_e1		;code 66 unknown
		jmp	prg_exec_e1		;code 67 unknown
		jmp	prg_exec_e1		;code 68 unknown
		jmp	prg_exec_e1		;code 69 unknown
		jmp	prg_exec_e1		;code 6a unknown
		jmp	prg_exec_e1		;code 6b unknown
		jmp	prg_exec_e1		;code 6c unknown
		jmp	prg_exec_e1		;code 6d unknown
		jmp	prg_exec_e1		;code 6e unknown
		jmp	prg_exec_e1		;code 6f unknown

		jmp	prg_exec_e1		;code 70 unknown
		jmp	prg_exec_e1		;code 71 unknown
		jmp	prg_exec_e1		;code 72 unknown
		jmp	prg_exec_e1		;code 73 unknown
		jmp	prg_exec_e1		;code 74 unknown
		jmp	prg_exec_e1		;code 75 unknown
		jmp	prg_exec_e1		;code 76 unknown
		jmp	prg_exec_e1		;code 77 unknown
		jmp	prg_exec_e1		;code 78 unknown
		jmp	prg_exec_e1		;code 79 unknown
		jmp	prg_exec_e1		;code 7a unknown
		jmp	prg_exec_e1		;code 7b unknown
		jmp	prg_exec_e1		;code 7c unknown
		jmp	prg_exec_e1		;code 7d unknown
		jmp	prg_exec_e1		;code 7e unknown
		jmp	prg_exec_e1		;code 7f unknown

		jmp	prg_exec_e1		;code 80 unknown
		jmp	prg_exec_e1		;code 81 unknown
		jmp	prg_exec_e1		;code 82 unknown
		jmp	prg_exec_e1		;code 83 unknown
		jmp	prg_exec_e1		;code 84 unknown
		jmp	prg_exec_e1		;code 85 unknown
		jmp	prg_exec_e1		;code 86 unknown
		jmp	prg_exec_e1		;code 87 unknown
		jmp	prg_exec_e1		;code 88 unknown
		jmp	prg_exec_e1		;code 89 unknown
		jmp	prg_exec_e1		;code 8a unknown
		jmp	prg_exec_e1		;code 8b unknown
		jmp	prg_exec_e1		;code 8c unknown
		jmp	prg_exec_e1		;code 8d unknown
		jmp	prg_exec_e1		;code 8e unknown
		jmp	prg_exec_e1		;code 8f unknown

		jmp	prg_exec_e1		;code 90 unknown
		jmp	prg_exec_e1		;code 91 unknown
		jmp	prg_exec_e1		;code 92 unknown
		jmp	prg_exec_e1		;code 93 unknown
		jmp	prg_exec_e1		;code 94 unknown
		jmp	prg_exec_e1		;code 95 unknown
		jmp	prg_exec_e1		;code 96 unknown
		jmp	prg_exec_e1		;code 97 unknown
		jmp	prg_exec_e1		;code 98 unknown
		jmp	prg_exec_e1		;code 99 unknown
		jmp	prg_exec_e1		;code 9a unknown
		jmp	prg_exec_e1		;code 9b unknown
		jmp	prg_exec_e1		;code 9c unknown
		jmp	prg_exec_e1		;code 9d unknown
		jmp	prg_exec_e1		;code 9e unknown
		jmp	prg_exec_e1		;code 9f unknown

		jmp	prg_exec_e1		;code a0 unknown
		jmp	prg_exec_e1		;code a1 unknown
		jmp	prg_exec_e1		;code a2 unknown
		jmp	prg_exec_e1		;code a3 unknown
		jmp	prg_exec_e1		;code a4 unknown
		jmp	prg_exec_e1		;code a5 unknown
		jmp	prg_exec_e1		;code a6 unknown
		jmp	prg_exec_e1		;code a7 unknown
		jmp	prg_exec_e1		;code a8 unknown
		jmp	prg_exec_e1		;code a9 unknown
		jmp	prg_exec_e1		;code aa unknown
		jmp	prg_exec_e1		;code ab unknown
		jmp	prg_exec_e1		;code ac unknown
		jmp	prg_exec_e1		;code ad unknown
		jmp	prg_exec_e1		;code ae unknown
		jmp	prg_exec_e1		;code af unknown

		jmp	prg_exec_e1		;code b0 unknown
		jmp	prg_exec_e1		;code b1 unknown
		jmp	prg_exec_e1		;code b2 unknown
		jmp	prg_exec_e1		;code b3 unknown
		jmp	prg_exec_e1		;code b4 unknown
		jmp	prg_exec_e1		;code b5 unknown
		jmp	prg_exec_e1		;code b6 unknown
		jmp	prg_exec_e1		;code b7 unknown
		jmp	prg_exec_e1		;code b8 unknown
		jmp	prg_exec_e1		;code b9 unknown
		jmp	prg_exec_e1		;code ba unknown
		jmp	prg_exec_e1		;code bb unknown
		jmp	prg_exec_e1		;code bc unknown
		jmp	prg_exec_e1		;code bd unknown
		jmp	prg_exec_e1		;code be unknown
		jmp	prg_exec_e1		;code bf unknown

		jmp	prg_exec_e1		;code c0 unknown
		jmp	prg_exec_e1		;code c1 unknown
		jmp	prg_exec_e1		;code c2 unknown
		jmp	prg_exec_e1		;code c3 unknown
		jmp	prg_exec_e1		;code c4 unknown
		jmp	prg_exec_e1		;code c5 unknown
		jmp	prg_exec_e1		;code c6 unknown
		jmp	prg_exec_e1		;code c7 unknown
		jmp	prg_exec_e1		;code c8 unknown
		jmp	prg_exec_e1		;code c9 unknown
		jmp	prg_exec_e1		;code ca unknown
		jmp	prg_exec_e1		;code cb unknown
		jmp	prg_exec_e1		;code cc unknown
		jmp	prg_exec_e1		;code cd unknown
		jmp	prg_exec_e1		;code ce unknown
		jmp	prg_exec_e1		;code cf unknown

		jmp	prg_exec_e1		;code d0 unknown
		jmp	prg_exec_e1		;code d1 unknown
		jmp	prg_exec_e1		;code d2 unknown
		jmp	prg_exec_e1		;code d3 unknown
		jmp	prg_exec_e1		;code d4 unknown
		jmp	prg_exec_e1		;code d5 unknown
		jmp	prg_exec_e1		;code d6 unknown
		jmp	prg_exec_e1		;code d7 unknown
		jmp	prg_exec_e1		;code d8 unknown
		jmp	prg_exec_e1		;code d9 unknown
		jmp	prg_exec_e1		;code da unknown
		jmp	prg_exec_e1		;code db unknown
		jmp	prg_exec_e1		;code dc unknown
		jmp	prg_exec_e1		;code dd unknown
		jmp	prg_exec_e1		;code de unknown
		jmp	prg_exec_e1		;code df unknown

		jmp	prg_exec_e1		;code e0 unknown
		jmp	prg_exec_e1		;code e1 unknown
		jmp	prg_exec_e1		;code e2 unknown
		jmp	prg_exec_e1		;code e3 unknown
		jmp	prg_exec_e1		;code e4 unknown
		jmp	prg_exec_e1		;code e5 unknown
		jmp	prg_exec_e1		;code e6 unknown
		jmp	prg_exec_e1		;code e7 unknown
		jmp	prg_exec_e1		;code e8 unknown
		jmp	prg_exec_e1		;code e9 unknown
		jmp	prg_exec_e1		;code ea unknown
		jmp	prg_exec_e1		;code eb unknown
		jmp	prg_exec_e1		;code ec unknown
		jmp	prg_exec_e1		;code ed unknown
		jmp	prg_exec_e1		;code ee unknown
		jmp	prg_exec_e1		;code ef unknown


		.db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		.db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

prg_exec_jtab3:	jmp	prg_exec_e1		;code 00 unknown
		jmp	prg_exec_e1		;code 01 unknown
		jmp	prg_exec_e1		;code 02 unknown
		jmp	prg_exec_e1		;code 03 unknown
		jmp	prg_exec_e1		;code 04 unknown
		jmp	prg_exec_e1		;code 05 unknown
		jmp	prg_exec_e1		;code 06 unknown
		jmp	prg_exec_e1		;code 07 unknown
		jmp	prg_exec_e1		;code 08 unknown
		jmp	prg_exec_e1		;code 09 unknown
		jmp	prg_exec_e1		;code 0a unknown
		jmp	prg_exec_e1		;code 0b unknown
		jmp	prg_exec_e1		;code 0c unknown
		jmp	prg_exec_e1		;code 0d unknown
		jmp	prg_exec_e1		;code 0e unknown
		jmp	prg_exec_e1		;code 0f unknown

		jmp	prg_exec_e1		;code 10 unknown
		jmp	prg_exec_e1		;code 11 unknown
		jmp	prg_exec_e1		;code 12 unknown
		jmp	prg_exec_e1		;code 13 unknown
		jmp	prg_exec_e1		;code 14 unknown
		jmp	prg_exec_e1		;code 15 unknown
		jmp	prg_exec_e1		;code 16 unknown
		jmp	prg_exec_e1		;code 17 unknown
		jmp	prg_exec_e1		;code 18 unknown
		jmp	prg_exec_e1		;code 19 unknown
		jmp	prg_exec_e1		;code 1a unknown
		jmp	prg_exec_e1		;code 1b unknown
		jmp	prg_exec_e1		;code 1c unknown
		jmp	prg_exec_e1		;code 1d unknown
		jmp	prg_exec_e1		;code 1e unknown
		jmp	prg_exec_e1		;code 1f unknown

		jmp	prg_exec_e1		;code 20 unknown
		jmp	prg_exec_e1		;code 21 unknown
		jmp	prg_exec_e1		;code 22 unknown
		jmp	prg_exec_e1		;code 23 unknown
		jmp	prg_exec_e1		;code 24 unknown
		jmp	prg_exec_e1		;code 25 unknown
		jmp	prg_exec_e1		;code 26 unknown
		jmp	prg_exec_e1		;code 27 unknown
		jmp	prg_exec_e1		;code 28 unknown
		jmp	prg_exec_e1		;code 29 unknown
		jmp	prg_exec_e1		;code 2a unknown
		jmp	prg_exec_e1		;code 2b unknown
		jmp	prg_exec_e1		;code 2c unknown
		jmp	prg_exec_e1		;code 2d unknown
		jmp	prg_exec_e1		;code 2e unknown
		jmp	prg_exec_e1		;code 2f unknown

		jmp	prg_exec_e1		;code 30 unknown
		jmp	prg_exec_e1		;code 31 unknown
		jmp	prg_exec_e1		;code 32 unknown
		jmp	prg_exec_e1		;code 33 unknown
		jmp	prg_exec_e1		;code 34 unknown
		jmp	prg_exec_e1		;code 35 unknown
		jmp	prg_exec_e1		;code 36 unknown
		jmp	prg_exec_e1		;code 37 unknown
		jmp	prg_exec_e1		;code 38 unknown
		jmp	prg_exec_e1		;code 39 unknown
		jmp	prg_exec_e1		;code 3a unknown
		jmp	prg_exec_e1		;code 3b unknown
		jmp	prg_exec_e1		;code 3c unknown
		jmp	prg_exec_e1		;code 3d unknown
		jmp	prg_exec_e1		;code 3e unknown
		jmp	prg_exec_e1		;code 3f unknown

		jmp	prg_exec_e1		;code 40 unknown
		jmp	prg_exec_e1		;code 41 unknown
		jmp	prg_exec_e1		;code 42 unknown
		jmp	prg_exec_e1		;code 43 unknown
		jmp	prg_exec_e1		;code 44 unknown
		jmp	prg_exec_e1		;code 45 unknown
		jmp	prg_exec_e1		;code 46 unknown
		jmp	prg_exec_e1		;code 47 unknown
		jmp	prg_exec_e1		;code 48 unknown
		jmp	prg_exec_e1		;code 49 unknown
		jmp	prg_exec_e1		;code 4a unknown
		jmp	prg_exec_e1		;code 4b unknown
		jmp	prg_exec_e1		;code 4c unknown
		jmp	prg_exec_e1		;code 4d unknown
		jmp	prg_exec_e1		;code 4e unknown
		jmp	prg_exec_e1		;code 4f unknown

		jmp	prg_exec_e1		;code 50 unknown
		jmp	prg_exec_e1		;code 51 unknown
		jmp	prg_exec_e1		;code 52 unknown
		jmp	prg_exec_e1		;code 53 unknown
		jmp	prg_exec_e1		;code 54 unknown
		jmp	prg_exec_e1		;code 55 unknown
		jmp	prg_exec_e1		;code 56 unknown
		jmp	prg_exec_e1		;code 57 unknown
		jmp	prg_exec_e1		;code 58 unknown
		jmp	prg_exec_e1		;code 59 unknown
		jmp	prg_exec_e1		;code 5a unknown
		jmp	prg_exec_e1		;code 5b unknown
		jmp	prg_exec_e1		;code 5c unknown
		jmp	prg_exec_e1		;code 5d unknown
		jmp	prg_exec_e1		;code 5e unknown
		jmp	prg_exec_e1		;code 5f unknown

		jmp	prg_exec_e1		;code 60 unknown
		jmp	prg_exec_e1		;code 61 unknown
		jmp	prg_exec_e1		;code 62 unknown
		jmp	prg_exec_e1		;code 63 unknown
		jmp	prg_exec_e1		;code 64 unknown
		jmp	prg_exec_e1		;code 65 unknown
		jmp	prg_exec_e1		;code 66 unknown
		jmp	prg_exec_e1		;code 67 unknown
		jmp	prg_exec_e1		;code 68 unknown
		jmp	prg_exec_e1		;code 69 unknown
		jmp	prg_exec_e1		;code 6a unknown
		jmp	prg_exec_e1		;code 6b unknown
		jmp	prg_exec_e1		;code 6c unknown
		jmp	prg_exec_e1		;code 6d unknown
		jmp	prg_exec_e1		;code 6e unknown
		jmp	prg_exec_e1		;code 6f unknown

		jmp	prg_exec_e1		;code 70 unknown
		jmp	prg_exec_e1		;code 71 unknown
		jmp	prg_exec_e1		;code 72 unknown
		jmp	prg_exec_e1		;code 73 unknown
		jmp	prg_exec_e1		;code 74 unknown
		jmp	prg_exec_e1		;code 75 unknown
		jmp	prg_exec_e1		;code 76 unknown
		jmp	prg_exec_e1		;code 77 unknown
		jmp	prg_exec_e1		;code 78 unknown
		jmp	prg_exec_e1		;code 79 unknown
		jmp	prg_exec_e1		;code 7a unknown
		jmp	prg_exec_e1		;code 7b unknown
		jmp	prg_exec_e1		;code 7c unknown
		jmp	prg_exec_e1		;code 7d unknown
		jmp	prg_exec_e1		;code 7e unknown
		jmp	prg_exec_e1		;code 7f unknown

		jmp	prg_exec_e1		;code 80 unknown
		jmp	prg_exec_e1		;code 81 unknown
		jmp	prg_exec_e1		;code 82 unknown
		jmp	prg_exec_e1		;code 83 unknown
		jmp	prg_exec_e1		;code 84 unknown
		jmp	prg_exec_e1		;code 85 unknown
		jmp	prg_exec_e1		;code 86 unknown
		jmp	prg_exec_e1		;code 87 unknown
		jmp	prg_exec_e1		;code 88 unknown
		jmp	prg_exec_e1		;code 89 unknown
		jmp	prg_exec_e1		;code 8a unknown
		jmp	prg_exec_e1		;code 8b unknown
		jmp	prg_exec_e1		;code 8c unknown
		jmp	prg_exec_e1		;code 8d unknown
		jmp	prg_exec_e1		;code 8e unknown
		jmp	prg_exec_e1		;code 8f unknown

		jmp	prg_exec_e1		;code 90 unknown
		jmp	prg_exec_e1		;code 91 unknown
		jmp	prg_exec_e1		;code 92 unknown
		jmp	prg_exec_e1		;code 93 unknown
		jmp	prg_exec_e1		;code 94 unknown
		jmp	prg_exec_e1		;code 95 unknown
		jmp	prg_exec_e1		;code 96 unknown
		jmp	prg_exec_e1		;code 97 unknown
		jmp	prg_exec_e1		;code 98 unknown
		jmp	prg_exec_e1		;code 99 unknown
		jmp	prg_exec_e1		;code 9a unknown
		jmp	prg_exec_e1		;code 9b unknown
		jmp	prg_exec_e1		;code 9c unknown
		jmp	prg_exec_e1		;code 9d unknown
		jmp	prg_exec_e1		;code 9e unknown
		jmp	prg_exec_e1		;code 9f unknown

		jmp	prg_exec_e1		;code a0 unknown
		jmp	prg_exec_e1		;code a1 unknown
		jmp	prg_exec_e1		;code a2 unknown
		jmp	prg_exec_e1		;code a3 unknown
		jmp	prg_exec_e1		;code a4 unknown
		jmp	prg_exec_e1		;code a5 unknown
		jmp	prg_exec_e1		;code a6 unknown
		jmp	prg_exec_e1		;code a7 unknown
		jmp	prg_exec_e1		;code a8 unknown
		jmp	prg_exec_e1		;code a9 unknown
		jmp	prg_exec_e1		;code aa unknown
		jmp	prg_exec_e1		;code ab unknown
		jmp	prg_exec_e1		;code ac unknown
		jmp	prg_exec_e1		;code ad unknown
		jmp	prg_exec_e1		;code ae unknown
		jmp	prg_exec_e1		;code af unknown

		jmp	prg_exec_e1		;code b0 unknown
		jmp	prg_exec_e1		;code b1 unknown
		jmp	prg_exec_e1		;code b2 unknown
		jmp	prg_exec_e1		;code b3 unknown
		jmp	prg_exec_e1		;code b4 unknown
		jmp	prg_exec_e1		;code b5 unknown
		jmp	prg_exec_e1		;code b6 unknown
		jmp	prg_exec_e1		;code b7 unknown
		jmp	prg_exec_e1		;code b8 unknown
		jmp	prg_exec_e1		;code b9 unknown
		jmp	prg_exec_e1		;code ba unknown
		jmp	prg_exec_e1		;code bb unknown
		jmp	prg_exec_e1		;code bc unknown
		jmp	prg_exec_e1		;code bd unknown
		jmp	prg_exec_e1		;code be unknown
		jmp	prg_exec_e1		;code bf unknown

		jmp	prg_exec_e1		;code c0 unknown
		jmp	prg_exec_e1		;code c1 unknown
		jmp	prg_exec_e1		;code c2 unknown
		jmp	prg_exec_e1		;code c3 unknown
		jmp	prg_exec_e1		;code c4 unknown
		jmp	prg_exec_e1		;code c5 unknown
		jmp	prg_exec_e1		;code c6 unknown
		jmp	prg_exec_e1		;code c7 unknown
		jmp	prg_exec_e1		;code c8 unknown
		jmp	prg_exec_e1		;code c9 unknown
		jmp	prg_exec_e1		;code ca unknown
		jmp	prg_exec_e1		;code cb unknown
		jmp	prg_exec_e1		;code cc unknown
		jmp	prg_exec_e1		;code cd unknown
		jmp	prg_exec_e1		;code ce unknown
		jmp	prg_exec_e1		;code cf unknown

		jmp	prg_exec_e1		;code d0 unknown
		jmp	prg_exec_e1		;code d1 unknown
		jmp	prg_exec_e1		;code d2 unknown
		jmp	prg_exec_e1		;code d3 unknown
		jmp	prg_exec_e1		;code d4 unknown
		jmp	prg_exec_e1		;code d5 unknown
		jmp	prg_exec_e1		;code d6 unknown
		jmp	prg_exec_e1		;code d7 unknown
		jmp	prg_exec_e1		;code d8 unknown
		jmp	prg_exec_e1		;code d9 unknown
		jmp	prg_exec_e1		;code da unknown
		jmp	prg_exec_e1		;code db unknown
		jmp	prg_exec_e1		;code dc unknown
		jmp	prg_exec_e1		;code dd unknown
		jmp	prg_exec_e1		;code de unknown
		jmp	prg_exec_e1		;code df unknown

		jmp	prg_exec_e1		;code e0 unknown
		jmp	prg_exec_e1		;code e1 unknown
		jmp	prg_exec_e1		;code e2 unknown
		jmp	prg_exec_e1		;code e3 unknown
		jmp	prg_exec_e1		;code e4 unknown
		jmp	prg_exec_e1		;code e5 unknown
		jmp	prg_exec_e1		;code e6 unknown
		jmp	prg_exec_e1		;code e7 unknown
		jmp	prg_exec_e1		;code e8 unknown
		jmp	prg_exec_e1		;code e9 unknown
		jmp	prg_exec_e1		;code ea unknown
		jmp	prg_exec_e1		;code eb unknown
		jmp	prg_exec_e1		;code ec unknown
		jmp	prg_exec_e1		;code ed unknown
		jmp	prg_exec_e1		;code ee unknown
		jmp	prg_exec_e1		;code ef unknown

act_reset:	cbi	CTRLPORT,SIG1
		sbi	CTRLDDR,SIG1
		jmp	main_loop_ok

rel_reset:	sbi	CTRLPORT,SIG1
		cbi	CTRLDDR,SIG1
		jmp	main_loop_ok


;-------------------------------------------------------------------------------
; wait n*10us
;-------------------------------------------------------------------------------
prg_wait:	ldi	r16,35			;1
prg_wait_1:	dec	r16			;1
		brne	prg_wait_1		;1/2
		sbiw	XL,1			;2
		nop				;1 filling
		brne	prg_wait		;1/2
		ret


prg_exec_e0:	clr	r16				;no error occured
		jmp	main_loop

prg_exec_e1:	ldi	r16,0x01			;unknown command
		jmp	main_loop

prg_exec_e2:	ldi	r16,0x02			;reserved command
		jmp	main_loop

start_device:	in	XL,CTRLDDR
		andi	XL,0xc0
		or	XL,r16
		out	CTRLDDR,XL
		in	XL,CTRLPORT
		andi	XL,0xc0
		or	XL,r17
		out	CTRLPORT,XL
		call	api_vcc_on
		jmp	main_loop_ok

stop_device:	call	api_vcc_off
		in	XL,CTRLDDR
		andi	XL,0xc0
		out	CTRLDDR,XL
		in	XL,CTRLPORT
		andi	XL,0xc0
		out	CTRLPORT,XL
		jmp	main_loop_ok


