#################################################################################
#										#
# GTMICRO gigatron micro emulator						#
# copyright (c) 2018-2019 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
# This program is free software under the BSD 2-Clause License.			#
# See LICENSE file in main directory.						#
#										#
#################################################################################

		.section	.text,"ax"
		.thumb
		.syntax unified
		.cpu cortex-m4
		.globl jmp_table

# register usage:
#----------------
#
#	r0	serial input
#	r1	scratch
#	r2	scratch
#	r3	PC
#	r4	ACC
#	r5	YX
#	r6	ALU
#	r7	next opcode from fetch stage
#	r8	current D value
#	r9	pointer to branch table
#	r10	pointer to extout structure
#	r11	pointer to vout structure
#	r12	ram base address
#	r14	jumptable base

#-------------------------------------------------------------------------------
# NOP macros, for filling
#-------------------------------------------------------------------------------
.macro NOP1
		nop
.endm
.macro NOP2
		NOP1	
		NOP1	
.endm
.macro NOP3
		NOP2	
		NOP1		
.endm
.macro NOP4
		NOP3	
		NOP1	
.endm
.macro NOP5
		NOP4	
		NOP1	
.endm
.macro NOP6
		NOP5	
		NOP1	
.endm
.macro NOP7
		NOP6	
		NOP1	
.endm
.macro NOP8
		NOP7	
		NOP1	
.endm
.macro NOP9
		NOP8	
		NOP1	
.endm
.macro NOP10
		NOP9	
		NOP1	
.endm
.macro NOP11
		NOP10	
		NOP1	
.endm
.macro NOP12
		NOP11	
		NOP1	
.endm
.macro NOP13
		NOP12	
		NOP1	
.endm
.macro NOP14
		NOP13	
		NOP1	
.endm
.macro NOP15
		NOP14	
		NOP1	
.endm
.macro NOP16
		NOP15	
		NOP1	
.endm
.macro NOP17
		NOP16	
		NOP1	
.endm
.macro NOP18
		NOP17	
		NOP1	
.endm
.macro NOP19
		NOP18	
		NOP1	
.endm

#-------------------------------------------------------------------------------
# NOP macros for instruction timing
#-------------------------------------------------------------------------------
.macro NOP_I00
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I01
		nop.w
		nop.w
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I02
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I03
#		nop
#		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I04
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I05
		nop.w
		nop.w
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I06
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I07
#		nop
#		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I08
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I09
		nop.w
		nop.w
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I0A
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I0B
#		nop
#		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I0C
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I0D
		nop.w
		nop.w
		nop.w
		nop.w
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I0E
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I0F
#		nop
#		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm


.macro NOP_I10
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I11
		nop.w
		nop.w
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I12
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I13
#		nop
#		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I14
		nop.w
		nop.w
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I15
		nop.w
		nop.w
		nop
		nop
		nop
		nop
.endm

.macro NOP_I16
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I17
#		nop
#		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I18
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I19
		nop.w
		nop.w
		nop.w
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I1A
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I1B
#		nop
#		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I1C
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I1D
		nop.w
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I1E
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

.macro NOP_I1F
#		nop
#		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
.endm

#-------------------------------------------------------------------------------
# fetch next instruction
#-------------------------------------------------------------------------------	
.macro FETCHNEXT
		and	r8,r7,0xFF		// (1) copy current D
		mov.w	r1,r3,lsl #1		// (1) PC * 2
		add	r1,#0x20000000		// (1) add inage base
		ldrh	r7,[r1,#0]		// (1) fetch next instruction
		add.w	r3,r3,#1		// (1) increment PC
		bic.w	r3,r3,#0xFF0000		// (1) limit PC (clear bit 16..)
.endm	

.macro FETCHNEXT_BRA
		and	r8,r7,0xFF		// (1) copy current D
		mov.w	r1,r3,lsl #1		// (1) PC * 2
		add	r1,#0x20000000		// (1) add inage base
		ldrh	r7,[r1,#0]		// (1) fetch next
		and.w	r1,r3,#0xFF00		// (1) store High byte of old PC
		add.w	r3,r3,#1		// (1) increment PC
		bic.w	r3,r3,#0xFF0000		// (1) limit PC (clear bit 16..)
.endm	

#-------------------------------------------------------------------------------
# jump to next instruction
#-------------------------------------------------------------------------------	
.macro JUMPNEXT
		and.w	r2,r7,0xFF00		// (1) copy current instruction
		add	r2,r14
		bx	r2			// (2) jump to next cmd
.endm	

#-------------------------------------------------------------------------------
# get macros, dest is in r2
#-------------------------------------------------------------------------------
.macro LOAD_ACC
		and.w	r2,r4,0xFF		// (1)	scratch = acc
.endm

.macro LOAD_D
		and.w	r2,r8,0xFF		// (1)	scratch = d
.endm

.macro LOAD_IN		
		and.w	r2,r0,0x1FE		// (1)	scratch = d
		lsr	r2,#1
.endm

.macro LOAD_R0D
		and.w	r2,r8,0xFF		// (1)	scratch = d
		ldrb	r2,[r2,r12]		// (2)  scratch -> [scratch]
.endm

.macro LOAD_R0X
		and.w	r2,r5,0xFF		// (1)
		ldrb	r2,[r2,r12]		// (2)  scratch=mem
.endm

.macro LOAD_RYD
		and.w	r2,r5,0xFF00		// (1)
		add	r2,r8			// (1)
		ldrb	r2,[r2,r12]		// (2)  scratch=in
.endm

.macro LOAD_RYX	
		bic.w	r2,r5,0xFF0000		// (1)
		ldrb	r2,[r5,r12]		// (2)  scratch=mem
.endm

.macro LOAD_RYXP
		bic.w	r2,r5,0xFF0000		// (1)
		ldrb	r2,[r5,r12]		// (2)  scratch=mem
		and.w	r6,r5,0xFF00		// (1)	
		adds	r5,#1			// (1)
		ands	r5,r5,0xFF		// (1)
		add	r5,r6			// (1)
.endm

.macro LOAD_UNDF	
		movs	r2,#0xFF		// (1)  scratch=0xff
.endm


#-------------------------------------------------------------------------------
# store macros, source is in r6
#-------------------------------------------------------------------------------
.macro STORE_ACC
		and	r4,r6,0xFF		// (1)	-> ac
.endm

.macro STORE_X
		and	r6,r6,0x00FF		// (1)	-> ac
		and	r5,r5,0xFF00		// (1) clear x
		orr	r5,r6			// (1) add new x
.endm

.macro STORE_Y
		lsl	r6,8			// (1)	shift
		and	r6,r6,0xFF00		// (1) 
		and	r5,r5,0x00FF		// (1)
		orr	r5,r6			// (1)
.endm

.macro STORE_OUT
		strb	r6,[r11,#0x14]		// (2)	store to output register
.endm

.macro STORE_OUT_HS
		strb	r4,[r10,#0x14]		// (2)	refresh AC output
		ldr	r2,[r11,#0x10]		// (2)  get serial IN
		lsl	r0,#1			// (1)  shift IN register
		lsr	r2,#8			// (1)  shift data 
		bfi	r0,r2,0,1		// (1)  insert new bit
		strb	r6,[r11,#0x14]		// (2)	store to output register
.endm

.macro STORE_R0D
		and.w	r2,r8,0xFF		// (1)	scratch = d
		strb	r6,[r2,r12]		// (2)  result -> [scratch]
.endm

.macro STORE_R0X
		and.w	r2,r5,0xFF		// (1)	scratch = x
		strb	r6,[r2,r12]		// (2)  result -> [scratch]
.endm

.macro STORE_RYD
		and.w	r2,r5,0xFF00		// (1)
		add	r2,r8			// (1)
		strb	r6,[r2,r12]		// (2)  scratch=in
.endm

.macro STORE_RYX
		bic.w	r2,r5,0xFF0000		// (1)
		strb	r6,[r2,r12]		// (2)  scratch=mem
.endm


.macro STORE_RYXP
		bic.w	r2,r5,0xFF0000		// (1)
		strb	r6,[r2,r12]		// (2)  scratch=mem
		and.w	r2,r5,0xFF00		// (1)	save Y
		add	r5,#1			// (1)	reg++
		and	r5,r5,0xFF		// (1)  mask X
		add	r5,r2			// (1)  put together
.endm

#-------------------------------------------------------------------------------
# ALU macros
#-------------------------------------------------------------------------------
.macro	ALU_LD
		and.w	r6,r2,#0xff		// (1)
.endm

.macro	ALU_ANDA
		and.w	r6,r4,r2		// (1)
.endm

.macro	ALU_ORA
		orr	r6,r4,r2		// (1)
.endm

.macro	ALU_XORA
		eor	r6,r4,r2		// (1)
.endm

.macro	ALU_ADDA
		add	r6,r4,r2		// (1)
.endm

.macro	ALU_SUBA
		sub	r6,r4,r2		// (1)
.endm

#-------------------------------------------------------------------------------
# jump/branch macros
#-------------------------------------------------------------------------------
.macro SETJMP
		and.w	r3,r5,0xFF00		// (1)	Y
		orr	r3,r2			// (1)	LOW byte  
.endm

.macro SETBRANCH_BGT
		orr	r1,r2			// (1) new LOW byte, r1 is pc to branch 
		mov	r2,r4,lsl #4		// (1) 8 word entries per byte
		add	r2,#2			// (1) table offset	
		ldrh	r2,[r2,r9]		// (2) get table entry
		and	r3,r2			// (1) if table = 0xFFFF, use incremented PC
		mvn	r2,r2			// (1) invert mask
		and	r1,r2			// (1) if table = 0x0000, use branched PC
		orr	r3,r1			// (1) this is our new PC
.endm	

.macro SETBRANCH_BLT
		orr	r1,r2			// (1) new LOW byte, r1 is pc to branch
		mov	r2,r4,lsl #4		// (1) 8 word entries per byte
		add	r2,#4			// (1) table offset		
		ldrh	r2,[r2,r9]		// (2) get table entry
		and	r3,r2			// (1) if table = 0xFFFF, use incremented PC
		mvn	r2,r2			// (1) invert mask
		and	r1,r2			// (1) if table = 0x0000, use branched PC
		orr	r3,r1			// (1) this is our new PC
.endm	

.macro SETBRANCH_BNE	// 11 clocks
		orr	r1,r2			// (1) new LOW byte, r1 is pc to branch
		mov	r2,r4,lsl #4		// (1) 8 word entries per byte
		add	r2,#6			// (1) table offset		
		ldrh	r2,[r2,r9]		// (2) get table entry
		and	r3,r2			// (1) if table = 0xFFFF, use incremented PC
		mvn	r2,r2			// (1) invert mask
		and	r1,r2			// (1) if table = 0x0000, use branched PC
		orr	r3,r1			// (1) this is our new PC
.endm	


.macro SETBRANCH_BEQ	// 11 clocks
		orr	r1,r2			// (1) new LOW byte, r1 is pc to branch
		mov	r2,r4,lsl #4		// (1) 8 word entries per byte
		add	r2,#8			// (1) table offset		
		ldrh	r2,[r2,r9]		// (2) get table entry
		and	r3,r2			// (1) if table = 0xFFFF, use incremented PC
		mvn	r2,r2			// (1) invert mask
		and	r1,r2			// (1) if table = 0x0000, use branched PC
		orr	r3,r1			// (1) this is our new PC
.endm	


.macro SETBRANCH_BGE	// 11 clocks
		orr	r1,r2			// (1) new LOW byte, r1 is pc to branch
		mov	r2,r4,lsl #4		// (1) 8 word entries per byte
		add	r2,#10			// (1) table offset		
		ldrh	r2,[r2,r9]		// (2) get table entry
		and	r3,r2			// (1) if table = 0xFFFF, use incremented PC
		mvn	r2,r2			// (1) invert mask
		and	r1,r2			// (1) if table = 0x0000, use branched PC
		orr	r3,r1			// (1) this is our new PC
.endm	

.macro SETBRANCH_BLE	// 11 clocks
		orr	r1,r2			// (1) new LOW byte, r1 is pc to branch
		mov	r6,r4,lsl #4		// (1) 8 word entries per byte
		add	r6,#12			// (1) table offset		
		ldrh	r6,[r6,r9]		// (2) get table entry
		and	r3,r6			// (1) if table = 0xFFFF, use incremented PC
		mvn	r6,r6			// (1) invert mask
		and	r1,r6			// (1) if table = 0x0000, use branched PC
		orr	r3,r1			// (1) this is our new PC
.endm	

.macro SETBRANCH_BRA	// 11 clocks
		orr	r1,r2			// (1) new LOW byte, r1 is pc to branch
		mov	r2,r4,lsl #4		// (1) 8 word entries per byte
		add	r2,#14			// (1) table offset		
		ldrh	r2,[r2,r9]		// (2) get table entry
		and	r3,r2			// (1) if table = 0xFFFF, use incremented PC
		mvn	r2,r2			// (1) invert mask
		and	r1,r2			// (1) if table = 0x0000, use branched PC
		orr	r3,r1			// (1) this is our new PC
.endm	


################################################################################
# JUMP TABLE
################################################################################
			.align 15
#-------------------------------------------------------------------------------
# code 00 (ld $dd)
#-------------------------------------------------------------------------------	
jmp_table:
jmp_table_00:		FETCHNEXT
			NOP_I00
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)

#-------------------------------------------------------------------------------
# code 01 (ld [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_01:		FETCHNEXT
			NOP_I01
			LOAD_R0D		// (3)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 02 (ld ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_02:		FETCHNEXT
			NOP_I02						
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)

#-------------------------------------------------------------------------------
# code 03 (ld in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_03:		FETCHNEXT
			NOP_I03
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 04 (ld $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_04:		FETCHNEXT
			NOP_I04
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 05 (ld[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_05:		FETCHNEXT
			NOP_I05			
			LOAD_R0X		// (3)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 06 (ld ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_06:		FETCHNEXT
			NOP_I06						
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 07 (ld in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_07:		FETCHNEXT
			NOP_I07						
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 08 (ld $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_08:		FETCHNEXT
			NOP_I08
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 09 (ld [y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_09:		FETCHNEXT
			NOP_I09
			LOAD_RYD		// (4)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac			
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 0A (ld ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_0A:		FETCHNEXT
			NOP_I0A						
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 0B (ld in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_0B:		FETCHNEXT
			NOP_I0B						
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 0C (ld $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_0C:		FETCHNEXT
			NOP_I0C
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 0D (ld [y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_0D:		FETCHNEXT
			NOP_I0D
			LOAD_RYX		// (3)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 0E (ld ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_0E:		FETCHNEXT
			NOP_I0E						
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 0F (ld in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_0F:		FETCHNEXT
			NOP_I0F						
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT		// (X)

#-------------------------------------------------------------------------------
# code 10 (ld $dd,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_10:		FETCHNEXT
			NOP_I10
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_X			// (3)	-> x
 			JUMPNEXT		// (X)

#-------------------------------------------------------------------------------
# code 11 (ld [$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_11:		FETCHNEXT
			NOP_I11
			LOAD_R0D		// (3)
			ALU_LD			// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT		// (X)
		
#-------------------------------------------------------------------------------
# code 12 (ld ac,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_12:		FETCHNEXT
			NOP_I12						
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT		// (X)

#-------------------------------------------------------------------------------
# code 13 (ld in,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_13:		FETCHNEXT
			NOP_I13						
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 14 (ld $dd,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_14:		FETCHNEXT
			NOP_I14
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 15 (ld [$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_15:		FETCHNEXT
			NOP_I15
			LOAD_R0D		// (3)
			ALU_LD			// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 16 (ld ac,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_16:		FETCHNEXT
			NOP_I16						
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 17 (ld in,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_17:		FETCHNEXT
			NOP_I17						
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 18 (ld $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_18:		FETCHNEXT
			NOP_I18						
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 19 (ld [$dd],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_19:		FETCHNEXT
			NOP_I19
			LOAD_R0D		// (3)
			ALU_LD			// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 1A (ld ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_1A:		FETCHNEXT
			NOP_I1A
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 1B (ld in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_1B:		FETCHNEXT
			NOP_I1B
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 1C (ld $dd,out) with update of IN/OUT	(PATCH IN ROM IMAGE REQUIRED)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_1C:		FETCHNEXT
			nop
			nop
			nop
			nop
			nop						
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_OUT_HS		// (9)	-> out
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 1D (ld [$dd],out) with update of IN/OUT	(PATCH IN ROM IMAGE REQUIRED)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_1D:		FETCHNEXT
			nop
			nop
			nop
			LOAD_R0D		// (3)
			ALU_LD			// (1)
			STORE_OUT_HS		// (9) -> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 1E (ld ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_1E:		FETCHNEXT
			NOP_I1E						
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT		// (X)
	
#-------------------------------------------------------------------------------
# code 1F (ld in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_1F:		FETCHNEXT
			NOP_I1F						
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT		// (X)

#-------------------------------------------------------------------------------
# code 20 (anda $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_20:		FETCHNEXT
			NOP_I00
			LOAD_D			// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 21 (anda [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_21:		FETCHNEXT
			NOP_I01
			LOAD_R0D		// (3)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 22 (anda ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_22:		FETCHNEXT
			NOP_I02						
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 23 (anda in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_23:		FETCHNEXT
			NOP_I03
			LOAD_IN			// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 24 (anda $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_24:		FETCHNEXT
			NOP_I04
			LOAD_D			// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 25 (anda[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_25:		FETCHNEXT
			NOP_I05			
			LOAD_R0X		// (3)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 26 (anda ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_26:		FETCHNEXT
			NOP_I06						
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 27 (anda in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_27:		FETCHNEXT
			NOP_I07						
			LOAD_IN			// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 28 (anda $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_28:		FETCHNEXT
			NOP_I08
			LOAD_D			// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 29 (anda [y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_29:		FETCHNEXT
			NOP_I09
			LOAD_RYD		// (4)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac			
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 2A (anda ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_2A:		FETCHNEXT
			NOP_I0A						
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 2B (anda in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_2B:		FETCHNEXT
			NOP_I0B
			LOAD_IN			// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 2C (anda $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_2C:		FETCHNEXT
			NOP_I0C
			LOAD_D			// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 2D (anda [y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_2D:		FETCHNEXT
			NOP_I0D
			LOAD_RYX		// (2)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 2E (anda ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_2E:		FETCHNEXT
			NOP_I0E
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 2F (anda in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_2F:		FETCHNEXT
			NOP_I0F
			LOAD_IN			// (1)
			ALU_ANDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 30 (anda $dd,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_30:		FETCHNEXT
			NOP_I10
			LOAD_D			// (1)
			ALU_ANDA		// (1)
			STORE_X			// (3)	-> x
 			JUMPNEXT

#-------------------------------------------------------------------------------
# code 31 (anda [$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_31:		FETCHNEXT
			NOP_I11
			LOAD_R0D		// (3)
			ALU_ANDA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT
		
#-------------------------------------------------------------------------------
# code 32 (anda ac,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_32:		FETCHNEXT
			NOP_I12
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 33 (anda in,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_33:		FETCHNEXT
			NOP_I13
			LOAD_IN			// (1)
			ALU_ANDA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 34 (anda $dd,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_34:		FETCHNEXT
			NOP_I14
			LOAD_D			// (1)
			ALU_ANDA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 35 (anda [$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_35:		FETCHNEXT
			NOP_I15
			LOAD_R0D		// (3)
			ALU_ANDA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 36 (anda ac,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_36:		FETCHNEXT
			NOP_I16
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 37 (anda in,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_37:		FETCHNEXT
			NOP_I17
			LOAD_IN			// (1)
			ALU_ANDA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 38 (anda $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_38:		FETCHNEXT
			NOP_I18
			LOAD_D			// (1)
			ALU_ANDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 39 (anda [$dd],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_39:		FETCHNEXT
			NOP_I19
			LOAD_R0D		// (3)
			ALU_ANDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 3A (anda ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_3A:		FETCHNEXT
			NOP_I1A
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 3B (anda in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_3B:		FETCHNEXT
			NOP_I1B
			LOAD_IN			// (1)
			ALU_ANDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 3C (anda $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_3C:		FETCHNEXT
			NOP_I1C
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 3D (anda [y,x++],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_3D:		FETCHNEXT
			NOP_I1D
			LOAD_RYXP		// (6)
			ALU_ANDA		// (1)
			STORE_OUT		// (2)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 3E (anda ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_3E:		FETCHNEXT
			NOP_I1E
			LOAD_ACC		// (1)
			ALU_ANDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 3F (anda in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_3F:		FETCHNEXT
			NOP_I1F
			LOAD_IN			// (1)
			ALU_ANDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 40 (ora $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_40:		FETCHNEXT
			NOP_I00
			LOAD_D			// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 41 (ora [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_41:		FETCHNEXT
			NOP_I01
			LOAD_R0D		// (3)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 42 (ora ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_42:		FETCHNEXT
			NOP_I02
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 43 (ora in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_43:		FETCHNEXT
			NOP_I03
			LOAD_IN			// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 44 (ora $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_44:		FETCHNEXT
			NOP_I04
			LOAD_D			// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 45 (ora[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_45:		FETCHNEXT
			NOP_I05
			LOAD_R0X		// (3)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 46 (ora ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_46:		FETCHNEXT
			NOP_I06
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 47 (ora in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_47:		FETCHNEXT
			NOP_I07
			LOAD_IN			// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 48 (ora $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_48:		FETCHNEXT
			NOP_I08
			LOAD_D			// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 49 (ora [y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_49:		FETCHNEXT
			NOP_I09
			LOAD_RYD		// (4)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac			
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 4A (ora ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_4A:		FETCHNEXT
			NOP_I0A
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 4B (ora in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_4B:		FETCHNEXT
			NOP_I0B
			LOAD_IN			// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 4C (ora $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_4C:		FETCHNEXT
			NOP_I0C
			LOAD_D			// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 4D (ora [y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_4D:		FETCHNEXT
			NOP_I0D
			LOAD_RYX		// (2)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 4E (ora ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_4E:		FETCHNEXT
			NOP_I0E
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 4F (ora in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_4F:		FETCHNEXT
			NOP_I0F
			LOAD_IN			// (1)
			ALU_ORA			// (2)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 50 (ora $dd,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_50:		FETCHNEXT
			NOP_I10
			LOAD_D			// (1)
			ALU_ORA			// (2)
			STORE_X			// (3)	-> x
 			JUMPNEXT

#-------------------------------------------------------------------------------
# code 51 (ora [$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_51:		FETCHNEXT
			NOP_I11
			LOAD_R0D		// (3)
			ALU_ORA			// (2)
			STORE_X			// (3)	-> x
			JUMPNEXT
		
#-------------------------------------------------------------------------------
# code 52 (ora ac,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_52:		FETCHNEXT
			NOP_I12
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_X			// (3)	-> x
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 53 (ora in,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_53:		FETCHNEXT
			NOP_I13
			LOAD_IN			// (1)
			ALU_ORA			// (2)
			STORE_X			// (3)	-> x
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 54 (ora $dd,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_54:		FETCHNEXT
			NOP_I14
			LOAD_D			// (1)
			ALU_ORA			// (2)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 55 (ora [$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_55:		FETCHNEXT
			NOP_I15
			LOAD_R0D		// (3)
			ALU_ORA			// (2)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 56 (ora ac,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_56:		FETCHNEXT
			NOP_I16
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 57 (ora in,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_57:		FETCHNEXT
			NOP_I17
			LOAD_IN			// (1)
			ALU_ORA			// (2)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 58 (ora $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_58:		FETCHNEXT
			NOP_I18
			LOAD_D			// (1)
			ALU_ORA			// (2)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 59 (ora [$dd],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_59:		FETCHNEXT
			NOP_I19
			LOAD_R0D		// (3)
			ALU_ORA			// (2)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 5A (ora ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_5A:		FETCHNEXT
			NOP_I1A
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 5B (ora in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_5B:		FETCHNEXT
			NOP_I1B
			LOAD_IN			// (1)
			ALU_ORA			// (2)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 5C (ora $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_5C:		FETCHNEXT
			NOP_I1C
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 5D (ora [y,x++],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_5D:		FETCHNEXT
			NOP_I1D
			LOAD_RYXP		// (6)
			ALU_ORA			// (2)
			STORE_OUT		// (2)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 5E (ora ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_5E:		FETCHNEXT
			NOP_I1E
			LOAD_ACC		// (1)
			ALU_ORA			// (2)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 5F (ora in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_5F:		FETCHNEXT
			NOP_I1F
			LOAD_IN			// (1)
			ALU_ORA			// (2)
			STORE_OUT		// (2)	-> out
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 60 (xora $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_60:		FETCHNEXT
			NOP_I00
			LOAD_D			// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 61 (xora [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_61:		FETCHNEXT
			NOP_I01
			LOAD_R0D		// (3)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 62 (xora ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_62:		FETCHNEXT
			NOP_I02
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 63 (xora in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_63:		FETCHNEXT
			NOP_I03
			LOAD_IN			// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 64 (xora $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_64:		FETCHNEXT
			NOP_I04
			LOAD_D			// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 65 (xora[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_65:		FETCHNEXT
			NOP_I05
			LOAD_R0X		// (3)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 66 (xora ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_66:		FETCHNEXT
			NOP_I06
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 67 (xora in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_67:		FETCHNEXT
			NOP_I07
			LOAD_IN			// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 68 (xora $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_68:		FETCHNEXT
			NOP_I08
			LOAD_D			// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 69 (xora [y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_69:		FETCHNEXT
			NOP_I09
			LOAD_RYD		// (4)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac			
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 6A (xora ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_6A:		FETCHNEXT
			NOP_I0A
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 6B (xora in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_6B:		FETCHNEXT
			NOP_I0B
			LOAD_IN			// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 6C (xora $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_6C:		FETCHNEXT
			NOP_I0C
			LOAD_D			// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 6D (xora [y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_6D:		FETCHNEXT
			NOP_I0D
			LOAD_RYX		// (2)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 6E (xora ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_6E:		FETCHNEXT
			NOP_I0E
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 6F (xora in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_6F:		FETCHNEXT
			NOP_I0F
			LOAD_IN			// (1)
			ALU_XORA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 70 (xora $dd,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_70:		FETCHNEXT
			NOP_I10
			LOAD_D			// (1)
			ALU_XORA		// (1)
			STORE_X			// (3)	-> x
 			JUMPNEXT

#-------------------------------------------------------------------------------
# code 71 (xora [$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_71:		FETCHNEXT
			NOP_I11
			LOAD_R0D		// (3)
			ALU_XORA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT
		
#-------------------------------------------------------------------------------
# code 72 (xora ac,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_72:		FETCHNEXT
			NOP_I12
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 73 (xora in,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_73:		FETCHNEXT
			NOP_I13
			LOAD_IN			// (1)
			ALU_XORA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 74 (xora $dd,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_74:		FETCHNEXT
			NOP_I14
			LOAD_D			// (1)
			ALU_XORA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 75 (xora [$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_75:		FETCHNEXT
			NOP_I15
			LOAD_R0D		// (3)
			ALU_XORA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 76 (xora ac,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_76:		FETCHNEXT
			NOP_I16
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 77 (xora in,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_77:		FETCHNEXT
			NOP_I17
			LOAD_IN			// (1)
			ALU_XORA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 78 (xora $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_78:		FETCHNEXT
			NOP_I18
			LOAD_D			// (1)
			ALU_XORA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 79 (xora [$dd],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_79:		FETCHNEXT
			NOP_I19
			LOAD_R0D		// (3)
			ALU_XORA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 7A (xora ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_7A:		FETCHNEXT
			NOP_I1A
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 7B (xora in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_7B:		FETCHNEXT
			NOP_I1B
			LOAD_IN			// (1)
			ALU_XORA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 7C (xora $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_7C:		FETCHNEXT
			NOP_I1C
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 7D (xora [y,x++],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_7D:		FETCHNEXT
			NOP_I1D
			LOAD_RYXP		// (6)
			ALU_XORA		// (1)
			STORE_OUT		// (2)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 7E (xora ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_7E:		FETCHNEXT
			NOP_I1E
			LOAD_ACC		// (1)
			ALU_XORA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 7F (xora in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_7F:		FETCHNEXT
			NOP_I1F
			LOAD_IN			// (1)
			ALU_XORA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 80 (adda $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_80:		FETCHNEXT
			NOP_I00
			LOAD_D			// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 81 (adda [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_81:		FETCHNEXT
			NOP_I01
			LOAD_R0D		// (3)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 82 (adda ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_82:		FETCHNEXT
			NOP_I02
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 83 (adda in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_83:		FETCHNEXT
			NOP_I03
			LOAD_IN			// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 84 (adda $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_84:		FETCHNEXT
			NOP_I04
			LOAD_D			// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 85 (adda[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_85:		FETCHNEXT
			NOP_I05
			LOAD_R0X		// (3)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 86 (adda ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_86:		FETCHNEXT
			NOP_I06
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 87 (adda in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_87:		FETCHNEXT
			NOP_I07
			LOAD_IN			// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 88 (adda $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_88:		FETCHNEXT
			NOP_I08
			LOAD_D			// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 89 (adda [y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_89:		FETCHNEXT
			NOP_I09
			LOAD_RYD		// (4)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac			
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 8A (adda ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_8A:		FETCHNEXT
			NOP_I0A
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 8B (adda in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_8B:		FETCHNEXT
			NOP_I0B
			LOAD_IN			// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 8C (adda $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_8C:		FETCHNEXT
			NOP_I0C
			LOAD_D			// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 8D (adda [y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_8D:		FETCHNEXT
			NOP_I0D
			LOAD_RYX		// (2)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 8E (adda ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_8E:		FETCHNEXT
			NOP_I0E
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 8F (adda in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_8F:		FETCHNEXT
			NOP_I0F
			LOAD_IN			// (1)
			ALU_ADDA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 90 (adda $dd,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_90:		FETCHNEXT
			NOP_I10
			LOAD_D			// (1)
			ALU_ADDA		// (1)
			STORE_X			// (3)	-> x
 			JUMPNEXT

#-------------------------------------------------------------------------------
# code 91 (adda [$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_91:		FETCHNEXT
			NOP_I11
			LOAD_R0D		// (3)
			ALU_ADDA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT
		
#-------------------------------------------------------------------------------
# code 92 (adda ac,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_92:		FETCHNEXT
			NOP_I12
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT

#-------------------------------------------------------------------------------
# code 93 (adda in,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_93:		FETCHNEXT
			NOP_I13
			LOAD_IN			// (1)
			ALU_ADDA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 94 (adda $dd,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_94:		FETCHNEXT
			NOP_I14
			LOAD_D			// (1)
			ALU_ADDA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 95 (adda [$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_95:		FETCHNEXT
			NOP_I15
			LOAD_R0D		// (3)
			ALU_ADDA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 96 (adda ac,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_96:		FETCHNEXT
			NOP_I16
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 97 (adda in,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_97:		FETCHNEXT
			NOP_I17
			LOAD_IN			// (1)
			ALU_ADDA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 98 (adda $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_98:		FETCHNEXT
			NOP_I18
			LOAD_D			// (1)
			ALU_ADDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 99 (adda [$dd],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_99:		FETCHNEXT
			NOP_I19
			LOAD_R0D		// (3)
			ALU_ADDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 9A (adda ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_9A:		FETCHNEXT
			NOP_I1A
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 9B (adda in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_9B:		FETCHNEXT
			NOP_I1B
			LOAD_IN			// (1)
			ALU_ADDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 9C (adda $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_9C:		FETCHNEXT
			NOP_I1C
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 9D (adda [y,x++],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_9D:		FETCHNEXT
			NOP_I1D
			LOAD_RYXP		// (6)
			ALU_ADDA		// (1)
			STORE_OUT		// (2)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 9E (adda ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_9E:		FETCHNEXT
			NOP_I1E
			LOAD_ACC		// (1)
			ALU_ADDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code 9F (adda in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_9F:		FETCHNEXT
			NOP_I1F
			LOAD_IN			// (1)
			ALU_ADDA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT


#-------------------------------------------------------------------------------
# code A0 (suba $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A0:		FETCHNEXT
			NOP_I00
			LOAD_D			// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code A1 (suba [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A1:		FETCHNEXT
			NOP_I01
			LOAD_R0D		// (3)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code A2 (suba ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A2:		FETCHNEXT
			NOP_I02
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code A3 (suba in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A3:		FETCHNEXT
			NOP_I03
			LOAD_IN			// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code A4 (suba $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A4:		FETCHNEXT
			NOP_I04
			LOAD_D			// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code A5 (suba[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A5:		FETCHNEXT
			NOP_I05
			LOAD_R0X		// (3)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code A6 (suba ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A6:		FETCHNEXT
			NOP_I06
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code A7 (suba in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A7:		FETCHNEXT
			NOP_I07
			LOAD_IN			// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code A8 (suba $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A8:		FETCHNEXT
			NOP_I08
			LOAD_D			// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code A9 (suba [y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_A9:		FETCHNEXT
			NOP_I09
			LOAD_RYD		// (4)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac			
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code AA (suba ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_AA:		FETCHNEXT
			NOP_I0A
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code AB (suba in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_AB:		FETCHNEXT
			NOP_I0B
			LOAD_IN			// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code AC (suba $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_AC:		FETCHNEXT
			NOP_I0C
			LOAD_D			// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code AD (suba [y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_AD:		FETCHNEXT
			NOP_I0D
			LOAD_RYX		// (2)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code AE (suba ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_AE:		FETCHNEXT
			NOP_I0E
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code AF (suba in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_AF:		FETCHNEXT
			NOP_I0F
			LOAD_IN			// (1)
			ALU_SUBA		// (1)
			STORE_ACC		// (1)	-> ac
			JUMPNEXT

#-------------------------------------------------------------------------------
# code B0 (suba $dd,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B0:		FETCHNEXT
			NOP_I10
			LOAD_D			// (1)
			ALU_SUBA		// (1)
			STORE_X			// (3)	-> x
 			JUMPNEXT

#-------------------------------------------------------------------------------
# code B1 (suba [$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B1:		FETCHNEXT
			NOP_I11
			LOAD_R0D		// (3)
			ALU_SUBA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT
		
#-------------------------------------------------------------------------------
# code B2 (suba ac,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B2:		FETCHNEXT
			NOP_I12
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT

#-------------------------------------------------------------------------------
# code B3 (suba in,x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B3:		FETCHNEXT
			NOP_I13
			LOAD_IN			// (1)
			ALU_SUBA		// (1)
			STORE_X			// (3)	-> x
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code B4 (suba $dd,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B4:		FETCHNEXT
			NOP_I14
			LOAD_D			// (1)
			ALU_SUBA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code B5 (suba [$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B5:		FETCHNEXT
			NOP_I15
			LOAD_R0D		// (3)
			ALU_SUBA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code B6 (suba ac,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B6:		FETCHNEXT
			NOP_I16
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code B7 (suba in,y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B7:		FETCHNEXT
			NOP_I17
			LOAD_IN			// (1)
			ALU_SUBA		// (1)
			STORE_Y			// (4)	-> y
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code B8 (suba $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B8:		FETCHNEXT
			NOP_I18
			LOAD_D			// (1)
			ALU_SUBA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code B9 (suba [$dd],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_B9:		FETCHNEXT
			NOP_I19
			LOAD_R0D		// (3)
			ALU_SUBA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code BA (suba ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_BA:		FETCHNEXT
			NOP_I1A
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code BB (suba in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_BB:		FETCHNEXT
			NOP_I1B
			LOAD_IN			// (1)
			ALU_SUBA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code BC (suba $dd,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_BC:		FETCHNEXT
			NOP_I1C
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code BD (suba [y,x++],out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_BD:		FETCHNEXT
			NOP_I1D
			LOAD_RYXP		// (6)
			ALU_SUBA		// (1)
			STORE_OUT		// (2)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code BE (suba ac,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_BE:		FETCHNEXT
			NOP_I1E
			LOAD_ACC		// (1)
			ALU_SUBA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code BF (suba in,out)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_BF:		FETCHNEXT
			NOP_I1F
			LOAD_IN			// (1)
			ALU_SUBA		// (1)
			STORE_OUT		// (2)	-> out
			JUMPNEXT


#-------------------------------------------------------------------------------
# code C0 (st $dd,[$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C0:		FETCHNEXT
			NOP12
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
			JUMPNEXT

#-------------------------------------------------------------------------------
# code C1 (st undef,[$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C1:		FETCHNEXT
			NOP12
			LOAD_UNDF		// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
			JUMPNEXT
	
	
#-------------------------------------------------------------------------------
# code C2 (st [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C2:		FETCHNEXT
			NOP12
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
			JUMPNEXT

	
#-------------------------------------------------------------------------------
# code C3 (st in,[$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C3:		FETCHNEXT
			NOP12
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code C4 (st $dd,[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C4:		FETCHNEXT
			NOP12
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_R0X		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code C5 (st undef,[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C5:		FETCHNEXT
			NOP12
			LOAD_UNDF		// (1)
			ALU_LD			// (1)
			STORE_R0X		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code C6 (st ac,[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C6:		FETCHNEXT
			NOP12
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_R0X		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code C7 (st in,[x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C7:		FETCHNEXT
			NOP12
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_R0X		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code C8 (st $dd,[y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C8:		FETCHNEXT
			NOP11
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_RYD		// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code C9 (st undef,[y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_C9:		FETCHNEXT
			NOP11
			LOAD_UNDF		// (1)
			ALU_LD			// (1)
			STORE_RYD		// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code CA (st ac,[y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_CA:		FETCHNEXT
			NOP11
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_RYD		// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code CB (st in,[y,$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_CB:		FETCHNEXT
			NOP11
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_RYD		// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code CC (st $dd,[y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_CC:		FETCHNEXT
			NOP12
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_RYX		// (2)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code CD (st undef,[y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_CD:		FETCHNEXT
			NOP12
			LOAD_UNDF		// (1)
			ALU_LD			// (1)
			STORE_RYX		// (2)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code CE (st ac,[y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_CE:		FETCHNEXT
			NOP12
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_RYX		// (2)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code CF (st in,[y,x])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_CF:		FETCHNEXT
			NOP12
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_RYX		// (2)
			JUMPNEXT

#-------------------------------------------------------------------------------
# code D0 (st $dd,[$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D0:		FETCHNEXT
			NOP8
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
 			STORE_X			// (3)
 			JUMPNEXT

#-------------------------------------------------------------------------------
# code D1 (st undef,[$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D1:		FETCHNEXT
			NOP8
			LOAD_UNDF		// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
 			STORE_X			// (3)
			JUMPNEXT
		
#-------------------------------------------------------------------------------
# code D2 (st ac,[$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D2:		FETCHNEXT
			NOP8
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
 			STORE_X			// (3)
			JUMPNEXT

#-------------------------------------------------------------------------------
# code D3 (st in,[$dd],x)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D3:		FETCHNEXT
			NOP8
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
 			STORE_X			// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code D4 (st $dd,[$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D4:		FETCHNEXT
			NOP6
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
 			STORE_Y			// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code D5 (st undef,[$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D5:		FETCHNEXT
			NOP6
			LOAD_UNDF		// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
 			STORE_Y			// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code D6 (st ac,[$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D6:		FETCHNEXT
			NOP6
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
 			STORE_Y			// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code D7 (st in,[$dd],y)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D7:		FETCHNEXT
			NOP6
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
 			STORE_Y			// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code D8 (st $dd,[$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D8:		FETCHNEXT
			NOP12
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code D9 (st undef,[$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_D9:		FETCHNEXT
			NOP12
			LOAD_UNDF		// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code DA (st ac,[$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_DA:		FETCHNEXT
			NOP12
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code DB (st in,[$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_DB:		FETCHNEXT
			NOP12
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_R0D		// (3)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code DC (st $dd,[y,x++])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_DC:		FETCHNEXT
			NOP7
			LOAD_D			// (1)
			ALU_LD			// (1)
			STORE_RYXP		// (6)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code DD (st undef,[y,x++])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_DD:		FETCHNEXT
			NOP7
			LOAD_UNDF		// (1)
			ALU_LD			// (1)
			STORE_RYXP		// (6)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code DE (st ac,[y,x++])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_DE:		FETCHNEXT
			NOP7
			LOAD_ACC		// (1)
			ALU_LD			// (1)
			STORE_RYXP		// (6)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code DF (st in,[y,x++])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_DF:		FETCHNEXT
			NOP7
			LOAD_IN			// (1)
			ALU_LD			// (1)
			STORE_RYXP		// (6)
			JUMPNEXT


#-------------------------------------------------------------------------------
# code E0 (jmp y,$dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E0:		FETCHNEXT
			NOP15
			LOAD_D			// (1)			
			SETJMP			// (4)
			JUMPNEXT

#-------------------------------------------------------------------------------
# code E1 (jmp y,[$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E1:		FETCHNEXT
			NOP11
			LOAD_R0D		// (3)
			SETJMP			// (4)
			nop
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code E2 (jmp y,ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E2:		FETCHNEXT
			NOP15
			LOAD_ACC		// (1)			
			SETJMP			// (4)
			JUMPNEXT

#-------------------------------------------------------------------------------
# code E3 (jmp y,in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E3:		FETCHNEXT
			NOP15
			LOAD_IN			// (1)			
			SETJMP			// (4)
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code E4 (bgt $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E4:		FETCHNEXT_BRA
			mov	r2,r8
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_E4_b		// is zero -> no branch						
			ands	r6,#0x80
			bne	jmp_table_E4_a		// is negative -> no branch					
			orr	r3,r1,r2
 			NOP7
			JUMPNEXT

			.align 6
jmp_table_E4_a:		NOP2
 			JUMPNEXT			// negative


			.align 6
jmp_table_E4_b:		NOP5
			JUMPNEXT			// zero
	
#-------------------------------------------------------------------------------
# code E5 (bgt [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E5:		FETCHNEXT_BRA
			ldrb	r2,[r8,r12]
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_E5_b		// is zero -> no branch						
			ands	r6,#0x80
			bne	jmp_table_E5_a		// is negative -> no branch					
			orr	r3,r1,r2
 			NOP6
			JUMPNEXT

			.align 6
jmp_table_E5_a:		NOP1
 			JUMPNEXT			// negative


			.align 6
jmp_table_E5_b:		NOP4
			JUMPNEXT			// tero
	
#-------------------------------------------------------------------------------
# code E6 (bgt ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E6:		FETCHNEXT_BRA
			mov	r2,r4
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_E6_b		// is zero -> no branch						
			ands	r6,#0x80
			bne	jmp_table_E6_a		// is negative -> no branch					
			orr	r3,r1,r2
 			NOP7
			JUMPNEXT

			.align 6
jmp_table_E6_a:		NOP2
 			JUMPNEXT

			.align 6
jmp_table_E6_b:		NOP5
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code E7 (bgt in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E7:		FETCHNEXT_BRA
			mov	r2,r0
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_E7_b		//is zero -> no branch						
			ands	r6,#0x80
			bne	jmp_table_E7_a		//is negative -> no branch					
			orr	r3,r1,r2
 			NOP7
			JUMPNEXT

			.align 6
jmp_table_E7_a:		NOP2
 			JUMPNEXT

			.align 6
jmp_table_E7_b:		NOP5
			JUMPNEXT

#-------------------------------------------------------------------------------
# code E8 (blt $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E8:		FETCHNEXT_BRA
			mov	r2,r8
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_E8_b		// is zero -> no branch						
			ands	r6,#0x80
			beq	jmp_table_E8_a		// is positive -> no branch					
			orr	r3,r1,r2
 			NOP7
 			JUMPNEXT

			.align 6
jmp_table_E8_a:		NOP2
 			JUMPNEXT			// positive


			.align 6			// zero
jmp_table_E8_b:		NOP5
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code E9 (blt [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_E9:		FETCHNEXT_BRA
			ldrb	r2,[r8,r12]
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_E9_b		// is zero -> no branch						
			ands	r6,#0x80
			beq	jmp_table_E9_a		// is positive -> no branch					
			orr	r3,r1,r2
 			NOP6
 			JUMPNEXT

			.align 6
jmp_table_E9_a:		NOP1
 			JUMPNEXT			// positive


			.align 6			// zero
jmp_table_E9_b:		NOP4
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code EA (blt ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_EA:		FETCHNEXT_BRA		// (10)
			mov	r2,r4
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_EA_b		// is zero -> no branch						
			ands	r6,#0x80
			beq	jmp_table_EA_a		// is positive -> no branch					
			orr	r3,r1,r2
 			NOP7
 			JUMPNEXT

			.align 6
jmp_table_EA_a:		NOP2
 			JUMPNEXT			// positive


			.align 6			// zero
jmp_table_EA_b:		NOP5
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code EB (blt in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_EB:		FETCHNEXT_BRA		// (10)
			mov	r2,r0
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_EB_b		// is zero -> no branch						
			ands	r6,#0x80
			beq	jmp_table_EB_a		// is positive -> no branch					
			orr	r3,r1,r2
 			NOP7
 			JUMPNEXT

			.align 6
jmp_table_EB_a:		NOP2
 			JUMPNEXT			// positive


			.align 6			// zero
jmp_table_EB_b:		NOP5
			JUMPNEXT

#-------------------------------------------------------------------------------
# code EC (bne $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_EC:		FETCHNEXT_BRA		// (10)
			mov	r2,r8
			mov	r6,r4		// get accu
			ands	r6,#0xFF
			bne	jmp_table_EC_a		//is zero						
			NOP12
 			JUMPNEXT

			.align 6
jmp_table_EC_a:		nop
			orr	r3,r1,r2
			nop
			nop
			nop
 			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code ED (bne [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_ED:		FETCHNEXT_BRA		// (10)
			ldrb	r2,[r8,r12]	// (2)  scratch -> [scratch]
			mov	r6,r4		// get accu
			ands	r6,#0xFF
			bne	jmp_table_ED_a		//is zero						
			NOP11
 			JUMPNEXT

			.align 6
jmp_table_ED_a:		nop
			orr	r3,r1,r2
			nop
			nop
 			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code EE (bne ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_EE:		FETCHNEXT_BRA		// (10)
			mov	r2,r4
			mov	r6,r4		// get accu
			ands	r6,#0xFF
			bne	jmp_table_EE_a		//is zero						
			NOP12
 			JUMPNEXT

			.align 6
jmp_table_EE_a:		nop
			orr	r3,r1,r2
			nop
			nop
			nop
 			JUMPNEXT
		
#-------------------------------------------------------------------------------
# code EF (bne in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_EF:		FETCHNEXT_BRA		// (10)
			mov	r2,r0
			mov	r6,r4		// get accu
			ands	r6,#0xFF
			bne	jmp_table_EF_a		//is zero						
			NOP12
 			JUMPNEXT

			.align 6
jmp_table_EF_a:		nop
			orr	r3,r1,r2
			nop
			nop
			nop
 			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code F0 (beq $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F0:		FETCHNEXT_BRA		// (10)
			mov	r2,r8
			mov	r6,r4		// get accu
			ands	r6,#0xFF
			beq	jmp_table_F0_a		//is zero						
			NOP12
 			JUMPNEXT

			.align 6
jmp_table_F0_a:		nop
			orr	r3,r1,r2
			nop
			nop
			nop
 			JUMPNEXT

#-------------------------------------------------------------------------------
# code F1 (beq [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F1:		FETCHNEXT_BRA		// (10)
			ldrb	r2,[r8,r12]	// (2)  scratch -> [scratch]
			mov	r6,r4		// get accu
			ands	r6,#0xFF
			beq	jmp_table_F1_a		//is zero						
			NOP11
 			JUMPNEXT

			.align 6
jmp_table_F1_a:		nop
			orr	r3,r1,r2
			nop
			nop
 			JUMPNEXT
		
#-------------------------------------------------------------------------------
# code F2 (beq ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F2:		FETCHNEXT_BRA		// (10)
			mov	r2,r4
			mov	r6,r4		// get accu
			ands	r6,#0xFF
			beq	jmp_table_F2_a		//is zero						
			NOP12
 			JUMPNEXT

			.align 6
jmp_table_F2_a:		nop
			orr	r3,r1,r2
			nop
			nop
			nop
 			JUMPNEXT

#-------------------------------------------------------------------------------
# code F3 (beq in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F3:		FETCHNEXT_BRA		// (10)
			mov	r2,r0
			mov	r6,r4		// get accu
			ands	r6,#0xFF
			beq	jmp_table_F3_a		//is zero						
			NOP12
 			JUMPNEXT

			.align 6
jmp_table_F3_a:		nop
			orr	r3,r1,r2
			nop
			nop
			nop
 			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code F4 (bge $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F4:		FETCHNEXT_BRA		// (10)
			mov	r2,r8
			mov	r6,r4			// get accu
			ands	r6,#0x80
			bne	jmp_table_F4_a		// is negative -> no branch					
			orr	r3,r1,r2
 			NOP11
 			JUMPNEXT

			.align 6
jmp_table_F4_a:		NOP5
 			JUMPNEXT			// positive
	
#-------------------------------------------------------------------------------
# code F5 (bge [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F5:		FETCHNEXT_BRA		// (10)
			ldrb	r2,[r8,r12]
			mov	r6,r4			// get accu
			ands	r6,#0x80
			bne	jmp_table_F5_a		// is negative -> no branch					
			orr	r3,r1,r2
 			NOP9
 			JUMPNEXT

			.align 6
jmp_table_F5_a:		NOP3
 			JUMPNEXT			// positive
	
#-------------------------------------------------------------------------------
# code F6 (bge ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F6:		FETCHNEXT_BRA		// (10)
			mov	r2,r4
			mov	r6,r4			// get accu
			ands	r6,#0x80
			bne	jmp_table_F6_a		// is negative -> no branch					
			orr	r3,r1,r2
 			NOP11
 			JUMPNEXT

			.align 6
jmp_table_F6_a:		NOP5
 			JUMPNEXT			// positive
	
#-------------------------------------------------------------------------------
# code F7 (bge in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F7:		FETCHNEXT_BRA		// (10)
			mov	r2,r0
			mov	r6,r4			// get accu
			ands	r6,#0x80
			bne	jmp_table_F7_a		// is negative -> no branch					
			orr	r3,r1,r2
 			NOP11
 			JUMPNEXT

			.align 6
jmp_table_F7_a:		NOP5
 			JUMPNEXT			// positive
	
#-------------------------------------------------------------------------------
# code F8 (ble $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F8:		FETCHNEXT_BRA		// (10)
			mov	r2,r8
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_F8_b		// is zero -> branch						
			ands	r6,#0x80
			beq	jmp_table_F8_a		// is positive -> no branch					
			orr	r3,r1,r2
 			NOP7
 			JUMPNEXT

			.align 6
jmp_table_F8_a:		NOP2
 			JUMPNEXT			// positive

			.align 6			// zero
jmp_table_F8_b:		NOP4
			orr	r3,r1,r2
			JUMPNEXT

#-------------------------------------------------------------------------------
# code F9 (ble [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_F9:		FETCHNEXT_BRA		// (10)
			ldrb	r2,[r8,r12]
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_F9_b		// is zero -> branch						
			ands	r6,#0x80
			beq	jmp_table_F9_a		// is positive -> no branch					
			orr	r3,r1,r2
 			NOP6
 			JUMPNEXT

			.align 6
jmp_table_F9_a:		NOP1
 			JUMPNEXT			// positive

			.align 6			// zero
jmp_table_F9_b:		NOP3
			orr	r3,r1,r2
			JUMPNEXT

#-------------------------------------------------------------------------------
# code FA (ble ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_FA:		FETCHNEXT_BRA		// (10)
			mov	r2,r4
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_FA_b		// is zero -> branch						
			ands	r6,#0x80
			beq	jmp_table_FA_a		// is positive -> no branch					
			orr	r3,r1,r2
 			NOP7
 			JUMPNEXT

			.align 6
jmp_table_FA_a:		NOP2
 			JUMPNEXT			// positive

			.align 6			// zero
jmp_table_FA_b:		NOP4
			orr	r3,r1,r2
			JUMPNEXT

#-------------------------------------------------------------------------------
# code FB (ble in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_FB:		FETCHNEXT_BRA		// (10)
			mov	r2,r0
			mov	r6,r4			// get accu
			ands	r6,#0xFF
			beq	jmp_table_FB_b		// is zero -> branch						
			ands	r6,#0x80
			beq	jmp_table_FB_a		// is positive -> no branch					
			orr	r3,r1,r2
  			NOP7
			JUMPNEXT

			.align 6
jmp_table_FB_a:		NOP2
 			JUMPNEXT			// positive

			.align 6			// zero
jmp_table_FB_b:		NOP4
			orr	r3,r1,r2
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code FC (bra $dd)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_FC:		FETCHNEXT_BRA		// (10)
			mov	r2,r8
			orr	r3,r1,r2
			NOP14
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code FD (bra [$dd])
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_FD:		FETCHNEXT_BRA		// (10)
			LOAD_R0D		// (3)			
			orr	r3,r1,r2
			NOP11
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code FE (bra ac)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_FE:		FETCHNEXT_BRA		// (9)
			LOAD_ACC		// (1)			
			NOP2
			orr	r3,r1,r2
			NOP12
			JUMPNEXT
	
#-------------------------------------------------------------------------------
# code FF (bra in)
#-------------------------------------------------------------------------------	
			.align 8
jmp_table_FF:		FETCHNEXT_BRA		// (9)
			LOAD_IN			// (1)			
			NOP2
			orr	r3,r1,r2
			NOP12
			JUMPNEXT
