#!/usr/bin/perl
#################################################################################
#										#
# rom data generator/patcher for gigatron micro emulator			#
# copyright (c) 2018-2019 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
# This program is free software under the BSD 2-Clause License.			#
# See LICENSE file in main directory.						#
#										#
#################################################################################
use POSIX;
use Fcntl;

$binfile="ROMv3.rom";
$datfile=">../rom.s";

&gencode("ROMv3.rom","rom_default",0x179,0x2AC);
&gencode("ROMv1.rom","rom_alta",0x27e,0x1ab);
&gencode("ROMv2.rom","rom_altb",0x177,0x2AC);

sub gencode
{
	$binfile=$_[0];
	$datfile=">../".$_[1].".s";
	$label=$_[1];
	$hend=$_[2]*2+2;
	$hx2=$_[3]*2+2;
	
	printf "\n---------------------------------------------------------------------\n";
	printf " create	data file $datfile from $binfile\n";
	printf "---------------------------------------------------------------------\n";
	
	$dlen = -s $binfile;
	open (BREAD, $binfile);
	binmode(BREAD);
	for($i=0;$i<$dlen;$i++)
	{
		read(BREAD,$romdata[$i],1);
	}
	close(BREAD);

#	print "Bytes: $i $dlen\n";

	open (DWRITE,$datfile);
	
	print DWRITE "############################################################################\n";
	print DWRITE "# automatic generated file                                                  \n";
	print DWRITE "# source: $binfile\n";
	print DWRITE "############################################################################\n\n";
	print DWRITE "\t\t.section\t.img,\"ax\"\n";
	print DWRITE "\t\t.thumb\n";
	print DWRITE "\t\t.syntax unified\n";
	print DWRITE "\t\t.globl $label\n\n";
	print DWRITE "\t\t.include \"inc/setup.inc\"\n\n";
	print DWRITE "$label:\n";
	print DWRITE ".if pwmcheck == 0\n";

	$ptr=0;

	for($i=0;$i<8192;$i++)
	{
		print DWRITE "\n\t\t.dc ";
		$addr=$ptr >> 1;
		for($j=0;$j<8;$j++)
		{
			$b1=ord($romdata[$ptr++]);
			$b2=ord($romdata[$ptr++]);
			$iwert=$b1*256 + $b2;
			if($addr < 2048)
			{
				if($ptr != $hx2)
				{
					if($iwert == 0x18C0){	$iwert = 0x1CC0;printf "SUBSTITUTE 18C0 -> 1CC0 @ %#4.4x\n",($ptr-2) >> 1	};
				}
				if($ptr==$hend)
				{	
					$iwert = 0x1D0A;printf "SUBSTITUTE 190A -> 1D0A @ %#4.4x\n",($ptr-2) >> 1	
				};	
			}
			
			
			if($iwert==0)
			{
				print DWRITE "0x0000";
			}
			else
			{
				printf DWRITE "%#4.4x",$iwert;
			}			
			if($j < 7)
			{
				print DWRITE ",";
			}
			else
			{
				printf DWRITE "\t// %#4.4x",$addr;
			}			
			
		}
	}
	print DWRITE "\n\n";
	print DWRITE ".endif\n\n";
	close(DWRITE);
}

