;################################################################################
;#										#
;# eeprom - EEPROM R/W library for ATmega controllers				#
;# copyright (c) 2007-2012 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; read one byte (r16) from EEPROM memory (Y)
;------------------------------------------------------------------------------
eeprom_read:	sbic	EECR,EEPE
		rjmp	eeprom_read
		out	EEARH,YH
		out	EEARL,YL
		sbi	EECR,EERE
		in	r16,EEDR
		ret				;thats all

;------------------------------------------------------------------------------
; write one byte (r16) to EEPROM memory (Y)
;------------------------------------------------------------------------------
eeprom_write:	sbic	EECR,EEPE		;wait for EEPROM ready
		rjmp	eeprom_write
		sts	sys_autostart,const_0	;disable autostart
		out	EEARH,YH
		out	EEARL,YL
		sbi	EECR,EERE
		in	r0,EEDR
		cp	r0,r16
		brne	eeprom_write3
		ret				;no modify necessary

eeprom_write3:	out	EEDR,r16		;write byte
		cli
		sbi	EECR,EEMPE
		sbi	EECR,EEPE
		sei
		ret

