#!/usr/bin/perl
#################################################################################
#										#
# rom data generator/patcher for AX81						#
# copyright (c) 2010-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 3		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
use POSIX;
use Fcntl;

$binfile="zx81rom.bin";
$datfile=">../tables/romdata_zx81.inc";

$dlen = -s $binfile;

open (BREAD, $binfile);
binmode(BREAD);
for($i=0;$i<$dlen;$i++)
{
	read(BREAD,$romdata[$i],1);
}
close(BREAD);


#some patches
$romdata[0x004]=chr(0x7b);	#memory end

# remove fast mode stuff
$romdata[0x4ca]=chr(0xed);	#set waitforkey
$romdata[0x4cb]=chr(0x14);
$romdata[0x4cc]=chr(0xcb);	#bit 0,(HL)
$romdata[0x4cd]=chr(0x46);
$romdata[0x4ce]=chr(0x28);	#jrz loop
$romdata[0x4cf]=chr(0xfc);
$romdata[0x4d0]=chr(0x00);	#nowaitforkey
$romdata[0x4d1]=chr(0x00);
$romdata[0x4d2]=chr(0x00);	#nop (filling)

# change the KBD routine
#$romdata[0x2bb]=chr(0x2a);
#$romdata[0x2bc]=chr(0x25);
#$romdata[0x2bd]=chr(0x40);
#$romdata[0x2be]=chr(0xc9);

#use AVR KBD routine
$romdata[0x2bb]=chr(0xed);
$romdata[0x2bc]=chr(0x0a);
$romdata[0x2bd]=chr(0xc9);

#signalize fast/slow in bit 7 of CDFLAGS
$romdata[0xf29]=chr(0xbe);
$romdata[0xf2e]=chr(0xfe);

#patch save routine
$romdata[0x2fc]=chr(0xed);
$romdata[0x2fd]=chr(0x0c);
$romdata[0x2fe]=chr(0xc3);
$romdata[0x2ff]=chr(0x07);
$romdata[0x300]=chr(0x02);

#patch load routine
$romdata[0x347]=chr(0xeb);
$romdata[0x348]=chr(0xed);
$romdata[0x349]=chr(0x0d);
$romdata[0x34a]=chr(0xc3);
$romdata[0x34b]=chr(0x07);
$romdata[0x34c]=chr(0x02);

#pause stuff
$romdata[0xf3a]=chr(0xed);
$romdata[0xf3b]=chr(0x0b);
$romdata[0xf3c]=chr(0x00);

#enable slow
$romdata[0x21c]=chr(0x00);
$romdata[0x21d]=chr(0x00);

#disable fast at N/L
$romdata[0x6f3]=chr(0x00);
$romdata[0x6f4]=chr(0x00);
$romdata[0x6f5]=chr(0x00);

$romdata[0xf35]=chr(0x00);
$romdata[0xf36]=chr(0x00);
$romdata[0xf37]=chr(0x00);

#decode routine replacement
$romdata[0x7bd]=chr(0xed);	# avr kdecode
$romdata[0x7be]=chr(0x09);
$romdata[0x7bf]=chr(0xc9);	# return


open (DWRITE,$datfile);

for($i=0;$i<$dlen;$i++)
{
	if(($i%16)==0)
	{
		print DWRITE "\t\t.db ";
	}
	$ibyte=$romdata[$i];
	$iwert=ord($ibyte);
	if($iwert==0)
	{
		print DWRITE "0x00";
	}
	else
	{
		printf DWRITE "%#2.2x",$iwert;
	}
	if(($i%16)<15)
	{
		print DWRITE ",";
	}
	else
	{
		printf DWRITE "\t;%4x\n",$i-15;
	}
	
}
close(DWRITE);



