;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


;-------------------------------------------------------------------------------
;video-interrupt (no registers destroyed, stack=13)
;save registers (25c)
;-------------------------------------------------------------------------------
vint_vstart:	push	ZH			;2 save Z-register
		push	ZL			;2 save Z-register
		push	YH			;2 save Y-register
		push	YL			;2 save Y-register
		push	XH			;2 save X-register
		push	XL			;2 save X-register
		in	r15,SREG		;1 save status
		sei				;1 enable border end int
		wdr				;1 watchdog reset

;-------------------------------------------------------------------------------
;count line up and select output
;-------------------------------------------------------------------------------
		add	vline_l,const_1		;1
		adc	vline_h,const_0		;1
		in	ZL,GPIOR1
		in	ZH,GPIOR2
		ijmp


vint_bstart:	lds	r14,TCNT1L
		sbrs	r14,0
		rjmp	vint_bstart_1
vint_bstart_1:	sbrs	r14,1
		lpm	r13,Z
		sbic	GPIOR0,4		;1 skip if vertical border enable
		sbi	PORTD,3
		reti

vint_bstop:	sbis	PORTD,3		;1 skip if vertical border enable
		reti
		lds	r14,TCNT1L
		sbrs	r14,0
		rjmp	vint_bstop_1
vint_bstop_1:	sbrs	r14,1
		lpm	r13,Z
		cbi	PORTD,3
		reti
