;######################################################################
;#                                                                    #
;#    AVR ChipBasic2 API V1.50 API Macros                             #
;#    (c) 2009-2015 Joerg Wolfram                                     #
;#                                                                    #
;# This program is free software; you can redistribute it and/or      #
;# modify it under the terms of the GNU General Public License        #
;# as published by the Free Software Foundation; either version 3     #
;# of the License, or (at your option) any later version.             #
;#                                                                    #
;# This program is distributed in the hope that it will be useful,    #
;# but WITHOUT ANY WARRANTY; without even the implied warranty of     #
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU    #
;# General Public License for more details.                           #
;#                                                                    #
;# You should have received a copy of the GNU General Public          #
;# License along with this library; if not, write to the              #
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,       #
;# Boston, MA 02111-1307, USA.                                        #
;#                                                                    #
;######################################################################
.macro api_token
	call	0x001e
.endm

.macro api_untoken
	call	0x0020
.endm

.macro api_version
	call	0x0022
.endm

.macro api_popxyz
	jmp	0x0024
.endm

.macro api_pushxyz
	call	0x0025
.endm

.macro api_popregs
	jmp	0x0026
.endm

.macro api_pushregs
	call	0x0027
.endm

.macro api_getvram
	call	0x0028
.endm

.macro api_getsysram
	call	0x002b
.endm

.macro api_getpal
	call	0x002e
.endm

.macro api_getarray
	call	0x0031
.endm

.macro api_getchart0
	call	0x0034
.endm

.macro api_getchart1
	call	0x0037
.endm

.macro api_getbuffer
	call	0x003a
.endm

.macro api_getvalues
	call	0x003d
.endm

.macro api_getpartab
	call	0x0040
.endm

.macro api_getvar
	call	0x0043
.endm

.macro api_getprg
	call	0x0046
.endm

.macro api_dataptr
	call	0x0058
.endm

.macro api_getbase
	call	0x005a
.endm

.macro api_getprog
	call	0x005c
.endm

.macro api_getprog_1
	call	0x0060
.endm

.macro api_getprog_2
	call	0x0064
.endm

.macro api_setcolor
	call	0x0065
.endm

.macro api_setfcolor
	call	0x0067
.endm

.macro api_setborder
	call	0x0069
.endm

.macro api_setvmode
	call	0x006b
.endm

.macro api_setpalette
	call	0x006d
.endm

.macro api_sync
	call	0x006f
.endm

.macro api_slow
	call	0x0071
.endm

.macro api_fast
	call	0x0073
.endm

.macro api_setchannel
	call	0x0075
.endm

.macro api_setfont
	call	0x0077
.endm

.macro api_clrscr
	call	0x0079
.endm

.macro api_outchar
	call	0x007b
.endm

.macro api_outdez
	call	0x007d
.endm

.macro api_outhex
	call	0x007f
.endm

.macro api_gotoxy
	call	0x0081
.endm

.macro api_romtext
	call	0x0083
.endm

.macro api_thistext
	call	0x0085
.endm

.macro api_cbox
	call	0x0087
.endm

.macro api_ibox
	call	0x008a
.endm

.macro api_scroll
	call	0x008d
.endm

.macro api_newline
	call	0x008f
.endm

.macro api_sprite
	call	0x0091
.endm

.macro api_cursor
	call	0x0093
.endm

.macro api_waitkey
	call	0x0097
.endm

.macro api_nokey
	call	0x0099
.endm

.macro api_kstate
	call	0x009b
.endm

.macro api_kflags
	call	0x009f
.endm

.macro api_getkey
	call	0x00a2
.endm

.macro api_lastkey
	call	0x00a5
.endm

.macro api_scancode
	call	0x00a8
.endm

.macro api_putser
	call	0x00ab
.endm

.macro api_getser
	call	0x00ad
.endm

.macro api_getserb
	call	0x00af
.endm

.macro api_putser2
	call	0x00b1
.endm

.macro api_getser2
	call	0x00b3
.endm

.macro api_getserb2
	call	0x00b5
.endm

.macro api_putpar
	call	0x00b7
.endm

.macro api_putxm
	call	0x00b9
.endm

.macro api_getxm
	call	0x00bb
.endm

.macro api_putsernl
	call	0x00bd
.endm

.macro api_putsernl2
	call	0x00bf
.endm

.macro api_baud2
	call	0x00c1
.endm

.macro api_hexline
	call	0x00c3
.endm

.macro api_plot
	call	0x00c5
.endm

.macro api_draw
	call	0x00c7
.endm

.macro api_box
	call	0x00c9
.endm

.macro api_fbox
	call	0x00cb
.endm

.macro api_circle
	call	0x00cd
.endm

.macro api_fcircle
	call	0x00d1
.endm

.macro api_bcopy1
	call	0x00d5
.endm

.macro api_bcopy2
	call	0x00d7
.endm

.macro api_bcopy3
	call	0x00d9
.endm

.macro api_menu
	call	0x00db
.endm

.macro api_drawmenu
	call	0x00dd
.endm

.macro api_alert
	call	0x00df
.endm

.macro api_ask
	call	0x00e1
.endm

.macro api_alertthis
	call	0x00e3
.endm

.macro api_askthis
	call	0x00e5
.endm

.macro api_alert_nb
	call	0x00e7
.endm

.macro api_ask_nb
	call	0x00e9
.endm

.macro api_alertthis_nb
	call	0x00eb
.endm

.macro api_askthis_nb
	call	0x00ed
.endm

.macro api_wbox
	call	0x00ef
.endm

.macro api_whbox
	call	0x00f1
.endm

.macro api_saywrite
	call	0x00f3
.endm

.macro api_saytransfer
	call	0x00f5
.endm

.macro api_note
	call	0x00f7
.endm

.macro api_setvolume
	call	0x00f9
.endm

.macro api_startseq
	call	0x00fb
.endm

.macro api_setseq
	call	0x00fd
.endm

.macro api_getseq
	call	0x00ff
.endm

.macro api_i2c_read
	call	0x0101
.endm

.macro api_i2c_write
	call	0x0103
.endm

.macro api_i2c_start
	call	0x0105
.endm

.macro api_i2c_stop
	call	0x0107
.endm

.macro api_i2c_rbyte
	call	0x0109
.endm

.macro api_i2c_rbyten
	call	0x010b
.endm

.macro api_i2c_wbyte
	call	0x010d
.endm

.macro api_i2c_rlm75
	call	0x010f
.endm

.macro api_eep_read
	call	0x0111
.endm

.macro api_eep_write
	call	0x0113
.endm

.macro api_abs
	call	0x0115
.endm

.macro api_add
	call	0x0117
.endm

.macro api_sub
	call	0x0119
.endm

.macro api_mul
	call	0x011b
.endm

.macro api_div
	call	0x011d
.endm

.macro api_sin
	call	0x011f
.endm

.macro api_cos
	call	0x0121
.endm

.macro api_eq
	call	0x0123
.endm

.macro api_lt
	call	0x0125
.endm

.macro api_gt
	call	0x0127
.endm

.macro api_sqr
	call	0x0129
.endm

.macro api_rnd
	call	0x012b
.endm

.macro api_adc
	call	0x012d
.endm

.macro api_dbit
	call	0x012f
.endm

.macro api_fs_create
	call	0x0131
.endm

.macro api_fs_delete
	call	0x0135
.endm

.macro api_fs_read
	call	0x0139
.endm

.macro api_fs_write
	call	0x013d
.endm

.macro api_fs_cfree
	call	0x0141
.endm

.macro api_fs_size
	call	0x0143
.endm

.macro api_fs_checkf
	call	0x0145
.endm

.macro api_fs_gettype
	call	0x0147
.endm

.macro api_fs_rread
	call	0x014b
.endm

.macro api_fs_rwrite
	call	0x014e
.endm

.macro api_fs_fsize
	call	0x0151
.endm

.macro api_fs_ffind
	call	0x0153
.endm

.macro api_fs_fsel
	call	0x0155
.endm

.macro api_fs_fsel_nb
	call	0x0157
.endm

.macro api_fs_check
	call	0x0159
.endm

.macro api_copychar4
	call	0x015b
.endm

.macro api_copychar6
	call	0x015d
.endm

.macro api_basrun
	call	0x015f
.endm

.macro api_exparser
	call	0x0161
.endm

.macro api_tparser
	call	0x0163
.endm

.macro api_lfind
	call	0x0165
.endm

.macro api_lcall
	call	0x0167
.endm

.macro api_preceive
	call	0x0169
.endm

.macro api_psend
	call	0x016b
.endm

.macro api_wpage
	call	0x016d
.endm

.macro api_arrview
	call	0x016f
.endm

.macro api_extsearch
	call	0x0171
.endm

.macro api_extdisable
	call	0x0173
.endm

.macro api_basgetpar
	call	0x0175
.endm

.macro api_basgetvar
	call	0x0177
.endm

.macro api_vm0line
	jmp	0x0179
.endm

.macro api_vm0cls
	jmp	0x017d
.endm

.macro api_vm0char
	jmp	0x0180
.endm

.macro api_vm0gotoxy
	jmp	0x0184
.endm

.macro api_vm0plot
	jmp	0x0186
.endm

.macro api_vm0newline
	jmp	0x0188
.endm

.macro api_sbackup
	call	0x018c
.endm

.macro api_srestore
	call	0x018e
.endm

.macro api_screenshot
	call	0x0190
.endm

.macro api_aread
	call	0x0192
.endm

.macro api_awrite
	call	0x0194
.endm

.macro api_pageset
	call	0x0196
.endm

.macro api_pageget
	call	0x0199
.endm

.macro api_scale
	call	0x019c
.endm

.macro api_spisel
	call	0x019e
.endm

.macro api_spiunsel
	call	0x01a0
.endm

.macro api_spicomm
	call	0x01a2
.endm

.macro api_xmem_rb
	call	0x01a4
.endm

.macro api_xmem_rw
	call	0x01a6
.endm

.macro api_xmem_wb
	call	0x01a8
.endm

.macro api_xmem_ww
	call	0x01aa
.endm

.macro api_xmem_chk
	call	0x01ac
.endm

.macro api_xmem_clr
	call	0x01ae
.endm

