;################################################################################
;#										#
;# libdfl - Dataflash library							#
;# copyright (c) 2007-2015 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;uncomment next line to enable the whole library if avr_libmake is not used
;.set	use_libdflash	= 1

;error codes:
;------------
; 17	dataflash error
; 23	cannot create new file (file exist)
; 24	cannot create new file (not enough free datapages)
; 25	file not found (is empty)
; 26	page not in file
; 27	invalid number of pages (<1 or > 128)

;------------------------------------------------------------------------------
; send dataflash byte (tempreg1)
;------------------------------------------------------------------------------
libdfl_out:	out	SPDR,tempreg1
libdfl_out1:	in	tempreg1,SPSR
		sbrs	tempreg1,SPIF
		rjmp	libdfl_out1
		in	tempreg1,SPDR
		ret

;------------------------------------------------------------------------------
; enable dataflash (for SPI extender)
;------------------------------------------------------------------------------
libdfl_sel:	push	tempreg1
		ldi	tempreg1,0xfe
		rcall	libdfl_out
		pop	tempreg1
		cbi	PORTB,4			;now set SS signal
		ret

libdfl_unsel:	sbi	PORTB,4
		ret

;------------------------------------------------------------------------------
; wait for Dataflash ready status
;------------------------------------------------------------------------------
libdfl_stat:	clr	ereg
		rcall	libdfl_sel
		ldi	tempreg1,0xd7		;command
		rcall	libdfl_out		;output command
		clr	tempreg1		;dummy
		rcall	libdfl_out
		sbi	PORTB,4			;stop transfer
		andi	tempreg1,0xbc		;mask out compare an x bits
		cpi	tempreg1,0x24		;8MB wait
		breq	libdfl_stat
		cpi	tempreg1,0x1c		;4MB wait
		breq	libdfl_stat
		clr 	ereg			;no error
		cpi	tempreg1,0xa4		;8MB OK
		breq	libdfl_stat1
		cpi	tempreg1,0x9c		;4MB OK
		breq	libdfl_stat1		
		ldi	ereg,17			;dataflash error
libdfl_stat1:	ret

;------------------------------------------------------------------------------
; get size to tempreg1 0x00/0x08/0x10
;------------------------------------------------------------------------------
libdfl_size:	clr	ereg			;no error
		rcall	libdfl_stat		;get status
		cpi	ereg,0x00		;OK?
		breq	libdfl_size_2
		ldi	tempreg1,0x00		;no blocks
libdfl_size_1:	sts	libdfl_ram,tempreg1	;store size
		ret				;thats all

libdfl_size_2:	cpi	tempreg1,0x9c		;4MB OK
		brne	libdfl_size_3
		ldi	tempreg1,0x08		;2048 blocks
		rjmp	libdfl_size_1

libdfl_size_3:	ldi	tempreg1,0x10		;4096 blocks
		rjmp	libdfl_size_1

;------------------------------------------------------------------------------
; get max page to tempreg1 0x00/0x7f/0xff
;------------------------------------------------------------------------------
libdfl_maxpage:	rcall	libdfl_size		;get size
		cpi	tempreg1,0x00
		brne	libdfl_maxpe
		ret
libdfl_maxpe:	lsl	tempreg1
		lsl	tempreg1
		lsl	tempreg1
		lsl	tempreg1
		dec	tempreg1
		ret

;------------------------------------------------------------------------------
; out block address from Block X
;------------------------------------------------------------------------------
libdfl_spibad:	lsl	XL			;address *2
		rol	XH
		mov	tempreg1,XH
		rcall	libdfl_out		;out high
		mov	tempreg1,XL
		rcall	libdfl_out		;out low
		mov	tempreg1,const_0
		rcall	libdfl_out		;00=byte in page
		lsr	XH			;restore old address
		ror	XL
libdfl_spibad1:	ret				;thats all

;------------------------------------------------------------------------------
; read block X to buffer 2
;------------------------------------------------------------------------------
libdfl_bread:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_bread2
libdfl_breada:	push	tempreg1
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_bread1		;no
		rcall	libdfl_sel
		ldi	tempreg1,0x55
		rcall	libdfl_out		;output command
		rcall	libdfl_spibad		;output address
		sbi	PORTB,4			;stop transfer
		rcall	libdfl_stat		;wait for ready
libdfl_bread1:	pop	tempreg1
libdfl_bread2:	ret

;------------------------------------------------------------------------------
; read block X to buffer 1
;------------------------------------------------------------------------------
libdfl_iread:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_iread2
		push	tempreg1
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_iread1		;no
		rcall	libdfl_sel
		ldi	tempreg1,0x53
		rcall	libdfl_out		;output command
		rcall	libdfl_spibad		;output address
		sbi	PORTB,4			;stop transfer
		rcall	libdfl_stat		;wait for ready
libdfl_iread1:	pop	tempreg1
libdfl_iread2:	ret

;------------------------------------------------------------------------------
; write block X from buffer 2
;------------------------------------------------------------------------------
libdfl_bwrite:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_bwrite2
		push	tempreg1
;debug: show page number to write
;		push	XL
;		push	XH
;		ldi	ctrl,0x01
;		libmio_outhex
;		libmio_outspace
;		pop	XH
;		pop	XL
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_bwrite1		;no
		rcall	libdfl_sel
		ldi	tempreg1,0x86
		rcall	libdfl_out		;output command
		rcall	libdfl_spibad		;output address
		sbi	PORTB,4			;stop transfer
libdfl_bwrite1:	pop	tempreg1
libdfl_bwrite2:	ret

libdfl_dwrite:	adiw	XL,1
		sts	libdfl_ram+1,XH		;store last written+1
		sts	libdfl_ram+2,XL		;store last written+1
		sbiw	XL,1
		rjmp	libdfl_bwrite

;------------------------------------------------------------------------------
; put page type of page X from tempreg1
;------------------------------------------------------------------------------
libdfl_stype:	rcall	libdfl_ghead		;set X to header
		rcall	libdfl_bread
		rcall	libdfl_ptype
		rjmp	libdfl_bwrite

;------------------------------------------------------------------------------
; get page type of page X to tempreg1
;------------------------------------------------------------------------------
libdfl_gtype:	push	tempreg4
		clr	tempreg4		;byte 0 of header
		rcall	libdfl_ghbyte		;get header byte
		pop	tempreg4
		ret

;------------------------------------------------------------------------------
; get page write counter of page X to Y
;------------------------------------------------------------------------------
libdfl_gcount:	push	tempreg4
		ldi	tempreg4,0x01		;byte 1 of header=HIGH
		rcall	libdfl_ghbyte		;get header byte
		mov	YH,tempreg1
		ldi	tempreg4,0x02		;byte 2 of header=LOW
		rcall	libdfl_ghbyte		;get header byte
		mov	YL,tempreg1		
		pop	tempreg4
		ret

;------------------------------------------------------------------------------
; get rewrite counter of page X to tempreg1
;------------------------------------------------------------------------------
libdfl_grwc:	push	tempreg4
		ldi	tempreg4,3		;byte 0 of header
		rcall	libdfl_ghbyte		;get header byte
		pop	tempreg4
		ret

;------------------------------------------------------------------------------
; get headerbyte tempreg4 of page X to tempreg1
;------------------------------------------------------------------------------
libdfl_ghbyte:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_ghbyte1
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_ghbyte1		;no
		rcall	libdfl_sel		;start transfer
		ldi	tempreg1,0xd2
		rcall	libdfl_out		;output command
		lsl	XL
		rol	XH
		inc	XL
		mov	tempreg1,XH
		rcall	libdfl_out
		mov	tempreg1,XL
		rcall	libdfl_out
		mov	tempreg1,tempreg4	;position of byte
		rcall	libdfl_out
		lsr	XH
		ror	XL
		rcall	libdfl_outd		;dummy bytes
		sbi	PORTB,4			;stop transfer
libdfl_ghbyte1:	ret

;output dummy bytes
libdfl_outd:	rcall	libdfl_out		;dummy bytes
		rcall	libdfl_out
		rcall	libdfl_out
		rcall	libdfl_out
		rjmp	libdfl_out		;get byte

;------------------------------------------------------------------------------
; get data word tempreg4 of page X to Y
;------------------------------------------------------------------------------
libdfl_gdword:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_gdword1
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_gdword1		;no
		rcall	libdfl_sel		;start transfer
		ldi	tempreg1,0xd2
		rcall	libdfl_out		;output command
		lsl	XL
		rol	XH
		mov	tempreg1,XH
		rcall	libdfl_out
		mov	tempreg1,XL
		rcall	libdfl_out
		mov	tempreg1,tempreg4	;position of byte
		lsl	tempreg1
		rcall	libdfl_out
		lsr	XH
		ror	XL
		rcall	libdfl_outd		;dummy bytes
		mov	YH,tempreg1
		rcall	libdfl_out		;get byte
		mov	YL,tempreg1		
		sbi	PORTB,4			;stop transfer
libdfl_gdword1:	ret

;------------------------------------------------------------------------------
; put page type tempreg1 to buffer 2
;------------------------------------------------------------------------------
libdfl_ptype:	push	tempreg4
		ldi	tempreg4,0x00		;byte 0 of header
		rcall	libdfl_phbyte		;get header byte
		pop	tempreg4
		ret

;------------------------------------------------------------------------------
; put page write counter Y to buffer 2
;------------------------------------------------------------------------------
libdfl_pcount:	push	tempreg4
		ldi	tempreg4,0x01		;byte 1 of header=HIGH
		mov	tempreg1,YH
		rcall	libdfl_phbyte		;put header byte
		ldi	tempreg4,0x02		;byte 2 of header=LOW
		mov	tempreg1,YL
		rcall	libdfl_ghbyte		;put header byte
		pop	tempreg4
		ret

;------------------------------------------------------------------------------
; put rewrite counter tempreg1 to buffer 2
;------------------------------------------------------------------------------
libdfl_prwc:	push	tempreg4
		ldi	tempreg4,0x03		;byte 0 of header
		rcall	libdfl_ghbyte		;get header byte
		pop	tempreg4
		ret

;------------------------------------------------------------------------------
; write header byte tempreg4 in buffer 2 (tempreg1=value)
;------------------------------------------------------------------------------
libdfl_phbyte:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_phbyte1
		push	tempreg1		;save reg
		rcall	libdfl_stat		;wait for ready
		pop	tempreg1
		cpi	ereg,0			;OK
		brne	libdfl_phbyte1		;no
		rcall	libdfl_sel
		push	tempreg1		;save value
		ldi	tempreg1,0x87
		rcall	libdfl_out		;output command
		clr	tempreg1		;page hi
		rcall	libdfl_out
		ldi	tempreg1,0x01		;page lo
		rcall	libdfl_out
		mov	tempreg1,tempreg4	;offset
		rcall	libdfl_out
		pop	tempreg1
		push	tempreg1
		rcall	libdfl_out		;put data
		sbi	PORTB,4
		pop	tempreg1
libdfl_phbyte1:	ret

;------------------------------------------------------------------------------
; write data byte tempreg4 in buffer 2 (tempreg1=value)
;------------------------------------------------------------------------------
libdfl_pdbyte:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_pdbyte1
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_phbyte1		;no
		rcall	libdfl_sel
		push	tempreg1		;save value
		ldi	tempreg1,0x87
		rcall	libdfl_out		;output command
		clr	tempreg1		;page hi
		rcall	libdfl_out
		ldi	tempreg1,0x00		;page lo
		rcall	libdfl_out
		mov	tempreg1,tempreg4	;offset
		rcall	libdfl_out
		pop	tempreg1
		push	tempreg1
		rcall	libdfl_out		;put data
		sbi	PORTB,4
		pop	tempreg1
libdfl_pdbyte1:	ret

;------------------------------------------------------------------------------
; write RAM (Y) to buffer 2 (256 bytes)
;------------------------------------------------------------------------------
libdfl_wrbuf:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_wrbuf3
		push	YH
		push	YL
		push	tempreg1
		push	tempreg2
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_wrbuf2		;no
		rcall	libdfl_sel
		ldi	tempreg1,0x87
		rcall	libdfl_out		;output command
		clr	tempreg1		;page hi
		rcall	libdfl_out
		clr	tempreg1		;page lo
		rcall	libdfl_out
		ldi	tempreg1,0x00		;offset
		rcall	libdfl_out
		clr	tempreg2		;bytes to copy
libdfl_wrbuf1:	ld	tempreg1,Y+
		rcall	libdfl_out		;put data
		dec	tempreg2
		brne	libdfl_wrbuf1
		sbi	PORTB,4
libdfl_wrbuf2:	pop	tempreg2
		pop	tempreg1
		pop	YL
		pop	YH
libdfl_wrbuf3:	ret

;------------------------------------------------------------------------------
; write 0xff to buffer 2 (256 bytes data)
;------------------------------------------------------------------------------
libdfl_clrbuf:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_clrbuf3
		push	tempreg1
		push	tempreg2
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_clrbuf2		;no
		rcall	libdfl_sel
		ldi	tempreg1,0x87
		rcall	libdfl_out		;output command
		clr	tempreg1		;page hi
		rcall	libdfl_out
		clr	tempreg1		;page lo
		rcall	libdfl_out
		ldi	tempreg1,0x00		;offset
		rcall	libdfl_out
		clr	tempreg2		;256 bytes
libdfl_clrbuf1:	ldi	tempreg1,0xff
		rcall	libdfl_out		;put data
		dec	tempreg2
		brne	libdfl_clrbuf1
		sbi	PORTB,4
libdfl_clrbuf2:	pop	tempreg2
		pop	tempreg1
libdfl_clrbuf3:	ret

;------------------------------------------------------------------------------
; read RAM (Y) from buffer 2 (data)
;------------------------------------------------------------------------------
libdfl_rdbuf:	cpi	ereg,0x00		;skip if we are in error state
		brne	libdfl_rdbuf3
		push	YH
		push	YL
		push	tempreg1
		push	tempreg2
		rcall	libdfl_stat		;wait for ready
		cpi	ereg,0			;OK
		brne	libdfl_rdbuf2		;no
		rcall	libdfl_sel
		ldi	tempreg1,0xd6
		rcall	libdfl_out		;output command
		clr	tempreg1		;page hi
		rcall	libdfl_out
		clr	tempreg1		;page lo
		rcall	libdfl_out
		ldi	tempreg1,0x00		;offset
		rcall	libdfl_out
		clr	tempreg1		;dummy1
		rcall	libdfl_out
		clr	tempreg2		;256 bytes
libdfl_rdbuf1:	rcall	libdfl_out		;get data
		st	Y+,tempreg1
		dec	tempreg2
		brne	libdfl_rdbuf1
		sbi	PORTB,4
libdfl_rdbuf2:	pop	tempreg2
		pop	tempreg1
		pop	YL
		pop	YH
libdfl_rdbuf3:	ret

;------------------------------------------------------------------------------
; format modul
;------------------------------------------------------------------------------
libdfl_format:	push	XH			;save registers
		push	XL
		push	YH
		push	YL
		push	tempreg1
		push	tempreg2
		push	tempreg4
;page 0
libdfl_format2:	rcall	libdfl_clrbuf		;empty data area in buffer 2
		ldi	tempreg1,0x0f		;first writelimit
		rcall	libdfl_ptype		;set type byte
		clr	tempreg1		;0
		rcall	libdfl_prwc		;set rewrite counter
		clr	XL			;page 0
		clr	XH
		rcall	libdfl_bwrite		;write buffer
		adiw	XL,1			;next page
;other pages
libdfl_format3:	ldi	tempreg1,0xfd		;empty data 
		mov	YL,XL			;copy low pointer
		andi	YL,0x0f			;mask bits
		cpi	YL,0x01			;Header page?
		brne	libdfl_format4		;no
		ldi	tempreg1,0xfc		;empty header
libdfl_format4:	rcall	libdfl_ptype		;set type byte
		clr	tempreg1		;0
		rcall	libdfl_prwc		;set rewrite counter
		clr	YL			;write counter=0
		clr	YH
		rcall	libdfl_pcount		
		rcall	libdfl_bwrite		;write buffer
		adiw	XL,1			;next page
		cpi	XL,0x00
		brne	libdfl_format5
		ldi	tempreg1,0xe5		;draw symbol (brick)
		libmio_outchar	
libdfl_format5:	lds	tempreg1,libdfl_ram	;pages*256
		cp	XH,tempreg1		;all done?
		brne	libdfl_format3		;no->loop
		rjmp	libdfl_rewrit1		;jump to end

;------------------------------------------------------------------------------
; rewrite next page
;------------------------------------------------------------------------------
libdfl_rewrite:	;ret				;switch of for debug
		push	XH			;save registers
		push	XL
		push	YH
		push	YL
		push	tempreg1
		push	tempreg2
		push	tempreg4
		rcall	libdfl_size		;wait for ready
		cpi	tempreg1,0		;OK
		brne	libdfl_rewrit2		;yes
;end
libdfl_rewrit1:	pop	tempreg4		;restore registers
		pop	tempreg2
		pop	tempreg1
		pop	YL
		pop	YH
		pop	XL
		pop	XH
		ret

		mov	XH,tempreg1		;maxpages*256
		clr	XL
		sbiw	XL,1			;number of last page

		rcall	libdfl_grwc		;get counter of last page
		mov	YL,tempreg1
		clr	XH			;number of first page
		clr	XL
		rcall	libdfl_grwc		;get counter of first page
		cp	tempreg1,YL		;equal
		brne	libdfl_rewrit3		;no
libdfl_rewrit2:	rcall	libdfl_bread		;read page
		rcall	libdfl_grwc
		inc	tempreg1		;increment counter
		rcall	libdfl_prwc		;write new counter to buffer
		rcall	libdfl_bwrite		;write page back
		rjmp	libdfl_rewrit1		;end

libdfl_rewrit3:	adiw	XL,1			;next page
		rcall	libdfl_grwc		;get counter of this page
		cp	tempreg1,YL		;=last?
		brne	libdfl_rewrit3		;loop
		rjmp	libdfl_rewrit2		;page to rewrite found

;------------------------------------------------------------------------------
; free page X
;------------------------------------------------------------------------------
libdfl_freep:	push	YH			;save registers
		push	YL
		push	tempreg1
		rcall	libdfl_bread		;read to buffer
		ldi	tempreg1,0xfd		;empty data 
		mov	YL,XL			;copy low pointer
		andi	YL,0x0f			;mask bits
		cpi	YL,0x01			;Header page?
		brne	libdfl_freep1		;no
		ldi	tempreg1,0xfc		;empty header
libdfl_freep1:	rcall	libdfl_ptype		;set type
		rcall	libdfl_gcount		;get write counter
		adiw	YL,1			;+1
		rcall	libdfl_pcount		;put write counter
		rcall	libdfl_clrbuf		;clear buffer (data bytes)
		rcall	libdfl_bwrite
		pop	tempreg1
		pop	YL
		pop	YH
		ret

;------------------------------------------------------------------------------
; check for format
;------------------------------------------------------------------------------
libdfl_cif:	push_ptr			;save registers
		clr	XL			;page 0
		clr	XH
		movw	YL,XL			;clear counter
		rcall	libdfl_size		;wait for ready
		cpi	tempreg1,0x00		;NOK
		breq	libdfl_cif_3		;no
		mov	ZH,tempreg1		;pages * 256
libdfl_cif_1:	rcall	libdfl_gtype		;get type byte
		cpi	tempreg1,0xfc		;free header page?
		breq	libdfl_cif_u		;no
		cpi	tempreg1,0xfd		;free data page?
		breq	libdfl_cif_u		;no
		cpi	tempreg1,0xab		;used data page?
		breq	libdfl_cif_u		;no	
		cpi	tempreg1,0x0f		;start of useable types?
		brcs	libdfl_cif_2		;no
		cpi	tempreg1,0x90		;end of useable types?
		brcc	libdfl_cif_2		;no

libdfl_cif_u:	adiw	YL,1			;count up
libdfl_cif_2:	adiw	XL,1			;next page
		cp	XH,ZH			;the end?
		brne	libdfl_cif_1
		ldi	tempreg1,0			;unformatted
		cp	YH,ZH
		brne	libdfl_cif_3
		ldi	tempreg1,1			;formatted
libdfl_cif_3:	pop_ptr

;------------------------------------------------------------------------------
; count free datapages to Y and free headerpages to Z
;------------------------------------------------------------------------------
libdfl_cfree:	push	r16			;save registers
		push	XH
		push	XL
		push	tempreg1
		clr	XL			;page 0
		clr	XH
		movw	YL,XL			;clear dp counter
		movw	ZL,XL			;clear hp counter
		rcall	libdfl_size		;wait for ready
		cpi	tempreg1,0		;OK
		breq	libdfl_cfree_4		;no
		mov	r16,tempreg1		;pages * 256
libdfl_cfree_1:	rcall	libdfl_gtype		;get type byte
		cpi	tempreg1,0xfd		;free data page?
		brne	libdfl_cfree_2		;no
		push	YH
		push	YL
		rcall	libdfl_gcount		;get rewrite counter
		mov	tempreg1,YH		;high byte
		pop	YL
		pop	YH
		cpi	tempreg1,0xff
		breq	libdfl_cfree_3		;not useable
		adiw	YL,1			;count up

libdfl_cfree_2:	cpi	tempreg1,0xfc		;free header page?
		brne	libdfl_cfree_3		;no
		adiw	ZL,1			;count up

libdfl_cfree_3:	adiw	XL,1			;next page
		cp	XH,r16			;the end?
		brne	libdfl_cfree_1
libdfl_cfree_4:	pop	tempreg1		;restore registers
		pop	XL
		pop	XH
		pop	r16
		ret				;thats all

;------------------------------------------------------------------------------
; find free datapage with useable write counter to X
;------------------------------------------------------------------------------
libdfl_findf:	push	ZH			;save registers
		push	ZL
		push	YH
		push	YL
		push	tempreg1
		push	r18
		rcall	libdfl_size		;wait for ready
		cpi	tempreg1,0x00		;no flash
		breq	libdfl_findf2
		clr	XL			;page 0
		clr	XH
		rcall	libdfl_gtype
		mov	r18,tempreg1		;write limit (High)
		lds	XH,libdfl_ram+1		;last written
		lds	XL,libdfl_ram+2		;last written
		lds 	tempreg1,libmio_ram	;pages*256
		cp	XH,tempreg1
		brcs	libdfl_find0
		ldi	XL,2			;set to start
		clr	XH
libdfl_find0:	movw	ZL,XL			;stop here if no page found
libdfl_findf1:	rcall	libdfl_gtype		;get type
		cpi	tempreg1,0xfd		;free data page?
		brne	libdfl_findf3
		rcall	libdfl_gcount		;get counter
		cp	YH,r18			;limit reached?
		brcc	libdfl_findf3		;yes

libdfl_findf2:	pop	r18			;restore registers
		pop	tempreg1
		pop	YL
		pop	YH
		pop	ZL
		pop	ZH
		ret

libdfl_findf3:	adiw	XL,5			;next page we are using offset 5 
		lds	tempreg1,libdfl_ram	;max pages *256
		cp	XH,tempreg1
		brne	libdfl_findf4
		clr	XH
libdfl_findf4:	cp	XH,ZH			;compare HI
		brne	libdfl_findf1
		cp	XL,ZL			;compare LO
		brne	libdfl_findf1
		clr	XL			;page 0
		clr	XH
		rcall	libdfl_bread		;read buffer
		rcall	libdfl_gtype		;write limit
		cpi	tempreg1,0xff		;all
		breq	libdfl_findf5
		subi	tempreg1,0xf0		;limit +4096
		mov	r18,tempreg1		;new write limit (High)
		rcall	libdfl_ptype
		rcall	libdfl_bwrite
		movw	XL,ZL			;restore pointer
		rjmp	libdfl_findf1

libdfl_findf5:	ldi	XL,0xff			;no useable page found
		ldi	XH,0xff
		rjmp	libdfl_findf2

;------------------------------------------------------------------------------
; create new file 
; file number is in bas_partab
; size is in bas_partab+2
; type is in bas_partab+4
;------------------------------------------------------------------------------
libdfl_rput:	sts	bas_partab,tempreg1
		sts	bas_partab+2,tempreg2
		sts	bas_partab+4,tempreg3
		ret

libdfl_create:	push_regs			;save registers

;check for flash available
		rcall	libdfl_size		;check
		cpi	tempreg1,0x00
		brne	libdfl_crea_1		;error
		ldi	ereg,17
libdfl_crea_e:	pop_regs			;restore registers

;check if fileno is in range
libdfl_crea_1:	rcall	libdfl_ghead		;get number of header page to X
		cp	XH,tempreg1		;max
		brcs	libdfl_crea_2
		ldi	ereg,27			;not in range
		rjmp	libdfl_crea_e

;check if file exists
libdfl_crea_2:	rcall	libdfl_gtype		;get type
		cpi	tempreg1,0xfc		;free header page
		breq	libdfl_crea_2a		;file exists not
		ldi	ereg,23			;error code
		rjmp	libdfl_crea_e

;check for valid size
libdfl_crea_2a:	lds	tempreg1,bas_partab+2	;size
		cpi	tempreg1,0x00		;=0
		brne	libdfl_crea_3		
		ldi	ereg,27			;invalid size
		rjmp	libdfl_crea_e
libdfl_crea_3:	cpi	tempreg1,0x81		;>128
		brcs	libdfl_crea_4		
		ldi	ereg,27			;invalid size
		rjmp	libdfl_crea_e

;check for free data pages
libdfl_crea_4:	rcall	libdfl_cfree		;count
		cpi	YH,0x00
		brne	libdfl_crea_5
		cp	YL,tempreg1
		brcc	libdfl_crea_5
libdfl_crea_4a:	ldi	ereg,24
		rjmp	libdfl_crea_e

;clear buffers
libdfl_crea_5:	ldi	YL,LOW(libdfl_buffer)	;set buffer
		ldi	YH,HIGH(libdfl_buffer)
		ldi	tempreg2,0x00		;256 bytes
		ldi	tempreg3,0xff		;fill byte
libdfl_crea_6:	st	Y+,tempreg3
		dec	tempreg2
		brne	libdfl_crea_6
		rcall	libdfl_clrbuf
		adiw	XL,1			;point to next page
		sts	libdfl_ram+1,XH		;store last written
		sts	libdfl_ram+2,XL		;store last written
		lds	tempreg1,bas_partab+2	;size
		ldi	YL,LOW(libdfl_buffer)	;set buffer
		ldi	YH,HIGH(libdfl_buffer)
		
;the write loop
libdfl_crea_7:	push	tempreg1		;save counter
		rcall	libdfl_findf		;find free data page
		st	Y+,XH			;store to hp buffer
		st	Y+,XL
		ldi	tempreg1,0xab		;used data page
		rcall	libdfl_ptype
		push	YH
		push	YL
		rcall	libdfl_gcount		;get write counter
		adiw	YL,1			;+1
		rcall	libdfl_pcount		;put write counter
		pop	YL
		pop	YH
		rcall	libdfl_grwc		;get rewrite counter
		rcall	libdfl_prwc		;write to buffer
		rcall	libdfl_dwrite		;write to flash
		rcall	libdfl_rewrite		;rewrite a page
		pop	tempreg1		;restore counter
		dec	tempreg1
		brne	libdfl_crea_7

;now write header page
		rcall	libdfl_ghead		;get header page addr to X
		ldi	YL,LOW(libdfl_buffer)	;set buffer
		ldi	YH,HIGH(libdfl_buffer)
		rcall	libdfl_wrbuf		;write to buffer
		lds	tempreg1,bas_partab+4	;set data type
		rcall	libdfl_ptype		;put this
		push	YH
		push	YL
		rcall	libdfl_gcount		;get write counter
		adiw	YL,1			;+1
		rcall	libdfl_pcount		;put write counter
		pop	YL
		pop	YH
		rcall	libdfl_grwc		;get rewrite counter
		rcall	libdfl_prwc		;write to buffer
		rcall	libdfl_bwrite		;write to flash
		rjmp	libdfl_crea_e		;end

;--------------------------------------------------------------------------------
; calc headerpage from filenumber
; fnum in bas_partab
;--------------------------------------------------------------------------------
libdfl_gheada:	rcall	libdfl_rput
libdfl_ghead:	lds	XL,bas_partab		;file number
libdfl_ghead1:	swap	XL			;calc header page number (*16 +1)
		mov	XH,XL
		andi	XL,0xf0
		andi	XH,0x0f
		adiw	XL,1
		ret

;------------------------------------------------------------------------------
; delete file (bas_partab=file)
;------------------------------------------------------------------------------
libdfl_del:	push_regs			;save registers
		clr	tempreg4
		rcall	libdfl_ghead		;get number of header page
		rcall	libdfl_gtype		;get header type
		cpi	tempreg1,0xfc		;free
		breq	libdfl_del_e
libdfl_del_1:	rcall	libdfl_gdword
		cpi	YH,0xff			;all?
		breq	libdfl_del_2
		push	XH			;save datapage pointer
		push	XL
		movw	XL,YL
		rcall	libdfl_freep		;free data page
		pop	XL
		pop	XH
		rcall	libdfl_rewrite		;rewrite a page
		subi	tempreg4,0xff		;+2
		brne	libdfl_del_1
libdfl_del_2:	rcall	libdfl_freep		;free header page
libdfl_del_e:	pop_regs

;------------------------------------------------------------------------------
; write page 
; file number is in bas_partab
; page is in bas_partab+2
; arraypos is in bas_partab+4
;------------------------------------------------------------------------------
libdfl_write:	push_regs			;save registers
		push	r18
		clr	XL			;page 0
		clr	XH
		rcall	libdfl_stat		;wait
		rcall	libdfl_gtype
		mov	r18,tempreg1		;write limit (High)
		rcall	libdfl_ghead		;get number of header page
		rcall	libdfl_gtype		;get header type
		cpi	tempreg1,0xfc		;free
		brne	libdfl_write_1
		ldi	ereg,25			;file not exist
libdfl_write_e:	pop	r18			;restore registers
		pop_regs

;check for valid size
libdfl_write_1:	lds	tempreg4,bas_partab+2	;size
		cpi	tempreg4,0x80		;>128
		brcs	libdfl_write_2		
		ldi	ereg,27			;invalid page
		rjmp	libdfl_write_e

libdfl_write_2:	rcall	libdfl_gdword
		cpi	YH,0xff
		brne	libdfl_write_3
		ldi	ereg,27			;invalid page
		rjmp	libdfl_write_e

;write page
libdfl_write_3:	movw	XL,YL			;copy page no
		ldi	YL,LOW(bas_array)	;ptr
		ldi	YH,HIGH(bas_array)
		lds	tempreg1,bas_partab+4
		cpi	tempreg1,0x01
		brne	libdfl_write_4
		inc	YH

libdfl_write_4:	cpi	tempreg1,0x02
		brne	libdfl_write_5
		subi	YH,0xfe			;+2

libdfl_write_5:	rcall	libdfl_wrbuf		;write df buffer
		push	YH
		push	YL
		rcall	libdfl_gcount		;get write counter
		cp	YH,r18			;must find new page?
		breq	libdfl_write_6		;yes1
		adiw	YL,1			;+1
		rcall	libdfl_pcount		;put write counter
		pop	YL
		pop	YH
		rcall	libdfl_gtype
		rcall	libdfl_ptype
		rcall	libdfl_grwc		;get rewrite counter
		rcall	libdfl_prwc		;write to buffer
		rcall	libdfl_bwrite		;write to flash
		rcall	libdfl_rewrite		;rewrite a page
		rjmp	libdfl_write_e

libdfl_write_6:	rcall	libdfl_freep		;set page to free
		rcall	libdfl_findf		;find free page
		rcall	libdfl_gcount		;get write counter
		adiw	YL,1			;+1
		rcall	libdfl_pcount		;put write counter
		pop	YL
		pop	YH
		ldi	tempreg1,0xab		;used data page
		rcall	libdfl_ptype
		rcall	libdfl_grwc		;get rewrite counter
		rcall	libdfl_prwc		;write to buffer
		rcall	libdfl_bwrite		;write to flash
		movw	YL,XL			;new page number
		rcall	libdfl_ghead		;calc no of header page
		rcall	libdfl_bread		;read buffer
		lds	tempreg4,bas_partab+2	;page number
		lsl	tempreg4
		mov	tempreg1,YH
		rcall	libdfl_pdbyte
		inc	tempreg4
		mov	tempreg1,YL
		rcall	libdfl_pdbyte
		rcall	libdfl_gtype
		rcall	libdfl_ptype
		rcall	libdfl_grwc		;get rewrite counter
		rcall	libdfl_prwc		;write to buffer
		rcall	libdfl_bwrite		;write to flash
		rjmp	libdfl_write_e

;------------------------------------------------------------------------------
; read page 
; file number is in bas_partab
; page is in bas_partab+2
; arraypos is in bas_partab+4
;------------------------------------------------------------------------------
libdfl_read:	push_regs			;save registers
		rcall	libdfl_ghead		;get number of header page
		rcall	libdfl_gtype		;get header type
		cpi	tempreg1,0xfc		;free
		brne	libdfl_read_1
		ldi	ereg,30			;file not exist
libdfl_read_e:	pop_regs

;check for valid pos
libdfl_read_1:	lds	tempreg4,bas_partab+2	;page to read
		cpi	tempreg4,0x80		;>128
		brcs	libdfl_read_2
		ldi	ereg,27			;invalid page
		rjmp	libdfl_read_e

libdfl_read_2:	rcall	libdfl_gdword
		cpi	YH,0xff
		brne	libdfl_read_3
		ldi	ereg,27			;invalid page
		rjmp	libdfl_read_e

;read page
libdfl_read_3:	movw	XL,YL			;copy number
		rcall	libdfl_bread		;read to buffer
		ldi	YL,LOW(bas_array)	;ptr
		ldi	YH,HIGH(bas_array)
		lds	tempreg1,bas_partab+4
		cpi	tempreg1,0x01
		brne	libdfl_read_4
		inc	YH
libdfl_read_4:	cpi	tempreg1,0x02
		brne	libdfl_read_5
		subi	YH,0xfe			;+2

libdfl_read_5:	rcall	libdfl_rdbuf
		rjmp	libdfl_read_e

;------------------------------------------------------------------------------
; read name 
; XL=file number
; bas_inbuf 18Bytes
;------------------------------------------------------------------------------
libdfl_nread:	push_ptr			;save registers
		push	tempreg1
		push	tempreg2
		push	tempreg4
		rcall	libdfl_ghead		;get number of header page
		rcall	libdfl_gtype		;get header type
		cpi	tempreg1,0xfc		;free
		brne	libdfl_nread_1
		ldi	ereg,30			;file not exist
		rjmp	libdfl_read_e

libdfl_nread_1:	clr	tempreg4		;we will get first page
		rcall	libdfl_gdword
		movw	XL,YL			;copy value
		ldi	tempreg4,0		;we will start with first word
		ldi	ZL,LOW(bas_inbuf)
		ldi	ZH,HIGH(bas_inbuf)
libdfl_nread_2:	rcall	libdfl_gdword
		st	Z+,YH
		st	Z+,YL
		inc	tempreg4
		cpi	tempreg4,0x20
		brne	libdfl_nread_2
		rjmp	libdfl_read_e
