;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# drawing alert boxes								#
;# copyright (c) 2007-2015 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;------------------------------------------------------------------------------
; draw alert box, color followed by nullterminated text (without backup)
; Y=8-12 X=2-27 24 chars available
;------------------------------------------------------------------------------
libmio_abox_0:	lds	tempreg1,libmio_color
		push	tempreg1
		push	ZH
		push	ZL
		rcall	libmio_albox		;draw alert box
		libmio_thistext
		.db	11,9," PRESS ENTER ",0
		pop	ZL
		pop	ZH
		pop	tempreg1
		sts	libmio_color,tempreg1
libmio_abox_1:	rcall	libmio_waitkey
		cpi	tempreg1,0xea
		brne	libmio_abox_1
		rjmp	libmio_nokey



libmio_abox:	pop	ZH			;get return address
		pop	ZL
		rcall	libmio_boxp
		push	ZL			;push new return address
		push	ZH
libmio_abox1:	set
		rcall	libmio_abox_0
		call	mon_restore
		ret

libmio_aboxn:	pop	ZH			;get return address
		pop	ZL
		rcall	libmio_boxp
		push	ZL			;push new return address
		push	ZH
libmio_aboxn1:	clt
		rjmp	libmio_abox_0

;------------------------------------------------------------------------------
; copy text to bas_inbuf
;------------------------------------------------------------------------------
libmio_boxp:	lsl	ZL			;*2 so we use bytes
		rol	ZH
libmio_copyt:	ldi	YL,LOW(bas_inbuf)
		ldi	YH,HIGH(bas_inbuf)
		lpm	tempreg1,Z+		;color byte
		st	Y+,tempreg1		;store this

		ldi	tempreg2,0x18		;maxlen
libmio_copyt1:	lpm	tempreg1,Z+
		st	Y+,tempreg1
		cpi	tempreg1,0x00
		breq	libmio_copyt2
		dec	tempreg2
		brne	libmio_copyt1

libmio_copyt2:	st	Y+,const_0
		sbiw	ZL,1			;point to zero
		lsr	ZH			;/2
		ror	ZL
		adiw	ZL,1			;point to next instruction
		ldi	YL,LOW(bas_inbuf)
		ldi	YH,HIGH(bas_inbuf)
		ret

;------------------------------------------------------------------------------
; draw alert box, color followed by nullterminated text (without backup)
; Y=8-12 X=2-27 24 chars available
;------------------------------------------------------------------------------
libmio_ybox_0:	lds	tempreg1,libmio_color
		push	tempreg1
		push	ZH
		push	ZL
		rcall	libmio_albox		;draw alert box
		libmio_thistext
		.db	11,8," (Y)es / (N)o ",0,0
		pop	ZL
		pop	ZH
		pop	tempreg1		;restore color
		sts	libmio_color,tempreg1
		rcall	libmio_nokey
		rcall	libmio_waityn
		rcall	libmio_nokey
		clr	tempreg1
		brtc	libmio_ynbox2
		inc	tempreg1
libmio_ynbox2:	ret


libmio_ynbox:	pop	ZH			;get return address
		pop	ZL
		rcall	libmio_boxp
		push	ZL			;push new return address
		push	ZH
libmio_ynbox1:	set
		rcall	libmio_ybox_0
		call	mon_restore
		ret


libmio_ynboxn:	pop	ZH			;get return address
		pop	ZL
		rcall	libmio_boxp
		push	ZL			;push new return address
		push	ZH
libmio_ynboxn1:	clt
		rjmp	libmio_ybox_0


libmio_waityn:	clt
		rcall	libmio_waitkey
		cpi	tempreg1,0xea		;ENTER
		breq	libmio_wyn_1
		cpi	tempreg1,0xed		;ESC
		breq	libmio_wyn_2
		andi	tempreg1,0xdf		;UPCASE

		cpi	tempreg1,'N'
		breq	libmio_wyn_2
		cpi	tempreg1,'Y'
		brne	libmio_waityn

libmio_wyn_1:	set
libmio_wyn_2:	ret

;-----------------------------------------------------------------------
; draw box for ask/alert, Y=pointer
;-----------------------------------------------------------------------
libmio_albox:	push	ZH			;save Z register
		push	ZL
		ldi	ctrl,0x02		;status normal
		sts	libmio_channel,const_0	;out to screen
		ld	XL,Y+			;fg
		call	libmio_setcol		;new color
		push	YH
		push	YL
		brtc	libmio_albox_0
		call	mon_backup
libmio_albox_0:	ldi	YL,0x02
		ldi	YH,0x08
		ldi	ZL,0x1b
		ldi	ZH,0x0c
		libmio_wbox
		ldi	XL,0x03
		ldi	XH,0x09
		libmio_gotoxy
		pop	YL
		pop	YH
		ldi	tempreg2,0x18		;max 24 chars
libmio_albox_1:	ld	tempreg1,Y+
		cpi	tempreg1,0x00
		breq	libmio_albox_2
		push	YH
		push	YL
		push	tempreg2
		libmio_outchar
		pop	tempreg2
		pop	YL
		pop	YH
		dec	tempreg2
		brne	libmio_albox_1		;loop

libmio_albox_2:	lds	tempreg1,libmio_color
		swap	tempreg1
		sts	libmio_color,tempreg1
		pop	ZL			;restore Z register
		pop	ZH
		ret
