;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# spi transfer module								#
;# copyright (c) 2006-2015 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

spi_set:	cpi	XL,0xff			;reset?
		brne	spi_set_2

spi_set_1:	out	SPCR,const_0		;disable SPI
		ldi	XL,0x5c			;standard
		out	SPCR,XL
		out	SPSR,const_0		;U2X=0
		ret

spi_set_2:	out	SPCR,const_0		;disable SPI
		out	SPSR,const_0		;U2X=0
		sbrc	XL,6
		out	SPSR,const_1		;U2X=1
		andi	XL,0x3f
		ori	XL,0x40
		out	SPCR,XL
		ret

spi_wait:	in	XH,SPSR
		sbrs	XH,SPIF
		rjmp	spi_wait
		ret
