;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# token table for line compressor/expander					#
;# copyright (c) 2006-2015 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
tokentab:
;functions
		.db 0x02,"ABS(..."
		.db 0x03,"SGN(..."
		.db 0x04,"SQR(..."
		.db 0x05,"NOT(..."
		.db 0x06,"RND(..."
		.db 0x07,"ADC(..."

		.db 0x08,"IN(...."
		.db 0x09,"XPEEK(."
		.db 0x0a,"TEMP(.."
		.db 0x0b,"LO(...."
		.db 0x0c,"HI(...."
		.db 0x0d,"KEY(..."
		.db 0x0e,"EPEEK(."
		.db 0x0f,"ERR(..."

		.db 0x10,"AR(...."
		.db 0x11,"SIN(..."
		.db 0x12,"COS(..."
		.db 0x13,"FTYPE(."
		.db 0x14,"FSIZE(."
		.db 0x15,"PSTAT(."
		.db 0x16,"SPI(..."
		.db 0x17,"MENU(.."

		.db 0x18,"VPEEK(."
		.db 0x19,"XREC(.."
		.db 0x1a,"FFIND(."
		.db 0x1b,"DBIT(.."

;commands
		.db 0x80,"PRINT.."
		.db 0x81,"CLS...."
		.db 0x82,"GOTO..."
		.db 0x83,"BOX...."
		.db 0x84,"ACOPY.."
		.db 0x85,"SYNC..."
		.db 0x86,"END...."
		.db 0x87,"BCOPY.."
		.db 0x88,"THEN..."
		.db 0x89,"POS...."
		.db 0x8a,"NOTE..."
		.db 0x8b,"ONSYNC."
		.db 0x8c,"RREAD.."
		.db 0x8d,"RWRITE."
		.db 0x8e,"GOSUB.."
		.db 0x8f,"RETURN."

		.db 0x90,"VMODE.."
		.db 0x91,"NEXT..."
		.db 0x92,"INPUT.."
		.db 0x93,"PLOT..."
		.db 0x94,"WAIT..."
		.db 0x95,"TSET..."
		.db 0x96,"TGET..."
		.db 0x97,"FSELECT"
		.db 0x98,"ONERR.."
		.db 0x99,"SPUT..."
		.db 0x9a,"SGET..."
		.db 0x9b,"EPOKE.."
		.db 0x9c,"GETPIX."
		.db 0x9d,"CIRCLE."
		.db 0x9e,"COLOR.."
		.db 0x9f,"BORDER."

		.db 0xa0,"FONT..."
		.db 0xa1,"PUMP..."
		.db 0xa2,"XPOKE.."
		.db 0xa3,"VPOKE.."
		.db 0xa4,"LIMIT.."
		.db 0xa5,"GETCHAR"
		.db 0xa6,"DRAWTO."
		.db 0xa7,"PLAY..."
		.db 0xa8,"SPRITE."
		.db 0xa9,"SCROLL."
		.db 0xaa,"BREAK.."
		.db 0xab,"REPEAT."
		.db 0xac,"UNTIL.."
		.db 0xad,"DRAW..."
		.db 0xae,"ICOMM.."
		.db 0xaf,"DATA..."

		.db 0xb0,"CTEXT.."
		.db 0xb1,"FREAD.."
		.db 0xb2,"FWRITE."
		.db 0xb3,"CBOX..."
		.db 0xb4,"GETATTR"
		.db 0xb5,"FDELETE"
		.db 0xb6,"FBOX..."
		.db 0xb7,"PALETTE"
		.db 0xb8,"FOR...."
		.db 0xb9,"IF....."
		.db 0xba,"DIR...."
		.db 0xbb,"OUT...."
		.db 0xbc,"FCIRCLE"
		.db 0xbd,"ALERT.."
		.db 0xbe,"FCREATE"
		.db 0xbf,"ASK...."

;abbrevations and alternatives

		.db 0xce,"GOS...."	;gosub
		.db 0xc0,"?......"	;print
		.db 0xc1,"XSEND.."	;XSEND is alternative to CLS
		.db 0xc2,"GO....."	;GOTO
		.db 0xc3,"TO....."	;TO is alternative to BOX
		.db 0xc4,"LOADP.."	;LOADP is alternative to ACOPY
		.db 0xc5,"SCALE.."	;SCALE is alternative to SYNC
		.db 0xc6,"CCHAR.."	;CCHAR is alternative to END
		.db 0xc7,"BC....."	;bcopy
		.db 0xc8,"SAVEP.."	;SAVEP is alternative to THEN
		.db 0xc9,"ARC...."	;ARC is alternative to POS
		.db 0xca,"NO....."	;note
		.db 0xcb,"PIE...."	;PIE is alternative to ONSYNC
		.db 0xcc,"RRD...."	;rread
		.db 0xcd,"RWR...."	;rwrite
		.db 0xcf,"RET...."	;return
		
		.db 0xd0,"VM....."	;vmode
		.db 0xd1,"IBOX..."	;IBOX is alternative to NEXT
		.db 0xd2,"INP...."	;input
		.db 0xd3,"PL....."	;plot
		.db 0xd4,"FRAME.."	;FRAME is alternative to WAIT
		.db 0xd5,"HFRAME."	;HFRAME is alternative to TSET
		.db 0xd6,"LFIND.."	;LFIND ist alternative to TGET
		.db 0xd7,"FSEL..."	;fselect
		.db 0xd8,"VOL...."	;VOL is alternative to ONERR
		.db 0xd9,"TLEN..."	;TLEN is alternative to SPUT
		.db 0xda,"ASHIFT."	;ASHIFT is alternative to SGET
		.db 0xdb,"EP....."	;epoke
		.db 0xdc,"GPX...."	;getpix
		.db 0xdd,"CI....."	;circle
		.db 0xde,"COL...."	;color
		.db 0xdf,"BO....."	;border

		.db 0xe0,"CALL..."	;CALL is alternative to FONT
		.db 0xe1,"CA....."	;CA is alternative to PUMP
		.db 0xe2,"XP....."	;xpoke
		.db 0xe3,"VP....."	;vpoke
		.db 0xe4,"LIM...."	;limit
		.db 0xe5,"GCH...."	;gchar
		.db 0xe6,"DTO...."	;drawto
		.db 0xe7,"WRAP..."	;WRAP is alternative to PLAY
		.db 0xe8,"SPR...."	;sprite
		.db 0xeb,"REP...."	;repeat
		.db 0xec,"UNT...."	;until
		.db 0xed,"DR....."	;draw
		.db 0xee,"IC....."	;icomm
		.db 0xef,"DA....."	;data

		.db 0xf0,"SPISEL."	;SPISEL is alternative to CTEXT
		.db 0xf1,"FRD...."	;fread
		.db 0xf2,"FWR...."	;fwrite
		.db 0xf3,"BAUD..."	;BAUD is alternative to CBOX
		.db 0xf4,"GAT...."	;gattr
		.db 0xf5,"FDEL..."	;fdelete
		.db 0xf6,"PAGE..."	;PAGE is alternative to FBOX
		.db 0xf7,"PAL...."	;palette
		.db 0xf8,"TFIND.."	;text find
		.db 0xf9,"VID...."	;VID is alternative to IF
		.db 0xfa,"ESPUT.."	;ESPUT is alternative to DIR
		.db 0xfb,"ESGET.."	;ESGET is alternative to OUT
		.db 0xfc,"FCI...."	;fcircle
		.db 0xfd,"EBAUD.."	;EBAUD is alternative to ALERT
		.db 0xfe,"FCR...."	;fcreate

		.db 0x00,"......."	;stop
