#!/usr/bin/perl
#################################################################################
#										#
# table generator for libmio							#
# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)				#
#										#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 2		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################

$takt=16000000;
$pwm=256;
$maxcount=65536;
$fakt=3.5;

$count=0;
$ncount=1;
$cmode=0;
$cline=0;
$cpos=0;

sub clear_cells
{
    for($i=0;$i<6144;$i++)
    {
	$cell[$i]=00;
    }
}

sub get_pixel
{
    $nb=0;
    if ($z =~ /^\./) {$nb=0}
    elsif ($z =~ /^b/) {$nb=2}
    elsif ($z =~ /^r/) {$nb=4}
    elsif ($z =~ /^m/) {$nb=6}
    elsif ($z =~ /^g/) {$nb=8}
    elsif ($z =~ /^c/) {$nb=10}
    elsif ($z =~ /^y/) {$nb=12}
    elsif ($z =~ /^w/) {$nb=12}
    elsif ($z =~ /^B/) {$nb=2}
    elsif ($z =~ /^R/) {$nb=4}
    elsif ($z =~ /^M/) {$nb=6}
    elsif ($z =~ /^G/) {$nb=8}
    elsif ($z =~ /^C/) {$nb=10}
    elsif ($z =~ /^Y/) {$nb=12}
    elsif ($z =~ /^W/) {$nb=14}
    $z=$';
    return $nb;
}

sub get_nibble
{
    $nb=255;
    if ($z =~ /^0/) {$nb=0}
    elsif ($z =~ /^1/) {$nb=1}
    elsif ($z =~ /^2/) {$nb=2}
    elsif ($z =~ /^3/) {$nb=3}
    elsif ($z =~ /^4/) {$nb=4}
    elsif ($z =~ /^5/) {$nb=5}
    elsif ($z =~ /^6/) {$nb=6}
    elsif ($z =~ /^7/) {$nb=7}
    elsif ($z =~ /^8/) {$nb=8}
    elsif ($z =~ /^9/) {$nb=9}
    elsif ($z =~ /^a/) {$nb=10}
    elsif ($z =~ /^b/) {$nb=11}
    elsif ($z =~ /^c/) {$nb=12}
    elsif ($z =~ /^d/) {$nb=13}
    elsif ($z =~ /^e/) {$nb=14}
    elsif ($z =~ /^f/) {$nb=15}
    elsif ($z =~ /^,/) {$nb=100}
    $z=$';
    return $nb;
}

&clear_cells;

###############################################################################
# read character cells
###############################################################################
open (RTAB, "ctab_128c8.dat");
while(<RTAB>)
{
    $z=$_;
    chomp($z);
    if ($z =~ /cell/) 
    {
	$cline=0;
    }
    
    elsif (length($z)>5)
    {
	$pix1=&get_pixel();
	$pix2=&get_pixel();
	$pix3=&get_pixel();
	$pix4=&get_pixel();
	$pix5=&get_pixel();
	$pix6=&get_pixel();
	if (($cline>0) && ($cline <11))
	{
	    $cell[4*$count+512*($cline-1)]=$pix4+16*$pix1;
	    $cell[4*$count+512*($cline-1)+1]=$pix5+16*$pix2;
	    $cell[4*$count+512*($cline-1)+2]=$pix6+16*$pix3;
	}    
	$cline++;

        if ($cline==12)
	{
	    $cline=0;
	    $count++;
	}
    }

}

close(RTAB);

###############################################################################
# read keytable
###############################################################################
open (RTAB, "keytab_ger.dat");
$cellno=3;
print "Offset keytab: $cellno \n";
while(<RTAB>)
{
    $z=$_;
    $tc=0;
    if (length($z)>23)
    {
	for($i=0;$i<25;$i++)
	{
	    $knb=&get_nibble();
	    if ($knb < 16)
	    {
		$tc=$tc*16+$knb;
	    }
	    if ($knb == 100)
	    {
		$cell[$cellno]=$tc;
		$tc=0;
		$cellno+=4;
	    }
	}    
    }    
}

close(RTAB);

###############################################################################
# set wavetab1
###############################################################################
print "Offset wtab1: $cellno \n";
$sin1=0.65;
$cos1=0;
$sin2=0;
$cos2=0;
$sin3=0.2;
$cos3=0;
$sin4=0;
$cos4=0;
$sin5=0;
$cos5=0.1;
$sin6=0;
$cos6=0;
$sin7=0.05;
$cos7=0;

for($x=0;$x<256;$x++)
{
    $y=0;
    $y+=$sin1*127*sin($x*3.1416/128);
    $y+=$cos1*127*cos($x*3.1416/128);
    $y+=$sin2*127*sin($x*3.1416/64);
    $y+=$cos2*127*cos($x*3.1416/64);
    $y+=$sin3*127*sin($x*3.1416/42.66667);
    $y+=$cos3*127*cos($x*3.1416/42.66667);
    $y+=$sin4*127*sin($x*3.1416/32);
    $y+=$cos4*127*cos($x*3.1416/32);
    $y+=$sin5*127*sin($x*3.1416/25.6);
    $y+=$cos5*127*cos($x*3.1416/25.6);
    $y+=$sin6*127*sin($x*3.1416/21.33333);
    $y+=$cos6*127*cos($x*3.1416/21.33333);
    $y+=$sin7*127*sin($x*3.1416/18.2857);
    $y+=$cos7*127*cos($x*3.1416/18.2857);
    if ($y<(-0.5)) {$y=256+$y};
    $cell[$cellno]=$y;
    $cellno+=4;		
}

###############################################################################
# set envtab
###############################################################################
print "Offset envtab: $cellno \n";
$ende=16;
for($x=0;$x<128;$x++)
{
    $y=128*exp(-($x/$ende*$fakt))+0.5;
    if ($x > $ende) {$y=0};
    $cell[$cellno]=$y;
    $cellno+=4;		
}

###############################################################################
# create offset table
###############################################################################
print "Offset offset: $cellno \n";
$sprung=exp(log(2)/12);
$samfrq=$takt/$pwm;

for($x=0;$x<64;$x++)
{
    $freq=220*$sprung**($x+3);
    $delta=$maxcount*$freq/$samfrq;
    $y=int($delta+0.5);
    $yl=$y%256;
    $cell[$cellno]=$yl;
    $cellno+=4;		
    $yh=$y/256;
    $cell[$cellno]=$yh;
    $cellno+=4;		
}

###############################################################################
# write interleaved table
###############################################################################
open (WTAB, ">../table.inc");
    for($i=0;$i<320;$i++)
    {
        print WTAB "        .db "; 
        for($j=0;$j<16;$j++)
        {
	    $cellpos=$i*16+$j;
	    $y=$cell[$cellpos];
	    if ($y<1) {printf WTAB "0x00"} 
	    else {printf WTAB "%#2.2x",$y};
	    if ($j<15) {print WTAB ","}
	    else {print WTAB "\n"};
	}
    }
close(WTAB);

