;################################################################################
;#										#
;# libmio - multi i/o for ATMega 16/32 	version 0.20				#
;# copyright (c) 2005/2006 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# * PAL/NTSC RGB videodisplay with up to 32x24 chars and 8 colors		#
;# * 1 channel sound can play notes and noise					#
;# * ps2-keyboard interface							#
;# * 1200 Bps bidirectional serial port						#
;# * pseudorandom generator							#
;# * 0,1s timer									#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.macro libmio_vint
    jmp	libmio_isr
.endm

.macro libmio_init
    call	libmio_init
.endm

.macro libmio_outchar
    call	libmio_char
.endm

.macro libmio_outcomma
    call	libmio_comma
.endm

.macro libmio_outspace
    call	libmio_space
.endm

.macro libmio_waitkey
    .set	use_libmio_waitkey = 1
    .set	libmio_ps2key = 1
    call	libmio_waitkey
.endm

.macro libmio_cursor
    .set	use_libmio_cursor = 1
    .set	libmio_ps2key = 1
    call	libmio_cursor
.endm

.macro libmio_outdez
    .set	use_libmio_outd = 1
    call	libmio_outd
.endm

.macro libmio_outhex
    .set	use_libmio_outh = 1
    call	libmio_outh
.endm

.macro libmio_clrscr
    call	libmio_clr
.endm

.macro libmio_fillchar
    call	libmio_fill
.endm

.macro libmio_ramtext
    .set	use_libmio_oram = 1
    call	libmio_oram
.endm

.macro libmio_romtext
    .set	use_libmio_orom = 1
    call	libmio_orom
.endm

.macro libmio_thistext
    .set	use_libmio_othis = 1
    .set	use_libmio_gotoxy = 1
    call	libmio_othis
.endm

.macro libmio_mtext
    .set	use_libmio_mtext = 1
    call	libmio_mtext
.endm

.macro libmio_newline
    .set	use_libmio_newline = 1
    call	libmio_newline
.endm

.macro libmio_gotoxy
    .set	use_libmio_gotoxy = 1
    call	libmio_gxy
.endm

.macro libmio_plot
    .set	use_libmio_plot = 1
    call	libmio_plot
.endm

.macro libmio_box
    .set	use_libmio_plot = 1
    .set	use_libmio_box = 1
    call	libmio_box
.endm

.macro libmio_fbox
    .set	use_libmio_plot = 1
    .set	use_libmio_fbox = 1
    call	libmio_fbox
.endm

.macro libmio_sync
    .set	use_libmio_sync = 1
    call	libmio_sync
.endm

.macro libmio_note
    .set	use_libmio_note = 1
    call	libmio_note
.endm

.macro libmio_calc
    call	libmio_calc
.endm

.macro libmio_pser
    .set	use_libmio_serial = 1
    .set	use_libmio_pser = 1
    call	libmio_pser
.endm

.macro libmio_gser
    .set	use_libmio_serial = 1
    .set	use_libmio_gser = 1
    call	libmio_gser
.endm

.macro libmio_ppar
    .set	use_libmio_ppar = 1
    call	libmio_ppar
.endm

.macro libmio_color
    andi	XL,0x03
    sts		libmio_color,XL
.endm

.macro libmio_lscroll
    .set	use_libmio_lscroll = 1
    call	libmio_lsc
.endm

.macro libmio_lpscroll
    .set	use_libmio_lpscroll = 1
    call	libmio_lps
.endm

.macro libmio_screenshot
    .set	use_libmio_screenshot = 1
    call	libmio_scrs
.endm

.macro libmio_chpump
    .set	use_libmio_chp = 1
    call	libmio_chp
.endm

.equ	libmio_rampos_l	= libmio_ram
.equ	libmio_rampos_h = libmio_ram+1
.equ	libmio_line_l	= libmio_ram+2
.equ	libmio_line_h	= libmio_ram+3
.equ	libmio_cur_x	= libmio_ram+4
.equ	libmio_cur_y	= libmio_ram+5
.equ	libmio_cline 	= libmio_ram+6
.equ	libmio_vflags	= libmio_ram+7
.equ	libmio_frames	= libmio_ram+8

.equ	libmio_kbdclock	= libmio_ram+10
.equ	libmio_kbdshift	= libmio_ram+11
.equ 	libmio_kbdstate	= libmio_ram+12
.equ	libmio_scancode	= libmio_ram+13
.equ	libmio_keycode	= libmio_ram+14
.equ	libmio_lastkey	= libmio_ram+15

.equ	libmio_wpos_l	= libmio_ram+16
.equ	libmio_wpos_h	= libmio_ram+17
.equ	libmio_woff_l	= libmio_ram+18
.equ	libmio_woff_h	= libmio_ram+19
.equ	libmio_env	= libmio_ram+20
.equ	libmio_note_val	= libmio_ram+21

.equ	libmio_rand1	= libmio_ram+22
.equ	libmio_rand2	= libmio_ram+23
.equ	libmio_rand3	= libmio_ram+24
.equ	libmio_rand4	= libmio_ram+25
.equ	libmio_time0	= libmio_ram+26
.equ	libmio_time_l	= libmio_ram+27
.equ	libmio_time_h	= libmio_ram+28
.equ	libmio_tcnt	= libmio_ram+29
.equ	libmio_tdat	= libmio_ram+30
.equ	libmio_rcnt	= libmio_ram+31
.equ	libmio_rdat	= libmio_ram+32
.equ	libmio_config	= libmio_ram+33
.equ	libmio_channel  = libmio_ram+34
.equ	libmio_lpos	= libmio_ram+35
.equ	libmio_color	= libmio_ram+36
.equ	libmio_kflags	= libmio_ram+37
