#!/usr/bin/perl
#################################################################################
#										#
# screenshot tool for libmio verion 1.00					#
# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)				#
#										#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 2		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
$fname=$ARGV[0];

$ct[0]=".";
$ct[1]="B";
$ct[2]="R";
$ct[3]="M";
$ct[4]="G";
$ct[5]="C";
$ct[6]="Y";
$ct[7]="W";

sub get_pixel
{
    $nb=0;
    if ($z =~ /^\./) {$nb=0}
    elsif ($z =~ /^b/) {$nb=2}
    elsif ($z =~ /^r/) {$nb=4}
    elsif ($z =~ /^m/) {$nb=6}
    elsif ($z =~ /^g/) {$nb=8}
    elsif ($z =~ /^c/) {$nb=10}
    elsif ($z =~ /^y/) {$nb=12}
    elsif ($z =~ /^w/) {$nb=12}
    elsif ($z =~ /^B/) {$nb=2}
    elsif ($z =~ /^R/) {$nb=4}
    elsif ($z =~ /^M/) {$nb=6}
    elsif ($z =~ /^G/) {$nb=8}
    elsif ($z =~ /^C/) {$nb=10}
    elsif ($z =~ /^Y/) {$nb=12}
    elsif ($z =~ /^W/) {$nb=14}
    $z=$';
    return $nb;
}

sub get_nibble
{
    $nb=255;
    if ($z =~ /^0/) {$nb=0}
    elsif ($z =~ /^1/) {$nb=1}
    elsif ($z =~ /^2/) {$nb=2}
    elsif ($z =~ /^3/) {$nb=3}
    elsif ($z =~ /^4/) {$nb=4}
    elsif ($z =~ /^5/) {$nb=5}
    elsif ($z =~ /^6/) {$nb=6}
    elsif ($z =~ /^7/) {$nb=7}
    elsif ($z =~ /^8/) {$nb=8}
    elsif ($z =~ /^9/) {$nb=9}
    elsif ($z =~ /^A/) {$nb=10}
    elsif ($z =~ /^B/) {$nb=11}
    elsif ($z =~ /^C/) {$nb=12}
    elsif ($z =~ /^D/) {$nb=13}
    elsif ($z =~ /^E/) {$nb=14}
    elsif ($z =~ /^F/) {$nb=15}
    elsif ($z =~ /^,/) {$nb=100}
    $z=$';
    return $nb;
}

###############################################################################
# get filename and set color array
###############################################################################
$fname=$ARGV[0];

$ct[0]=".";
$ct[1]="B";
$ct[2]="R";
$ct[3]="M";
$ct[4]="G";
$ct[5]="C";
$ct[6]="Y";
$ct[7]="W";

###############################################################################
# set serial port and read data from chip
###############################################################################
system `stty 1200 cs8 -parenb -echo -crtscts -ixon < /dev/ttyS0`;
print "reading data...";
open (SER, "/dev/ttyS0");
    $data=<SER>;
close(SER);
print "done\n";

###############################################################################
# read character cells
###############################################################################
open (RTAB, "../generator/ctab_128c8.dat");
while(<RTAB>)
{
    $z=$_;
    chomp($z);
    if ($z =~ /cell/) 
    {
	$cline=0;
    }
    elsif (length($z)>5)
    {
	$pix1=&get_pixel();
	$pix2=&get_pixel();
	$pix3=&get_pixel();
	$pix4=&get_pixel();
	$pix5=&get_pixel();
	$pix6=&get_pixel();
	if (($cline>0) && ($cline <11))
	{
	    $cell[6*($cline-1)+60*$count+0]=$pix1/2;
	    $cell[6*($cline-1)+60*$count+1]=$pix2/2;
	    $cell[6*($cline-1)+60*$count+2]=$pix3/2;
	    $cell[6*($cline-1)+60*$count+3]=$pix4/2;
	    $cell[6*($cline-1)+60*$count+4]=$pix5/2;
	    $cell[6*($cline-1)+60*$count+5]=$pix6/2;
	}    
	$cline++;

        if ($cline==12)
	{
	    $cline=0;
	    $count++;
	}
    }
}
close(RTAB);

###############################################################################
# read image
###############################################################################
for($x=0;$x<690;$x++)
{
    $icell[$x]=ord(substr($data,$x,1))-128;
}

close(RTAB);

###############################################################################
# write xpm image
###############################################################################
open (WTAB, ">temp.xpm");
print WTAB "static char *screenshot_xpm[] ={\n";
print WTAB "\"372 240 8 1\",\n";
print WTAB "\". c #000000\",\n";
print WTAB "\"B c #0000ff\",\n";
print WTAB "\"R c #ff0000\",\n";
print WTAB "\"M c #ff00ff\",\n";
print WTAB "\"G c #00ff00\",\n";
print WTAB "\"C c #00ffff\",\n";
print WTAB "\"Y c #ffff00\",\n";
print WTAB "\"W c #ffffff\",\n";
for($pline=0;$pline<5;$pline++)
{
    print WTAB "\""; 
    for($chr=0;$chr<372;$chr++)
    {
        print WTAB "."; 
    }
    print WTAB "\",\n";
}

for($cline=0;$cline<23;$cline++)
{
    for($pline=0;$pline<10;$pline++)
    {
        print WTAB "\"......"; 
	for($chr=0;$chr<30;$chr++)
	{
	    $ctype=$icell[$chr+30*$cline];
	    if ($ctype>127)
	    {
	     $ctype-=128;
	    }
	    print WTAB $ct[$cell[6*$pline+60*$ctype]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+1]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+1]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+2]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+2]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+3]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+3]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+4]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+4]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+5]]; 
	    print WTAB $ct[$cell[6*$pline+60*$ctype+5]]; 
	}
        print WTAB "......\",\n";
    }
}
for($pline=0;$pline<5;$pline++)
{
    print WTAB "\""; 
    for($chr=0;$chr<372;$chr++)
    {
        print WTAB "."; 
    }
	if ($pline<5)
	{
            print WTAB "\",\n";
	}
	else
	{
            print WTAB "\"\n";
	}    
}
    
print WTAB "};\n"; 
close(WTAB);

###############################################################################
# convert xpm image to whatever you want
###############################################################################
system`convert temp.xpm $fname`;
system`rm temp.xpm`;
