;################################################################################
;#										#
;# avr-chipbasic v0.61								#
;# single chip basic computer with atmega 16					#
;# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 2 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.CSEG
.include	"m16def.inc"
.def		byte0 = r2
.def		byte1 = r3

.def		acc1l = r16
.def		acc1h = r17
.def		acc2l = r18
.def		acc2h = r19

.def		tempreg1 = r20
.def		tempreg2 = r21
.def		tempreg3 = r22
.def		tempreg4 = r23
.def		tempreg5 = r4
.def		tempreg6 = r5
.def		tempreg7 = r6
.def		tempreg8 = r7

.def		ereg = r24
.def		ctrl = r25

.equ		libmio_vram	= 0x060		;690 bytes video RAM
.equ		tb_expar_ros	= 0x320		;14 bytes operand stack
.equ		varspace	= 0x320		;52 bytes tbasic variables
.equ		tb_array	= 0x354		;32 bytes array @()
.equ		tb_ram		= 0x374		;16 bytes tbasic system RAM
.equ		tb_stacks	= 0x384		;20 bytes tbasic stacks
.equ		tb_sps		= 0x398		;10 bytes tbasic sps
.equ		tb_sprites	= 0x3a2		;30 bytes tbasic sprites

.equ		tb_inbuf	= 0x3c0		;32 bytes input buffer
.equ		tb_linebuf	= 0x3e0		;32 bytes line buffer
.equ		libmio_ram	= 0x400		;40 bytes libmio system RAM
.equ		stack		= 0x45f		;56 bytes system stack

.include	"libmio/definitions.asm"
.include	"macros.inc"

.org 0x0000
		rjmp	start
.org OC1Baddr	
		libmio_vint

		
start:		cli
		ldi	XL,0x00
		mov	byte0,XL
		ldi	XL,0x01
		mov	byte1,XL
		ldi	XL,HIGH(stack)
		out	SPH,XL
		ldi	XL,LOW(stack)
		out	SPL,XL
	    	libmio_init
		call	i2c_initl
		libmio_clrscr
		clr	ereg
		sei
		lds	XL,libmio_config	;config
		sbrc	XL,4			;autorun pin
loop:		jmp	menu_main		;editor
loop1:		call	tbrun			;run program
		rjmp	loop1			;run again

.include	"modules/i2c.asm"
.include	"modules/menu.asm"
.include	"modules/editor.asm"
.include	"modules/exparser.asm"
.include	"modules/memory.asm"
.include	"modules/interpreter.asm"


.include	"libs.inc"


.org	0x1600
libmio_table:
.include	"libmio/table.inc"
		