;################################################################################
;#										#
;# chipbasic - single chip basic computer with ATMega 16			#
;# full screen editor								#
;# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.set	editor_linestart = 2
.set	editor_lines = 20
.set	editor_linedigits = 2
.set	tb_linelen = 27
.set	mem_linelen = 25
.set	editor_unchanged = 19
.set	editor_changed = 21

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
editor_entry:	libmio_clrscr			;clear screen
		clr	ctrl
		libmio_thistext
		.db 0,0,editor_unchanged," PROGRAM: ",0
		ldi	ZL,LOW(libmio_vram+11)	;start of program name
		ldi	ZH,HIGH(libmio_vram+11)
		rcall	ee_readname
		rcall	editor_cstat		;clear status line
		ldi	YL,0
		ldi	YH,2
		ldi	ZL,61
		ldi	ZH,2
		libmio_fbox
		call	prg_list	
		cpi	ereg,0
		breq	editor_entry_p
editor_lnum_2:	ldi	XL,21			;yellow
		ldi	ZL,LOW(errtab1*2)
		ldi	ZH,HIGH(errtab1*2)
		cpi	ereg,1
		breq	editor_entry_o
		ldi	XL,17			;red
		mov	YH,ereg			;error number
		cpi	YH,18
		brcs	editor_lnum_3
		ldi	YH,17
editor_lnum_3:	dec	YH
		cpi	YH,0
		breq	editor_entry_f
editor_lnum_4:	lpm	tempreg1,Z+
		cpi	tempreg1,0
		brne	editor_lnum_4
		sbiw	ZL,1
editor_lnum_5:	lpm	tempreg1,Z+
		cpi	tempreg1,0
		breq	editor_lnum_5
		rjmp	editor_lnum_3	

editor_entry_f:	sbiw	ZL,1
editor_entry_o:	rcall	editor_fstat
		ldi	XL,2
		ldi	XH,22
		libmio_gotoxy
		libmio_romtext			;errortext
		libmio_thistext
		.db	255," IN ",0
		clr	XH
		lds	XL,tb_ram+12		;line no	
		inc	XL
		clr	XH
		ldi	ctrl,0x02
    		libmio_outdez
		ldi	tempreg1,':'
		libmio_outchar
		clr	XH
		lds	XL,tb_ram+11		;statement	
		inc	XL
		clr	XH
		ldi	ctrl,0x02
    		libmio_outdez
editor_entry_p:	ret				;thats all
		
;------------------------------------------------------------------------------
;main editor loop
;------------------------------------------------------------------------------
editor_main:	ldi	XL,editor_changed		;change signal char
		mov	tempreg6,XL
		ldi	tempreg4,editor_unchanged
		rcall	editor_entry
editor_main_00:	ldi	XL,3
		ldi	XH,2
editor_main_0:	libmio_gotoxy
editor_main_1:	libmio_cursor

;------------------------------------------------------------------------------
;pos1 key
;------------------------------------------------------------------------------
		cpi	tempreg1,0xe0		;pos1
		brne	editor_main_2
		ldi	XL,editor_linedigits+1
		rjmp	editor_main_0

;------------------------------------------------------------------------------
;end key
;------------------------------------------------------------------------------
editor_main_2:	cpi	tempreg1,0xe1		;end
		brne	editor_main_3
		ldi	XL,libmio_cols-1
		rjmp	editor_main_0

;------------------------------------------------------------------------------
;cursor left key
;------------------------------------------------------------------------------
editor_main_3:	cpi	tempreg1,0xe2		;left
		brne	editor_main_4
		dec	XL
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;cursor right key
;------------------------------------------------------------------------------
editor_main_4:	cpi	tempreg1,0xe3		;right
		brne	editor_main_5
		inc	XL	
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;cursor up key
;------------------------------------------------------------------------------
editor_main_5:	cpi	tempreg1,0xe4		;up
		brne	editor_main_6
		dec	XH
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;cursor down key
;------------------------------------------------------------------------------
editor_main_6:	cpi	tempreg1,0xe5		;down
		brne	editor_main_7
		inc	XH
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;enter key
;------------------------------------------------------------------------------
editor_main_7:	cpi	tempreg1,0xea		;enter
		brne	editor_main_70
		inc	XH
		ldi	XL,3
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;check for borders
;------------------------------------------------------------------------------
editor_checkb:	cpi	XL,editor_linedigits+1
		brcc	editor_chb1
		ldi	XL,editor_linedigits+1
editor_chb1:	cpi	XL,libmio_cols
		brcs	editor_chb2
		ldi	XL,libmio_cols-1			
editor_chb2:	cpi	XH,editor_linestart
		brcc	editor_chb3
		ldi	XH,editor_linestart
editor_chb3:	cpi	XH,editor_linestart+editor_lines
		brcs	editor_chb4
		ldi	XH,editor_linestart+editor_lines-1
editor_chb4:	sts	libmio_cur_x,XL
	    	sts	libmio_cur_y,XH
		rjmp	editor_main_1			

;------------------------------------------------------------------------------
;alt+delete key
;------------------------------------------------------------------------------
editor_main_70:	cpi	tempreg1,0xe9		;delete
		brne	editor_main_75
		lds	tempreg2,libmio_kbdstate
		sbrs	tempreg2,4		;check alt key
		rjmp	editor_main_75
		lds	XL,libmio_cur_y		;recent y-pos
		subi	XL,editor_linestart
		cpi	XL,editor_lines-1	;last line
		brne	editor_main_72
editor_main_71:	rcall	editor_cline		;clear line
		rjmp	editor_change
editor_main_72:	rcall	editor_cnext
		inc	XL			;next line
		cpi	XL,editor_lines-1
		brne	editor_main_72
		rjmp	editor_main_71

;------------------------------------------------------------------------------
;alt+insert key (insert line)
;------------------------------------------------------------------------------
editor_main_75:	cpi	tempreg1,0xe8		;insert
		brne	editor_main_8
		lds	tempreg1,libmio_kbdstate
		sbrs	tempreg1,4		;check alt key
		rjmp	editor_main_8
		lds	XL,libmio_cur_y		;recent y-pos
		subi	XL,editor_linestart
		cpi	XL,editor_lines-1	;last line
		brne	editor_main_77
editor_main_76:	rcall	editor_cline		;clear line
		rjmp	editor_change
editor_main_77:	mov	tempreg2,XL		;copy line number
		ldi	XL,editor_lines-1	;last line
editor_main_78:	rcall	editor_cprev		;copy from prev
		dec	XL
		cp	XL,tempreg2
		brne	editor_main_78
		rjmp	editor_main_76	
		
;------------------------------------------------------------------------------
;delete key
;------------------------------------------------------------------------------
editor_main_8:	cpi	tempreg1,0xe9		;delete
		brne	editor_main_9
		rcall	editor_dchar
		rjmp	editor_change

;------------------------------------------------------------------------------
;backspace key
;------------------------------------------------------------------------------
editor_main_9:	cpi	tempreg1,0xec		;backspace
		brne	editor_main_a
		lds	XL,libmio_cur_x		;actual cursor
		cpi	XL,editor_linedigits+1	;at the beginning?
		brne	editor_main_91		;no
		rjmp	editor_main_1		;loop
editor_main_91:	dec	XL
		sts	libmio_cur_x,XL
		rcall	editor_dchar
		rjmp	editor_change		;loop

;------------------------------------------------------------------------------
;F2 save
;------------------------------------------------------------------------------
editor_main_a:	cpi	tempreg1,0xf2
		brne	editor_main_c
		lds	XL,libmio_vram
		cpi	XL,editor_unchanged	;no change
		breq	editor_main_b1
		ldi	XL,21
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 22,2,"SAVE PROGRAM Y/N ?",0
		rcall	editor_yn		
		cpi	tempreg1,'N'
		breq	editor_main_b
		rcall	editor_save
		ldi	tempreg4,editor_unchanged
editor_main_b:	rcall	editor_cstat
		clr	ereg
editor_main_b1:	rjmp	editor_main_00			

;------------------------------------------------------------------------------
;F3 Load
;------------------------------------------------------------------------------
editor_main_c:	cpi	tempreg1,0xf3
		brne	editor_main_d
		lds	XL,libmio_vram
		cpi	XL,editor_unchanged			;no change
		breq	editor_main_c1
		ldi	XL,21
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 22,2,"LOST CHANGES Y/N ?",0
		rcall	editor_yn		
		cpi	tempreg1,'N'
		breq	editor_main_b
		rcall	editor_load
editor_main_c1:	rjmp	editor_main_b

;------------------------------------------------------------------------------
;F8 new program
;------------------------------------------------------------------------------
editor_main_d:	cpi	tempreg1,0xf8
		brne	editor_mainr
		ldi	XL,21
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 22,2,"CLEAR PROGRAM Y/N ?",0
		rcall	editor_yn		
		cpi	tempreg1,'N'
		breq	editor_main_e
		rcall	editor_new
		sts	libmio_vram,tempreg6	;set change symbol
editor_main_e:	rjmp	editor_main_b

;------------------------------------------------------------------------------
;F9 edit programm name
;------------------------------------------------------------------------------
editor_mainr:	cpi	tempreg1,0xf9
		brne	editor_exit
		lds	tempreg7,libmio_cur_x
		lds	tempreg8,libmio_cur_y
		rcall	editor_ren
		ldi	ZL,LOW(libmio_vram+11)	;start of program name
		ldi	ZH,HIGH(libmio_vram+11)
		rcall	ee_writename
		sts	libmio_cur_x,tempreg7
		sts	libmio_cur_y,tempreg8
		rjmp	editor_main_1

;------------------------------------------------------------------------------
;ESC
;------------------------------------------------------------------------------
editor_exit:	cpi	tempreg1,0xed
		brne	editor_main_k
		lds	XL,libmio_vram
		cpi	XL,editor_unchanged	;no change
		brne	editor_exit_1
		ret
editor_exit_1:	ldi	XL,21
		rcall	editor_fstat
		libmio_thistext
		.db 22,2,"QUIT W/O SAVE Y/N ?",0
		rcall	editor_yn		
		cpi	tempreg1,'N'
		breq	editor_main_e
		ret

;------------------------------------------------------------------------------
;F10 run
;------------------------------------------------------------------------------
editor_main_k:	cpi	tempreg1,0xfa		;F10
		brne	editor_main_f		;no
		lds	XL,libmio_vram
		cpi	XL,editor_unchanged			;no change
		brne	editor_main_l
		libmio_clrscr			;clear screen
		ret				;go back and run
editor_main_l:	ldi	XL,18
		rcall	editor_fstat
		libmio_thistext
		.db 22,2,"SAVE CHANGES BEFORE RUN!",0
		libmio_waitkey		
		rjmp	editor_main_b

editor_main_f:
;------------------------------------------------------------------------------
;a visible  char
;------------------------------------------------------------------------------
editor_main_20:	lds	XL,libmio_kbdstate
		sbrc	XL,2			;left ctrl
		rjmp	editor_main_ig		;ignore
		sbrc	XL,3			;right ctrl
		rjmp	editor_main_ig		;ignore
		cpi	tempreg1,0x20		;Space
		brcs	editor_main_ig		;ignore less
		cpi	tempreg1,0x60		;last visible+1
		brcc	editor_main_ig		;igore greater or equal
		lds	XL,libmio_cur_x		;cursor position x
		cpi	XL,libmio_cols-1	;at the end?
		breq	editor_main_28
		mov	tempreg2,XL		;save x-pos
		ldi	XL,libmio_cols-1
		sts	libmio_cur_x,XL
		libmio_calc
editor_main_21:	ld	XH,-Y		
		std	Y+1,XH
		dec	XL
		cp	XL,tempreg2
		brne	editor_main_21
		sts	libmio_cur_x,XL
		libmio_calc
    		st	Y,tempreg1
		inc	XL
		sts	libmio_cur_x,XL
		libmio_calc
		sts	libmio_vram,tempreg6		;change symbol
		rjmp	editor_main_1		
				
editor_main_28:	libmio_calc			;calculate vram address
    		st	Y,tempreg1
editor_change:	sts	libmio_vram,tempreg6	;set change symbol
		rjmp	editor_main_1		;loop
		
editor_main_ig:	rjmp	editor_main_1		

;------------------------------------------------------------------------------
;editor load line XL
;------------------------------------------------------------------------------
editor_lline:	ldi	ZL,LOW(libmio_vram+2*libmio_cols+3)
		ldi	ZH,HIGH(libmio_vram+2*libmio_cols+3)
		ldi	tempreg1,libmio_cols
		mul	XL,tempreg1
		add	ZL,r0
		adc	ZH,r1
editor_lline1:	ldi	tempreg2,mem_linelen
		mul	tempreg2,XL
		mov	YL,r0
		mov	YH,r1
		ldi	tempreg2,mem_linelen	;bytes per line
editor_lline_1:	rcall	ee_read
		cpi	tempreg1,0xff
		breq	editor_lline_3
		cpi	tempreg1,0x80
		brcs	editor_lline_2
		push	XL
		call	tb_xtoken		;expand token
		pop	XL
		rjmp	editor_lline_1
editor_lline_2:	st	Z+,tempreg1
		dec	tempreg2
		brne	editor_lline_1
editor_lline_3:	ret
							
;------------------------------------------------------------------------------
;editor clear line (XL=0..17)
;------------------------------------------------------------------------------
editor_cline:	ldi	YL,LOW(libmio_vram+2*libmio_cols+3)
		ldi	YH,HIGH(libmio_vram+2*libmio_cols+3)
		ldi	XH,libmio_cols
		mul	XL,XH
		add	YL,r0
		adc	YH,r1
		ldi	XH,libmio_cols-editor_linedigits-1
		ldi	tempreg1,0x20		;space
editor_cline_1:	st	Y+,tempreg1
		dec	XH
		brne	editor_cline_1
		ret			

;------------------------------------------------------------------------------
;copy line (XL=0..16) from next
;------------------------------------------------------------------------------
editor_cnext:	ldi	YL,LOW(libmio_vram+2*libmio_cols+3)
		ldi	YH,HIGH(libmio_vram+2*libmio_cols+3)
		ldi	XH,libmio_cols
		mul	XL,XH
		add	YL,r0
		adc	YH,r1
		ldi	XH,libmio_cols-editor_linedigits-1
editor_cnext_1:	ldd	tempreg1,Y+libmio_cols
		st	Y+,tempreg1
		dec	XH
		brne	editor_cnext_1
		ret			

;------------------------------------------------------------------------------
;copy line (XL=1..17) from previous
;------------------------------------------------------------------------------
editor_cprev:	ldi	YL,LOW(libmio_vram+libmio_cols+3)
		ldi	YH,HIGH(libmio_vram+libmio_cols+3)
		ldi	XH,libmio_cols
		mul	XL,XH
		add	YL,r0
		adc	YH,r1
		ldi	XH,libmio_cols-3
editor_cprev_1:	ld	tempreg1,Y+
		std	Y+libmio_cols-1,tempreg1
		dec	XH
		brne	editor_cprev_1
		ret			

;------------------------------------------------------------------------------
;del char on cursor pos
;------------------------------------------------------------------------------
editor_dchar:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		lds	XL,libmio_cur_y		;cursor position y
		ldi	XH,libmio_cols
		mul	XL,XH
		add	YL,r0
		adc	YH,r1
		lds	XL,libmio_cur_x		;cursor position x
		add	YL,XL
		adc	YH,byte0
editor_dchar_1:	cpi	XL,libmio_cols-1	;at the end?
		breq	editor_dchar_2
		ldd	XH,Y+1
		st	Y+,XH
		inc	XL
		rjmp	editor_dchar_1	
		
editor_dchar_2:	ldi	XH,0x20			;space
		st	Y,XH
		ret


;------------------------------------------------------------------------------
;check keys for Y/N 
;------------------------------------------------------------------------------
editor_yn:	libmio_waitkey
		cpi	tempreg1,'Y'
		breq	editor_yn1
		cpi	tempreg1,'N'
		breq	editor_yn1
		cpi	tempreg1,0xed		;ESC
		brne	editor_yn2
		ldi	tempreg1,'N'
editor_yn1:	ret		
editor_yn2:	cpi	tempreg1,0xea
		brne	editor_yn
		ldi	tempreg1,'Y'
		ret		
		
;------------------------------------------------------------------------------
;load program from EEPROM
;------------------------------------------------------------------------------
editor_load:	call	prg_list		;get program
		sts	libmio_vram,tempreg4	;delete change symbol
		ret

;------------------------------------------------------------------------------
;save program to EEPROM
;------------------------------------------------------------------------------
editor_save:	ldi	XL,0x00			;first line
editor_save1:	push	XL
		rcall	ee_writeline
		pop	XL
		inc	XL
		cpi	XL,editor_lines
		brne	editor_save1
		ldi	tempreg4,editor_unchanged
		sts	libmio_vram,tempreg4	;delete change symbol
		ret	

;------------------------------------------------------------------------------
;new program
;------------------------------------------------------------------------------
editor_new:	ldi	XL,0
editor_new_1:	rcall	editor_cline
		inc	XL
		cpi	XL,editor_lines
		brne	editor_new_1
		ret

;------------------------------------------------------------------------------
;clear status line 
;------------------------------------------------------------------------------
editor_cstat:	ldi	XL,19
		rcall	editor_fstat
		libmio_thistext
		.db 22,2,19,"OK",0
		ret

;------------------------------------------------------------------------------
;fill status line with XL 
;------------------------------------------------------------------------------
editor_fstat:	push	ZL
		push	ZH
		ldi	ZL,LOW(libmio_vram+libmio_cols*(libmio_rows-1))	
		ldi	ZH,HIGH(libmio_vram+libmio_cols*(libmio_rows-1))	
		ldi	XH,libmio_cols
editor_fstat1:	st	Z+,XL
		dec	XH
		brne	editor_fstat1
		pop	ZH
		pop	ZL		
		ret

;-----------------------------------------------------------------------
; edit name
;-----------------------------------------------------------------------
editor_ren:	ldi	XH,0
		ldi	XL,11
		libmio_gotoxy
edit_ren_01:	libmio_cursor			;view cursor
		cpi	tempreg1,0xea		;enter
		brne	edit_ren_02
		ret
edit_ren_02:	cpi	tempreg1,0xe2		;cursor left
		brne	edit_ren_03
		lds	XL,libmio_cur_x
		cpi	XL,11
		breq	edit_ren_01
		dec	XL
		sts	libmio_cur_x,XL
		rjmp	edit_ren_01
edit_ren_03:	cpi	tempreg1,0xe3		;cursor right
		brne	edit_ren_04
		lds	XL,libmio_cur_x
		cpi	XL,20
		breq	edit_ren_01
		inc	XL
		sts	libmio_cur_x,XL
		rjmp	edit_ren_01
edit_ren_04:	cpi	tempreg1,32
		brcs	edit_ren_01			
		cpi	tempreg1,0x60
		brcc	edit_ren_01
		st	Y,tempreg1
		lds	XL,libmio_cur_x
		cpi	XL,20
		breq	edit_ren_05
		inc	XL
		sts	libmio_cur_x,XL
edit_ren_05:	rjmp	edit_ren_01
					
;------------------------------------------------------------------------------
;status messages
;------------------------------------------------------------------------------
errtab1:	.db "BREAK",0,"OVERFLOW",0,"DIVIDE /0",0,"SQR FROM <0",0
errtab5:	.db "CONSTANT TOO BIG",0,"WRONG EXPRESSION",0,"SYNTAX ERROR",0,"UNKNOWN KEYWORD",0
errtab9:	.db "WRONG FORMAT",0,"BAD LINENUMBER",0,"NEXT W/O FOR",0,"RETURN W/O CALL",0
errtab13:	.db "TOO MANY CALL",0,"TOO MANY FOR",0,"WRONG CHANNEL",0,"I2C ERROR",0
errtab17:	.db "UNKNOWN ERROR",0
