;################################################################################
;#										#
;# chipbasic - single chip basic computer with ATMega 16			#
;# expression parser								#
;# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
; ereg			= error code
;		 0	= OK
;		 1	= break
;		 2	= overflow (add,sub,mul)
;		 3	= division by zero
;		 4	= square root from negative value
;		 5	= constant overflow (basic expression parser)
;		 6	= garbage in expression
;		 7	= syntax error (basic expression parser)
;
;		tb_expar_ros	= address of stack root
;##############################################################################

;##############################################################################
; the basic parser
; Z= pointer in ram
;##############################################################################
tb_expar:	ldi	YL,LOW(tb_expar_ros)	;set stack pointer
		ldi	YH,HIGH(tb_expar_ros)	;
		st	-Y,byte0		;write low value
		st	-Y,byte0		;write high value
		ldi	ereg,0x00		;no error
		push	byte0			;stack stopper
		clr	XL			;OP L
		clr	XH			;OP H
		clr	tempreg1		;clear status (last=op)

;------------------------------------------------------------------------------
; get character from string
;------------------------------------------------------------------------------
tb_expar_bp_01:	ld	tempreg4,Z+		;get char
		cpi	tempreg4,0x20		;space
		breq	tb_expar_bp_01
		
;------------------------------------------------------------------------------
; check if we are at the end of expression
;------------------------------------------------------------------------------
tb_expar_bp_e1:	cpi	tempreg4,0xff		;EOL?
		breq	tb_expar_bp_e2
		cpi	tempreg4,':'		;":" next statement 
		breq	tb_expar_bp_e2		;yes
		cpi	tempreg4,','		;"," parameter separator
		breq	tb_expar_bp_e2		;yes
		cpi	tempreg4,0x3b		;";" parameter separator
		breq	tb_expar_bp_e2		;yes
		cpi	tempreg4,0x20		;" " parameter separator
		breq	tb_expar_bp_e2		;yes
		brne	tb_expar_bp_s1
tb_expar_bp_e2:	pop	tempreg2		;get last operand
		cpi	tempreg2,0x00		;end?
		breq	tb_expar_bp_e3		;->end
		cpi	tempreg2,0x0f
		brcs	tb_expar_bp_e5
		rcall	tb_expar_bp_x
		rjmp	tb_expar_bp_e2
tb_expar_bp_e3:	ld	XH,Y+			;get high result
		ld	XL,Y+			;get low result
tb_expar_bp_e4:	sbiw	ZL,1			;corect Z-pointer
		ret
tb_expar_bp_e5:	ldi	ereg,6
tb_expar_bp_e6:	pop	tempreg2		;get last operand
		cpi	tempreg2,0x00		;end?
		breq	tb_expar_bp_e3		;->end
		rjmp	tb_expar_bp_e6
					
;------------------------------------------------------------------------------
; space will be ignored
;------------------------------------------------------------------------------
tb_expar_bp_s1:	cpi	tempreg4,0x20		;space
		breq	tb_expar_bp_01		;next char


;------------------------------------------------------------------------------
; check for a binary number
;------------------------------------------------------------------------------
tb_expar_bin1:	cpi	tempreg4,92		;binary numbers start with ~
		brne	tb_expar_hex1
tb_expar_bin2:	clr	tempreg3
		ld	tempreg4,Z+		;get next char
		cpi	tempreg4,48		;"0"
		breq	tb_expar_bin3		;add zero digit
		cpi	tempreg4,49		;"1"
		brne	tb_expar_bin4
		inc	tempreg3		;
tb_expar_bin3:	lsl	XL
		rol	XH
		or	XL,tempreg3
		brcs	tb_expar_bin5		;overflow
		rjmp	tb_expar_bin2
tb_expar_bin4:	rjmp	tb_expar_bp_n3
tb_expar_bin5:	rjmp	tb_expar_bp_n5		

;------------------------------------------------------------------------------
; check for a hexadecimal number
;------------------------------------------------------------------------------
tb_expar_hex1:	cpi	tempreg4,'$'		;hex numbers start with $
		brne	tb_expar_bp_n1		;no
tb_expar_hex2:	ld	tempreg4,Z+		;get next char
		cpi	tempreg4,48		;"0"
		brcs	tb_expar_hex3		;less than "0"
		cpi	tempreg4,58		;"9"+1
		brcc	tb_expar_hex3		;greater then "9"
		subi	tempreg4,48		;number base
		rjmp	tb_expar_hex4
tb_expar_hex3:	cpi	tempreg4,65		;"A"
		brcs	tb_expar_hex5		;less than "A"
		cpi	tempreg4,71		;"F"+1
		brcc	tb_expar_hex5		;greater then "F"
		subi	tempreg4,55		;hex base	
tb_expar_hex4:	cpi	XH,0x10
		brcc	tb_expar_hex6		;error
		swap	XL			;*16
		swap	XH
		mov	tempreg2,XL
		andi	tempreg2,0x0f
		andi	XL,0xf0
		or	XH,tempreg2
		add	XL,tempreg4
		rjmp	tb_expar_hex2
tb_expar_hex5:	rjmp	tb_expar_bp_n3
tb_expar_hex6:	rjmp	tb_expar_bp_n5		
		
;------------------------------------------------------------------------------
; check for a decimal number
;------------------------------------------------------------------------------
tb_expar_bp_n1:	cpi	tempreg4,48		;"0"
		brcs	tb_expar_bp_m1		;next check
		cpi	tempreg4,58		;"9"+1
		brcc	tb_expar_bp_m1		;next check
		cpi	tempreg1,0x80		;last was op?		
		brcs	tb_expar_bp_n2
		ldi	ereg,6			;missing operator
		rjmp	tb_expar_bp_err		;error handling

;mult result with 10 and add actual value		
tb_expar_bp_n2:	lsl	XL			;*2
		rol	XH			;
		brcs	tb_expar_bp_n5		;overflow
		mov	tempreg5,XL		;result *2
		mov	tempreg6,XH		
		lsl	XL			;*2
		rol	XH			;
		brcs	tb_expar_bp_n5		;overflow
		lsl	XL			;*2
		rol	XH			;
		brcs	tb_expar_bp_n5		;overflow
		add	XL,tempreg5		;-> x*10
		adc	XH,tempreg6
		brcs	tb_expar_bp_n5		;overflow
		subi	tempreg4,48		;add value
		add	XL,tempreg4
		adc	XH,byte0
		brcs	tb_expar_bp_n5		;overflow
		sbrc	XH,7			;negative
		rjmp	tb_expar_bp_n5
		ld	tempreg4,Z+		;get next char
		cpi	tempreg4,48		;"0"
		brcs	tb_expar_bp_n3		;not a digit
		cpi	tempreg4,58		;"9"+1
		brcc	tb_expar_bp_n3		;not a digit
		rjmp	tb_expar_bp_n2		;add this digit			
		
tb_expar_bp_n3:	cpi	tempreg1,0x7f		;inverter?
		brne	tb_expar_bp_n4
		rcall	tb_expar_inva		;invert value
tb_expar_bp_n4:	st	-Y,XL			;write low value
		st	-Y,XH			;write high value
		ldi	tempreg1,0x80		;last element is a value
		rjmp	tb_expar_bp_e1		;next			
		
tb_expar_bp_n5:	ldi	ereg,5			;constant overflow
		rjmp	tb_expar_bp_err		;error handling

;------------------------------------------------------------------------------
; multichar ops ABS( SGN( NOT( SQR( RND( ADC( DIN( PEEK(
;------------------------------------------------------------------------------
tb_expar_mo_nx:	rjmp	tb_expar_ary		;jump extender

tb_expar_bp_m1:	cpi	tempreg4,65		;>="A"
		brcs	tb_expar_mo_nx		;no 
		cpi	tempreg4,91		;<"Z"+1
		brcc	tb_expar_mo_nx		;no
		
		ld	tempreg3,Z
		cpi	tempreg3,65		;>="A"
		brcs	tb_expar_bp_v1		;no second alpha -> variable
		cpi	tempreg3,91		;<"Z"+1
		brcc	tb_expar_bp_v1		;no second alpha -> variable
		
		mov	tempreg5,YL		;save registers
		mov	tempreg6,YH
		mov	YL,ZL			;copy RAM pointer
		mov	YH,ZH
		sbiw	YL,1			;YL points to first char
		mov	r16,YL
		mov	r17,YH
		ldi	ZL,LOW(tb_expar_ttab*2)		;token table
		ldi	ZH,HIGH(tb_expar_ttab*2)	;token table
		ldi	tempreg2,0x04		;first token
tb_expar_mo_01:	lpm	tempreg4,Z+		;get char from table		
		cpi	tempreg4,0		;end of table
		brne	tb_expar_mo_02
		ldi	ereg,8			;unknown
		rjmp	tb_expar_bp_err		;error handling
tb_expar_mo_02:	cpi	tempreg4,' '		;found
		brne	tb_expar_mo_03
		ld	tempreg3,Y+
		cpi	tempreg3,'('
		brne	tb_expar_mo_05
		push	tempreg2		;push OP
		mov	tempreg1,tempreg2	;set status
		clr	XL			;clear operand
		clr	XH
		mov	ZL,YL
		mov	ZH,YH
		mov	YL,tempreg5
		mov	YH,tempreg6
		rjmp	tb_expar_bp_01		;next char
tb_expar_mo_03:	ld	tempreg3,Y+		;ram char
;		sts	0x200,tempreg4		;test chars
;		sts	0x201,tempreg3
;		libmio_waitkey
		cp	tempreg3,tempreg4
		breq	tb_expar_mo_01		;next char				
tb_expar_mo_04:	lpm	tempreg4,Z+
		cpi	tempreg4,0x20		;space
		brne	tb_expar_mo_04
		inc	tempreg2		;next token		
		mov	YL,r16			;points to first char in RAM
		mov	YH,r17
		rjmp	tb_expar_mo_01
tb_expar_mo_05:	ldi	ereg,7			;syntax error
		rjmp	tb_expar_bp_err		;error handling
		
;------------------------------------------------------------------------------
; a variable "A...Z"
;------------------------------------------------------------------------------
tb_expar_bp_v1:	cpi	tempreg1,0x80		;last was op?		
		brcs	tb_expar_bp_v2
		ldi	ereg,6			;missing operator
		rjmp	tb_expar_bp_err		;error handling

tb_expar_bp_v2:	subi	tempreg4,65		;-"A"
		lsl	tempreg4		;*2
		mov	tempreg5,ZL		;save Z-reg
		mov	tempreg6,ZH
		ldi	ZL,LOW(varspace)	;pointer to vars
		ldi	ZH,HIGH(varspace)
		add	ZL,tempreg4		;set actual pointer
		adc	ZH,byte0
		ld	XL,Z+
		ld	XH,Z+
		mov	ZL,tempreg5		;restore Z-reg			
		mov	ZH,tempreg6
		ld	tempreg4,Z+
		rjmp	tb_expar_bp_n3

;------------------------------------------------------------------------------
; an array element @(
;------------------------------------------------------------------------------
tb_expar_ary:	cpi	tempreg4,'@'		;start of array desc
		brne	tb_expar_bp_i1		;no
		ld	tempreg3,Z+		;get next char
		cpi	tempreg3,40		;"("
		brne	tb_expar_ary1		;error
		ldi	tempreg2,0x0d		;OP for @
		push	tempreg2		;push OP
		mov	tempreg1,tempreg2	;set status
		clr	XL			;clear operand
		clr	XH
		rjmp	tb_expar_bp_01		;next char
tb_expar_ary1:	ldi	ereg,6			;wrong expression		
		rjmp	tb_expar_bp_err		;error handling
		
;------------------------------------------------------------------------------
; an inverter
;------------------------------------------------------------------------------
tb_expar_bp_i1:	cpi	tempreg4,45		;"-"
		brne	tb_expar_bp_p1
		cpi	tempreg1,0x7f		;is already inverted
		brne	tb_expar_bp_i2
		clr	tempreg1
		rjmp	tb_expar_bp_01
tb_expar_bp_i2:	brcc	tb_expar_bp_i3		;last was not an operator
		ldi	tempreg1,0x7f		;set inverter
		rjmp	tb_expar_bp_01		;next			
tb_expar_bp_i3:	rjmp	tb_expar_bp_c1		

;------------------------------------------------------------------------------
; check for parantheses
;------------------------------------------------------------------------------
tb_expar_bp_p1:	cpi	tempreg4,40		;"("
		brne	tb_expar_bp_p2
		ldi	tempreg4,0x01		;code for left paranthesis
		push	tempreg4		;push to stack	
		clr	XL			;clear operand
		clr	XH
		mov	tempreg1,tempreg4
		rjmp	tb_expar_bp_01		;next character

tb_expar_bp_p2:	cpi	tempreg4,41		;")"
		brne	tb_expar_bp_l1
tb_expar_bp_p3:	pop	tempreg2		;get operator
		cpi	tempreg2,0x01		;left paranthesis
		breq	tb_expar_bp_p9		;yes
		cpi	tempreg2,0x04		;ABS(
		brne	tb_expar_bp_p4		;not
		rcall	tb_expar_abs
		rjmp	tb_expar_bp_p9		;goto end

tb_expar_bp_p4:	cpi	tempreg2,0x05		;SGN(
		brne	tb_expar_bp_p5		;not
		rcall	tb_expar_sgn
		rjmp	tb_expar_bp_p9		;goto end

tb_expar_bp_p5:	cpi	tempreg2,0x06		;SQR(
		brne	tb_expar_bp_pc		;not
		rcall	tb_expar_sqr
		cpi	ereg,0x00
		breq	tb_expar_bp_pa		;goto end
		rjmp	tb_expar_bp_err

tb_expar_bp_pc:	cpi	tempreg2,0x08		;RND(
		brne	tb_expar_bp_pr		;not
		rjmp	tb_expar_rnd

tb_expar_bp_pr:	cpi	tempreg2,0x0d		;@(
		brne	tb_expar_cp_ad		;not
		rjmp	tb_expar_ar

tb_expar_cp_ad:	cpi	tempreg2,0x09		;ADC(
		brne	tb_expar_cp_di		;not
		rjmp	tb_expar_adc

tb_expar_cp_di:	cpi	tempreg2,0x0a		;DIN(
		brne	tb_expar_cp_pe		;not
		rjmp	tb_expar_din

tb_expar_cp_pe:	cpi	tempreg2,0x0b		;PEEK(
		brne	tb_expar_cp_te		;not
		rjmp	tb_expar_peek

tb_expar_cp_te:	cpi	tempreg2,0x0c		;TEMP(
		brne	tb_expar_bp_p6		;not
		rjmp	tb_expar_temp
		

tb_expar_bp_p6:	cpi	tempreg2,0x07		;NOT(
		brne	tb_expar_bp_p7		;not
		ld	XH,Y+			;get high value of TOS/SEC
		ld	XL,Y+			;get low value of TOS/SEC
		com	XH			;invert
		com	XL			
		rjmp	tb_expar_bp_pa		;goto end
		
tb_expar_bp_p7:	cpi	tempreg2,0x00		;end
		breq	tb_expar_bp_p8		;no open 
		rcall	tb_expar_bp_x
		cpi	ereg,0x00
		breq	tb_expar_bp_p3
		rjmp	tb_expar_bp_err

tb_expar_bp_p8:	ldi	ereg,6			;error code
		ret				;thats all

tb_expar_bp_pa:	st	-Y,XL			;write result to stack
		st	-Y,XH			;

tb_expar_bp_p9:	clr	XL			;clear operand
		clr	XH
		ldi	tempreg1,0x02		;code for right paranthesis
		rjmp	tb_expar_bp_01		;next character
	
;------------------------------------------------------------------------------
; check if last was an operand
;------------------------------------------------------------------------------
tb_expar_bp_l1:	cpi	tempreg1,0x7f		;upper border for operators
		brcc	tb_expar_bp_c1		;last was no operator
		cpi	tempreg1,0x0f		;lower border for operators
		brcs	tb_expar_bp_c1
		ldi	ereg,6			;missing operand
		rjmp	tb_expar_bp_err

;------------------------------------------------------------------------------
; a comparsion
;------------------------------------------------------------------------------
tb_expar_bp_c1:	cpi	tempreg4,60		;"<"
		brne	tb_expar_bp_c4
		ldi	tempreg4,0x11		;code for less
		ld	tempreg3,Z		;get next
		cpi	tempreg3,62		;">"
		brne	tb_expar_bp_c2		;no
		ldi	tempreg4,0x12		;code for not equal
		ld	tempreg3,Z+		;correct Z-register
		rjmp	tb_expar_bp_d0		;do operation
tb_expar_bp_c2:	cpi	tempreg3,61		;"="
		brne	tb_expar_bp_c3		;no
		ldi	tempreg4,0x13		;code for less or equal
		ld	tempreg3,Z+		;correct Z-register		
tb_expar_bp_c3:	rjmp	tb_expar_bp_d0		;do operation

tb_expar_bp_c4:	cpi	tempreg4,62		;">"
		brne	tb_expar_bp_c6
		ldi	tempreg4,0x14		;code for greater
		ld	tempreg3,Z		;get next
		cpi	tempreg3,61		;"="
		brne	tb_expar_bp_c5		;no
		ldi	tempreg4,0x15		;code for greater or equal
		ld	tempreg3,Z+		;correct Z-register		
tb_expar_bp_c5:	rjmp	tb_expar_bp_d0		;do operation
				
tb_expar_bp_c6:	cpi	tempreg4,61		;"="
		brne	tb_expar_bp_c7
		ldi	tempreg4,0x16		;code for equal
		rjmp	tb_expar_bp_d0		;do operation
		
tb_expar_bp_c7:		
;------------------------------------------------------------------------------
; an arithmetic operator 
;------------------------------------------------------------------------------
tb_expar_bp_o1:	cpi	tempreg4,43		;"+"
		brne	tb_expar_bp_o2
		ldi	tempreg4,0x20		;code for +
		rjmp	tb_expar_bp_d0
			
tb_expar_bp_o2:	cpi	tempreg4,45		;"-"
		brne	tb_expar_bp_o3
		ldi	tempreg4,0x21		;code for sub
		rjmp	tb_expar_bp_d0

tb_expar_bp_o3:	cpi	tempreg4,35		;"#"
		brne	tb_expar_bp_o4
		ldi	tempreg4,0x22		;code for or
		rjmp	tb_expar_bp_d0
		
;next level		
					
tb_expar_bp_o4:	cpi	tempreg4,42		;"*"
		brne	tb_expar_bp_o5
		ldi	tempreg4,0x30		;code for mult
		rjmp	tb_expar_bp_d0
			
tb_expar_bp_o5:	cpi	tempreg4,47		;"/"
		brne	tb_expar_bp_o6
		ldi	tempreg4,0x31		;code for div
		rjmp	tb_expar_bp_d0	

tb_expar_bp_o6:	cpi	tempreg4,37		;"%"
		brne	tb_expar_bp_o7
		ldi	tempreg4,0x32		;code for mod
		rjmp	tb_expar_bp_d0	

tb_expar_bp_o7:	cpi	tempreg4,38		;"&"
		brne	tb_expar_bp_o8
		ldi	tempreg4,0x33		;code for and
		rjmp	tb_expar_bp_d0	

tb_expar_bp_o8:	ldi	ereg,7			;syntax error
				
;------------------------------------------------------------------------------
; clear stack on error 
;------------------------------------------------------------------------------
tb_expar_bp_err:	pop	tempreg1		;get operator
			cpi	tempreg1,0		;stack ist empty?
			brne	tb_expar_bp_err		;loop
tb_expar_bp_er1:	ret				;thats all		
		
;------------------------------------------------------------------------------
; do operator function 
;------------------------------------------------------------------------------
tb_expar_bp_d0:	pop	tempreg2		;get last operator from stack
	
	    	mov	XL,tempreg4		;recent operator
		mov	XH,tempreg2		;last operator		
		andi	XL,0xf0			;we need only priority
		andi	XH,0xf0			;		
		cp	XH,XL			;compare last with recent
		brcs	tb_expar_bp_d2		;branch if last is not less
		
tb_expar_bp_d1:	rcall	tb_expar_bp_x		;do last operation
		cpi	ereg,0x00		;error?
		brne	tb_expar_bp_err		;yes
		rjmp	tb_expar_bp_d0
		
;write last and recent operator on stack
		
tb_expar_bp_d2:	push	tempreg2		;put last on stack
		push	tempreg4		;put recent on stack
		clr	XL			;clear operand
		clr	XH
		mov	tempreg1,tempreg4	;set status
		rjmp	tb_expar_bp_01		;get next char

;------------------------------------------------------------------------------
; execute function with 2 parameters 
;------------------------------------------------------------------------------
tb_expar_bp_x:	push	r21
		push	r20
		ld	r17,Y+			;get high value of TOS
		ld	r16,Y+			;get low value of TOS
		ld	XH,Y+			;get high value of SEC
		ld	XL,Y+			;get low value of SEC

		cpi	tempreg2,0x11		;<
		brne	tb_expar_bp_x1
		rcall	tb_expar_gt
		rjmp	tb_expar_bp_xy		
		
tb_expar_bp_x1:	cpi	tempreg2,0x12		;<>
		brne	tb_expar_bp_x2
		rcall	tb_expar_eq
		subi	XL,1
		andi	XL,1
		rjmp	tb_expar_bp_xy		
		
tb_expar_bp_x2:	cpi	tempreg2,0x13		;<=
		brne	tb_expar_bp_x3
		rcall	tb_expar_lt
		subi	XL,1
		andi	XL,1
		rjmp	tb_expar_bp_xy		
		
tb_expar_bp_x3:	cpi	tempreg2,0x14		;>
		brne	tb_expar_bp_x4
		rcall	tb_expar_lt
		rjmp	tb_expar_bp_xy		
		
		
tb_expar_bp_x4:	cpi	tempreg2,0x15		;>=
		brne	tb_expar_bp_x5
		rcall	tb_expar_gt
		subi	XL,1
		andi	XL,1
		rjmp	tb_expar_bp_xy		
		
tb_expar_bp_x5:	cpi	tempreg2,0x16		;=
		brne	tb_expar_bp_x6
		rcall	tb_expar_eq
		rjmp	tb_expar_bp_xy
		
tb_expar_bp_x6:	cpi	tempreg2,0x20		;+
		brne	tb_expar_bp_x7
		rcall	tb_expar_add
		rjmp	tb_expar_bp_xy
		
tb_expar_bp_x7:	cpi	tempreg2,0x21		;-
		brne	tb_expar_bp_x8
		rcall	tb_expar_sub
		rjmp	tb_expar_bp_xy
		
tb_expar_bp_x8:	cpi	tempreg2,0x22		;or
		brne	tb_expar_bp_x9
		or	XL,r16
		or	XH,r17
		rjmp	tb_expar_bp_xy
		
tb_expar_bp_x9:	cpi	tempreg2,0x30		;*
		brne	tb_expar_bp_xa
		rcall	tb_expar_mul
		rjmp	tb_expar_bp_xy		;put TOS

tb_expar_bp_xa:	cpi	tempreg2,0x31		;/
		brne	tb_expar_bp_xb
		rcall	tb_expar_d16		;call division
		rjmp	tb_expar_bp_xy		;put TOS
		
tb_expar_bp_xb:	cpi	tempreg2,0x32		;%
		brne	tb_expar_bp_xc
		rcall	tb_expar_d16		;call division
		mov	XL,r18			;get remainder
		mov	XH,r19
		rjmp	tb_expar_bp_xy		;put TOS
		
tb_expar_bp_xc:	cpi	tempreg2,0x33		;and
		brne	tb_expar_bp_xy
		and	XL,r16
		and	XH,r17
		rjmp	tb_expar_bp_xy
		
tb_expar_bp_xy:	st	-Y,XL			;write result to stack
		st	-Y,XH			
		pop	r20
		pop	r21
		ret
		
;-------------------------------------------------------------------------------
; absolute value
; TOS <= abs(TOS)
;-------------------------------------------------------------------------------
tb_expar_abs:	ld	XH,Y+			;get high value of TOS
		ld	XL,Y+			;get low value of TOS
		rcall	tb_expar_absa		;calc absolute value
tb_expar_abs1:	st	-Y,XL			;write low value
		st	-Y,XH			;write high value
		ret

;-------------------------------------------------------------------------------
; absolute value of op1
;-------------------------------------------------------------------------------
tb_expar_absa:	sbrs	XH,7			;skip if negative
		ret				;return if op was positive
tb_expar_inva:	com	XL			;switch sign
		com	XH			;
		add	XL,byte1		;
		adc	XH,byte0		;
		ret				;thats all

;-------------------------------------------------------------------------------
; absolute value of op2
;-------------------------------------------------------------------------------
tb_expar_absb:	sbrs	r17,7			;skip if negative
		ret				;return if op was positive
tb_expar_invb:	com	r16			;switch sign
		com	r17			;
		add	r16,byte1		;
		adc	r17,byte0		;
		ret				;thats all

;-------------------------------------------------------------------------------
; signum
; TOS <= sign(TOS) (-1,0,1)
;-------------------------------------------------------------------------------
tb_expar_sgn:	ld	XH,Y+			;get high value of TOS
		ld	XL,Y+			;get low value of TOS
		or	XL,XH			;or to check if zero
		breq	tb_expar_sgn_1		;branch if not zero
		bst	XH,7			;write sign to T
		ldi	XL,0x01			;set to 1
		clr	XH		
		brtc	tb_expar_sgn_1
		sbiw	XL,2
tb_expar_sgn_1:	rjmp	tb_expar_abs1		;put result to stack
		

;-------------------------------------------------------------------------------
; 16 Bit subtraction
; (TOS) <= (SEC)-(TOS)
; t is set, if overflow
;-------------------------------------------------------------------------------
tb_expar_sub:	rcall	tb_expar_invb		;-(TOS)

;-------------------------------------------------------------------------------
; 16 Bit addition
; (TOS) <= (TOS)+(SEC)
; t is set, if overflow
;-------------------------------------------------------------------------------
tb_expar_add:	mov	r18,XH			;High 1
		eor	r18,r17			;exclusive or with high 2
		add	XL,r16			;add low bytes
		adc	XH,r17			;add high bytes
		sbrc	r18,7			;skip if signs equal
		ret				;result is ok
		mov	r18,XH			;High result
		eor	r18,r17			;High OP2
		sbrc	r18,7			;skip if signs equal
		ldi	ereg,2			;set error
		ret				;thats all

;-------------------------------------------------------------------------------
; 16 Bit multiplication
; (TOS) <= (TOS) * (SEC)
; t is set, if overflow
;-------------------------------------------------------------------------------
tb_expar_mul:	rcall	tb_mult32
tb_expar_mul_1:	mov	XL,r18			;result low
		mov	XH,r19			;result high
		andi	XH,0x7f			;set temp result positive
		brtc	tb_expar_mul_2		;result is positive
		rcall	tb_expar_inva		;invert result
tb_expar_mul_2:	sbrc	r19,7			;skip if no overflow
		rjmp	tb_expar_mul_e		;overflow in bit 15 -> error
		or	r20,r21
		brne	tb_expar_mul_e		;overflow
		ret
tb_expar_mul_e:	ldi	ereg,2			;set error
		ret				;thats all


;-------------------------------------------------------------------------------
; 16*16 Bit unsigned multiplication
;-------------------------------------------------------------------------------
tb_mult32:	mov	r18,XH			;High 1
		eor	r18,r17			;exclusive or with high 2
		bst	r18,7			;save sign
		rcall	tb_expar_absb		;absolute val 1
tb_mult32a:	rcall	tb_expar_absa		;absolute val 2
		mul	XH,r17			;high bytes
		mov	r20,r0
		mov	r21,r1
		mul	XL,r16			;low bytes
		mov	r18,r0
		mov	r19,r1
		mul	XL,r17			;first cross multiplication
		add	r19,r0		
		adc	r20,r1
		adc	r21,byte0
		mul	XH,r16			;second cross multiplication
		add	r19,r0		
		adc	r20,r1
		adc	r21,byte0
		ret
		
;-------------------------------------------------------------------------------
; 16 Bit signed division
; r16,r17 / XL,XH => r16,r17 + remainder r18,r19
;-------------------------------------------------------------------------------
tb_expar_d16:	mov	r18,r17			;HIGH divisor
		or	r18,r16			;or LOW divisor
		brne	tb_expar_cz_1		;jump if no zero
		ldi	ereg,3			;set error
		ret				;return (error)

tb_expar_cz_1:	mov	r18,XH			;High dividend
		eor	r18,r17			;exclusive or with high divisor
		bst	r18,7			;store sign of result in T
		rcall	tb_expar_absa		;absolute val 1
		rcall	tb_expar_absb		;absolute val 2
		clr	r18			;clear remainder L
		clr	r19			;clear remainder H
		clr	r20			;clear carry source
	    	ldi	r21,17			;loop counter
		
tb_expar_d16_1:	rol	r20
		rol	XL			;lshift dividend
		rol	XH			;
		dec	r21			;loop counter
		breq	tb_expar_d16_2		;end of loop
		rol	r18			;shift into remainder
		rol	r19			;
		ldi	r20,0xff		;set carry source
		sub	r18,r16			;sub divisor
		sbc	r19,r17			;
		brcc	tb_expar_d16_1		;branch if no borrow
		add	r18,r16			;add divisor to restore
		adc	r19,r17			;
		ldi	r20,0x00		;clear carry source
		rjmp	tb_expar_d16_1		;goto loop
tb_expar_d16_2:	brtc	tb_expar_d16_4		;jump if result is positive
		rjmp	tb_expar_inva		;invert result
tb_expar_d16_4:	ret				;thats all

;-------------------------------------------------------------------------------
; 16 Bit equal (return 1 if TOS == SEC)
;-------------------------------------------------------------------------------
tb_expar_eq:	eor	r16,XL			;compare low
		eor	r17,XH			;compare high
		clr	XL			;set result to 0
		clr	XH
		or	r16,r17			;diff bits
		breq	tb_expar_fls		
		ret

;-------------------------------------------------------------------------------
; 16 Bit greater (return 1 if TOS > SEC)
;-------------------------------------------------------------------------------
tb_expar_gt:  	subi	XH,0x80			;invert sign-bit of OP1
		subi	r17,0x80		;invert sign-bit of OP2
		sub	XL,r16			;SEC-TOS
		sbc	XH,r17
		clr	XL			;set to zero
		clr	XH
		brcs	tb_expar_fls		;no carry		
		ret

;-------------------------------------------------------------------------------
; 16 Bit less (return 1 if TOS < SEC)
;-------------------------------------------------------------------------------
tb_expar_lt:	subi	XH,0x80			;invert sign-bit of OP1
		subi	r17,0x80		;invert sign-bit of OP2
		sub	r16,XL			;TOS-SEC
		sbc	r17,XH
		clr	XL			;set to zero
		clr	XH
		brcs	tb_expar_fls				
		ret

;-------------------------------------------------------------------------------
; result is false
;-------------------------------------------------------------------------------
tb_expar_fls:	ldi	XL,0x01
		ldi	XH,0x00
		ret

;-------------------------------------------------------------------------------
; 16 Bit square root
; TOS <= sqrt(TOS)
; t is set, if operand is negative
;-------------------------------------------------------------------------------
tb_expar_sqr:	ld	XH,Y+			;get high value of TOS
		ld	XL,Y+			;get low value of TOS
		ldi	ereg,4			;set error
		sbrc	XH,7			;skip if positive
		ret
		push	r16
		push	r17
		push	r18
		push	r19
		clr	ereg			;clear error
		mov	r16,XL			;copy value
		mov	r17,XH		
		ldi	XH,2			;offset for tempreg
		clr	XL			;clear result
		mov	r18,byte1		;set tempreg to 1
		clr	r19
tb_expar_sqr_1:	sub	r16,r18			;sub tempreg
		sbc	r17,r19
		brcs	tb_expar_sqr_2		;overflow
		inc	XL			;result+1
		add	r18,XH			;tempreg=tempreg+2
		adc	r19,byte0		;
		rjmp	tb_expar_sqr_1		;loop
tb_expar_sqr_2:	clr	XH			;
		st	-Y,XL			;write low value
		st	-Y,XH			;write high value
		pop	r19
		pop	r18
		pop	r17
		pop	r16
		ret
		
;-------------------------------------------------------------------------------
; 16 Bit RND
;-------------------------------------------------------------------------------
tb_expar_rnd:	push	r20
		push	r21
		lds	r16,libmio_rand3
		lds	r17,libmio_rand2
		ld	XH,Y+			;get high value of TOS
		ld	XL,Y+			;get low value of TOS
		rcall	tb_mult32a		;mult
		ldi	r18,0x80
		add	r19,r18
		adc	r20,byte0
		adc	r21,byte0
		mov	XL,r20
		mov	XH,r21
		pop	r21
		pop	r20
		rjmp	tb_expar_bp_pa		;goto end

;-------------------------------------------------------------------------------
; arrayelement value
;-------------------------------------------------------------------------------
tb_expar_ar:	push	ZL
		push	ZH
		ld	XL,Y+			;get high value of TOS (dummy)
		ld	XL,Y+			;get low value of TOS
		ldi	ZL,LOW(tb_array)
		ldi	ZH,HIGH(tb_array)
		sbrc	XL,7			;is bit 7 set?
		rjmp	tb_expar_ar2
		andi	XL,0x0f
		lsl	XL
		add	ZL,XL
		adc	ZH,byte0
		ld	XL,Z+
		ld	XH,Z+
tb_expar_ar1:	pop	ZH
		pop	ZL
		rjmp	tb_expar_bp_pa		;goto end


tb_expar_ar2:	andi	XL,0x1f
		add	ZL,XL
		adc	ZH,byte0
		ld	XL,Z+
		clr	XH
		rjmp	tb_expar_ar1		;goto end

;-------------------------------------------------------------------------------
; analog input
;-------------------------------------------------------------------------------
tb_expar_adc:	ld	XL,Y+			;get high value of TOS (dummy)
		ld	XL,Y+			;get low value of TOS
		andi	XL,0x07
		ori	XL,0xc0
		out	ADMUX,XL
		sbi	ADCSR,ADSC
tb_expar_adc1:	sbic	ADCSR,ADSC
		rjmp	tb_expar_adc1
		in	XL,ADCL
		in	XH,ADCH		
		rjmp	tb_expar_bp_pa		;goto end

;-------------------------------------------------------------------------------
; digital input
;-------------------------------------------------------------------------------
tb_expar_din:	ld	XL,Y+			;get high value of TOS (dummy)
		ld	XL,Y+			;get low value of TOS
		andi	XL,0x07
		inc	XL
		in	XH,PINA
tb_expar_din_1:	lsr	XH
		dec	XL
		brne	tb_expar_din_1	
		clr	XL
		rol	XL
		clr 	XH
		rjmp	tb_expar_bp_pa		;goto end

;-------------------------------------------------------------------------------
; peek
;-------------------------------------------------------------------------------
tb_expar_peek:	ld	XL,Y+			;get high value of TOS
		ld	XH,Y+			;get low value of TOS
		mov	tempreg5,YL
		mov	tempreg6,YH
		mov	YL,XL
		mov	YH,XH
		call	i2c_rword
		mov	YL,tempreg5
		mov	YH,tempreg6
		rjmp	tb_expar_bp_pa		;goto end

;-------------------------------------------------------------------------------
; temp
;-------------------------------------------------------------------------------
tb_expar_temp:	ld	XL,Y+			;get high value of TOS (dummy)
		ld	XL,Y+			;get low value of TOS
		call	i2c_rtemp
		cpi	ereg,0
		brne	tb_expar_i2err
		rjmp	tb_expar_bp_pa		;goto end

tb_expar_i2err:	clr	XL
		clr	XH
		ldi	ereg,16
		rjmp	tb_expar_bp_e6
		
tb_expar_ttab:	.db "ABS SGN SQR NOT RND ADC IN PEEK TEMP ",0