;################################################################################
;#										#
;# chipbasic - single chip basic computer with ATMega 16			#
;# runtime engine								#
;# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.set	tb_maxline = 20
.set	tb_stackdepth = 4
tbrun:
;-----------------------------------------------------------------------
; clear all variables
;-----------------------------------------------------------------------
		ldi	ZH,HIGH(varspace)	
		ldi	ZL,LOW(varspace)
		ldi	XL,0			;zero
		ldi	XH,224			;52 bytes variables
tbrun_i1:	st	Z+,XL
		dec	XH
		brne	tbrun_i1
		dec	XL
		sts	tb_ram+13,XL		;last line is 255
		sts	libmio_color,byte0	;cyan plot
		ldi	XL,0xc6
		out	ADCSR,XL		;enable ADC
		
;-----------------------------------------------------------------------
; main loop for all lines
;-----------------------------------------------------------------------
tbrun_02:	rcall	ee_readline		;read line from EEPROM
		rcall	tb_run			;interpret line
		cpi	ereg,0x00		
		brne	tbrun_03
		lds	XL,tb_ram+12		;linenumber
		cpi	XL,tb_maxline
		brcs	tbrun_02
tbrun_03:	ldi	ctrl,0x0c		;standard format
		ret				;line numer exceeds 0x0f		

;-----------------------------------------------------------------------
; interpret line from Z
;-----------------------------------------------------------------------
tb_run:		ldi	ZH,HIGH(tb_linebuf)	;start of buffer
		ldi	ZL,LOW(tb_linebuf)	;start of buffer
		sts	libmio_channel,byte0	;set output to screen
		clr	ereg			;clear Error
		lds	XL,tb_ram+11		;statement to go
		clr	XH
tb_run_001:	cp	XL,XH			;found?
		breq	tb_run_00		;yes

tb_run_002:	ld	tempreg4,Z+		;get char
		cpi	tempreg4,0xff		;end of line
		breq	tb_run_01d		;next line
		cpi	tempreg4,0x27		;comment
		breq	tb_run_01d		;next line
		cpi	tempreg4,'"'		;string
		brne	tb_run_004
tb_run_003:	ld	tempreg4,Z+		;get char
		cpi	tempreg4,0xff		;end of line
		breq	tb_run_01d		;yes
		cpi	tempreg4,0x27		;comment
		breq	tb_run_01d	
		cpi	tempreg4,'"'		;string
		brne	tb_run_003
		rjmp	tb_run_002
tb_run_004:	cpi	tempreg4,':'		;separator	
		brne	tb_run_002
		inc	XH			;statement+1
		cp	XL,XH			;found?
		brne	tb_run_002
		rjmp	tb_run_00	

tb_run_01:
tb_run_00:	lds	tempreg4,libmio_kflags	;break
		cpi	tempreg4,1
		brne	tb_run_01a
		mov	ereg,tempreg4
		ret	
	
tb_run_01a:	libmio_screenshot
		ld	tempreg4,Z+		;get char
		cpi	tempreg4,0xff		;EOL?
		brne	tb_run_01c
tb_run_01d:	sts	tb_ram+11,byte0		;first statement
		lds	XL,tb_ram+12		;next line
		inc	XL
		sts	tb_ram+12,XL
		ret				;end of line

tb_run_01c:	sbrc	tempreg4,7
		rjmp	tb_run_99		;token
		cpi	tempreg4,32		;space
		breq	tb_run_00
		cpi	tempreg4,':'
		brne	tb_run_01e
		lds	tempreg7,tb_ram+11
		inc	tempreg7
		sts	tb_ram+11,tempreg7
		rjmp	tb_run_00
tb_run_01e:	cpi	tempreg4,'?'		;print
		brne	tb_run_01f
		ldi	ctrl,0x0c		;standard format
		rjmp	tb_print_00	
		
tb_run_01f:	cpi	tempreg4,0x27		;comment
		breq	tb_run_01d
		cpi	tempreg4,'@'		;array set
		breq	tb_run_ar
tb_run_03:	cpi	tempreg4,'A'
		brcs	tb_run_se
		cpi	tempreg4,'Z'+1
		brcc	tb_run_se
		sts	tb_ram+3,tempreg4	;store variable number
;get second char
		ld	tempreg4,Z+
		cpi	tempreg4,'A'
		brcs	tb_run_nk		;no keyword
		cpi	tempreg4,'Z'+1
		brcc	tb_run_nk		;no keyword
		rjmp	tb_run_kw		;keyword

tb_run_99:	mov	XH,tempreg4
		rjmp	tb_run_kw01
		
;-----------------------------------------------------------------------
; check for variable setting
;-----------------------------------------------------------------------
tb_run_nk:	rcall	tb_ignorespc		;space
	    	cpi	tempreg4,'='
		brne	tb_run_se
		rcall	tb_expar		;call parser
		lds	tempreg1,tb_ram+3	;restore variable number
		cpi	ereg,0
		brne	tb_run_end
		subi	tempreg1,'A'
		lsl	tempreg1			
		ldi	YH,high(varspace)	
		ldi	YL,low(varspace)
		add	YL,tempreg1
		adc	YH,byte0					
		st	Y+,XL
		st	Y+,XH
		rjmp	tb_run_00		;loop

tb_run_se:	ldi	ereg,7			;syntax error
tb_run_end:	ret		

;-----------------------------------------------------------------------
; check for array setting
;-----------------------------------------------------------------------
tb_run_ar_se:	pop	ZL			;restore pointer
		pop	ZH
		rjmp	tb_run_se

tb_run_ar:	push	ZL			;save pointer
		push	ZH
		ldi	XH,1			;paranthesis pointer	
tb_run_ar_01:	ld	XL,Z+
		cpi	XL,0xff			;end
		breq	tb_run_ar_se		;syntax error
		cpi	XL,40			;"("
		brne	tb_run_ar_01
tb_run_ar_02:	ld	XL,Z+
		cpi	XL,0xff			;end
		breq	tb_run_ar_se		;syntax error
		cpi	XL,40			;"("
		brne	tb_run_ar_03
		inc	XH			;paranthesis counter +1
		rjmp	tb_run_ar_02
tb_run_ar_03:	cpi	XL,41			;")"
		brne	tb_run_ar_02
		subi	XH,1			;paranthesis counter -1
		brne	tb_run_ar_02		;at the end?
tb_run_ar_04:	ld	XL,Z+
		cpi	XL,32			;space
		breq	tb_run_ar_04
		cpi	XL,'='			;must be an equation
		brne	tb_run_ar_se
		ldi	XL,','			;separator			
		st	-Z,XL			;replace equal with this
		pop	ZH			;restore pointer
		pop	ZL
		clr	ereg
		rcall	tb_expar		;get arrayindex
		sts	tb_ram+3,XL
tb_run_ar_05:	ld	XL,Z+
		cpi	XL,32			;space
		breq	tb_run_ar_05
		cpi	XL,','
		brne	tb_run_se		;error
		rcall	tb_expar		;call parser
		cpi	ereg,0
		brne	tb_run_end
		ldi	YH,high(tb_array)	
		ldi	YL,low(tb_array)
		lds	tempreg2,tb_ram+3
		sbrc	tempreg2,7
		rjmp	tb_run_ar1
		andi	tempreg2,0x0f
		lsl	tempreg2
		add	YL,tempreg2
		adc	YH,byte0
		st	Y+,XL
		st	Y+,XH
		rjmp	tb_run_00		;loop
		
tb_run_ar1:	add	YL,tempreg2
		adc	YH,byte0
		st	Y+,XL
		rjmp	tb_run_00		;loop

;-----------------------------------------------------------------------
; check for keywords
;-----------------------------------------------------------------------
tb_run_kw:	sbiw	ZL,2			;Z points to first char
		rcall	tb_gtoken		;get token value
		cpi	ereg,0			;OK
		breq	tb_run_kw01
		ret
		
tb_run_kw01:	sts	tb_ram+14,ZL		;store pointer
		sts	tb_ram+15,ZH
		ldi	ZL,LOW(tb_run_kw06)
		ldi	ZH,HIGH(tb_run_kw06)
		andi	tempreg4,0x3f		;64 token
		add	ZL,tempreg4
		adc	ZH,byte0
		ijmp
		
tb_run_kw06:	rjmp	tb_print		;80
		rjmp	tb_cls			;81
		rjmp	tb_goto			;82
		rjmp	tb_box			;83
		rjmp	tb_fbox			;84
		rjmp	tb_sync			;85
		rjmp	tb_end			;86
		rjmp	tb_if			;87
		rjmp	tb_then			;88
		rjmp	tb_posxy		;89
		rjmp	tb_note			;8a
		rjmp	tb_emit			;8b
		rjmp	tb_waitkey		;8c
		rjmp	tb_readkey		;8d
		rjmp	tb_call		;8e
		rjmp	tb_return		;8f
		
		rjmp	tb_for			;90
		rjmp	tb_next			;91
		rjmp	tb_input		;92
		rjmp	tb_plot			;93
		rjmp	tb_wait			;94
		rjmp	tb_tset			;95
		rjmp	tb_tget			;96
		rjmp	tb_eeput		;97
		rjmp	tb_eeget		;98
		rjmp	tb_sput			;99
		rjmp	tb_sget			;9a
		rjmp	tb_poke			;9b
		rjmp	tb_dir			;9c
		rjmp	tb_out			;9d
		rjmp	tb_color		;9e
		rjmp	tb_lchar		;9f
		rjmp	tb_lpix			;a0
		rjmp	tb_chpump		;a1
		
;-----------------------------------------------------------------------
; keyword is PRINT
;-----------------------------------------------------------------------
tb_print:	rcall	tb_rlp			;restore Z-register
		ldi	ctrl,0x0c		;standard format
		sts	libmio_channel,byte0	;print to screen
tb_print_00:	ld	XH,Z+
		cpi	XH,32			;space
		breq	tb_print_00
		cpi	XH,':'
		breq	tb_print_08
		cpi	XH,0x3b			;";"
		breq	tb_print_07
		cpi	XH,','			;tab
		brne	tb_print_004
tb_print_001:	libmio_outspace
		lds	XH,libmio_lpos
		andi	XH,0x07
		cpi	XH,0x00
		brne	tb_print_001
		sts	tb_ram,byte0		;no newline
		rjmp	tb_print_00
tb_print_004:	cpi	XH,0xff
		brne	tb_print_01		;no end
tb_print_10:	lds	XL,tb_ram		;newline?
		cpi	XL,01			;yes?
		brne	tb_print_11
		libmio_newline
tb_print_11:	rjmp	tb_run_01d		;next line

tb_print_07:	sts	tb_ram,byte0		;no newline
		rjmp	tb_print_00		;get next char

tb_print_08:	sbiw	ZL,1			;point to :
		lds	XL,tb_ram		;newline?
		cpi	XL,01			;yes?
		brne	tb_print_09
		libmio_newline
tb_print_09:	sts	tb_ram,byte1		;enable newline
		rjmp	tb_run_01

tb_print_01:	cpi	XH,'"'			;is it a string?
		brne	tb_printf_01		;no
tb_print_02:	sts	tb_ram,byte1		;clear comma
		ld	tempreg1,Z+		;get string char
		cpi	tempreg1,0xff
		breq	tb_print_10		;yes
		cpi	tempreg1,'"'		;end of string
		breq	tb_print_00		;yes
		libmio_outchar			;output char
		rjmp	tb_print_02		;string loop

tb_printf_01:	cpi	XH,'!'			;format
		brne	tb_printc_01
		rcall	tb_expar
		mov	ctrl,XL
		rjmp	tb_print_00				

tb_printc_01:	cpi	XH,'#'			;format
		brne	tb_print_03
		ld	tempreg1,Z+		;get string char
		subi	tempreg1,'0'
		cpi	tempreg1,0		;screen output
		brne	tb_printc_02
		sts	libmio_channel,tempreg1
		rjmp	tb_print_00				
tb_printc_02:	cpi	tempreg1,1		;serial output
		brne	tb_printc_03
		sts	libmio_channel,tempreg1
		rjmp	tb_print_00				
tb_printc_03:	cpi	tempreg1,2		;parallel output
		brne	tb_printc_04
		sts	libmio_channel,tempreg1
		rjmp	tb_print_00				
tb_printc_04:	ldi	ereg,15
		ret	

tb_print_03:	sbiw	ZL,1			;set pointer to char before
		rcall	tb_expar		;mathematics
		cpi	ereg,0
		breq	tb_print_04
		ret
		
tb_print_04:	cpi	ctrl,0x80		;Hex/dez
		brcc	tb_print_05
		libmio_outdez		
		sts	tb_ram,byte1		;clear comma
		rjmp	tb_print_00				

tb_print_05:	libmio_outhex
		sts	tb_ram,byte1		;clear comma		
		rjmp	tb_print_00				

;-----------------------------------------------------------------------
; keyword is CLS
;-----------------------------------------------------------------------
tb_cls:		rcall	tb_rlp			;restore Z-register
		libmio_clrscr
		rjmp	tb_run_01
	    
;-----------------------------------------------------------------------
; keyword is GOTO
;-----------------------------------------------------------------------
tb_goto:	rcall	tb_exparser
		cpi	XH,00
		breq	tb_goto_02
tb_goto_01:	ldi	ereg,10			;no valid linenumber
		ret
tb_goto_02:	cpi	XL,0x00
		breq	tb_goto_01
		cpi	XL,tb_maxline+1		;max linenumber
		brcc	tb_goto_01
		subi	XL,1			;linenumber start with 0
		sts	tb_ram+12,XL		
		sts	tb_ram+11,byte0
		ret		

;-----------------------------------------------------------------------
; keyword is box
;-----------------------------------------------------------------------
tb_box:		rcall	tb_g4
		libmio_box
		rjmp	tb_g4_end		

;-----------------------------------------------------------------------
; keyword is fbox
;-----------------------------------------------------------------------
tb_fbox:	rcall	tb_g4			;get parameters
		libmio_fbox
		rjmp	tb_g4_end		
		
;-----------------------------------------------------------------------
; keyword is sync
;-----------------------------------------------------------------------
tb_sync:	rcall	tb_exparser
		cpi	ereg,0
		breq	tb_sync_01
		ret
tb_sync_01:	cpi	XL,0
		brne	tb_sync_02
		cpi	XH,0
		brne	tb_sync_02
		rjmp	tb_run_01		;continue
tb_sync_02:	libmio_sync
		sbiw	XL,1
		rjmp	tb_sync_01			

;-----------------------------------------------------------------------
; keyword is end
;-----------------------------------------------------------------------
tb_end:		pop	XH
		pop	XH
		ret

;-----------------------------------------------------------------------
; keyword is if
;-----------------------------------------------------------------------
tb_if:		rcall	tb_exparser
		or	XL,XH
		brne	tb_if1
		rjmp	tb_run_01d		;next line
tb_if1:		rjmp	tb_run_01		;continue

;-----------------------------------------------------------------------
; keyword is then
;-----------------------------------------------------------------------
tb_then:	rcall	tb_rlp			;correct pointer
		rjmp	tb_run_01		;continue
	
;-----------------------------------------------------------------------
; keyword is pos
;-----------------------------------------------------------------------
tb_posxy:	rcall	tb_g2			;get parameters
		libmio_gotoxy
tb_posxy_ext:	rjmp	tb_run_01		

;-----------------------------------------------------------------------
; keyword is note
;-----------------------------------------------------------------------
tb_note:	rcall	tb_exparser
		libmio_note
		rjmp	tb_run_01

;-----------------------------------------------------------------------
; keyword is emit
;-----------------------------------------------------------------------
tb_emit:	rcall	tb_exparser
tb_emit_01:	mov	tempreg1,XL
		libmio_outchar
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_posxy_ext
		rcall	tb_ignorespace
		call	tb_expar
		rjmp	tb_emit_01	

;-----------------------------------------------------------------------
; keyword is wkey 
;-----------------------------------------------------------------------
tb_waitkey:	rcall	tb_getvar		;get variable
		sts	libmio_lastkey,byte0
tb_waitkey_1:	lds	XL,libmio_lastkey
		cpi	XL,0
		breq	tb_waitkey_1
		st	Y+,XL			;low key
		st	Y+,byte0			
		rjmp	tb_run_01

;-----------------------------------------------------------------------
; keyword is rkey
;-----------------------------------------------------------------------
tb_readkey:	rcall	tb_getvar		;get variable
		lds	XL,libmio_keycode
		st	Y+,XL			;low key
		st	Y+,byte0			
		rjmp	tb_run_01

;-----------------------------------------------------------------------
; keyword is CALL
;-----------------------------------------------------------------------
tb_call:	rcall	tb_exparser
		cpi	XH,00
		breq	tb_call_02
tb_call_01:	ldi	ereg,10			;no valid linenumber
		ret
tb_call_02:	cpi	XL,0x00
		breq	tb_call_01
		cpi	XL,tb_maxline+1		;max linenumber
		brcc	tb_call_01
		lds	XH,tb_ram+5		;stackpointer
		cpi	XH,tb_stackdepth-1	;maximum-1
		brcs	tb_call_03
		ldi	ereg,13			;too many gosub
		ret
tb_call_03:	subi	XL,1			;gosub line
		push	XL			
		ldi	YL,LOW(tb_stacks)	;stack root
		ldi	YH,HIGH(tb_stacks)
		ldi	XL,5			;bytes/record
		mul	XL,XH
		add	YL,r0
		adc	YH,r1
		inc	XH			;inc pointer
		sts	tb_ram+5,XH
		lds	XH,tb_ram+11		;statement
		inc	XH			;must return to next statement
		ori	XH,0x80			;mark as gosub
		st	Y+,XH			;return statement number
		lds	XH,tb_ram+12		;our line number
		st	Y+,XH
		sts	tb_ram+11,byte0		;statement=0
		pop	XL
		sts	tb_ram+12,XL		;set as next
		ret		

;-----------------------------------------------------------------------
; keyword is RETURN
;-----------------------------------------------------------------------
tb_return:	rcall	tb_rlp			;restore Z-register
		lds	XH,tb_ram+5		;stackpointer
		cpi	XH,0
		brne	tb_return_02
tb_return_01:	ldi	ereg,12			;return without call
		ret
tb_return_02:	dec	XH
		ldi	YL,LOW(tb_stacks)	;stack root
		ldi	YH,HIGH(tb_stacks)
		ldi	XL,5			;bytes/record
		mul	XL,XH
		add	YL,r0
		adc	YH,r1
		sts	tb_ram+5,XH
		ld	XH,Y+	
		sbrs	XH,7			;check if TOS is call
		rjmp	tb_return_01		;no
		andi	XH,0x7f
		sts	tb_ram+11,XH		;statement
		ld	XH,Y+				
		sts	tb_ram+12,XH		;linenumber
		ret

;-----------------------------------------------------------------------
; keyword is FOR
;-----------------------------------------------------------------------
tb_for_err:	ldi	ereg,7
		ret
tb_for:		rcall	tb_rlp			;restore Z-register
		rcall	tb_ignorespace		;space
		cpi	tempreg4,'A'
		brcs	tb_for_err
		cpi	tempreg4,'Z'+1
		brcc	tb_for_err
		subi	tempreg4,'A'
		lsl	tempreg4
		sts	tb_ram+3,tempreg4	;store variable number
		rcall	tb_ignorespace		;space
	    	cpi	tempreg4,'='
		brne	tb_for_err		;syntax error
		rcall	tb_expar		;call parser
		cpi	ereg,0
		breq	tb_for_1
		ret
tb_for_1:	lds	tempreg4,tb_ram+3	;variable
		ldi	YH,high(varspace)	
		ldi	YL,low(varspace)
		add	YL,tempreg4
		adc	YH,byte0					
		st	Y+,XL			;set variable to initial value
		st	Y+,XH
		rcall	tb_ignorespace
		cpi	tempreg4,'T'
		brne	tb_for_err
		ld	tempreg4,Z+
		cpi	tempreg4,'O'
		brne	tb_for_err
		rcall	tb_expar		;target value
		mov	tempreg5,XL		;save target value
		mov	tempreg6,XH
		cpi	ereg,0
		breq	tb_for_2
		ret
tb_for_2:	lds	XH,tb_ram+5		;stackpointer
		cpi	XH,tb_stackdepth-1	;maximum-1
		brcs	tb_for_3
		ldi	ereg,14			;too many for
		ret
tb_for_3:	ldi	YL,LOW(tb_stacks)	;stack root
		ldi	YH,HIGH(tb_stacks)
		ldi	XL,5			;bytes/record
		mul	XL,XH
		add	YL,r0
		adc	YH,r1
		inc	XH			;inc pointer
		sts	tb_ram+5,XH
		lds	XH,tb_ram+11
		inc	XH			;next must skip this
		st	Y+,XH			;return statement number
		lds	XH,tb_ram+12		;our line number
		st	Y+,XH
		lds	XH,tb_ram+3		;variable offset
		st	Y+,XH
		st	Y+,tempreg5		;target value low
		st	Y+,tempreg6		;target value high
		rjmp	tb_run_01	

;-----------------------------------------------------------------------
; keyword is NEXT
;-----------------------------------------------------------------------
tb_next:	rcall	tb_rlp			;restore Z-register
		lds	XH,tb_ram+5		;stackpointer
		cpi	XH,0
		brne	tb_next_02
tb_next_01:	ldi	ereg,11			;next without for
		ret
tb_next_02:	dec	XH
		ldi	YL,LOW(tb_stacks)	;stack root
		ldi	YH,HIGH(tb_stacks)
		ldi	XL,5			;bytes/record
		mul	XL,XH
		add	YL,r0
		adc	YH,r1
		ld	XH,Y+			;statement
		sbrc	XH,7			;check if TOS is for
		rjmp	tb_next_01		;no
		andi	XH,0x7f
		sts	tb_ram+10,XH		;save statement temporary
		ld	tempreg6,Y+		;get line number to jump	
		ld	tempreg4,Y+		;variable
		ldi	XH,high(varspace)	
		ldi	XL,low(varspace)
		add	XL,tempreg4
		adc	XH,byte0					
		ld	r16,X+			;variable low
		ld	r17,X+			;variable high
		add	r16,byte1
		adc	r17,byte0
		st	-X,r17
		st	-X,r16
		ld	XL,Y+			;target low
		ld	XH,Y+			;target high
		adiw	XL,1			;+1
		cp	r16,XL
		brne	tb_next_03
		cp	r17,XH
		brne	tb_next_03
		lds	XH,tb_ram+5		;stackpointer
		dec	XH
		sts	tb_ram+5,XH		
		rjmp	tb_run_01		;next statement
tb_next_03:	sts	tb_ram+12,tempreg6
		lds	XH,tb_ram+10
		sts	tb_ram+11,XH
		ret
			
;-----------------------------------------------------------------------
; keyword is INPUT
;-----------------------------------------------------------------------
tb_input:	rcall	tb_rlp			;restore Z-register
tb_input_00:	ld	XH,Z+
		cpi	XH,32			;space
		breq	tb_input_00
		mov	tempreg1,XH
		cpi	XH,0xff
		brne	tb_input_02
tb_input_01:	libmio_newline
		sbiw	ZL,1
		rjmp	tb_run_01

tb_input_02:	cpi	XH,':'			;end of statement
		breq	tb_input_01
		cpi	XH,0x3b			;";"	ignore this
		breq	tb_input_00
		cpi	XH,','			;tab
		brne	tb_input_04
tb_input_03:	libmio_outspace
		lds	XH,libmio_cur_x
		andi	XH,0x07
		cpi	XH,0x00
		brne	tb_input_03
		rjmp	tb_input_00

tb_input_04:	cpi	XH,'"'			;is it a string?
		brne	tb_input_06		;no
tb_input_05:	ld	tempreg1,Z+		;get string char
		cpi	tempreg1,0xff
		breq	tb_input_01
		cpi	tempreg1,'"'		;end of string
		breq	tb_input_00		;yes
		libmio_outchar			;output char
		rjmp	tb_input_05		;string loop
		
tb_input_06:	cpi	XH,'A'
		brcs	tb_input_err
		cpi	XH,'Z'+1
		brcc	tb_input_err
		subi	XH,'A'
		lsl	XH
		sts	tb_ram+10,XH		;variable number
		ld	XH,Z
		cpi	XH,'A'
		brcs	tb_input_07
		cpi	XH,'Z'+1
		brcc	tb_input_07
		rjmp	tb_input_err
tb_input_07:	rcall	tb_inval		;get value		
		ldi	YH,high(varspace)	
		ldi	YL,low(varspace)
		lds	r17,tb_ram+10
		add	YL,r17
		adc	YH,byte0					
		st	Y+,XL			;set variable to initial value
		st	Y+,XH
		rjmp	tb_input_00

tb_input_err:	ldi	ereg,7			;syntax error
		ret

;-----------------------------------------------------------------------
; keyword is plot
;-----------------------------------------------------------------------
tb_plot:	rcall	tb_g2			;get parameters
;		andi	ctrl,0x03		;mask color bits
;		sts	libmio_color,ctrl	;set color
		libmio_plot
tb_plot_end:	rjmp	tb_run_01		

;-----------------------------------------------------------------------
; keyword is wait
;-----------------------------------------------------------------------
tb_wait:	rcall	tb_exparser
		cpi	ereg,0
		breq	tb_wait_01
		ret
tb_wait_01:	mov	tempreg1,XL
		or	tempreg1,XH
		breq	tb_plot_end
tb_wait_02:	lds	tempreg1,libmio_time0
		cpi	tempreg1,0x00
		breq	tb_wait_02
tb_wait_03:	lds	tempreg1,libmio_time0
		cpi	tempreg1,0x00
		brne	tb_wait_03
		sbiw	XL,1
		rjmp	tb_wait_01			    	

;-----------------------------------------------------------------------
; keyword is tset
;-----------------------------------------------------------------------
tb_tset:	rcall	tb_exparser			;get value
		sts	libmio_time_l,XL
		sts	libmio_time_h,XH
		rjmp	tb_wait_01			    	

;-----------------------------------------------------------------------
; keyword is tget
;-----------------------------------------------------------------------
tb_tget:	rcall	tb_getvar		;get variable
		lds	XL,libmio_time_l
		st	Y+,XL			;low timer
		lds	XL,libmio_time_h
		st	Y+,XL			;high timer
		rjmp	tb_run_01

;-----------------------------------------------------------------------
; keyword is eput
;-----------------------------------------------------------------------
tb_eeput:	rcall	tb_exparser
		ldi	YL,LOW(510)		;eeprom address
		ldi	YH,HIGH(510)
		mov	tempreg1,XL
		rcall	ee_write
		inc	YL
		mov	tempreg1,XH
		rcall	ee_write
		rjmp	tb_run_01

;-----------------------------------------------------------------------
; keyword is eget
;-----------------------------------------------------------------------
tb_eeget:	ldi	YL,LOW(510)		;eeprom address
		ldi	YH,HIGH(510)
		rcall	ee_read
		mov	XL,tempreg1
		rcall	ee_read
		mov	XH,tempreg1
		rcall	tb_getvar		;get variable
		st	Y+,XL			;low value
		st	Y+,XH			;high value
		rjmp	tb_run_01

;-----------------------------------------------------------------------
; keyword is sput
;-----------------------------------------------------------------------
tb_sput:	rcall	tb_exparser
tb_sput_01:	mov	tempreg1,XL
		libmio_pser
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_sput_ext
		rcall	tb_ignorespace
		call	tb_expar
		rjmp	tb_sput_01
tb_sput_ext:	rjmp	tb_run_01		


;-----------------------------------------------------------------------
; keyword is sget
;-----------------------------------------------------------------------
tb_sget:	libmio_gser
		mov	XL,tempreg1
		clr	XH
	    	rcall	tb_getvar		;get variable
		st	Y+,XL			;low value
		st	Y+,XH			;high value
		rjmp	tb_run_01

;-----------------------------------------------------------------------
; keyword is poke
;-----------------------------------------------------------------------
tb_poke:	rcall	tb_g2w
		call	i2c_wword	
	    	rjmp	tb_run_01		

;-----------------------------------------------------------------------
; keyword is dir
;-----------------------------------------------------------------------
tb_dir:		rcall	tb_exparser
		out	DDRA,XL
	    	rjmp	tb_run_01		

;-----------------------------------------------------------------------
; keyword is out (XH=pin XL=val)
;-----------------------------------------------------------------------
tb_out:		rcall	tb_g2
		andi	XH,0x07			;8 Bits
		inc	XH
		clr	tempreg4		;or mask for reset
		ldi	tempreg3,0x7f		;and mask for reset
		sbrs	XL,0			;value bit
		ldi	tempreg4,0x80		;or mask for set
		sbrs	XL,0			;value bit
		ldi	tempreg3,0xff		;and mask for set
tb_out_1:	bst	tempreg4,7		;rotate or mask
		lsl	tempreg4
		bld	tempreg4,0
		bst	tempreg3,7		;rotate and mask
		lsl	tempreg3
		bld	tempreg3,0
		dec	XH
		brne	tb_out_1
		in	r16,PORTA
		or	r16,tempreg4
		and	r16,tempreg3
		out	PORTA,r16
	    	rjmp	tb_run_01		

;-----------------------------------------------------------------------
; keyword is color
;-----------------------------------------------------------------------
tb_color:	rcall	tb_exparser
		andi	XL,0x03
		sts	libmio_color,XL
	    	rjmp	tb_run_01		

;-----------------------------------------------------------------------
; keyword is lchar (lines)
;-----------------------------------------------------------------------
tb_lchar:	rcall	tb_exparser
		libmio_lscroll
	    	rjmp	tb_run_01		

;-----------------------------------------------------------------------
; keyword is lpix (lines)
;-----------------------------------------------------------------------
tb_lpix:	rcall	tb_exparser
		libmio_lpscroll
	    	rjmp	tb_run_01		

;-----------------------------------------------------------------------
; keyword is pump
;-----------------------------------------------------------------------
tb_chpump:	rcall	tb_exparser
		libmio_chpump
	    	rjmp	tb_run_01		
		
;-----------------------------------------------------------------------
; get 4 parameters (YH,YL,ZH,ZL), Z will be saved
;-----------------------------------------------------------------------
tb_g4:		rcall	tb_exparser
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_g4_err
		adiw	ZL,1			;next char
		sts	tb_ram+1,XL		;save X1
		rcall	tb_expar
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_g4_err
		adiw	ZL,1			;next char
		sts	tb_ram+2,XL		;save Y1
		rcall	tb_expar
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_g4_err
		adiw	ZL,1			;next char
		sts	tb_ram+3,XL		;save X
		rcall	tb_expar
		mov	tempreg5,ZL
		mov	tempreg6,ZH
		mov	ZL,XL
		lds	ZH,tb_ram+3
		lds	YL,tb_ram+2
		lds	YH,tb_ram+1
		ret

tb_g4_err:	pop	ereg
		pop	ereg
		ldi	ereg,7
		ret

;restore Z-register
tb_g4_end:	mov	ZL,tempreg5
		mov	ZH,tempreg6
		rjmp	tb_run_01		

;-----------------------------------------------------------------------
; get 3 parameters (XH,XL,ctrl)
;-----------------------------------------------------------------------
tb_g3:		rcall	tb_exparser
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_g4_err
		adiw	ZL,1			;next char
		sts	tb_ram+1,XL		;save X1
		rcall	tb_expar
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_g4_err
		adiw	ZL,1			;next char
		sts	tb_ram+2,XL		;save Y1
		rcall	tb_expar
		mov	ctrl,XL
		lds	XH,tb_ram+1
		lds	XL,tb_ram+2
		ret

;-----------------------------------------------------------------------
; get 2 byte parameters (XH,XL)
;-----------------------------------------------------------------------
tb_g2:		rcall	tb_exparser
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_g4_err
		adiw	ZL,1			;next char
		sts	tb_ram+1,XL		;save X1
		call	tb_expar
		lds	XH,tb_ram+1
		ret

;-----------------------------------------------------------------------
; get 2 word parameters (Y,X)
;-----------------------------------------------------------------------
tb_g2w:		rcall	tb_exparser
		rcall	tb_ignorespc
		cpi	tempreg4,','
		brne	tb_g4_err
		adiw	ZL,1			;next char
		mov	YL,XL
		mov	YH,XH
		call	tb_expar
		ret

;-----------------------------------------------------------------------
; get variable address
;-----------------------------------------------------------------------
tb_getvar:	lds	ZL,tb_ram+14		;get line pointer
		lds	ZH,tb_ram+15
		ld	tempreg4,Z
tb_va:		rcall	tb_ignorespc
tb_va_1:	cpi	tempreg4,'A'
		brcs	tb_va_err
		cpi	tempreg4,'Z'+1
		brcc	tb_va_err
		subi	tempreg4,'A'
		lsl	tempreg4
		ldi	YH,high(varspace)	
		ldi	YL,low(varspace)
		add	YL,tempreg4
		adc	YH,byte0					
		ret
tb_va_err:	pop	ereg
		pop	ereg
		ldi	ereg,7
		ret		

;-----------------------------------------------------------------------
; read until char is not space
;-----------------------------------------------------------------------
tb_ignorespace:	ld	tempreg4,Z+
tb_ignorespc:	cpi	tempreg4,32			;space
		breq	tb_ignorespace
tb_ignoresp01:	ret		

;-----------------------------------------------------------------------
; restore line pointer
;-----------------------------------------------------------------------
tb_rlp:		lds	ZL,tb_ram+14		;get line pointer
		lds	ZH,tb_ram+15
		ld	tempreg4,Z
		ret

;-----------------------------------------------------------------------
; restore line pointer and get parameter
;-----------------------------------------------------------------------
tb_exparser:	lds	ZL,tb_ram+14		;get line pointer
		lds	ZH,tb_ram+15
		ld	tempreg4,Z
		rjmp	tb_expar
		
;-----------------------------------------------------------------------
; input value
;-----------------------------------------------------------------------
tb_inval:	push	ZL			;save pointer
		push	ZH
		libmio_calc			;calculate address
		mov	ZL,YL			;set start of pointer
		mov	ZH,YH
		ldi	r16,0			;length
tb_inval_01:	libmio_cursor			;view cursor
		cpi	tempreg1,0xea		;enter
		brne	tb_inval_04
		cpi	r16,0			;no char
		brne	tb_inval_02	
		clr	XL
		clr	XH
tb_inval_01a:	pop	ZH			;restore pointer
		pop	ZL
		ret
		
tb_inval_02:	ldi	YL,LOW(tb_inbuf)
		ldi	YH,HIGH(tb_inbuf)
tb_inval_03:	ld	XL,Z+
		st	Y+,XL
		dec	r16
		brne	tb_inval_03
		ldi	XL,0x20
		st	Y+,XL
		ldi	XL,0xff			;eol
		st	Y+,XL
		ldi	ZL,LOW(tb_inbuf)
		ldi	ZH,HIGH(tb_inbuf)
		call	tb_expar		;calculate value
		rjmp	tb_inval_01a	
tb_inval_04:	cpi	tempreg1,0xec		;backspace
		brne	tb_inval_05
		cpi	r16,0
		breq	tb_inval_01		;nothing
		lds	XL,libmio_cur_x
		dec	XL
		sts	libmio_cur_x,XL
		libmio_calc
		ldi	XL,0x20
		st	Y,XL
		dec	r16
		rjmp	tb_inval_01
tb_inval_05:	cpi	tempreg1,0x20
		brcs	tb_inval
		cpi	tempreg1,'Z'+1
		brcc	tb_inval
		lds	XL,libmio_cur_x		
		cpi	XL,libmio_cols-1
		brcc	tb_inval
		libmio_outchar
		inc	r16
		rjmp	tb_inval_01
		
tb_vline:	ldi	ctrl,2
		clr	XH
		lds	XL,tb_ram+12		;line
		inc	XL
		libmio_outdez
		ldi	tempreg1,':'
		libmio_outchar
		clr	XH
		lds	XL,tb_ram+11		;statement
		libmio_outdez
		libmio_outspace
		ret				

;-----------------------------------------------------------------------
; get token value in tempreg4 (pointer=Z points to char after token)
;-----------------------------------------------------------------------
tb_gtoken:	clr	ereg			;clear error
		mov	r0,ZL			;copy pointer
		mov	r1,ZH
		ldi	tempreg4,0x80		;first token
		clt				;no abbrevation aneabled
		ldi	ZL,LOW(toktab*2)	;Start of keyword table
		ldi	ZH,HIGH(toktab*2)
tb_gtoken_02:	mov	YL,r0			;set ram pointer
		mov	YH,r1
tb_gtoken_04:	lpm	tempreg2,Z+		;rom char
		cpi	tempreg2,0		;end?
		brne	tb_gtoken_06		;syntax error
		ldi	ereg,8			;unknown
		mov	ZL,r0			;return old pointer
		mov	ZH,r1
		ret				;error return
tb_gtoken_06:	cpi	tempreg2,'.'		;shortest abbrevation
		brne	tb_gtoken_08
		set				;enable abbrevation
		rjmp	tb_gtoken_04	
		
tb_gtoken_08:	cpi	tempreg2,32		;space in rom table
		brne	tb_gtoken_10
		rjmp	tb_gtoken_13		;normal return		
		
tb_gtoken_10:	ld	tempreg1,Y+		;get ram char
		cpi	tempreg1,32		;space
		breq	tb_gtoken_12		;yes
		cpi	tempreg1,':'		;next statement
		breq	tb_gtoken_12		;yes
		cpi	tempreg1,0xff		;EOL
		breq	tb_gtoken_12		;yes
		rjmp	tb_gtoken_14		
tb_gtoken_12:	brtc	tb_gtoken_17		;abbrevation not enabled
		ori	tempreg4,0x40		;token is abbrevated
		sbiw	ZL,1
tb_gtoken_13:	mov	ZL,YL			;copy pointer to Z
		mov	ZH,YH
		ret				;normal return
		
tb_gtoken_14:	cp	tempreg1,tempreg2	;compare
		breq	tb_gtoken_04		;next char
		
tb_gtoken_16:	lpm	tempreg2,Z+
		cpi	tempreg2,0		;end?
		brne	tb_gtoken_18		;syntax error
tb_gtoken_17:	ldi	ereg,0x08		;unknown
		mov	ZL,r0			;return old pointer
		mov	ZH,r1
		ret				;error return

tb_gtoken_18:	cpi	tempreg2,32		;wait for space in rom table
		brne	tb_gtoken_16
		inc	tempreg4		;next token
		rjmp	tb_gtoken_02		;compare with next

;-----------------------------------------------------------------------
; expand token value in tempreg1 (pointer=Z++)
;-----------------------------------------------------------------------
tb_xtoken:	mov	r0,ZL			;save Z-pointer in r0/r1
		mov	r1,ZH
		ldi	ZL,LOW(toktab*2)	;Start of keyword table
		ldi	ZH,HIGH(toktab*2)
		mov	XH,tempreg1
		andi	tempreg1,0x3f		;64 token
tb_xtoken_1:	cpi	tempreg1,0
		brne	tb_xtoken_2
	    	push	YL			;save Y-register
		push	YH
		mov	YL,r0			;Y-register = ram-pointer
		mov	YH,r1
		sbrs	XH,6
		rjmp	tb_xtoken_10
		rjmp	tb_xtoken_20
		

tb_xtoken_10:	lpm	XL,Z+
		cpi	XL,'.'
		breq	tb_xtoken_10
		st	Y+,XL
		cpi	XL,0x20
		brne	tb_xtoken_10		
		sbiw	YL,1
		mov	ZL,YL			;copy ram-pointer to Z
		mov	ZH,YH
		pop	YH			;restore Y-register
		pop	YL
		ret		

tb_xtoken_20:	lpm	XL,Z+
		st	Y+,XL
		cpi	XL,'.'
		brne	tb_xtoken_20		
		sbiw	YL,1
		ldi	XH,0x20
		st	Y+,XH
		mov	ZL,YL			;copy ram-pointer to Z
		mov	ZH,YH
		pop	YH			;restore Y-register
		pop	YL
		ret		
		
tb_xtoken_2:	lpm	XL,Z+			;get char
		cpi	XL,0x00			;end
		brne	tb_xtoken_3		;
		mov	ZL,r0
		mov	ZH,r1	
		ret
		
tb_xtoken_3:	cpi	XL,0x20			;space
		brne	tb_xtoken_2
		dec	tempreg1
		rjmp	tb_xtoken_1


toktab:		.db "PR.INT CL.S GO.TO BO.X FB.OX SY.NC EN.D IF"
		.db " TH.EN PO.S NO.TE EM.IT WK.EY RK.EY CA.LL RE.TURN FO.R"
		.db " NE.XT IN.PUT PL.OT WA.IT TS.ET TG.ET EP.UT EG.ET SP.UT "
		.db "SG.ET POK.E DI.R OU.T CO.LOR LC.HAR LP.IX PU.MP ",0
