#!/usr/bin/perl
#################################################################################
#                                                                              	#
# latex2web.pl : a little latex to html converter			       	#
# verion 0.4									#
# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)				#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 2		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
$fstack=0;
$secnumber=0;
$subsecnumber=0;
$subsubsecnumber=0;
$opensl=1;
$openbold=2;
$opensec=3;
$openlist=4;
$istab=0;
$islist=0;
$lastbr=0;

$newline="<br>\n";
$dnline="<br><br>\n";
$link="";

&read_config();
&process_file($ARGV[0]);

sub read_config
{
    open (RFILE,"/usr/local/share/latex2web/config");
    while(<RFILE>)
    {
	@cline = split(/=>/,$_);
	$ss=$cline[0];
	&shrinkstring;
	$ckey=$ss;
	$ss=$cline[1];
	&shrinkstring;
	$config{$ckey}=$ss;
    }
    close(RFILE);
}

sub shrinkstring
{
    while($ss =~ s/\A |\t//){};
    while($ss =~ s/ |\t|\n\Z//){};
}

sub process_file
{
    print "processing file :".$_[0]."\n";
    $texfile=$_[0];
    $htmlfile="> content.incl";
    open (RFILE,$texfile);
    open (WFILE,$htmlfile);
    $active_parse=0;
    $tnext="";
    while(<RFILE>)
    {
	$copy=1;
        $z=$_;
	$z =~ s/\t/ /gs;
        chomp($z);
	if ($z =~ s/^%%link=//)
	{
	    $link=$';
	    $z=" ";
	}
	$z =~ s/\\%/%/gs;

	&pre_substitute;			
	$maxloops=20;
	$r="";
	while (($z ne "") && (--$maxloops>0))
	{
    	    if ($z =~ /%%/) {$z=""};
	    &check_begin_end;
	    if ($active_parse==1)
	    {
		$gelesen=0;
		if ($gelesen==0) {&check_tab};
		if ($gelesen==0) {&check_images};
		if ($gelesen==0) {&check_list};
		if ($gelesen==0) {&check_sections};
		if ($gelesen==0) {&check_direction};
		if ($gelesen==0) {&check_verbatim};
		if ($gelesen==0) {&check_textsizes};
		if ($gelesen==0) {&check_bold};
		if ($gelesen==0) {&check_close};
		if ($gelesen==0) {&check_par};
		if ($gelesen==0) {&normal_text};
	    }	
	}
	$r =~ s/^\n//gs;
	$r =~ s/^ //gs;
	&post_substitute;	
	chomp($r);
	if (($active_parse==1) && ($r ne "")) {print WFILE $r."\n"}
    }
    print WFILE "\n<font size=2><br><br>erzeugt mit latex2web.pl v0.4 &copy; 2006 Joerg Wolfram<br>\n";
    close(WFILE);
    close(RFILE);
}

sub check_tab
{
    if ($z =~ s/^\\begin\{tabular\}//)
    {
	$istab=1;
	if ($lastbr==0) 
	{
	    $r.="<br>";
	    $lastbr=1;
	} 
	$r.="\n<table border=1 bgcolor=\"".$config{"tablebackgroundcolor"}."\"><tr>\n";
	$z =~ s/\{|}|\|//sg;
	$cols=0;
	while ($z =~ s/^l|r|c|m//)
	{
	    $tabd[$cols]=$&;
	    $cols+=1;	
	}
	$acol=0;
	&check_tdd;
	$z="";
    } 
    if ($z =~ s/^\\end\{tabular\}//)
    {
	$istab=0;
	$r.="</tr></table>\n"; 
	$lastbr=0;	
    } 
    if ($istab==1)
    {
	if ($z =~ s/^&//)
	{
	    $r.="</td>\n";
	    &check_tdd;
	}
	if ($z =~ s/^\\tabularnewline//)
	{
	    $r.="</td>\n</tr><tr>\n";
	    $acol=0;
	    &check_tdd;	    
	}
	if ($z =~ s/^\\hline//)
	{
	    $acol=$acol;	    
	}	
    }
}

sub check_images
{
    if ($z =~ s/^\\includegraphics//)
    {
	($z =~ s/\{//);
	$z=$';
	($z =~ s/}//);
	$z=$';
	$c=$`;
	$r.="\n<img src=\"".$c."\">\n";
    }
}

sub check_list
{
    if ($z =~ s/^\\begin\{enumerate\}//)
    {
	$islist=1;
	$r.="<br>\n<ol>\n";
	$gelesen=1;
    } 
    if ($z =~ s/^\\begin\{itemize\}//)
    {
	$islist=2;
	$r.="<br>\n<ul>\n";
	$gelesen=1;
    } 
    if ($z =~ s/^\\end\{enumerate\}//)
    {
	$islist=0;
	$r.="\n</ol>\n"; 
	$gelesen=1;
    } 
    if ($z =~ s/^\\end\{itemize\}//)
    {
	$islist=0;
	$r.="\n</ul>\n"; 
	$gelesen=1;
    } 
    if ($z =~ s/^\\item\{//)
    {
	if ($islist == 1)
	{
	    $r.="<li><font color=\"".$config{"numitemcolor"}."\" size=".$config{"numitemsize"}.">"; 
	}
	else
	{
	    $r.="<li><font color=\"".$config{"itemcolor"}."\" size=".$config{"itemsize"}.">"; 
	}
	$stack[$fstack]=$openlist;
	$fstack++;
	$gelesen=1;
    } 
}

sub check_tdd
{
    if($tabd[$acol] eq "l")
    {
        $r.="<td align=left><font color=".$config{"tablecolor"}." size=".$config{"tablesize"}.">";
    }
    if($tabd[$acol] eq "r")
    {
        $r.="<td align=right><font color=".$config{"tablecolor"}." size=".$config{"tablesize"}.">";
    }
    if($tabd[$acol] eq "c")
    {
        $r.="<td align=center><font color=".$config{"tablecolor"}." size=".$config{"tablesize"}.">";
    }
    if($tabd[$acol] eq "m")
    {
        $r.="<td align=left><font color=".$config{"tablecolor"}." size=".$config{"tablesize"}.">";
    }

    $acol+=1;
}


sub check_begin_end
{
    if ($z =~ s/^\\begin\{document\}//)
    {
	$active_parse=1;
	$r=$stdfont."\n"; 
    } 
    if ($z =~ s/^\\end\{document\}//) 
    {
	$active_parse=0;
	$r="";
    } 
}

sub check_sections
{
    if ($z =~ s/^\\section\{//gs)
    {
	$secnumber+=1;
	$subsecnumber=0;
	$subsubsecnumber=0;
	$r.="<br><br><font color=\"".$config{"sectioncolor"}."\" size=".$config{"sectionsize"}.">";
	$r.=$secnumber." ";
	$stack[$fstack++]=$opensec;
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\subsection\{//gs)
    {
	$subsecnumber+=1;
	$subsubsecnumber=0;
	$r.="<br><br><font color=\"".$config{"subsectioncolor"}."\" size=".$config{"subsectionsize"}.">";
	$r.=$secnumber.".".$subsecnumber." ";
	$stack[$fstack++]=$opensec;
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\subsubsection\{//gs)
    {
	$subsubsecnumber+=1;
	$r.="<br><br><font color=\"".$config{"subsubsectioncolor"}."\" size=".$config{"subsubsectionsize"}.">";
	$r.=$secnumber.".".$subsecnumber.".".$subsubsecnumber." ";
	$stack[$fstack++]=$opensec;
	$gelesen=1;
	$lastbr=0;	
    }
}

sub check_direction
{
    if ($z =~ s/^\\begin\{center\}//)
    {
	$r.="<div align=center>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\end\{center\}//)
    {
	$r.="</div>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\begin\{flushleft\}//)
    {
	$r.="<div align=left>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\end\{flushleft\}//)
    {
	$r.="</div>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\begin\{flushright\}//)
    {
	$r.="<div align=right>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\end\{flushright\}//)
    {
	$r.="</div>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\begin\{raggedleft\}//)
    {
	$r.="<div align=left>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\end\{raggedleft\}//)
    {
	$r.="</div>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\begin\{raggedright\}//)
    {
	$r.="<div align=right>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\end\{raggedright\}//)
    {
	$r.="</div>\n";
	$gelesen=1;
	$lastbr=0;	
    }

}

sub check_verbatim
{
    if ($z =~ s/^\\begin\{verbatim\}//)
    {
	$r.="<table border=0 bgcolor=\"".$config{"listingbgcolor"}."\" width=100%><tr><td><pre>\n";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\end\{verbatim\}//)
    {
	$r.="</pre></td></tr></table><br>\n";
	$gelesen=1;
	$lastbr=0;	
    }
}

sub check_bold
{
    if ($istab == 1)
    {
	if ($z =~ s/^\\textbf\{//)
	{
	    $r.="<b><font color=\"".$config{"tabboldcolor"}."\">";
	    $stack[$fstack]=$openbold;
	    $fstack++;
	    $gelesen=1;
	    $lastbr=0;	
	}
    }
    elsif ($islist == 1)
    {
	if ($z =~ s/^\\textbf\{//)
	{
	    $r.="<b><font color=\"".$config{"numitemboldcolor"}."\">";
	    $stack[$fstack]=$openbold;
	    $fstack++;
	    $gelesen=1;
	    $lastbr=0;	
	}
    }
    elsif ($islist == 2)
    {
	if ($z =~ s/^\\textbf\{//)
	{
	    $r.="<b><font color=\"".$config{"itemboldcolor"}."\">";
	    $stack[$fstack]=$openbold;
	    $fstack++;
	    $gelesen=1;
	    $lastbr=0;	
	}
    }
    else
    {	
	if ($z =~ s/^\\textbf\{//)
	{
	    $r.="<b><font color=\"".$config{"boldcolor"}."\">";
	    $stack[$fstack]=$openbold;
	    $fstack++;
	    $gelesen=1;
	    $lastbr=0;	
	}
    }	
    if ($z =~ s/^\\textsl\{//)
    {
	$r.="<font color=\"".$config{"slantedcolor"}."\"><em>";
	$stack[$fstack]=$opensl;
	$fstack++;
	$gelesen=1;
	$lastbr=0;	
    }
}


sub check_textsizes
{
    if ($z =~ s/^\\tiny//)
    {
	$r.="<font color=\"".$config{"tinycolor"}."\" size=".$config{"tinysize"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\scriptsize//)
    {
	$r.="<font color=\"".$config{"scriptcolor"}."\" size=".$config{"scriptsize"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\footnotesize//)
    {
	$r.="<font color=\"".$config{"footnotecolor"}."\" size=".$config{"footnotesize"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\small//)
    {
	$r.="<font color=\"".$config{"smallcolor"}."\" size=".$config{"smallsize"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\large//)
    {
	$r.="<font color=\"".$config{"largecolor1"}."\" size=".$config{"largesize1"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\Large//)
    
    {
	$r.="<font color=\"".$config{"largecolor2"}."\" size=".$config{"largesize2"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\LARGE//)
    {
	$r.="<font color=\"".$config{"largecolor3"}."\" size=".$config{"largesize3"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\huge//)
    {
	$r.="<font color=\"".$config{"hugecolor1"}."\" size=".$config{"hugesize1"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
    if ($z =~ s/^\\Huge//)
    {
	$r.="<font color=\"".$config{"hugecolor2"}."\" size=".$config{"hugesize2"}.">";
	$gelesen=1;
	$lastbr=0;	
    }
}


sub check_close
{
    if ($z =~ s/^\}//)
    {
	$gelesen=1;
	$docl=0;
	if ($fstack>0)
	{
	    $fstack-=1;
	    $docl=$stack[$fstack];
	}    
	if (($docl == $openbold) && ($islist == 0))
	{
	    $r.="</b><font color=\"".$config{"standardcolor"}."\">";
	    $lastbr=0;	    
	}
	if (($docl == $openbold) && ($islist == 1))
	{
	    $r.="</b><font color=\"".$config{"numitemcolor"}."\">";
	    $lastbr=0;	    
	}
	if (($docl == $openbold) && ($islist == 2))
	{
	    $r.="</b><font color\"=".$config{"itemcolor"}."\">";
	    $lastbr=0;	    
	}

	if ($docl == $opensec)
	{
	    $r.="<br><font color=\"".$config{"standardcolor"}."\" size=".$config{"standardsize"}.">";

	    $lastbr=1;
	}
	if (($docl == $opensl) && ($islist == 0))
	{
	    $r.="<font color=\"".$config{"standardcolor"}."\"></em>";
	    $lastbr=0;
	}
	if (($docl == $opensl) && ($islist == 1))
	{
	    $r.="<font color=\"".$config{"numitemcolor"}."\"></em>";
	    $lastbr=0;
	}
	if (($docl == $opensl) && ($islist == 2))
	{
	    $r.="<font color=\"".$config{"itemcolor"}."\"></em>";
	    $lastbr=0;
	}
	
	
	if ($docl == $openlist)
	{
	    $r.="</li><font color=\"".$config{"standardcolor"}."\" size=".$config{"standardsize"}.">";
	    $lastbr=0;
	}

    }
}

sub check_par
{
    if ($z =~ s/^\\par//)
    {
	$r.="<br>";
	$gelesen=1;
    }
}


sub normal_text
{
    if ($z =~ s/\\|}|&//)
    {
	$p=$`;
	if ($link ne "")
	{
	    $r.=$link;
	}
	$r.=$p;
	if ($link ne "")
	{
	    $r.="</a>";
	    $link="";
	}
	$z=$&.$';
	$gelesen=1;
	$lastbr=0;
    }
    else
    {
	$p=$z;
	$r.=$p;
	$z="";
	$gelesen=1;
	$lastbr=0;
    }
}


sub pre_substitute
{
    $z =~ s//subst_auml;/gs;
    $z =~ s//subst_ouml;/gs;
    $z =~ s//subst_uuml;/gs;
    $z =~ s//subst_Auml;/gs;
    $z =~ s//subst_Ouml;/gs;
    $z =~ s//subst_Uuml;/gs;
    $z =~ s//subst_szlig;/gs;
    $z =~ s/\\{/subst_lcurly;/gs;
    $z =~ s/\\}/subst_rcurly;/gs;
    $z =~ s/\\#/subst_cross;/gs;
    $z =~ s/\\%/subst_percent;/gs;
    $z =~ s/\\&/subst_amp;/gs;
    $z =~ s/\\\$/subst_dollar;/gs;
    $z =~ s/\\_/subst_underline;/gs;
    $z =~ s/\\verb=\\=/subst_bslash;/gs;
    $z =~ s/\\verb=\^=/subst_dach;/gs;
    $z =~ s/\\verb=~=/subst_tilde;/gs;
    $z =~ s/\{\[}/\[/gs;
    $z =~ s/\{}//gs;
    $z =~ s/\\ldots/\.\.\./gs;
    $z =~ s/,,/subst_quot;/gs;
    $z =~ s/''/subst_quot;/gs;
    $z =~ s/</subst_lt;/gs;
    $z =~ s/>/subst_gt;/gs;
    $z =~ s/\\\\/subst_newline;/gs;
    $z =~ s/\\newline/subst_newline;/gs;
}

sub post_substitute
{
    $r =~ s/subst_auml;/&auml;/gs;
    $r =~ s/subst_ouml;/&ouml;/gs;
    $r =~ s/subst_uuml;/&uuml;/gs;
    $r =~ s/subst_Auml;/&Auml;/gs;
    $r =~ s/subst_Ouml;/&Ouml;/gs;
    $r =~ s/subst_Uuml;/&Uuml;/gs;
    $r =~ s/subst_szlig;/&szlig;/gs;
    $r =~ s/subst_quot;/&quot;/gs;
    $r =~ s/subst_quot;/&quot;/gs;
    $r =~ s/subst_lt;/&lt;/gs;
    $r =~ s/subst_gt;/&gt;/gs;
    $r =~ s/subst_lcurly;/\{/gs;
    $r =~ s/subst_rcurly;/}/gs;
    $r =~ s/subst_amp;/&amp;/gs;
    $r =~ s/subst_underline;/_/gs;
    $r =~ s/subst_cross;/#/gs;
    $r =~ s/subst_percent;/%/gs;
    $r =~ s/subst_bslash;/\\/gs;
    $r =~ s/subst_dach;/\^/gs;
    $r =~ s/subst_tilde;/~/gs;
    $r =~ s/subst_dollar;/\$/gs;
    $r =~ s/subst_newline;/<br>\n/gs;
}