;################################################################################
;#										#
;# chipbasic - single chip basic computer with ATMega 16			#
;# EEPROM memory interface							#
;# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; read one byte from program memory
;------------------------------------------------------------------------------
ee_read:	sbic	EECR,EEWE
		rjmp	ee_read
		out	EEARH,YH
		out	EEARL,YL
		sbi	EECR,EERE
		in	tempreg1,EEDR
		adiw	YL,1
		ret

;------------------------------------------------------------------------------
; read line from program memory to line buffer
;------------------------------------------------------------------------------
ee_readline:	lds	XL,tb_ram+12		;linenumber
		lds	XH,tb_ram+13		;last linenumber
		cp	XH,XL
		breq	ee_readline2
		sts	tb_ram+13,XL		;store as last
		ldi	ZL,LOW(tb_linebuf)	;buffer address
		ldi	ZH,HIGH(tb_linebuf)
		ldi	XH,mem_linelen		;bytes/line
		mul	XH,XL
		mov	YL,r0
		mov	YH,r1
		ldi	XH,mem_linelen		;useable bytes
ee_readline1:	rcall	ee_read			;get byte
		st	Z+,tempreg1
		cpi	tempreg1,0xff
		breq	ee_readline2
		dec	XH
		brne	ee_readline1
		ldi	XH,0x20			;write Space
		st	Z+,XH
		ldi	XH,0xff			;write EOL
		st	Z+,XH
ee_readline2:	ret					

;------------------------------------------------------------------------------
; read name from program memory to Z+
;------------------------------------------------------------------------------
ee_readname:	ldi	YL,LOW(500)
		ldi	YH,HIGH(500)
		ldi	XH,10			;bytes/name
ee_readname1:	rcall	ee_read			;get byte
		st	Z+,tempreg1
		dec	XH
		brne	ee_readname1
		ret					
		
;------------------------------------------------------------------------------
; write one byte to program memory
;------------------------------------------------------------------------------
ee_write4:	mov	tempreg1,tempreg4	;write tr4 instead of tr1
		dec	XH			;bytes counter
ee_write:	sbic	EECR,EEWE
		rjmp	ee_write
		out	EEARH,YH
		out	EEARL,YL
		sbi	EECR,EERE
		in	tempreg5,EEDR
		cp	tempreg5,tempreg1
		brne	ee_write_1
		adiw	YL,1
		ret	
ee_write_1:	sbic	EECR,EEWE
		rjmp	ee_write_1
		out	EEDR,tempreg1
		sbi	EECR,EEMWE
		sbi	EECR,EEWE
ee_write_2:	sbic	EECR,EEWE		;verify
		rjmp	ee_write_2
		sbi	EECR,EERE
		in	tempreg5,EEDR
		cp	tempreg1,tempreg5		
		brne	ee_write		;repeat programming
		adiw	YL,1
		ret

;------------------------------------------------------------------------------
; write line (XL) from vram to line buffer to program memory
;------------------------------------------------------------------------------
ee_writeline:	ldi	YL,LOW(libmio_vram+2*libmio_cols+3)
		ldi	YH,HIGH(libmio_vram+2*libmio_cols+3)
		ldi	XH,libmio_cols		;bytes/vram-line
		mul	XH,XL
		add	YL,r0
		adc	YH,r1
		adiw	YL,tb_linelen
		ldi	ZL,LOW(tb_linebuf+tb_linelen)	;buffer address
		ldi	ZH,HIGH(tb_linebuf+tb_linelen)
		ldi	tempreg1,tb_linelen	;number of visible chars
		ldi	XH,0xff
		st	Z,XH			;stopper
ee_writeline0:	ld	XH,-Y
		cpi	XH,0x20			;space
		brne	ee_writeline2
		ldi	XH,0xff
		st	-Z,XH
		dec	tempreg1
		brne	ee_writeline0
		rjmp	ee_writeline3
ee_writeline1:	ld	XH,-Y		
ee_writeline2:	st	-Z,XH
		dec	tempreg1
		brne	ee_writeline1

		
ee_writeline3:	ldi	ZL,LOW(tb_linebuf)	;buffer address
		ldi	ZH,HIGH(tb_linebuf)
		ldi	XH,mem_linelen		;length of EE-line
		mul	XH,XL
		mov	YL,r0
		mov	YH,r1
		
ee_writel_09:	clr	tempreg3		;in string counter
ee_writel_10:	cpi	XH,0
		breq	ee_writel_16
		ld	tempreg4,Z+		;get char
		cpi	tempreg4,0xff		;stop
		brne	ee_writel_11	
		rcall	ee_write4		;write this and return
		rjmp	ee_writel_10
ee_writel_11:	cpi	tempreg4,0x20		;space
		breq	ee_writel_10		;delete spaces before statements
		cpi	tempreg4,':'		;delete multiple colon
		breq	ee_writel_10
		sbiw	ZL,1			;set pointer to char	
		push	XH	
		push	YL
		push	YH
		rcall	tb_gtoken		;check for token
		pop	YH
		pop	YL
		pop	XH
		cpi	ereg,0x00		;success?
		brne	ee_writel_12		;brne
		rcall	ee_write4		;write token
		clr	tempreg3		;in string counter
;no token
ee_writel_12:	cpi	XH,0
		breq	ee_writel_16
		ld	tempreg4,Z+
		cpi	tempreg4,0xff		;stop
		brne	ee_writel_13	
		rcall	ee_write4		;write this
		rjmp	ee_writel_10
ee_writel_13:	cpi	tempreg4,'"'
		brne	ee_writel_14
		inc	tempreg3
ee_writel_15:	rcall	ee_write4		;write "
		rjmp	ee_writel_12
ee_writel_14:	cpi	tempreg4,':'
		brne	ee_writel_15
		rcall	ee_write4		;write :
		sbrc	tempreg3,0		;skip if not in string
		rjmp	ee_writel_12
		rjmp	ee_writel_10
ee_writel_16:	ret				;exit if full	

;------------------------------------------------------------------------------
; store name from Z+ to program memory
;------------------------------------------------------------------------------
ee_writename:	ldi	YL,LOW(500)
		ldi	YH,HIGH(500)
		ldi	XH,10			;bytes/name
ee_writename1:	ld	tempreg1,Z+
		rcall	ee_write		;write byte
		dec	XH
		brne	ee_writename1
		ret					
