;################################################################################
;#										#
;# chipbasic - single chip basic computer with ATMega 16			#
;# menu functions								#
;# copyright (c) 2006 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.equ	menu_max = 7
;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
menu_main:	ldi	XL,1
		libmio_chpump			;enable chargepump for serial
		rcall	menu_maxbox
		ldi	YL,0
		ldi	YH,40
		ldi	ZL,59
		ldi	ZH,40
		libmio_fbox
		clr	ereg		
		clr	ctrl
		libmio_thistext
		.db 2,6,"AVR CHIPBASIC 0.61",0
		libmio_thistext
		.db 3,4,"(C) 2006 JOERG WOLFRAM",0

		libmio_thistext
		.db	6,4,"EDITOR",0

		libmio_thistext
		.db	8,4,"RUN",0

		libmio_thistext			;load from card
		.db	10,4,0
		rcall	menu_text1

		libmio_thistext			;save to card
		.db	12,4,0
		rcall	menu_text2

		libmio_thistext			;load from serial
		.db	14,4,0
		rcall	menu_text3

		libmio_thistext			;save to serial
		.db	16,4,0
		rcall	menu_text4

		libmio_thistext			;save to serial
		.db	18,4,0
		rcall	menu_text5

		libmio_thistext			;show program name
		.db	21,1,"PROGRAM: ",0
		libmio_calc
		mov	ZL,YL
		mov	ZH,YH
		call	ee_readname


		ldi	ZL,0			;pos 1
menu_main_1:	ldi	YL,LOW(libmio_vram+6*libmio_cols+3)
		ldi	YH,HIGH(libmio_vram+6*libmio_cols+3)
		ldi	ZH,0
menu_main_2:	ldi	XL,0x20
		cp	ZH,ZL
		brne	menu_main_3
		ldi	XL,0x16
menu_main_3:	st	Y,XL
		adiw	YL,libmio_cols*2
		inc	ZH
		cpi	ZH,menu_max
		brne	menu_main_2
		
menu_main_4:	libmio_waitkey

;------------------------------------------------------------------------------
;cursor up key
;------------------------------------------------------------------------------
menu_main_4n:	cpi	tempreg1,0xe4		;up
		brne	menu_main_5
		dec	ZL
		cpi	ZL,0xff
		brne	menu_main_1
		ldi	ZL,0x00
		rjmp	menu_main_1

;------------------------------------------------------------------------------
;cursor down key
;------------------------------------------------------------------------------
menu_main_5:	cpi	tempreg1,0xe5		;down
		brne	menu_main_6
		inc	ZL
		cpi	ZL,menu_max
		brne	menu_main_1
		ldi	ZL,menu_max-1
		rjmp	menu_main_1

;------------------------------------------------------------------------------
;enter key
;------------------------------------------------------------------------------
menu_main_6:	cpi	tempreg1,0xea		;enter
		brne	menu_main_1
		cpi	ZL,0x00			;EDIT
		brne	menu_main_7
		clr	ereg
		rjmp	menu_editloop
menu_main_7:	cpi	ZL,0x01			;RUN
		brne	menu_main_8
		sts	libmio_kflags,byte0
		rcall	menu_runprog		;run programm
		cpi	ereg,0x02
		brcc	menu_editloop
menu_main_71:	libmio_waitkey
		cpi	tempreg1,0xf1		;F1
		brne	menu_main_71
		rjmp	menu_main
menu_main_8:	cpi	ZL,0x02			;load from module
		brne	menu_main_9
		rjmp	menu_mread
menu_main_9:	cpi	ZL,0x03			;save to module
		brne	menu_main_10
		rjmp	menu_mstore
menu_main_10:	cpi	ZL,0x04			;load from serial
		brne	menu_main_11
		rjmp	menu_sread
menu_main_11:	cpi	ZL,0x05			;save to serial
		brne	menu_main_12
		rjmp	menu_swrite
		
menu_main_12:	rjmp	menu_print		
;------------------------------------------------------------------------------
; editor loop
;------------------------------------------------------------------------------
menu_editloop:	sts	libmio_color,byte0	;plot color = white
		call	editor_main
		sts	libmio_kflags,byte0
		lds	XL,libmio_lastkey
		cpi	XL,0xfa			;F10
		breq	menu_editloop1
		rjmp	menu_main
menu_editloop1:	call	menu_runprog		;run programm
menu_editloop2:	libmio_waitkey
		cpi	tempreg1,0xf1		;F1
		brne	menu_editloop2
		rjmp	menu_editloop

;------------------------------------------------------------------------------
; read from module
;------------------------------------------------------------------------------
menu_mread:	rcall	menu_maxbox
		libmio_thistext
		.db	2,4,0
		rcall	menu_text1
		rcall	menu_flist
		rcall	menu_msel
		cpi	XL,0xff
		brne	menu_mread02
		rjmp	menu_main
menu_mread02:	rcall	i2c_rprog
		cpi	ereg,0
		brne	menu_moderr
		rjmp	menu_main		
		
;------------------------------------------------------------------------------
; store to module
;------------------------------------------------------------------------------
menu_mstore:	rcall	menu_maxbox
		libmio_thistext
		.db	2,4,0
		rcall	menu_text2
		rcall	menu_flist
		rcall	menu_msel
		cpi	XL,0xff
		brne	menu_mstore02
		rjmp	menu_main
menu_mstore02:	rcall	i2c_wprog
		cpi	ereg,0
		brne	menu_moderr
		rjmp	menu_main		


menu_moderr:	libmio_thistext
		.db	21,1,"MEMORY CARD ERROR",0
		libmio_waitkey
		rjmp	menu_main

;------------------------------------------------------------------------------
; show filelist
;------------------------------------------------------------------------------
menu_flist:	clr	XL			;first program number
menu_flist1:	ldi	YL,LOW(libmio_vram+5*libmio_cols+6)		
		ldi	YH,HIGH(libmio_vram+5*libmio_cols+6)		
		ldi	XH,libmio_cols
		mul	XH,XL
		add	YL,r0
		adc	YH,r1
		push	XL
		rcall	i2c_rname
		pop	XL
		cpi	ereg,0
		breq	menu_flist2
		pop	XL
		pop	XL
		rjmp	menu_moderr	
menu_flist2:	inc	XL
		cpi	XL,0x10
		brne	menu_flist1
		ret

;------------------------------------------------------------------------------
; read from serial
;------------------------------------------------------------------------------
menu_sread:	libmio_clrscr			;clear screen
		libmio_thistext
		.db	0,0,"LOADING...",0
		ldi	XL,0			;position
		ldi	XH,2	
		libmio_gotoxy			;set cursor position
		ldi	tempreg1,0x15		;NAK		
		rcall	ser2prg_pserx		;send
		rcall	ser2prg
		rcall	editor_save
		libmio_thistext			;edit program name
		.db	0,0,"SET NAME: ",0
		rcall	editor_ren
		ldi	ZL,LOW(libmio_vram+11)
		ldi	ZH,HIGH(libmio_vram+11)
		rcall	ee_writename
	    	rjmp	menu_main

;------------------------------------------------------------------------------
; write to serial
;------------------------------------------------------------------------------
menu_swrite:	libmio_clrscr			;clear screen
		libmio_thistext
		.db	0,0,"SENDING PROGRAM...",0
		libmio_thistext
		.db	22,0,"PROGRESS:",0
		rcall	prg_list
		rcall	prg2ser
		rjmp	menu_main

;------------------------------------------------------------------------------
; print program
;------------------------------------------------------------------------------
menu_print:	libmio_clrscr			;clear screen
		libmio_thistext			;show program name
		.db	0,0,"PROGRAM: ",0
		libmio_calc
		mov	ZL,YL
		mov	ZH,YH
		call	ee_readname
		rcall	prg_list
		rcall	printlist
		rjmp	menu_main

;------------------------------------------------------------------------------
; select a program from list
;------------------------------------------------------------------------------
menu_msel:	ldi	ZL,0			;pos 1
menu_msel_1:	ldi	YL,LOW(libmio_vram+5*libmio_cols+5)
		ldi	YH,HIGH(libmio_vram+5*libmio_cols+5)
		ldi	ZH,0
menu_msel_2:	ldi	XL,0x20
		cp	ZH,ZL
		brne	menu_msel_3
		ldi	XL,0x16
menu_msel_3:	st	Y,XL
		adiw	YL,libmio_cols
		inc	ZH
		cpi	ZH,16
		brne	menu_msel_2
		
menu_msel_4:	libmio_waitkey			;wait for keypress

;------------------------------------------------------------------------------
;cursor up key
;------------------------------------------------------------------------------
		cpi	tempreg1,0xe4		;up
		brne	menu_msel_5
		dec	ZL
		cpi	ZL,0xff
		brne	menu_msel_1
		ldi	ZL,0x00
		rjmp	menu_msel_1

;------------------------------------------------------------------------------
;cursor down key
;------------------------------------------------------------------------------
menu_msel_5:	cpi	tempreg1,0xe5		;down
		brne	menu_msel_6
		inc	ZL
		cpi	ZL,16
		brne	menu_msel_1
		ldi	ZL,15
		rjmp	menu_msel_1

;------------------------------------------------------------------------------
;enter key
;------------------------------------------------------------------------------
menu_msel_6:	cpi	tempreg1,0xea		;enter
		brne	menu_msel_7
		mov	XL,ZL
		ret

;------------------------------------------------------------------------------
;escape key
;------------------------------------------------------------------------------
menu_msel_7:	cpi	tempreg1,0xed		;esc
		brne	menu_msel_1
		ldi	XL,0xff
		ret		
		

;------------------------------------------------------------------------------
;text load from memory card
;------------------------------------------------------------------------------
menu_text1:	libmio_thistext
		.db	255,"LOAD FROM MEMORY CARD",0
		ret

;------------------------------------------------------------------------------
;text save to memory card
;------------------------------------------------------------------------------
menu_text2:	libmio_thistext
		.db	255,"SAVE TO MEMORY CARD",0
		ret	

;------------------------------------------------------------------------------
;text load from serial
;------------------------------------------------------------------------------
menu_text3:	libmio_thistext
		.db	255,"RECEIVE (XMODEM)",0
		ret

;------------------------------------------------------------------------------
;text save to serial
;------------------------------------------------------------------------------
menu_text4:	libmio_thistext
		.db	255,"SEND (XMODEM)",0
		ret

;------------------------------------------------------------------------------
;text print listing
;------------------------------------------------------------------------------
menu_text5:	libmio_thistext
		.db	255,"PRINT LISTING",0
		ret
		
;------------------------------------------------------------------------------
;run program
;------------------------------------------------------------------------------
menu_runprog:	libmio_clrscr			;clear screen from menu			
		call	tbrun			;run programm
		sts	libmio_channel,byte0	;set output to screen
		libmio_newline
		libmio_thistext
		.db libmio_rows-1,0,16,0x17,0x18,0x19,0x1a,0x1a,0x10,0x1b,0x1c,0x10,0
		ret	

;------------------------------------------------------------------------------
;clear screen and draw box
;------------------------------------------------------------------------------
menu_maxbox:	libmio_clrscr			;clear screen
		ldi	YL,0
		ldi	YH,0
		ldi	ZL,59
		ldi	ZH,45
		libmio_box		
		ret

;------------------------------------------------------------------------------
;copy program to serial (XMODEM)
;------------------------------------------------------------------------------
prg2ser:	rcall	ser2prg_gserx		;get ack
		cpi	tempreg1,0x15		;NAK
		brne	prg2ser			;wait for it

		ldi	YL,LOW(libmio_vram+670)
		ldi	YH,HIGH(libmio_vram+670)
		ldi	ZL,LOW(libmio_vram+60)	;start in vram
		ldi	ZH,HIGH(libmio_vram+60)
		ldi	XL,21			;yellow
		ldi	tempreg3,1		;start with block 1
prg2ser_01:	clr	tempreg4		;clear checksum
		ldi	tempreg1,0x01		;SOH
		rcall	ser2prg_pserx
		mov	tempreg1,tempreg3	;block number
		rcall	ser2prg_pserx
		com	tempreg1		;complement of block number
		rcall	ser2prg_pserx
		ldi	tempreg2,4		;4 lines per block
prg2ser_04:	ldi	XH,30			;chars per line
prg2ser_05:	ld	tempreg1,Z+		;get char
		add	tempreg4,tempreg1	;add to checksum
		rcall	ser2prg_pserx		;write to serial port
		dec	XH
		brne	prg2ser_05		;loop
		ldi	tempreg1,0x20		;additional space
		add	tempreg4,tempreg1	;add to checksum
		rcall	ser2prg_pserx		;write to serial port
		ldi	tempreg1,0x0a		;LF
		add	tempreg4,tempreg1	;add to checksum
		rcall	ser2prg_pserx		;write to serial port
		st	Y+,XL			;progress bar
		dec	tempreg2		;next line in block
		brne	prg2ser_04		;loop
		mov	tempreg1,tempreg4	;checksum
		rcall	ser2prg_pserx		;write to serial port
		rcall	ser2prg_gserx		;get ack
		cpi	tempreg1,0x06		;ack
		breq	prg2ser_08		;next block
		sbiw	ZL,60			;set Z to start of block
		sbiw	ZL,60
		st	-Y,byte0
		st	-Y,byte0
		st	-Y,byte0
		st	-Y,byte0
		st	-Y,byte0
		rjmp	prg2ser_01		;repeat this block
prg2ser_08:	inc	tempreg3		;next block number
		cpi	tempreg3,6		;max blocks		
		brne	prg2ser_01		;continue with next block
		ldi	tempreg1,0x04		;EOT
		rcall	ser2prg_pserx		;write to serial port
prg2ser_09:	ret		

;------------------------------------------------------------------------------
;copy serial to program (XMODEM)
;------------------------------------------------------------------------------
ser2prg:	ldi	tempreg3,1		;start with block 1
		clr	YL			;chars
		clr	YH			;lines
ser2prg_01:	clr	tempreg4		;clear checksum
		lds	ZL,libmio_cur_x		;save screen position
		lds	ZH,libmio_cur_y
ser2prg_02:	rcall	ser2prg_gserx		;get char
	    	cpi	tempreg1,0x04		;EOT
		breq	ser2prg_08		;exit
	    	cpi	tempreg1,0x01		;SOH
		brne	ser2prg_02		;wait for it
		rcall	ser2prg_gserx		;get char
		cp	tempreg1,tempreg3	;good block number?
		brne	ser2prg_02		;wait for SOH		
		rcall	ser2prg_gserx		;get char
		com	tempreg1
		cp	tempreg1,tempreg3	;good block number?
		brne	ser2prg_02		;wait for SOH

		ldi	XL,0			;reset char counter
ser2prg_03:	rcall	ser2prg_gserx
		inc	XL			;char counter+1
		cpi	XL,129
		breq	ser2prg_06		;char is checksum
		add	tempreg4,tempreg1	;add to checksum			
		cpi	tempreg1,0x0a		;LF
		breq	ser2prg_05
		cpi	tempreg1,0x20		;space
		brcs	ser2prg_03		;is less
		cpi	tempreg1,'a'		;set to upper
		brcs	ser2prg_04
		cpi	tempreg1,'z'+1
		brcc	ser2prg_04
		subi	tempreg1,'a'-'A'
ser2prg_04:	cpi	YH,20			;max linenumber
		breq	ser2prg_03
		cpi	YL,30			;max chars
		breq	ser2prg_03	
		inc	YL			;chars+1
		libmio_outchar
		rjmp	ser2prg_03		;loop		
ser2prg_05:	cpi	YL,30
		breq	ser2prg_05a
		libmio_newline
ser2prg_05a:	inc	YH			;next line
		clr	YL			;char counter	
		rjmp	ser2prg_03		;loop
ser2prg_06:	cp	tempreg1,tempreg4	;checksum ok?
		brne	ser2prg_07
		ldi	tempreg1,0x06		;ACK		
		rcall	ser2prg_pserx		;send
		inc	tempreg3		;blocknumber +1
		rjmp	ser2prg_01		;next block
ser2prg_07:	ldi	tempreg1,0x15		;NAK		
		rcall	ser2prg_pserx		;send
		mov	XL,ZL
		mov	XH,ZH
		libmio_gotoxy
		rjmp	ser2prg_01		;repeat block
ser2prg_08:	ldi	tempreg1,0x06		;ACK		
		rjmp	ser2prg_pserx		;send
		

ser2prg_pserx:	libmio_pser			;call extender
		ret
ser2prg_gserx:	libmio_gser			;call extender					
		ret

;------------------------------------------------------------------------------
; list to screen
;------------------------------------------------------------------------------
prg_list:	ldi	XL,0			;position
		ldi	XH,2	
		libmio_gotoxy			;set cursor position
		ldi	ctrl,2			;linenumber format
		ldi	tempreg2,1
prg_list_01:	push	tempreg2
		clr	XH
		mov	XL,tempreg2
		libmio_outdez
		libmio_outspace
		libmio_calc
		mov	ZL,YL
		mov	ZH,YH
		mov	XL,tempreg2
		dec	XL
		call	editor_lline
		libmio_newline
		pop	tempreg2
		inc	tempreg2
		cpi	tempreg2,21
		brne	prg_list_01		
		ret
	
;------------------------------------------------------------------------------
; print listing
;------------------------------------------------------------------------------
printlist:	ldi	ZL,LOW(libmio_vram)	;start in vram
		ldi	ZH,HIGH(libmio_vram)
		ldi	tempreg1,0x0d		;CR
		libmio_ppar
		ldi	tempreg1,0x0a		;LF
		libmio_ppar
		ldi	tempreg3,22		;20 lines
printlist_01:	ldi	tempreg4,libmio_cols
printlist_02:	ld	tempreg1,Z+
		libmio_ppar
		dec	tempreg4
		brne	printlist_02
		ldi	tempreg1,0x0d		;CR
		libmio_ppar
		ldi	tempreg1,0x0a		;LF
		libmio_ppar
		dec	tempreg3
		brne	printlist_01
		ldi	tempreg1,0x0C		;PF
		libmio_ppar
		ret
		