;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;r18/r19=addr, r16=data
emu_in:		sbrc	r18,0			;KBD
		rjmp	emu_in_1

		cpi	r19,0xfe
		brne	emu_infe1
		ldi	ZH,2
		sts	zx80_venable,ZH
emu_infe1:	ldi	ZH,HIGH(io_fe*2)
		mov	ZL,r19			;HIGH addr
		lpm	ZL,Z
		ldi	ZH,HIGH(vsys_kbuf)
		ld	r16,Z
		ret

emu_in_1:	sbrc	r18,6
		rjmp	emu_in_x
		sbrs	r18,5
.if USE_IOA == 1
		rjmp	emu_in_ioa
.else
		nop
.endif
		sbrc	r18,5
.if USE_IOB == 1
		rjmp	emu_in_iob
.else
		nop
.endif

emu_in_x:	ldi	r16,0xff		;empty port
		ret

emu_in_ioa:	clr	r16
		sbrs	r18,4
		in	r16,IOPIN_A
		ret

emu_in_iob:	clr	r16
		sbrs	r18,4
		in	r16,IOPIN_B
		ret

;r18/r19=addr, r16=data
emu_out:	sbrc	r18,0			;NMI on
		rjmp	emu_out_1
		sts	vsys_nmi,const_1
		ret

emu_out_1:	sbrc	r18,1			;NMI off
		rjmp	emu_out_2
;		sts	vsys_nmi,const_0
		ret


emu_out_2:	sbrc	r18,6
		rjmp	emu_out_x
		sbrs	r18,5
.if USE_IOA == 1
		rjmp	emu_out_ioa
.else
		nop
.endif
		sbrc	r18,5
.if USE_IOA == 1
		rjmp	emu_out_iob
.else
		nop
.endif

emu_out_x:	ret

emu_out_ioa:	sbrs	r18,4
		out	IOPORT_A,r16
		sbrc	r18,4
		out	IODDR_A,r16
		ret

emu_out_iob:	sbrs	r18,4
		out	IOPORT_B,r16
		sbrc	r18,4
		out	IODDR_B,r16
		ret


;Z=addr (flash), EEARL=data
emu_poke:	ret

emu_intvec:	ldi	r16,0xff
		ret
