;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; load snapshot
;------------------------------------------------------------------------------
fsys_load_spec:	sts	fsys_sectnr,const_0	;start with sector 0
		rcall	fsys_rsector

		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldd	XL,Y+16			;valid flag
		cpi	XL,0xcc
;		cpi	XL,0xaa			;debug
		breq	fsys_rf_sp_0
		clt
		ret

fsys_rf_sp_0:	ldi	ZL,LOW(fsys_buf1)
		ldi	ZH,HIGH(fsys_buf1)
		ldi	XH,10
fsys_rf_sp_0a:	ld	XL,Y+
		st	Z+,XL
		dec	XH
		brne	fsys_rf_sp_0a

		ldi	YL,LOW(fsys_buffer+256)
		ldi	YH,HIGH(fsys_buffer+256)
		ld	reg_a,Y			;get A register (offset 0)
		ldd	reg_f,Y+1		;get F register (offset 1)

		ldd	reg_c,Y+2		;get C register (offset 2)
		ldd	reg_b,Y+3		;get B register (offset 3)

		ldd	reg_l,Y+4		;get L register (offset 4)
		ldd	reg_H,Y+5		;get H register (offset 5)

		ldd	PC_L,Y+6		;get PC register (offset 6)
		ldd	PC_H,Y+7

		ldd	SP_L,Y+8		;get SP register (offset 8)
		ldd	SP_H,Y+9

		ldd	XL,Y+10			;get i register (offset 10)
		sts	zreg_i,XL

		ldd	XL,Y+11			;get r register (offset 11)
		andi	XL,0x7f
		ldd	XH,Y+12			;get switch value (offset 12)
		sbrc	XH,0
		ori	XL,0x80
		sts	zreg_r,XL
		lsr	XH
		andi	XH,0x07
		mov	XL,XH
		swap	XL
		lsr	XL
		or	XL,XH

		ldd	reg_e,Y+13		;get E register (offset 13)
		ldd	reg_d,Y+14		;get D register (offset 14)

		ldd	XL,Y+15			;get C' register (offset 15)
		sts	zreg_c1,XL
		ldd	XL,Y+16			;get B' register
		sts	zreg_b1,XL

		ldd	XL,Y+17			;get E' register
		sts	zreg_e1,XL
		ldd	XL,Y+18			;get D' register
		sts	zreg_d1,XL

		ldd	XL,Y+19			;get L' register
		sts	zreg_l1,XL
		ldd	XL,Y+20			;get H' register
		sts	zreg_h1,XL

		ldd	XL,Y+21			;get A' register
		sts	zreg_a1,XL
		ldd	XL,Y+22			;get F' register
		sts	zreg_f1,XL

		ldd	XL,Y+23			;get IY register
		sts	zreg_iyl,XL
		ldd	XL,Y+24
		sts	zreg_iyh,XL

		ldd	XL,Y+25			;get IX register
		sts	zreg_ixl,XL
		ldd	XL,Y+26
		sts	zreg_ixh,XL

		ldd	XL,Y+27			;int alowed?
		sts	z80_iflag,XL

		ldd	XL,Y+29			;int mode?
		andi	XL,0x03			;limit
		sts	z80_imode,XL

fsys_rf_sp_01:	lds	XL,fsys_sectnr		;next sector
		inc	XL
		sts	fsys_sectnr,XL
		cpi	XL,33			;beyond last
		brne	fsys_rf_sp_02
		set				;OK
		jmp	fsys_ll_clow
fsys_rf_sp_02:	rcall	fsys_rsector		;read sector
		lds	ZH,fsys_sectnr
		dec	ZH			;start with 0
		lsl	ZH
		subi	ZH,0xc0
		ldi	ZL,0x00
		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldi	XH,0
fsys_rf_sp_03:	ld	XL,Y+
		push	ZL
		push	ZH
		movw	r0,ZL
		putmembyte XL,r0,r1
		pop	ZH
		pop	ZL
		adiw	ZL,1
		ld	XL,Y+
		push	ZL
		push	ZH
		movw	r0,ZL
		putmembyte XL,r0,r1
		pop	ZH
		pop	ZL
		adiw	ZL,1
		dec	XH
		brne	fsys_rf_sp_03
		rjmp	fsys_rf_sp_01


;------------------------------------------------------------------------------
; write file
;------------------------------------------------------------------------------
fsys_save_spec:	ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldi	XL,0xff
		ldi	XH,0x00
fsys_wf_sp_0a:	st	Y+,XL
		st	Y+,XL
		dec	XH
		brne	fsys_wf_sp_0a

		subi	YH,2

		ldi	ZL,LOW(fsys_buf1)
		ldi	ZH,HIGH(fsys_buf1)
		ldi	XH,10
fsys_wf_sp_0b:	ld	XL,Z+
		st	Y+,XL
		dec	XH
		brne	fsys_wf_sp_0b

		ldi	XL,0xcc
		sts	fsys_buffer+16,XL	;set as valid

		ldi	YL,LOW(fsys_buffer+256)
		ldi	YH,HIGH(fsys_buffer+256)
		st	Y,reg_a			;put A register (offset 0)
		std	Y+1,reg_f		;put F register (offset 1)

		std	Y+2,reg_c		;put C register (offset 2)
		std	Y+3,reg_b		;put B register (offset 3)

		std	Y+4,reg_l		;put L register (offset 4)
		std	Y+5,reg_h		;put H register (offset 5)

		std	Y+6,PC_L		;put PC register (offset 6)
		std	Y+7,PC_H

		std	Y+8,SP_L		;put SP register (offset 8)
		std	Y+9,SP_H

		lds	XL,zreg_i
		std	Y+10,XL			;put i register (offset 10)

		lds	XL,zreg_r
		andi	XL,0x7f
		std	Y+11,XL			;put r register (offset 11)

		lds	XL,zreg_r
		ldi	XH,0x07
		lsl	XH
		andi	XH,0x0e
		sbrc	XL,7
		ori	XH,0x01
		std	Y+12,XH

		std	Y+13,reg_e		;put E register (offset 13)
		std	Y+14,reg_d		;put D register (offset 14)

		lds	XL,zreg_c1		;put BC' register
		lds	XH,zreg_b1
		std	Y+15,XL
		std	Y+16,XH

		lds	XL,zreg_e1		;put DE' register
		lds	XH,zreg_d1
		std	Y+17,XL
		std	Y+18,XH

		lds	XL,zreg_l1		;put HL' register
		lds	XH,zreg_h1
		std	Y+19,XL
		std	Y+20,XH

		lds	XL,zreg_a1		;put AF' register
		lds	XH,zreg_f1
		std	Y+21,XL
		std	Y+22,XH

		lds	XL,zreg_iyl		;put IY register
		lds	XH,zreg_iyh
		std	Y+23,XL
		std	Y+24,XH

		lds	XL,zreg_ixl		;put IX register
		lds	XH,zreg_ixh
		std	Y+25,XL
		std	Y+26,XH

		lds	XL,z80_iflag
		andi	XL,0x01
		std	Y+27,XL

		std	Y+28,XL

		lds	XL,z80_imode
		andi	XL,0x03
		std	Y+29,XL

		sts	fsys_sectnr,const_0	;start with sector 0
		rcall	fsys_wsector

fsys_wf_sp_01:	lds	XL,fsys_sectnr
		inc	XL
		sts	fsys_sectnr,XL
		cpi	XL,33			;beyond last
		brne	fsys_wf_sp_02
		jmp	fsys_ll_clow
fsys_wf_sp_02:	lds	ZH,fsys_sectnr
		dec	ZH
		lsl	ZH
		subi	ZH,0xc0
		ldi	ZL,0x00
		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldi	XH,0
fsys_wf_sp_03:	push	ZL
		push	ZH
		movw	r0,ZL
		getmembyte XL,r0,r1
		pop	ZH
		pop	ZL
		st	Y+,XL
		adiw	ZL,1
		push	ZL
		push	ZH
		movw	r0,ZL
		getmembyte XL,r0,r1
		pop	ZH
		pop	ZL
		st	Y+,XL
		adiw	ZL,1
		dec	XH
		brne	fsys_wf_sp_03

		rcall	fsys_wsector		;write sector
		rjmp	fsys_wf_sp_01

