#!/usr/bin/perl
#################################################################################
#										#
# rom data generator/patcher for AX81						#
# copyright (c) 2010-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 3		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
use POSIX;
use Fcntl;

$binfile="zx80rom.bin";
$datfile=">../tables/romdata_zx80.inc";

$dlen = -s $binfile;

open (BREAD, $binfile);
binmode(BREAD);
for($i=0;$i<$dlen;$i++)
{
	read(BREAD,$romdata[$i],1);
}
close(BREAD);


#some patches
$romdata[0x0038]=chr(0xc9);	# return (no int)
$romdata[0x01ad]=chr(0xc9);	# return (no int)

$romdata[0x0207]=chr(0xed);	#LOAD
$romdata[0x0208]=chr(0x12);
$romdata[0x0209]=chr(0xc3);	#goto main exec
$romdata[0x020a]=chr(0x83);
$romdata[0x020b]=chr(0x02);

$romdata[0x01b7]=chr(0xed);	#SAVE
$romdata[0x01b8]=chr(0x11);
$romdata[0x01b9]=chr(0xc3);	#goto main exec
$romdata[0x01ba]=chr(0x83);
$romdata[0x01bb]=chr(0x02);


open (DWRITE,$datfile);

for($i=0;$i<$dlen;$i++)
{
	if(($i%16)==0)
	{
		print DWRITE "\t\t.db ";
	}
	$ibyte=$romdata[$i];
	$iwert=ord($ibyte);
	if($iwert==0)
	{
		print DWRITE "0x00";
	}
	else
	{
		printf DWRITE "%#2.2x",$iwert;
	}
	if(($i%16)<15)
	{
		print DWRITE ",";
	}
	else
	{
		printf DWRITE "\t;%4x\n",$i-15;
	}
	
}
close(DWRITE);



