;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# init sequence								#
;# copyright (c) 2005-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;port konfiguration for port A ... D
;-------------------------------------------------------------------------------
vsys_init:	ldi	r16,128
		ldi	XL,LOW(vsys_ram)
		ldi	XH,HIGH(vsys_ram)
vsys_init_r:	st	X+,const_0
		dec	r16
		brne	vsys_init_r
		sts	vsys_en_keyb,const_1

		ldi	XL,0
		ldi	XH,0x02
vsys_init_v:	st	X+,const_0
		cpi	XH,0x05
		brne	vsys_init_v

		ldi	ZL,0
		ldi	ZH,0xde
		ldi	YL,0
		ldi	YH,0x3f
		ldi	XL,0
		ldi	XH,2
vsys_init_cs:	lpm	r16,Z+
		st	Y+,r16
		sbiw	XL,1
		brne	vsys_init_cs

		;port A config
		ldi	XL,0xff
		out	PORTA,XL
		out	DDRA,const_0

		;port B config
		ldi	XL,0xff
		out	PORTB,XL
		out	DDRB,const_0


		;port C config
		ldi	XL,0xff
		out	PORTC,XL
		ldi	XL,0xf0			;PC (7-4 out 3-0 in)
		ldi	XL,0x00			;test value for CB2
		out	DDRC,XL

		;port D config
		ldi	XL,0xff
		out	PORTD,XL
		ldi	XL,0x80			;send data, enable LED
		out	DDRD,XL

		out	GPIOR0,const_0
		sbi	GPIOR0,3
		ldi	XL,6
		sts	vsys_fskip,XL

		get_cfg

;-------------------------------------------------------------------------------
;usart configuration (synchronous for keyboard)
;-------------------------------------------------------------------------------
vsys_t2i:	sts	UCSR0A,const_0
		ldi	XL,0x10
		sts	UCSR0B,XL
		ldi	XL,0x66
		sts	UCSR0C,XL

		lds	XL,vsys_sysconf
		sbic	GPIOR0,6
		rjmp	init_tv
		sbic	GPIOR0,5
		rjmp	init_lcd


;-------------------------------------------------------------------------------
;timer configuration for VGA
;-------------------------------------------------------------------------------
init_vga:	ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(vsys_counter_v-1)
		ldi	ZL,LOW(vsys_counter_v-1)
		sts	ICR1H,ZH
		sts	ICR1L,ZL

		sts	OCR1AH,const_0		;we use only 8 bits
		ldi	ZH,vsys_hslen_v	;1 hsync length VGA
		sts	OCR1AL,ZH

		ldi	ZH,HIGH(vsys_hint_v)	;video start position
		sts	OCR1BH,ZH
		ldi	ZH,LOW(vsys_hint_v)
		sts	OCR1BL,ZH

		sts	UBRR1H,const_0
		sts	UBRR1L,const_0
		ldi	XL,0x18
		sts	UCSR1B,XL
		ldi	XL,0xc2
		sts	UCSR1C,XL
		sts	UBRR1H,const_0
		sts	UBRR1L,const_0

		ldi	XL,0xb7
init_vga_w2:	dec	XL
		nop
		brne	init_vga_w2

		ldi	XL,0x03
		sts	TCCR2A,XL
		ldi	XL,0x0A
		sts	TCCR2B,XL
		ldi	XL,vsys_counter_v/8-1
		sts	OCR2A,XL
		ldi	XL,vsys_bend_v
		sts	OCR2B,XL

		ldi	XL,0x04
		sts	TIMSK1,XL		;enable CHB INT
		ldi	XL,0x05
		sts	TIMSK2,XL		;enable CHB + OVF INT

		sbi	VSDDR,VSPIN
		sbi	HSDDR,HSPIN
		sbi	VODDR,VOPIN

		ldi	XL,LOW(vint_vg0)
		ldi	XH,HIGH(vint_vg0)
		out	GPIOR1,XL
		out	GPIOR2,XH

		ret

;-------------------------------------------------------------------------------
;timer configuration for LCD
;-------------------------------------------------------------------------------
init_lcd:
		;port A config
		ldi	XL,0x1F
		out	PORTA,XL		;VEE disabled
		ldi	XL,0xFF
		out	DDRA,XL

		ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(vsys_counter_l-1)
		ldi	ZL,LOW(vsys_counter_l-1)
		sts	ICR1H,ZH
		sts	ICR1L,ZL
		sts	OCR1BH,const_1		;vint position
		sts	OCR1BL,const_0

		ldi	XL,0x04
		sts	TIMSK1,XL		;enable TOV INT

		ldi	XL,LOW(vint_lc0)
		ldi	XH,HIGH(vint_lc0)
		out	GPIOR1,XL
		out	GPIOR2,XH
		sbi	VSDDR,VSPIN

		ret

;-------------------------------------------------------------------------------
;timer configuration for TV
;-------------------------------------------------------------------------------
init_tv:	ldi	XL,99
		sbic	GPIOR0,5		;1 pal/ntsc bit
		sts	vsys_fskip,XL

		ldi	XH,0xc2			;FAST-PWM-Mode 14 (PWM channel B)
		sts	TCCR1A,XH
		ldi	XH,0x19			;FAST-PWM-Mode (no prescaler)
		sts	TCCR1B,XH
		ldi	ZH,HIGH(vsys_counter_p-1)
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,HIGH(vsys_counter_n-1)
		sts	ICR1H,ZH
		ldi	ZH,LOW(vsys_counter_p-1)
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	ZH,LOW(vsys_counter_n-1)
		sts	ICR1L,ZH

		sts	OCR1AH,const_0		;we use only 8 bits
		ldi	ZH,vsys_hslen_t	;1 hsync length TV
		sts	OCR1AL,ZH

		ldi	ZH,HIGH(vsys_hint_t)	;border position
		sts	OCR1BH,ZH
		ldi	ZH,LOW(vsys_hint_t)
		sts	OCR1BL,ZH

		ldi	XL,0x04
		sts	TIMSK1,XL		;enable compare OC1B int

		sts	UBRR1H,const_0
		sts	UBRR1L,const_1
		ldi	XL,0x00
		sts	UCSR1B,XL
		ldi	XL,0xc2
		sts	UCSR1C,XL
		sts	UBRR1H,const_0
		sts	UBRR1L,const_1

		ldi	XL,vsys_tdelay_t
init_tv_w2:	dec	XL
		nop
		nop
		nop
		nop
		nop
		brne	init_tv_w2

		ldi	XL,0x03
		sts	TCCR2A,XL
		ldi	XL,0x0A
		sts	TCCR2B,XL
		ldi	XL,vsys_counter_p/8-1
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	XL,vsys_counter_n/8-1
		sts	OCR2A,XL
		ldi	XL,vsys_bend_p
		sbis	GPIOR0,5		;1 pal/ntsc bit
		ldi	XL,vsys_bend_n
		sts	OCR2B,XL

		ldi	XL,0x04
		sts	TIMSK1,XL		;enable CHB INT
		ldi	XL,0x05
		sts	TIMSK2,XL		;enable CHB + OVF INT

		sbi	VSDDR,VSPIN
		sbi	HSDDR,HSPIN
		sbi	VODDR,VOPIN

		ldi	XL,LOW(vint_tv0)
		ldi	XH,HIGH(vint_tv0)
		out	GPIOR1,XL
		out	GPIOR2,XH
		ret

;------------------------------------------------------------------------------
;wait for a key
;------------------------------------------------------------------------------
vsys_waitkey:	sts	vsys_lastkey,const_0
vsys_wkey1:	lds	r16,vsys_lastkey
		cpi	r16,0
		breq	vsys_wkey1
		ret

;------------------------------------------------------------------------------
;wait for no key
;------------------------------------------------------------------------------
vsys_nokey:	lds	r16,vsys_keycode
		cpi	r16,0
		brne	vsys_nokey
		ret

;------------------------------------------------------------------------------
;	;disable watchdog
;------------------------------------------------------------------------------
vsys_dwd:	wdr
		in	XL,MCUSR
		andi	XL,0xF7
		out	MCUSR,XL
		lds	XL,WDTCSR
		ori	XL,0x18
		sts	WDTCSR,XL
		sts	WDTCSR,const_0
		ret
