;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


; the level2 jump table
;------------------------------------------------------------------------------
.if align_mode == 1
.org (pc+255) & 0xff00
.endif

emu2_jtab:	jmp	emu_loop		;2	0x00	NOP
		jmp	emu_code_01
		jmp	emu_code_02
		jmp	emu_code_03
		jmp	emu_code_04
		jmp	emu_code_05
		jmp	emu_code_06
		jmp	emu_code_07
		jmp	emu_code_08
		jmp	emu2_code_09
		jmp	emu_code_0a
		jmp	emu_code_0b
		jmp	emu_code_0c
		jmp	emu_code_0d
		jmp	emu_code_0e
		jmp	emu_code_0f

		jmp	emu_code_10
		jmp	emu_code_11
		jmp	emu_code_12
		jmp	emu_code_13
		jmp	emu_code_14
		jmp	emu_code_15
		jmp	emu_code_16
		jmp	emu_code_17
		jmp	emu_code_18
		jmp	emu2_code_19
		jmp	emu_code_1a
		jmp	emu_code_1b
		jmp	emu_code_1c
		jmp	emu_code_1d
		jmp	emu_code_1e
		jmp	emu_code_1f

		jmp	emu_code_20
		jmp	emu2_code_21
		jmp	emu2_code_22
		jmp	emu2_code_23
		jmp	emu2_code_24
		jmp	emu2_code_25
		jmp	emu2_code_26
		jmp	emu_code_27
		jmp	emu_code_28
		jmp	emu2_code_29
		jmp	emu2_code_2a
		jmp	emu2_code_2b
		jmp	emu2_code_2c
		jmp	emu2_code_2d
		jmp	emu2_code_2e
		jmp	emu_code_2f

		jmp	emu_code_30
		jmp	emu_code_31
		jmp	emu_code_32
		jmp	emu_code_33
		jmp	emu2_code_34
		jmp	emu2_code_35
		jmp	emu2_code_36
		jmp	emu_code_37
		jmp	emu_code_38
		jmp	emu2_code_39
		jmp	emu_code_3a
		jmp	emu_code_3b
		jmp	emu_code_3c
		jmp	emu_code_3d
		jmp	emu_code_3e
		jmp	emu_code_3f

		jmp	emu_code_40
		jmp	emu_code_41
		jmp	emu_code_42
		jmp	emu_code_43
		jmp	emu2_code_44
		jmp	emu2_code_45
		jmp	emu2_code_46
		jmp	emu_code_47
		jmp	emu_code_48
		jmp	emu_code_49
		jmp	emu_code_4a
		jmp	emu_code_4b
		jmp	emu2_code_4c
		jmp	emu2_code_4d
		jmp	emu2_code_4e
		jmp	emu_code_4f

		jmp	emu_code_50
		jmp	emu_code_51
		jmp	emu_code_52
		jmp	emu_code_53
		jmp	emu2_code_54
		jmp	emu2_code_55
		jmp	emu2_code_56
		jmp	emu_code_57
		jmp	emu_code_58
		jmp	emu_code_59
		jmp	emu_code_5a
		jmp	emu_code_5b
		jmp	emu2_code_5c
		jmp	emu2_code_5d
		jmp	emu2_code_5e
		jmp	emu_code_5f

		jmp	emu2_code_60
		jmp	emu2_code_61
		jmp	emu2_code_62
		jmp	emu2_code_63
		jmp	emu2_code_64
		jmp	emu2_code_65
		jmp	emu2_code_66
		jmp	emu2_code_67
		jmp	emu2_code_68
		jmp	emu2_code_69
		jmp	emu2_code_6a
		jmp	emu2_code_6b
		jmp	emu2_code_6c
		jmp	emu2_code_6d
		jmp	emu2_code_6e
		jmp	emu2_code_6f

		jmp	emu2_code_70
		jmp	emu2_code_71
		jmp	emu2_code_72
		jmp	emu2_code_73
		jmp	emu2_code_74
		jmp	emu2_code_75
		jmp	emu_code_76
		jmp	emu2_code_77
		jmp	emu_code_78
		jmp	emu_code_79
		jmp	emu_code_7a
		jmp	emu_code_7b
		jmp	emu2_code_7c
		jmp	emu2_code_7d
		jmp	emu2_code_7e
		jmp	emu_code_7f

		jmp	emu_code_80
		jmp	emu_code_81
		jmp	emu_code_82
		jmp	emu_code_83
		jmp	emu2_code_84
		jmp	emu2_code_85
		jmp	emu2_code_86
		jmp	emu_code_87
		jmp	emu_code_88
		jmp	emu_code_89
		jmp	emu_code_8a
		jmp	emu_code_8b
		jmp	emu2_code_8c
		jmp	emu2_code_8d
		jmp	emu2_code_8e
		jmp	emu_code_8f

		jmp	emu_code_90
		jmp	emu_code_91
		jmp	emu_code_92
		jmp	emu_code_93
		jmp	emu2_code_94
		jmp	emu2_code_95
		jmp	emu2_code_96
		jmp	emu_code_97
		jmp	emu_code_98
		jmp	emu_code_99
		jmp	emu_code_9a
		jmp	emu_code_9b
		jmp	emu2_code_9c
		jmp	emu2_code_9d
		jmp	emu2_code_9e
		jmp	emu_code_9f

		jmp	emu_code_a0
		jmp	emu_code_a1
		jmp	emu_code_a2
		jmp	emu_code_a3
		jmp	emu2_code_a4
		jmp	emu2_code_a5
		jmp	emu2_code_a6
		jmp	emu_code_a7
		jmp	emu_code_a8
		jmp	emu_code_a9
		jmp	emu_code_aa
		jmp	emu_code_ab
		jmp	emu2_code_ac
		jmp	emu2_code_ad
		jmp	emu2_code_ae
		jmp	emu_code_af

		jmp	emu_code_b0
		jmp	emu_code_b1
		jmp	emu_code_b2
		jmp	emu_code_b3
		jmp	emu2_code_b4
		jmp	emu2_code_b5
		jmp	emu2_code_b6
		jmp	emu_code_b7
		jmp	emu_code_b8
		jmp	emu_code_b9
		jmp	emu_code_ba
		jmp	emu_code_bb
		jmp	emu2_code_bc
		jmp	emu2_code_bd
		jmp	emu2_code_be
		jmp	emu_code_bf

		jmp	emu_code_c0
		jmp	emu_code_c1
		jmp	emu_code_c2
		jmp	emu_code_c3
		jmp	emu_code_c4
		jmp	emu_code_c5
		jmp	emu_code_c6
		jmp	emu_code_c7
		jmp	emu_code_c8
		jmp	emu_code_c9
		jmp	emu_code_ca
		jmp	emu2_code_cb
		jmp	emu_code_cc
		jmp	emu_code_cd
		jmp	emu_code_ce
		jmp	emu_code_cf

		jmp	emu_code_d0
		jmp	emu_code_d1
		jmp	emu_code_d2
		jmp	emu_code_d3
		jmp	emu_code_d4
		jmp	emu_code_d5
		jmp	emu_code_d6
		jmp	emu_code_d7
		jmp	emu_code_d8
		jmp	emu_code_d9
		jmp	emu_code_da
		jmp	emu_code_db
		jmp	emu_code_dc
		jmp	emu2_code_dd
		jmp	emu_code_de
		jmp	emu_code_df

		jmp	emu_code_e0
		jmp	emu2_code_e1
		jmp	emu_code_e2
		jmp	emu2_code_e3
		jmp	emu_code_e4
		jmp	emu2_code_e5
		jmp	emu_code_e6
		jmp	emu_code_e7
		jmp	emu_code_e8
		jmp	emu2_code_e9
		jmp	emu_code_ea
		jmp	emu2_code_eb
		jmp	emu_code_ec
		jmp	emu2_code_ed
		jmp	emu_code_ee
		jmp	emu_code_ef

		jmp	emu_code_f0
		jmp	emu_code_f1
		jmp	emu_code_f2
		jmp	emu_code_f3
		jmp	emu_code_f4
		jmp	emu_code_f5
		jmp	emu_code_f6
		jmp	emu_code_f7
		jmp	emu_code_f8
		jmp	emu2_code_f9
		jmp	emu_code_fa
		jmp	emu_code_fb
		jmp	emu_code_fc
		jmp	emu2_code_fd
		jmp	emu_code_fe
		jmp	emu_code_ff

;------------------------------------------------------------------------------
; 0x09		ADD	IX,BC
;------------------------------------------------------------------------------
emu2_code_09:	lsr	reg_f			;shift out C flag
		add	reg_ixl,reg_c
		adc	reg_ixh,reg_b
		rol	reg_f			;shift in C flag
		rjmp	emu2_loopnc

;------------------------------------------------------------------------------
; 0x19		ADD	IX,DE
;------------------------------------------------------------------------------
emu2_code_19:	lsr	reg_f			;shift out C flag
		add	reg_ixl,reg_e
		adc	reg_ixh,reg_d
		rol	reg_f			;shift in C flag
		rjmp	emu2_loopnc

;------------------------------------------------------------------------------
; 0x21		LD 	IX,nnnn
;------------------------------------------------------------------------------
emu2_code_21:	getpcword reg_ixl,reg_ixh
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x22		LD 	(nnnn),IX
;------------------------------------------------------------------------------
emu2_code_22:	getpcword XL,XH
		putmemword reg_ixl,reg_ixh,XL,XH
		rjmp	emu2_loop		;2 end of command

;------------------------------------------------------------------------------
; 0x23		INC	IX
;------------------------------------------------------------------------------
emu2_code_23:	z80_inc16	reg_ixl,reg_ixh
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x24		INC	IXH
;------------------------------------------------------------------------------
emu2_code_24:	z80_increg reg_ixh
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x25		DEC	IXH
;------------------------------------------------------------------------------
emu2_code_25:	z80_decreg reg_ixh
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x26		LD	IXH,nn
;------------------------------------------------------------------------------
emu2_code_26:	getpcbyte reg_ixh
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x29		ADD	IX,IX
;------------------------------------------------------------------------------
emu2_code_29:	lsr	reg_f			;shift out C flag
		add	reg_ixl,reg_ixl
		adc	reg_ixh,reg_ixh
		rol	reg_f			;shift in C flag
		rjmp	emu2_loopnc

;------------------------------------------------------------------------------
; 0x2a		LD 	IX,(nnnn)
;------------------------------------------------------------------------------
emu2_code_2a:	getpcword XL,XH
		getmemword reg_ixl,reg_ixh,XL,XH
		rjmp	emu2_loop		;2 end of command

;------------------------------------------------------------------------------
; 0x2b		DEC	IX
;------------------------------------------------------------------------------
emu2_code_2b:	z80_dec16	reg_ixl,reg_ixh
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x2c		INC	IXL
;------------------------------------------------------------------------------
emu2_code_2c:	z80_increg reg_ixl
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x2d		DEC	IXL
;------------------------------------------------------------------------------
emu2_code_2d:	z80_decreg reg_ixl
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x2e		LD	IXL,nn
;------------------------------------------------------------------------------
emu2_code_2e:	getpcbyte reg_ixl
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x34		INC	(IX+d)
;------------------------------------------------------------------------------
emu2_code_34:
.if index_mode == 1
		getpcbyte r17
		getixbyte r16,r17
		z80_increg r16
		putixbyte r16,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		z80_increg r16
		rjmp	emu_putixbyte
.endif

;------------------------------------------------------------------------------
; 0x35		DEC	(IX+d)
;------------------------------------------------------------------------------
emu2_code_35:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		z80_decreg r16
		putIXbyte r16,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		z80_decreg r16
		rjmp	emu_putixbyte
.endif

;------------------------------------------------------------------------------
; 0x36		LD 	(IX+d),nn
;------------------------------------------------------------------------------
emu2_code_36:
.if index_mode == 1
		getpcword r17,r16
		putIXbyte r16,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		getpcword r17,r16
		rjmp	emu_putixbyte
.endif

;------------------------------------------------------------------------------
; 0x39		ADD	IX,SP
;------------------------------------------------------------------------------
emu2_code_39:	lsr	reg_f			;shift out C flag
		add	reg_ixl,SP_L
		adc	reg_ixh,SP_H
		rol	reg_f			;shift in C flag
		rjmp	emu2_loopnc

;------------------------------------------------------------------------------
; 0x44		LD	B,IXH
;------------------------------------------------------------------------------
emu2_code_44:	mov	reg_b,reg_ixh
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x45		LD	B,IXL
;------------------------------------------------------------------------------
emu2_code_45:	mov	reg_b,reg_ixl
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x46		LD	B,(IX+d)
;------------------------------------------------------------------------------
emu2_code_46:
.if index_mode == 1
		getpcbyte r17
		getIXbyte reg_b,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		mov	reg_b,r16
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0x4c		LD	C,IXH
;------------------------------------------------------------------------------
emu2_code_4c:	mov	reg_c,reg_ixh
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x4d		LD	C,IXL
;------------------------------------------------------------------------------
emu2_code_4d:	mov	reg_c,reg_ixl
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x4e		LD	C,(IX+d)
;------------------------------------------------------------------------------
emu2_code_4e:
.if index_mode == 1
		getpcbyte r17
		getIXbyte reg_c,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		mov	reg_c,r16
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0x54		LD	D,IXH
;------------------------------------------------------------------------------
emu2_code_54:	mov	reg_d,reg_ixh
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x55		LD	D,IXL
;------------------------------------------------------------------------------
emu2_code_55:	mov	reg_d,reg_ixl
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x56		LD	D,(IX+d)
;------------------------------------------------------------------------------
emu2_code_56:
.if index_mode == 1
		getpcbyte r17
		getIXbyte reg_d,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		mov	reg_d,r16
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0x5c		LD	E,IXH
;------------------------------------------------------------------------------
emu2_code_5c:	mov	reg_e,reg_ixh
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x5d		LD	E,IXL
;------------------------------------------------------------------------------
emu2_code_5d:	mov	reg_e,reg_ixl
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x5e		LD	E,(IX+d)
;------------------------------------------------------------------------------
emu2_code_5e:
.if index_mode == 1
		getpcbyte r17
		getIXbyte reg_e,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		mov	reg_e,r16
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0x60		LD	IXH,B
;------------------------------------------------------------------------------
emu2_code_60:	mov	reg_ixh,reg_b
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x61		LD	IXH,C
;------------------------------------------------------------------------------
emu2_code_61:	mov	reg_ixh,reg_c
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x62		LD	IXH,D
;------------------------------------------------------------------------------
emu2_code_62:	mov	reg_ixh,reg_d
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x63		LD	IXH,E
;------------------------------------------------------------------------------
emu2_code_63:	mov	reg_ixh,reg_e
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x64		LD	IXH,IXH
;------------------------------------------------------------------------------
emu2_code_64:	rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x65		LD	IXH,IXL
;------------------------------------------------------------------------------
emu2_code_65:	mov	reg_ixh,reg_ixl
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x66		LD	IXH,(IX+d)
;------------------------------------------------------------------------------
emu2_code_66:
.if index_mode == 1
		getpcbyte r17
		getixbyte reg_ixh,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		mov	reg_ixh,r16
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0x67		LD	IXH,A
;------------------------------------------------------------------------------
emu2_code_67:	mov	reg_ixh,reg_a
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x68		LD	IXL,B
;------------------------------------------------------------------------------
emu2_code_68:	mov	reg_ixl,reg_b
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x69		LD	IXL,C
;------------------------------------------------------------------------------
emu2_code_69:	mov	reg_ixl,reg_c
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x6a		LD	IXL,D
;------------------------------------------------------------------------------
emu2_code_6a:	mov	reg_ixl,reg_d
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x6b		LD	IXL,E
;------------------------------------------------------------------------------
emu2_code_6b:	mov	reg_ixl,reg_e
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0x6c		LD	IXL,IXH
;------------------------------------------------------------------------------
emu2_code_6c:	mov	reg_ixl,reg_ixh
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x6d		LD	IXL,IXL
;------------------------------------------------------------------------------
emu2_code_6d:	rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x6e		LD	IXL,(IX+d)
;------------------------------------------------------------------------------
emu2_code_6e:
.if index_mode == 1
		getpcbyte r17
		getixbyte reg_ixl,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		mov	reg_ixl,r16
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0x6f		LD	IXL,A
;------------------------------------------------------------------------------
emu2_code_6f:	mov	reg_ixl,reg_a
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x70		LD	(IX+d),B
;------------------------------------------------------------------------------
emu2_code_70:
.if index_mode == 1
		getpcbyte r17
		putIXbyte reg_b,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		mov	r16,reg_b
		rjmp	emu_wixbyte
.endif

;------------------------------------------------------------------------------
; 0x71		LD	(IX+d),C
;------------------------------------------------------------------------------
emu2_code_71:
.if index_mode == 1
		getpcbyte r17
		putIXbyte reg_c,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		mov	r16,reg_c
		rjmp	emu_wixbyte
.endif

;------------------------------------------------------------------------------
; 0x72		LD	(IX+d),D
;------------------------------------------------------------------------------
emu2_code_72:
.if index_mode == 1
		getpcbyte r17
		putIXbyte reg_d,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		mov	r16,reg_d
		rjmp	emu_wixbyte
.endif

;------------------------------------------------------------------------------
; 0x73		LD	(IX+d),E
;------------------------------------------------------------------------------
emu2_code_73:
.if index_mode == 1
		getpcbyte r17
		putIXbyte reg_e,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		mov	r16,reg_e
		rjmp	emu_wixbyte
.endif

;------------------------------------------------------------------------------
; 0x74		LD	(IX+d),H
;------------------------------------------------------------------------------
emu2_code_74:
.if index_mode == 1
		getpcbyte r17
		putIXbyte reg_h,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		mov	r16,reg_h
		rjmp	emu_wixbyte
.endif

;------------------------------------------------------------------------------
; 0x75		LD	(IX+d),L
;------------------------------------------------------------------------------
emu2_code_75:
.if index_mode == 1
		getpcbyte r17
		putIXbyte reg_l,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		mov	r16,reg_l
		rjmp	emu_wixbyte
.endif

;------------------------------------------------------------------------------
; 0x77		LD	(IX+d),A
;------------------------------------------------------------------------------
emu2_code_77:
.if index_mode == 1
		getpcbyte r17
		putIXbyte reg_a,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		mov	r16,reg_a
		rjmp	emu_wixbyte
.endif

;------------------------------------------------------------------------------
; 0x7c		LD	A,IXH
;------------------------------------------------------------------------------
emu2_code_7c:	mov	reg_a,reg_ixh
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x7d		LD	A,IXL
;------------------------------------------------------------------------------
emu2_code_7d:	mov	reg_a,reg_ixl
		rjmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0x7e		LD	A,(IX+d)
;------------------------------------------------------------------------------
emu2_code_7e:
.if index_mode == 1
		getpcbyte r17
		getixbyte reg_a,r17
		rjmp	emu2_loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		mov	reg_a,r16
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0x84		ADD	IXH
;------------------------------------------------------------------------------
emu2_code_84:	reg_add	reg_ixh
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x85		ADD	IXL
;------------------------------------------------------------------------------
emu2_code_85:	reg_add	reg_ixl
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x86		ADD	(IX+d)
;------------------------------------------------------------------------------
emu2_code_86:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		reg_add	r16
		jmp	emu_loopa
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		reg_add	r16
		jmp	emu_loopa
.endif

;------------------------------------------------------------------------------
; 0x8c		ADC	IXH
;------------------------------------------------------------------------------
emu2_code_8c:	reg_adc	reg_ixh
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8d		ADC	IXL
;------------------------------------------------------------------------------
emu2_code_8d:	reg_adc	reg_ixl
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8e		ADC	(IX+d)
;------------------------------------------------------------------------------
emu2_code_8e:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		reg_adc	r16
		jmp	emu_loopa
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		reg_adc	r16
		jmp	emu_loopa
.endif

;------------------------------------------------------------------------------
; 0x94		SUB	IXH
;------------------------------------------------------------------------------
emu2_code_94:	reg_sub	reg_ixh
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x95		SUB	IXL
;------------------------------------------------------------------------------
emu2_code_95:	reg_sub	reg_ixl
		jmp	emu_loops		;2 goto loop

;------------------------------------------------------------------------------
; 0x96		SUB	(IX+d)
;------------------------------------------------------------------------------
emu2_code_96:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		reg_sub	r16
		jmp	emu_loops		;2 goto loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		reg_sub	r16
		jmp	emu_loops
.endif

;------------------------------------------------------------------------------
; 0x9c		SBC	IXH
;------------------------------------------------------------------------------
emu2_code_9c:	reg_sbc	reg_ixh
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x9d		SBC	IXL
;------------------------------------------------------------------------------
emu2_code_9d:	reg_sbc	reg_ixl
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x9e		SBC	(IX+d)
;------------------------------------------------------------------------------
emu2_code_9e:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		reg_sbc	r16
		jmp	emu_loops		;2 goto loop
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		reg_sbc	r16
		jmp	emu_loops
.endif

;------------------------------------------------------------------------------
; 0xa4		AND	IXH
;------------------------------------------------------------------------------
emu2_code_a4:	and	reg_a,reg_ixh
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xa5		AND	IXL
;------------------------------------------------------------------------------
emu2_code_a5:	and	reg_a,reg_ixl
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xa6		AND	(IX+d)
;------------------------------------------------------------------------------
emu2_code_a6:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		and	reg_a,r16
		jmp	emu_and
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		and	reg_a,r16
		jmp	emu_and
.endif

;------------------------------------------------------------------------------
; 0xac		XOR	IXH
;------------------------------------------------------------------------------
emu2_code_ac:	eor	reg_a,reg_ixh
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xad		XOR	IXL
;------------------------------------------------------------------------------
emu2_code_ad:	eor	reg_a,reg_ixl
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xae		XOR	(IX+d)
;------------------------------------------------------------------------------
emu2_code_ae:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		eor	reg_a,r16
		jmp	emu_or
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		eor	reg_a,r16
		jmp	emu_or
.endif

;------------------------------------------------------------------------------
; 0xb4		OR	IXH
;------------------------------------------------------------------------------
emu2_code_b4:	or	reg_a,reg_ixh
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb5		OR	IXL
;------------------------------------------------------------------------------
emu2_code_b5:	or	reg_a,reg_ixl
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb6		OR	(IX+d)
;------------------------------------------------------------------------------
emu2_code_b6:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		or	reg_a,r16
		jmp	emu_or
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		or	reg_a,r16
		jmp	emu_or
.endif

;------------------------------------------------------------------------------
; 0xbc		CMP	IXH
;------------------------------------------------------------------------------
emu2_code_bc:	cp	reg_a,reg_ixh		;sub A
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xbd		CMP	IXL
;------------------------------------------------------------------------------
emu2_code_bd:	cp	reg_a,reg_ixl		;sub A
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xbe		CMP	(IX+d)
;------------------------------------------------------------------------------
emu2_code_be:
.if index_mode == 1
		getpcbyte r17
		getIXbyte r16,r17
		reg_cmp	r16
		jmp	emu_loops
.endif
.if index_mode == 2
		rcall	emu_getixbyte
		reg_cmp	r16
		jmp	emu_loops
.endif

;------------------------------------------------------------------------------
; 0xcb		IX bit commands
;------------------------------------------------------------------------------
emu2_code_cb:	jmp	emu5_sel		;goto loop

;------------------------------------------------------------------------------
; 0xdd		IX commands (todo)
;------------------------------------------------------------------------------
emu2_code_dd:	jmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0xe1		POP	IX
;------------------------------------------------------------------------------
emu2_code_e1:
.if stack_mode == 1
		z80_pop		reg_ixl,reg_ixh
		rjmp	emu2_loop
.endif
.if stack_mode == 2
		ldi	YL,12
		jmp	emu_pop
.endif
.if stack_mode == 3
		emu_pop3	reg_ixl,reg_ixh
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0xe3		EX (SP),IX
;------------------------------------------------------------------------------
emu2_code_e3:	
.if	stack_mode == 1
		movw	XL,SP_L
		movw	r0,reg_ixl
		getmemword reg_ixl,reg_ixh,XL,XH
		putmemword r0,r1,XL,XH
		rjmp	emu2_loop
.endif
.if stack_mode == 2
		ldi	YL,12
		jmp	emu_ex16
.endif
.if stack_mode == 3
		emu_exch3	reg_ixl,reg_ixh
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0xe5		PUSH IX
;------------------------------------------------------------------------------
emu2_code_e5:
.if stack_mode == 1
		z80_push	reg_ixl,reg_ixh
		rjmp	emu2_loop
.endif
.if stack_mode == 2
		ldi	YL,12
		jmp	emu_push
.endif
.if stack_mode == 3
		emu_push3	reg_ixl,reg_ixh
		rjmp	emu2_loop
.endif

;------------------------------------------------------------------------------
; 0xe9		JMP IX
;------------------------------------------------------------------------------
emu2_code_e9:	movw	PC_L,reg_ixl
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0xeb		EX 	DE,IX
;------------------------------------------------------------------------------
emu2_code_eb:	movw	r0,reg_e
		movw	reg_e,reg_ixl
		movw	reg_ixl,r0
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0xed		transport ext (todo)
;------------------------------------------------------------------------------
emu2_code_ed:	rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0xf9		LD	SP,IX
;------------------------------------------------------------------------------
emu2_code_f9:	mov	SP_L,reg_ixl
		mov	SP_H,reg_ixh
		rjmp	emu2_loop

;------------------------------------------------------------------------------
; 0xfd		IX bit commands
;------------------------------------------------------------------------------
emu2_code_fd:	jmp	emu2_loop		;goto loop


emu2_loopnc:	z80_clrnflag
emu2_loop:
		getpcbyte_m1 ZL			;12/13
		ldi	ZH,HIGH(emu_jtab)	;1
		ijmp				;2


emu2_sel:
.if align_mode == 1
		getpcbyte ZL			;12/13 cmd
		ldi	ZH,HIGH(emu2_jtab)	;1
		lsl	ZL
		brcc	emu2_sel1
		inc	ZH
emu2_sel1:	ijmp				;2
.else
		getpcbyte r16
		ldi	ZL,LOW(emu2_jtab)	;1
		ldi	ZH,HIGH(emu2_jtab)	;1
		lsl	r16
		adc	ZH,const_0
		add	ZL,r16
		adc	ZH,const_0
		ijmp
.endif


emu_getixbyte:	getpcbyte	r17
emu_rixbyte:	getixbyte	r16,r17
		ret

emu_wixbyte:	getpcbyte	r17
emu_putixbyte:	putixbyte	r16,r17
		rjmp	emu2_loop

