;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;the level 3 jump table
;-------------------------------------------------------------------------------
.if align_mode == 1
.org (pc+255) & 0xff00
.endif

emu4_jtab:	jmp	emu_loop
		jmp	emu_code_01
		jmp	emu_code_02
		jmp	emu_code_03
		jmp	emu_code_04
		jmp	emu_code_05
		jmp	emu4_code_06
		jmp	emu_code_07
		jmp	emu_code_08
		jmp	emu_code_09
		jmp	emu_code_0a
		jmp	emu_code_0b
		jmp	emu_code_0c
		jmp	emu_code_0d
		jmp	emu4_code_0e
		jmp	emu_code_0f

		jmp	emu_code_10
		jmp	emu_code_11
		jmp	emu_code_12
		jmp	emu_code_13
		jmp	emu_code_14
		jmp	emu_code_15
		jmp	emu4_code_16
		jmp	emu_code_17
		jmp	emu_code_18
		jmp	emu_code_19
		jmp	emu_code_1a
		jmp	emu_code_1b
		jmp	emu_code_1c
		jmp	emu_code_1d
		jmp	emu4_code_1e
		jmp	emu_code_1f

		jmp	emu_code_20
		jmp	emu_code_21
		jmp	emu_code_22
		jmp	emu_code_23
		jmp	emu_code_24
		jmp	emu_code_25
		jmp	emu4_code_26
		jmp	emu_code_27
		jmp	emu_code_28
		jmp	emu_code_29
		jmp	emu_code_2a
		jmp	emu_code_2b
		jmp	emu_code_2c
		jmp	emu_code_2d
		jmp	emu4_code_2e
		jmp	emu_code_2f

		jmp	emu_code_30
		jmp	emu_code_31
		jmp	emu_code_32
		jmp	emu_code_33
		jmp	emu_code_34
		jmp	emu_code_35
		jmp	emu4_code_36
		jmp	emu_code_37
		jmp	emu_code_38
		jmp	emu_code_39
		jmp	emu_code_3a
		jmp	emu_code_3b
		jmp	emu_code_3c
		jmp	emu_code_3d
		jmp	emu4_code_3e
		jmp	emu_code_3f

		jmp	emu_code_40
		jmp	emu_code_41
		jmp	emu_code_42
		jmp	emu_code_43
		jmp	emu_code_44
		jmp	emu_code_45
		jmp	emu4_code_46
		jmp	emu_code_47
		jmp	emu_code_48
		jmp	emu_code_49
		jmp	emu_code_4a
		jmp	emu_code_4b
		jmp	emu_code_4c
		jmp	emu_code_4d
		jmp	emu4_code_4e
		jmp	emu_code_4f

		jmp	emu_code_50
		jmp	emu_code_51
		jmp	emu_code_52
		jmp	emu_code_53
		jmp	emu_code_54
		jmp	emu_code_55
		jmp	emu4_code_56
		jmp	emu_code_57
		jmp	emu_code_58
		jmp	emu_code_59
		jmp	emu_code_5a
		jmp	emu_code_5b
		jmp	emu_code_5c
		jmp	emu_code_5d
		jmp	emu4_code_5e
		jmp	emu_code_5f

		jmp	emu_code_60
		jmp	emu_code_61
		jmp	emu_code_62
		jmp	emu_code_63
		jmp	emu_code_64
		jmp	emu_code_65
		jmp	emu4_code_66
		jmp	emu_code_67
		jmp	emu_code_68
		jmp	emu_code_69
		jmp	emu_code_6a
		jmp	emu_code_6b
		jmp	emu_code_6c
		jmp	emu_code_6d
		jmp	emu4_code_6e
		jmp	emu_code_6f

		jmp	emu_code_70
		jmp	emu_code_71
		jmp	emu_code_72
		jmp	emu_code_73
		jmp	emu_code_74
		jmp	emu_code_75
		jmp	emu4_code_76
		jmp	emu_code_77
		jmp	emu_code_78
		jmp	emu_code_79
		jmp	emu_code_7a
		jmp	emu_code_7b
		jmp	emu_code_7c
		jmp	emu_code_7d
		jmp	emu4_code_7e
		jmp	emu_code_7f

		jmp	emu_code_80
		jmp	emu_code_81
		jmp	emu_code_82
		jmp	emu_code_83
		jmp	emu_code_84
		jmp	emu_code_85
		jmp	emu4_code_86
		jmp	emu_code_87
		jmp	emu_code_88
		jmp	emu_code_89
		jmp	emu_code_8a
		jmp	emu_code_8b
		jmp	emu_code_8c
		jmp	emu_code_8d
		jmp	emu4_code_8e
		jmp	emu_code_8f

		jmp	emu_code_90
		jmp	emu_code_91
		jmp	emu_code_92
		jmp	emu_code_93
		jmp	emu_code_94
		jmp	emu_code_95
		jmp	emu4_code_96
		jmp	emu_code_97
		jmp	emu_code_98
		jmp	emu_code_99
		jmp	emu_code_9a
		jmp	emu_code_9b
		jmp	emu_code_9c
		jmp	emu_code_9d
		jmp	emu4_code_9e
		jmp	emu_code_9f

		jmp	emu_code_a0
		jmp	emu_code_a1
		jmp	emu_code_a2
		jmp	emu_code_a3
		jmp	emu_code_a4
		jmp	emu_code_a5
		jmp	emu4_code_a6
		jmp	emu_code_a7
		jmp	emu_code_a8
		jmp	emu_code_a9
		jmp	emu_code_aa
		jmp	emu_code_ab
		jmp	emu_code_ac
		jmp	emu_code_ad
		jmp	emu4_code_ae
		jmp	emu_code_af

		jmp	emu_code_b0
		jmp	emu_code_b1
		jmp	emu_code_b2
		jmp	emu_code_b3
		jmp	emu_code_b4
		jmp	emu_code_b5
		jmp	emu4_code_b6
		jmp	emu_code_b7
		jmp	emu_code_b8
		jmp	emu_code_b9
		jmp	emu_code_ba
		jmp	emu_code_bb
		jmp	emu_code_bc
		jmp	emu_code_bd
		jmp	emu4_code_be
		jmp	emu_code_bf

		jmp	emu_code_c0
		jmp	emu_code_c1
		jmp	emu_code_c2
		jmp	emu_code_c3
		jmp	emu_code_c4
		jmp	emu_code_c5
		jmp	emu4_code_c6
		jmp	emu_code_c7
		jmp	emu_code_c8
		jmp	emu_code_c9
		jmp	emu_code_ca
		jmp	emu_code_cb
		jmp	emu_code_cc
		jmp	emu_code_cd
		jmp	emu4_code_ce
		jmp	emu_code_cf

		jmp	emu_code_d0
		jmp	emu_code_d1
		jmp	emu_code_d2
		jmp	emu_code_d3
		jmp	emu_code_d4
		jmp	emu_code_d5
		jmp	emu4_code_d6
		jmp	emu_code_d7
		jmp	emu_code_d8
		jmp	emu_code_d9
		jmp	emu_code_da
		jmp	emu_code_db
		jmp	emu_code_dc
		jmp	emu_code_dd
		jmp	emu4_code_de
		jmp	emu_code_df

		jmp	emu_code_e0
		jmp	emu_code_e1
		jmp	emu_code_e2
		jmp	emu_code_e3
		jmp	emu_code_e4
		jmp	emu_code_e5
		jmp	emu4_code_e6
		jmp	emu_code_e7
		jmp	emu_code_e8
		jmp	emu_code_e9
		jmp	emu_code_ea
		jmp	emu_code_eb
		jmp	emu_code_ec
		jmp	emu_code_ed
		jmp	emu4_code_ee
		jmp	emu_code_ef

		jmp	emu_code_f0
		jmp	emu_code_f1
		jmp	emu_code_f2
		jmp	emu_code_f3
		jmp	emu_code_f4
		jmp	emu_code_f5
		jmp	emu4_code_f6
		jmp	emu_code_f7
		jmp	emu_code_f8
		jmp	emu_code_f9
		jmp	emu_code_fa
		jmp	emu_code_fb
		jmp	emu_code_fc
		jmp	emu_code_fd
		jmp	emu4_code_fe
		jmp	emu_code_ff

;------------------------------------------------------------------------------
; 0xcb 0x06		RLC IX+d
;------------------------------------------------------------------------------
emu4_code_06:
.if index_mode == 1
		getixbyte r16,r17
		z80_rlc r16
		putixbyte r16,r17
		rjmp	emu4_rflags		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_rlc r16
		rjmp	emu4_rflags
.endif
;------------------------------------------------------------------------------
; 0xcb 0x0e		rrc IX+d
;------------------------------------------------------------------------------
emu4_code_0e:
.if index_mode == 1
		getixbyte r16,r17
		z80_rrc r16
		putixbyte r16,r17
		rjmp	emu4_rflags		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_rrc r16
		rjmp	emu4_rflags
.endif

;------------------------------------------------------------------------------
; 0xcb 0x16		rl IX+d
;------------------------------------------------------------------------------
emu4_code_16:
.if index_mode == 1
		getixbyte r16,r17
		z80_rl r16
		putixbyte r16,r17
		rjmp	emu4_rflags		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_rl r16
		rjmp	emu4_rflags
.endif

;------------------------------------------------------------------------------
; 0xcb 0x1e		rr IX+d
;------------------------------------------------------------------------------
emu4_code_1e:
.if index_mode == 1
		getixbyte r16,r17
		z80_rr r16
		putixbyte r16,r17
		rjmp	emu4_rflags		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_rr r16
		rjmp	emu4_rflags
.endif

;------------------------------------------------------------------------------
; 0xcb 0x26		sla IX+d
;------------------------------------------------------------------------------
emu4_code_26:
.if index_mode == 1
		getixbyte r16,r17
		z80_sla r16
		putixbyte r16,r17
		rjmp	emu4_rflags		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_sla r16
		rjmp	emu4_rflags
.endif

;------------------------------------------------------------------------------
; 0xcb 0x2e		sra IX+d
;------------------------------------------------------------------------------
emu4_code_2e:
.if index_mode == 1
		getixbyte r16,r17
		z80_sra r16
		putixbyte r16,r17
		rjmp	emu4_rflags		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_sra r16
		rjmp	emu4_rflags
.endif

;------------------------------------------------------------------------------
; 0xcb 0x36		sls IX+d
;------------------------------------------------------------------------------
emu4_code_36:
.if index_mode == 1
		getixbyte r16,r17
		z80_sls r16
		putixbyte r16,r17
		rjmp	emu4_rflags		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_sls r16
		rjmp	emu4_rflags
.endif

;------------------------------------------------------------------------------
; 0xcb 0x3e		srl IX+d
;------------------------------------------------------------------------------
emu4_code_3e:
.if index_mode == 1
		getixbyte r16,r17
		z80_srl r16
		putixbyte r16,r17
		rjmp	emu4_rflags		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_srl r16
		rjmp	emu4_rflags
.endif

;------------------------------------------------------------------------------
; 0xcb 0x46		bit 0, IX+d
;------------------------------------------------------------------------------
emu4_code_46:
.if index_mode == 1
		getixbyte r16,r17
		z80_bit r16,0
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_bit r16,0
		rjmp	emu4_loop		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x4e		bit 1, IX+d
;------------------------------------------------------------------------------
emu4_code_4e:
.if index_mode == 1
		getixbyte r16,r17
		z80_bit r16,1
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_bit r16,1
		rjmp	emu4_loop		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x56		bit 2, IX+d
;------------------------------------------------------------------------------
emu4_code_56:
.if index_mode == 1
		getixbyte r16,r17
		z80_bit r16,2
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_bit r16,2
		rjmp	emu4_loop		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x5e		bit 3, IX+d
;------------------------------------------------------------------------------
emu4_code_5e:
.if index_mode == 1
		getixbyte r16,r17
		z80_bit r16,3
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_bit r16,3
		rjmp	emu4_loop		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x66		bit 4, IX+d
;------------------------------------------------------------------------------
emu4_code_66:
.if index_mode == 1
		getixbyte r16,r17
		z80_bit r16,4
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_bit r16,4
		rjmp	emu4_loop		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x6e		bit 5, IX+d
;------------------------------------------------------------------------------
emu4_code_6e:
.if index_mode == 1
		getixbyte r16,r17
		z80_bit r16,5
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_bit r16,5
		rjmp	emu4_loop		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x76		bit 6, IX+d
;------------------------------------------------------------------------------
emu4_code_76:
.if index_mode == 1
		getixbyte r16,r17
		z80_bit r16,6
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_bit r16,6
		rjmp	emu4_loop		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x7e		bit 7, IX+d
;------------------------------------------------------------------------------
emu4_code_7e:
.if index_mode == 1
		getixbyte r16,r17
		z80_bit r16,7
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_bit r16,7
		rjmp	emu4_loop		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x86		res 0, IX+d
;------------------------------------------------------------------------------
emu4_code_86:
.if index_mode == 1
		getixbyte r16,r17
		z80_res r16,0
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_res r16,0
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0x8e		res 1, IX+d
;------------------------------------------------------------------------------
emu4_code_8e:
.if index_mode == 1
		getixbyte r16,r17
		z80_res r16,1
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_res r16,1
		rjmp	emu_putixbyte		;2
.endif


;------------------------------------------------------------------------------
; 0xcb 0x96		res 2, IX+d
;------------------------------------------------------------------------------
emu4_code_96:
.if index_mode == 1
		getixbyte r16,r17
		z80_res r16,2
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_res r16,2
		rjmp	emu_putixbyte		;2
.endif


;------------------------------------------------------------------------------
; 0xcb 0x9e		res 3, IX+d
;------------------------------------------------------------------------------
emu4_code_9e:
.if index_mode == 1
		getixbyte r16,r17
		z80_res r16,3
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_res r16,3
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xa6		res 4, IX+d
;------------------------------------------------------------------------------
emu4_code_a6:
.if index_mode == 1
		getixbyte r16,r17
		z80_res r16,4
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_res r16,4
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xae		res 5, IX+d
;------------------------------------------------------------------------------
emu4_code_ae:
.if index_mode == 1
		getixbyte r16,r17
		z80_res r16,5
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_res r16,5
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xb6		res 6, IX+d
;------------------------------------------------------------------------------
emu4_code_b6:
.if index_mode == 1
		getixbyte r16,r17
		z80_res r16,6
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_res r16,6
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xbe		res 7, IX+d
;------------------------------------------------------------------------------
emu4_code_be:
.if index_mode == 1
		getixbyte r16,r17
		z80_res r16,7
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_res r16,7
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xc6		set 0, IX+d
;------------------------------------------------------------------------------
emu4_code_c6:
.if index_mode == 1
		getixbyte r16,r17
		z80_set r16,0
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_set r16,0
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xce		set 1, IX+d
;------------------------------------------------------------------------------
emu4_code_ce:
.if index_mode == 1
		getixbyte r16,r17
		z80_set r16,1
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_set r16,1
		rjmp	emu_putixbyte		;2
.endif


;------------------------------------------------------------------------------
; 0xcb 0xd6		set 2, IX+d
;------------------------------------------------------------------------------
emu4_code_d6:
.if index_mode == 1
		getixbyte r16,r17
		z80_set r16,2
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_set r16,2
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xde		set 3, IX+d
;------------------------------------------------------------------------------
emu4_code_de:
.if index_mode == 1
		getixbyte r16,r17
		z80_set r16,3
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_set r16,3
		rjmp	emu_putixbyte		;2
.endif


;------------------------------------------------------------------------------
; 0xcb 0xe6		set 4, IX+d
;------------------------------------------------------------------------------
emu4_code_e6:
.if index_mode == 1
		getixbyte r16,r17
		z80_set r16,4
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_set r16,4
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xee		set 5, IX+d
;------------------------------------------------------------------------------
emu4_code_ee:
.if index_mode == 1
		getixbyte r16,r17
		z80_set r16,5
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_set r16,5
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xf6		set 6, IX+d
;------------------------------------------------------------------------------
emu4_code_f6:
.if index_mode == 1
		getixbyte r16,r17
		z80_set r16,6
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_set r16,6
		rjmp	emu_putixbyte		;2
.endif

;------------------------------------------------------------------------------
; 0xcb 0xfe		set 7, IX+d
;------------------------------------------------------------------------------
emu4_code_fe:
.if index_mode == 1
		getixbyte r16,r17
		z80_set r16,7
		putixbyte r16,r17
		rjmp	emu4_loop		;2
.endif
.if index_mode == 2
		rcall	emu_rixbyte
		z80_set r16,7
		rjmp	emu_putixbyte		;2
.endif




emu4_rflags:
		ldi	ZH,HIGH(emu_flags_rot*2);1
		lpm	reg_f,Z			;3
		z80_clrnflag			;1 clear N flag
		bld	reg_f,0			;carry flag
emu4_loop:
.if index_mode == 2
		putixbyte r16,r17
.endif

		getpcbyte_m1 ZL			;12/13
		ldi	ZH,HIGH(emu_jtab)	;1
		ijmp				;2

emu4_sel:
.if align_mode == 1
		getpcbyte r17			;offset
		getpcbyte ZL			;FCT
		ldi	ZH,HIGH(emu4_jtab)	;1
		lsl	ZL
		brcc	emu4_sel1
		inc	ZH
emu4_sel1:	ijmp				;2
.else
		getpcword r17,r16		;offset,FCT
		ldi	ZH,HIGH(emu4_jtab)	;1
		ldi	ZL,LOW(emu4_jtab)	;1
		lsl	r16
		adc	ZH,const_0
		add	ZL,r16
		adc	ZH,const_0
		ijmp
.endif