;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

; the level2 jump table
;------------------------------------------------------------------------------
.if align_mode == 1
.org (pc+255) & 0xff00
.endif

emu3_jtab:	jmp	emu_loop		;2	0x00	NOP
		jmp	emu_code_01
		jmp	emu_code_02
		jmp	emu_code_03
		jmp	emu_code_04
		jmp	emu_code_05
		jmp	emu_code_06
		jmp	emu_code_07
		jmp	emu_code_08
		jmp	emu3_code_09
		jmp	emu_code_0a
		jmp	emu_code_0b
		jmp	emu_code_0c
		jmp	emu_code_0d
		jmp	emu_code_0e
		jmp	emu_code_0f

		jmp	emu_code_10
		jmp	emu_code_11
		jmp	emu_code_12
		jmp	emu_code_13
		jmp	emu_code_14
		jmp	emu_code_15
		jmp	emu_code_16
		jmp	emu_code_17
		jmp	emu_code_18
		jmp	emu3_code_19
		jmp	emu_code_1a
		jmp	emu_code_1b
		jmp	emu_code_1c
		jmp	emu_code_1d
		jmp	emu_code_1e
		jmp	emu_code_1f

		jmp	emu_code_20
		jmp	emu3_code_21
		jmp	emu3_code_22
		jmp	emu3_code_23
		jmp	emu3_code_24
		jmp	emu3_code_25
		jmp	emu3_code_26
		jmp	emu_code_27
		jmp	emu_code_28
		jmp	emu3_code_29
		jmp	emu3_code_2a
		jmp	emu3_code_2b
		jmp	emu3_code_2c
		jmp	emu3_code_2d
		jmp	emu3_code_2e
		jmp	emu_code_2f

		jmp	emu_code_30
		jmp	emu_code_31
		jmp	emu_code_32
		jmp	emu_code_33
		jmp	emu3_code_34
		jmp	emu3_code_35
		jmp	emu3_code_36
		jmp	emu_code_37
		jmp	emu_code_38
		jmp	emu3_code_39
		jmp	emu_code_3a
		jmp	emu_code_3b
		jmp	emu_code_3c
		jmp	emu_code_3d
		jmp	emu_code_3e
		jmp	emu_code_3f

		jmp	emu_code_40
		jmp	emu_code_41
		jmp	emu_code_42
		jmp	emu_code_43
		jmp	emu3_code_44
		jmp	emu3_code_45
		jmp	emu3_code_46
		jmp	emu_code_47
		jmp	emu_code_48
		jmp	emu_code_49
		jmp	emu_code_4a
		jmp	emu_code_4b
		jmp	emu3_code_4c
		jmp	emu3_code_4d
		jmp	emu3_code_4e
		jmp	emu_code_4f

		jmp	emu_code_50
		jmp	emu_code_51
		jmp	emu_code_52
		jmp	emu_code_53
		jmp	emu3_code_54
		jmp	emu3_code_55
		jmp	emu3_code_56
		jmp	emu_code_57
		jmp	emu_code_58
		jmp	emu_code_59
		jmp	emu_code_5a
		jmp	emu_code_5b
		jmp	emu3_code_5c
		jmp	emu3_code_5d
		jmp	emu3_code_5e
		jmp	emu_code_5f

		jmp	emu3_code_60
		jmp	emu3_code_61
		jmp	emu3_code_62
		jmp	emu3_code_63
		jmp	emu3_code_64
		jmp	emu3_code_65
		jmp	emu3_code_66
		jmp	emu3_code_67
		jmp	emu3_code_68
		jmp	emu3_code_69
		jmp	emu3_code_6a
		jmp	emu3_code_6b
		jmp	emu3_code_6c
		jmp	emu3_code_6d
		jmp	emu3_code_6e
		jmp	emu3_code_6f

		jmp	emu3_code_70
		jmp	emu3_code_71
		jmp	emu3_code_72
		jmp	emu3_code_73
		jmp	emu3_code_74
		jmp	emu3_code_75
		jmp	emu_code_76
		jmp	emu3_code_77
		jmp	emu_code_78
		jmp	emu_code_79
		jmp	emu_code_7a
		jmp	emu_code_7b
		jmp	emu3_code_7c
		jmp	emu3_code_7d
		jmp	emu3_code_7e
		jmp	emu_code_7f

		jmp	emu_code_80
		jmp	emu_code_81
		jmp	emu_code_82
		jmp	emu_code_83
		jmp	emu3_code_84
		jmp	emu3_code_85
		jmp	emu3_code_86
		jmp	emu_code_87
		jmp	emu_code_88
		jmp	emu_code_89
		jmp	emu_code_8a
		jmp	emu_code_8b
		jmp	emu3_code_8c
		jmp	emu3_code_8d
		jmp	emu3_code_8e
		jmp	emu_code_8f

		jmp	emu_code_90
		jmp	emu_code_91
		jmp	emu_code_92
		jmp	emu_code_93
		jmp	emu3_code_94
		jmp	emu3_code_95
		jmp	emu3_code_96
		jmp	emu_code_97
		jmp	emu_code_98
		jmp	emu_code_99
		jmp	emu_code_9a
		jmp	emu_code_9b
		jmp	emu3_code_9c
		jmp	emu3_code_9d
		jmp	emu3_code_9e
		jmp	emu_code_9f

		jmp	emu_code_a0
		jmp	emu_code_a1
		jmp	emu_code_a2
		jmp	emu_code_a3
		jmp	emu3_code_a4
		jmp	emu3_code_a5
		jmp	emu3_code_a6
		jmp	emu_code_a7
		jmp	emu_code_a8
		jmp	emu_code_a9
		jmp	emu_code_aa
		jmp	emu_code_ab
		jmp	emu3_code_ac
		jmp	emu3_code_ad
		jmp	emu3_code_ae
		jmp	emu_code_af

		jmp	emu_code_b0
		jmp	emu_code_b1
		jmp	emu_code_b2
		jmp	emu_code_b3
		jmp	emu3_code_b4
		jmp	emu3_code_b5
		jmp	emu3_code_b6
		jmp	emu_code_b7
		jmp	emu_code_b8
		jmp	emu_code_b9
		jmp	emu_code_ba
		jmp	emu_code_bb
		jmp	emu3_code_bc
		jmp	emu3_code_bd
		jmp	emu3_code_be
		jmp	emu_code_bf

		jmp	emu_code_c0
		jmp	emu_code_c1
		jmp	emu_code_c2
		jmp	emu_code_c3
		jmp	emu_code_c4
		jmp	emu_code_c5
		jmp	emu_code_c6
		jmp	emu_code_c7
		jmp	emu_code_c8
		jmp	emu_code_c9
		jmp	emu_code_ca
		jmp	emu3_code_cb
		jmp	emu_code_cc
		jmp	emu_code_cd
		jmp	emu_code_ce
		jmp	emu_code_cf

		jmp	emu_code_d0
		jmp	emu_code_d1
		jmp	emu_code_d2
		jmp	emu_code_d3
		jmp	emu_code_d4
		jmp	emu_code_d5
		jmp	emu_code_d6
		jmp	emu_code_d7
		jmp	emu_code_d8
		jmp	emu_code_d9
		jmp	emu_code_da
		jmp	emu_code_db
		jmp	emu_code_dc
		jmp	emu3_code_dd
		jmp	emu_code_de
		jmp	emu_code_df

		jmp	emu_code_e0
		jmp	emu3_code_e1
		jmp	emu_code_e2
		jmp	emu3_code_e3
		jmp	emu_code_e4
		jmp	emu3_code_e5
		jmp	emu_code_e6
		jmp	emu_code_e7
		jmp	emu_code_e8
		jmp	emu3_code_e9
		jmp	emu_code_ea
		jmp	emu3_code_eb
		jmp	emu_code_ec
		jmp	emu3_code_ed
		jmp	emu_code_ee
		jmp	emu_code_ef

		jmp	emu_code_f0
		jmp	emu_code_f1
		jmp	emu_code_f2
		jmp	emu_code_f3
		jmp	emu_code_f4
		jmp	emu_code_f5
		jmp	emu_code_f6
		jmp	emu_code_f7
		jmp	emu_code_f8
		jmp	emu3_code_f9
		jmp	emu_code_fa
		jmp	emu_code_fb
		jmp	emu_code_fc
		jmp	emu3_code_fd
		jmp	emu_code_fe
		jmp	emu_code_ff

;------------------------------------------------------------------------------
; 0x09		ADD	IY,BC
;------------------------------------------------------------------------------
emu3_code_09:	lsr	reg_f			;shift out C flag
		add	reg_iyl,reg_c
		adc	reg_iyh,reg_b
		rol	reg_f			;shift in C flag
		rjmp	emu3_loopnc

;------------------------------------------------------------------------------
; 0x19		ADD	IY,DE
;------------------------------------------------------------------------------
emu3_code_19:	lsr	reg_f			;shift out C flag
		add	reg_iyl,reg_e
		adc	reg_iyh,reg_d
		rol	reg_f			;shift in C flag
		rjmp	emu3_loopnc

;------------------------------------------------------------------------------
; 0x21		LD 	IY,nnnn
;------------------------------------------------------------------------------
emu3_code_21:	getpcword reg_iyl,reg_iyh
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x22		LD 	(nnnn),IY
;------------------------------------------------------------------------------
emu3_code_22:	getpcword XL,XH
		putmemword reg_iyl,reg_iyh,XL,XH
		rjmp	emu3_loop		;2 end of command

;------------------------------------------------------------------------------
; 0x23		INC	IY
;------------------------------------------------------------------------------
emu3_code_23:	z80_inc16	reg_iyl,reg_iyh
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x24		INC	IYH
;------------------------------------------------------------------------------
emu3_code_24:	z80_increg reg_iyh
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x25		DEC	IYH
;------------------------------------------------------------------------------
emu3_code_25:	z80_decreg reg_iyh
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x26		LD	IYH,nn
;------------------------------------------------------------------------------
emu3_code_26:	getpcbyte reg_iyh
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x29		ADD	IY,IY
;------------------------------------------------------------------------------
emu3_code_29:	lsr	reg_f			;shift out C flag
		add	reg_iyl,reg_iyl
		adc	reg_iyh,reg_iyh
		rol	reg_f			;shift in C flag
		rjmp	emu3_loopnc

;------------------------------------------------------------------------------
; 0x2a		LD 	IY,(nnnn)
;------------------------------------------------------------------------------
emu3_code_2a:	getpcword XL,XH
		getmemword reg_iyl,reg_iyh,XL,XH
		rjmp	emu3_loop		;2 end of command

;------------------------------------------------------------------------------
; 0x2b		DEC	IY
;------------------------------------------------------------------------------
emu3_code_2b:	z80_dec16	reg_iyl,reg_iyh
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x2c		INC	IYL
;------------------------------------------------------------------------------
emu3_code_2c:	z80_increg reg_iyl
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x2d		DEC	IYL
;------------------------------------------------------------------------------
emu3_code_2d:	z80_decreg reg_iyl
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x2e		LD	IYL,nn
;------------------------------------------------------------------------------
emu3_code_2e:	getpcbyte reg_iyl
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x34		INC	(IY+d)
;------------------------------------------------------------------------------
emu3_code_34:
.if index_mode == 1
		getpcbyte r17
		getiybyte r16,r17
		z80_increg r16
		putiybyte r16,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		z80_increg r16
		rjmp	emu_putiybyte
.endif

;------------------------------------------------------------------------------
; 0x35		DEC	(IY+d)
;------------------------------------------------------------------------------
emu3_code_35:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		z80_decreg r16
		putIYbyte r16,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		z80_decreg r16
		rjmp	emu_putiybyte
.endif

;------------------------------------------------------------------------------
; 0x36		LD 	(IY+d),nn
;------------------------------------------------------------------------------
emu3_code_36:
.if index_mode == 1
		getpcword r17,r16
		putIYbyte r16,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		getpcword r17,r16
		rjmp	emu_putiybyte
.endif

;------------------------------------------------------------------------------
; 0x39		ADD	IY,SP
;------------------------------------------------------------------------------
emu3_code_39:	lsr	reg_f			;shift out C flag
		add	reg_iyl,SP_L
		adc	reg_iyh,SP_H
		rol	reg_f			;shift in C flag
		rjmp	emu3_loopnc

;------------------------------------------------------------------------------
; 0x44		LD	B,IYH
;------------------------------------------------------------------------------
emu3_code_44:	mov	reg_b,reg_iyh
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x45		LD	B,IYL
;------------------------------------------------------------------------------
emu3_code_45:	mov	reg_b,reg_iyl
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x46		LD	B,(IY+d)
;------------------------------------------------------------------------------
emu3_code_46:
.if index_mode == 1
		getpcbyte r17
		getIYbyte reg_b,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		mov	reg_b,r16
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0x4c		LD	C,IYH
;------------------------------------------------------------------------------
emu3_code_4c:	mov	reg_c,reg_iyh
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x4d		LD	C,IYL
;------------------------------------------------------------------------------
emu3_code_4d:	mov	reg_c,reg_iyl
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x4e		LD	C,(IY+d)
;------------------------------------------------------------------------------
emu3_code_4e:
.if index_mode == 1
		getpcbyte r17
		getIYbyte reg_c,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		mov	reg_c,r16
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0x54		LD	D,IYH
;------------------------------------------------------------------------------
emu3_code_54:	mov	reg_d,reg_iyh
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x55		LD	D,IYL
;------------------------------------------------------------------------------
emu3_code_55:	mov	reg_d,reg_iyl
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x56		LD	D,(IY+d)
;------------------------------------------------------------------------------
emu3_code_56:
.if index_mode == 1
		getpcbyte r17
		getIYbyte reg_d,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		mov	reg_d,r16
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0x5c		LD	E,IYH
;------------------------------------------------------------------------------
emu3_code_5c:	mov	reg_e,reg_iyh
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x5d		LD	E,IYL
;------------------------------------------------------------------------------
emu3_code_5d:	mov	reg_e,reg_iyl
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x5e		LD	E,(IY+d)
;------------------------------------------------------------------------------
emu3_code_5e:
.if index_mode == 1
		getpcbyte r17
		getIYbyte reg_e,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		mov	reg_e,r16
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0x60		LD	IYH,B
;------------------------------------------------------------------------------
emu3_code_60:	mov	reg_iyh,reg_b
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x61		LD	IYH,C
;------------------------------------------------------------------------------
emu3_code_61:	mov	reg_iyh,reg_c
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x62		LD	IYH,D
;------------------------------------------------------------------------------
emu3_code_62:	mov	reg_iyh,reg_d
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x63		LD	IYH,E
;------------------------------------------------------------------------------
emu3_code_63:	mov	reg_iyh,reg_e
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x64		LD	IYH,IYH
;------------------------------------------------------------------------------
emu3_code_64:	rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x65		LD	IYH,IYL
;------------------------------------------------------------------------------
emu3_code_65:	mov	reg_iyh,reg_iyl
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x66		LD	IYH,(IY+d)
;------------------------------------------------------------------------------
emu3_code_66:
.if index_mode == 1
		getpcbyte r17
		getiybyte reg_iyh,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		mov	reg_iyh,r16
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0x67		LD	IYH,A
;------------------------------------------------------------------------------
emu3_code_67:	mov	reg_iyh,reg_a
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x68		LD	IYL,B
;------------------------------------------------------------------------------
emu3_code_68:	mov	reg_iyl,reg_b
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x69		LD	IYL,C
;------------------------------------------------------------------------------
emu3_code_69:	mov	reg_iyl,reg_c
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x6a		LD	IYL,D
;------------------------------------------------------------------------------
emu3_code_6a:	mov	reg_iyl,reg_d
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x6b		LD	IYL,E
;------------------------------------------------------------------------------
emu3_code_6b:	mov	reg_iyl,reg_e
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0x6c		LD	IYL,IYH
;------------------------------------------------------------------------------
emu3_code_6c:	mov	reg_iyl,reg_iyh
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x6d		LD	IYL,IYL
;------------------------------------------------------------------------------
emu3_code_6d:	rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x6e		LD	IYL,(IY+d)
;------------------------------------------------------------------------------
emu3_code_6e:
.if index_mode == 1
		getpcbyte r17
		getiybyte reg_iyl,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		mov	reg_iyl,r16
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0x6f		LD	IYL,A
;------------------------------------------------------------------------------
emu3_code_6f:	mov	reg_iyl,reg_a
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x70		LD	(IY+d),B
;------------------------------------------------------------------------------
emu3_code_70:
.if index_mode == 1
		getpcbyte r17
		putIYbyte reg_b,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		mov	r16,reg_b
		rjmp	emu_wiybyte
.endif

;------------------------------------------------------------------------------
; 0x71		LD	(IY+d),C
;------------------------------------------------------------------------------
emu3_code_71:
.if index_mode == 1
		getpcbyte r17
		putIYbyte reg_c,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		mov	r16,reg_c
		rjmp	emu_wiybyte
.endif

;------------------------------------------------------------------------------
; 0x72		LD	(IY+d),D
;------------------------------------------------------------------------------
emu3_code_72:
.if index_mode == 1
		getpcbyte r17
		putIYbyte reg_d,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		mov	r16,reg_d
		rjmp	emu_wiybyte
.endif

;------------------------------------------------------------------------------
; 0x73		LD	(IY+d),E
;------------------------------------------------------------------------------
emu3_code_73:
.if index_mode == 1
		getpcbyte r17
		putIYbyte reg_e,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		mov	r16,reg_e
		rjmp	emu_wiybyte
.endif

;------------------------------------------------------------------------------
; 0x74		LD	(IY+d),H
;------------------------------------------------------------------------------
emu3_code_74:
.if index_mode == 1
		getpcbyte r17
		putIYbyte reg_h,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		mov	r16,reg_h
		rjmp	emu_wiybyte
.endif

;------------------------------------------------------------------------------
; 0x75		LD	(IY+d),L
;------------------------------------------------------------------------------
emu3_code_75:
.if index_mode == 1
		getpcbyte r17
		putIYbyte reg_l,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		mov	r16,reg_l
		rjmp	emu_wiybyte
.endif

;------------------------------------------------------------------------------
; 0x77		LD	(IY+d),A
;------------------------------------------------------------------------------
emu3_code_77:
.if index_mode == 1
		getpcbyte r17
		putIYbyte reg_a,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		mov	r16,reg_a
		rjmp	emu_wiybyte
.endif

;------------------------------------------------------------------------------
; 0x7c		LD	A,IYH
;------------------------------------------------------------------------------
emu3_code_7c:	mov	reg_a,reg_iyh
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x7d		LD	A,IYL
;------------------------------------------------------------------------------
emu3_code_7d:	mov	reg_a,reg_iyl
		rjmp	emu3_loop		;goto loop

;------------------------------------------------------------------------------
; 0x7e		LD	A,(IY+d)
;------------------------------------------------------------------------------
emu3_code_7e:
.if index_mode == 1
		getpcbyte r17
		getiybyte reg_a,r17
		rjmp	emu3_loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		mov	reg_a,r16
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0x84		ADD	IYH
;------------------------------------------------------------------------------
emu3_code_84:	reg_add	reg_iyh
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x85		ADD	IYL
;------------------------------------------------------------------------------
emu3_code_85:	reg_add	reg_iyl
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x86		ADD	(IY+d)
;------------------------------------------------------------------------------
emu3_code_86:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		reg_add	r16
		jmp	emu_loopa
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		reg_add	r16
		jmp	emu_loopa
.endif

;------------------------------------------------------------------------------
; 0x8c		ADC	IYH
;------------------------------------------------------------------------------
emu3_code_8c:	reg_adc	reg_iyh
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8d		ADC	IYL
;------------------------------------------------------------------------------
emu3_code_8d:	reg_adc	reg_iyl
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8e		ADC	(IY+d)
;------------------------------------------------------------------------------
emu3_code_8e:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		reg_adc	r16
		jmp	emu_loopa
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		reg_adc	r16
		jmp	emu_loopa
.endif

;------------------------------------------------------------------------------
; 0x94		SUB	IYH
;------------------------------------------------------------------------------
emu3_code_94:	reg_sub	reg_iyh
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x95		SUB	IYL
;------------------------------------------------------------------------------
emu3_code_95:	reg_sub	reg_iyl
		jmp	emu_loops		;2 goto loop

;------------------------------------------------------------------------------
; 0x96		SUB	(IY+d)
;------------------------------------------------------------------------------
emu3_code_96:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		reg_sub	r16
		jmp	emu_loops		;2 goto loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		reg_sub	r16
		jmp	emu_loops
.endif

;------------------------------------------------------------------------------
; 0x9c		SBC	IYH
;------------------------------------------------------------------------------
emu3_code_9c:	reg_sbc	reg_iyh
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x9d		SBC	IYL
;------------------------------------------------------------------------------
emu3_code_9d:	reg_sbc	reg_iyl
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x9e		SBC	(IY+d)
;------------------------------------------------------------------------------
emu3_code_9e:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		reg_sbc	r16
		jmp	emu_loops		;2 goto loop
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		reg_sbc	r16
		jmp	emu_loops
.endif

;------------------------------------------------------------------------------
; 0xa4		AND	IYH
;------------------------------------------------------------------------------
emu3_code_a4:	and	reg_a,reg_iyh
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xa5		AND	IYL
;------------------------------------------------------------------------------
emu3_code_a5:	and	reg_a,reg_iyl
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xa6		AND	(IY+d)
;------------------------------------------------------------------------------
emu3_code_a6:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		and	reg_a,r16
		jmp	emu_and
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		and	reg_a,r16
		jmp	emu_and
.endif

;------------------------------------------------------------------------------
; 0xac		XOR	IYH
;------------------------------------------------------------------------------
emu3_code_ac:	eor	reg_a,reg_iyh
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xad		XOR	IYL
;------------------------------------------------------------------------------
emu3_code_ad:	eor	reg_a,reg_iyl
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xae		XOR	(IY+d)
;------------------------------------------------------------------------------
emu3_code_ae:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		eor	reg_a,r16
		jmp	emu_or
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		eor	reg_a,r16
		jmp	emu_or
.endif

;------------------------------------------------------------------------------
; 0xb4		OR	IYH
;------------------------------------------------------------------------------
emu3_code_b4:	or	reg_a,reg_iyh
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb5		OR	IYL
;------------------------------------------------------------------------------
emu3_code_b5:	or	reg_a,reg_iyl
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb6		OR	(IY+d)
;------------------------------------------------------------------------------
emu3_code_b6:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		or	reg_a,r16
		jmp	emu_or
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		or	reg_a,r16
		jmp	emu_or
.endif

;------------------------------------------------------------------------------
; 0xbc		CMP	IYH
;------------------------------------------------------------------------------
emu3_code_bc:	cp	reg_a,reg_iyh		;sub A
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xbd		CMP	IYL
;------------------------------------------------------------------------------
emu3_code_bd:	cp	reg_a,reg_iyl		;sub A
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xbe		CMP	(IY+d)
;------------------------------------------------------------------------------
emu3_code_be:
.if index_mode == 1
		getpcbyte r17
		getIYbyte r16,r17
		reg_cmp	r16
		jmp	emu_loops
.endif
.if index_mode == 2
		rcall	emu_getiybyte
		reg_cmp	r16
		jmp	emu_loops
.endif

;------------------------------------------------------------------------------
; 0xcb		IY bit commands
;------------------------------------------------------------------------------
emu3_code_cb:	jmp	emu5_sel		;goto loop

;------------------------------------------------------------------------------
; 0xdd		IX commands (todo)
;------------------------------------------------------------------------------
emu3_code_dd:	jmp	emu2_loop		;goto loop

;------------------------------------------------------------------------------
; 0xe1		POP	IY
;------------------------------------------------------------------------------
emu3_code_e1:
.if stack_mode == 1
		z80_pop		reg_iyl,reg_iyh
		rjmp	emu3_loop
.endif
.if stack_mode == 2
		ldi	YL,14
		jmp	emu_pop
.endif
.if stack_mode == 3
		emu_pop3	reg_iyl,reg_iyh
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0xe3		EX (SP),IY
;------------------------------------------------------------------------------
emu3_code_e3:	
.if	stack_mode == 1
		movw	XL,SP_L
		movw	r0,reg_iyl
		getmemword reg_iyl,reg_iyh,XL,XH
		putmemword r0,r1,XL,XH
		rjmp	emu3_loop
.endif
.if stack_mode == 2
		ldi	YL,14
		jmp	emu_ex16
.endif
.if stack_mode == 3
		emu_exch3	reg_iyl,reg_iyh
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0xe5		PUSH IY
;------------------------------------------------------------------------------
emu3_code_e5:
.if stack_mode == 1
		z80_push	reg_iyl,reg_iyh
		rjmp	emu3_loop
.endif
.if stack_mode == 2
		ldi	YL,14
		jmp	emu_push
.endif
.if stack_mode == 3
		emu_push3	reg_iyl,reg_iyh
		rjmp	emu3_loop
.endif

;------------------------------------------------------------------------------
; 0xe9		JMP IY
;------------------------------------------------------------------------------
emu3_code_e9:	movw	PC_L,reg_iyl
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0xeb		EX 	DE,IY
;------------------------------------------------------------------------------
emu3_code_eb:	movw	r0,reg_e
		movw	reg_e,reg_iyl
		movw	reg_iyl,r0
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0xed		transport ext (todo)
;------------------------------------------------------------------------------
emu3_code_ed:	rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0xf9		LD	SP,IY
;------------------------------------------------------------------------------
emu3_code_f9:	mov	SP_L,reg_iyl
		mov	SP_H,reg_iyh
		rjmp	emu3_loop

;------------------------------------------------------------------------------
; 0xfd		IY bit commands
;------------------------------------------------------------------------------
emu3_code_fd:	jmp	emu3_loop		;goto loop

emu3_loopnc:	z80_clrnflag
emu3_loop:
		getpcbyte_m1 ZL			;12/13
		ldi	ZH,HIGH(emu_jtab)	;1
		ijmp				;2


emu3_sel:
.if align_mode == 1
		getpcbyte ZL			;12/13 cmd
		ldi	ZH,HIGH(emu3_jtab)	;1
		lsl	ZL
		brcc	emu3_sel1
		inc	ZH
emu3_sel1:	ijmp				;2
.else
		getpcbyte r16			;12/13 cmd
		ldi	ZH,HIGH(emu3_jtab)	;1
		ldi	ZL,LOW(emu3_jtab)	;1
		lsl	r16
		adc	ZH,const_0
		add	ZL,r16
		adc	ZH,const_0
		ijmp
.endif

emu_getiybyte:	getpcbyte	r17
emu_riybyte:	getiybyte	r16,r17
		ret

emu_wiybyte:	getpcbyte	r17
emu_putiybyte:	putiybyte	r16,r17
		rjmp	emu3_loop
