;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


;r18/r19=addr, r16=data
emu_in:		cpi	r18,0xfe		;KBD
		brne	emu_in_2
		ldi	r16,0xff
		cpi	r19,0x7f
		brne	emu_in_1
		lds	r19,libmio_keycode
		cpi	r19,0xa0		;shift+space
		brne	emu_in_0
		ldi	r16,0xfe
		ret

emu_in_0:	cpi	r19,0xed		;ESC
		brne	emu_in_1
		ldi	r16,0xfe
		ret

emu_in_1:	lds	r0,zx_ram+0x25
		cp	r18,r0
		brne	emu_in_x
		lds	r16,zx_ram+0x26

emu_in_2:	cpi	r18,0xef
		brne	emu_in_x
		rcall	gen_tnum
		cpi	r19,0x03
		breq	emu_in_2x
		mov	r16,XH
		cpi	r19,0x01
		breq	emu_in_2x
		mov	r16,XL
emu_in_2x:	ret

emu_in_x:	ldi	r16,0xff		;empty port
		ret

;convert
gen_tnum:	lds	r16,fileio_ram+32
		ldi	XL,0x9c
		ldi	XH,0x9c
gen_tnum_1:	subi	r16,100
		brcs	gen_tnum_2
		inc	XH
		rjmp	gen_tnum_1
gen_tnum_2:	subi	r16,156
gen_tnum_3:	subi	r16,10
		brcs	gen_tnum_4
		inc	XL
		rjmp	gen_tnum_3
gen_tnum_4:	subi	r16,0x5a
		ret


;r18/r19=addr, r16=data
emu_out:	cpi	r18,0xfe		;NMI on
		brne	emu_out_fd
		sts	libmio_nmi,const_1
		ret

emu_out_fd:	cpi	r18,0xfd		;NMI off
		brne	emu_out_1
;		sts	libmio_nmi,const_0
		ret


emu_out_1:	cpi	r18,0x00		;wait for key
		brne	emu_out_2
		sts	libmio_keycode,const_0
		sts	libmio_kwait,const_1
		lds	r19,zx_ram+0x3b
		ori	r19,0x80
		sts	zx_ram+0x3b,r19
		ret

emu_out_2:	cpi	r18,0x00		;no wait for key
		brne	emu_out_x
		sts	libmio_keycode,const_0
		sts	libmio_kwait,const_0
		lds	r16,zx_ram+0x3b
		andi	r16,0xfe
		sts	zx_ram+0x3b,r16
		ret

emu_out_x:	ret

;Z=addr (flash), GPIOR1=data
emu_poke:	cpi	ZH,0xc0
		brne	emu_poke_e
;		cpi	ZL,222
;		brne	emu_poke_1
;		call	csub_e

emu_poke_1:	cpi	ZL,99
		brne	emu_poke_e
		in	r16,GPIOR1
		lds	ZL,fileio_ram+36
		sbrc	ZL,3
		andi	r16,0x01
		sts	fileio_ram+32,r16
emu_poke_e:	ret


