;################################################################################
;#										#
;# mode 7 engine 40x24 text							#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

libmio_fill:
		ldi	ZH,0x0a
		sbrc	vline_l,0
		ldi	ZH,0x05
		rjmp	libmio_bla_0

libmio_blank:
		clr	ZH
		sbrc	r19,2
		ldi	ZH,0x0f

libmio_bla_0:	ldi	YL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,79
libmio_bla_1:	out	DPIN,YL			;CP
		dec	XL
		out	DPIN,YL			;/CP
		brne	libmio_bla_1
		sts	libmio_lastnib,ZH
		rjmp	libmio_li_15


libmio_fblank:
		clr	ZH
		sbrc	r19,2
		ldi	ZH,0x0f

		ldi	ZL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,79
libmio_fbla_1:	out	DPIN,ZL			;CP
		dec	XL
		out	DPIN,ZL			;/CP
		brne	libmio_fbla_1
		ldi	ZH,0x20
		sbrc	r19,2
		ldi	ZH,0x2f
		sts	libmio_lastnib,ZH
		rjmp	libmio_li_15

;-------------------------------------------------------------------------------
; video output
;-------------------------------------------------------------------------------
libmio_oisr:	push	ZH
		push	ZL
		push	YL
		push	XH
		push	XL
		in	ZH,SREG
		push	ZH
		cbi	DPORT,4			;enable display
		push	r19
		lds	r19,libmio_sysconf

;count up line counter
		ldi	YL,0x80
		lds	ZH,libmio_lastnib
		out	DPORT,ZH
		add	vline_l,const_1
		sbi	DPORT,6			;set LD
		nop
		out	DPIN,YL			;CP
		nop
		out	DPIN,YL			;/CP
		nop
		cbi	DPORT,6			;clear LD

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
libmio_tism0:	mov	ZH,vline_l
		cpi	ZH,0
		breq	libmio_fblank		;first blank line
		cpi	ZH,24
		brcs	libmio_blank		;upper blank view
		cpi	ZH,216
		brcs	libmio_scrnx
		cpi	ZH,241
		brcs	libmio_blank
		rjmp	libmio_li_02

libmio_scrnx:	sbi	VSPORT,VSPIN		;dummy VSYNC inactive
		rjmp	libmio_scrn

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
libmio_li_02:	clr	vline_l
		dec	vline_l
		inc	vline_h
		cbi	VSPORT,VSPIN		;dummy VSYNC active

libmio_lif1:	lds	XL,zx_ram+0x0c		;DFILE addr
		lds	XH,zx_ram+0x0d

		andi	XH,0x3f			;max 16K
		subi	XH,0xfe			;start at 0x0200

libmio_lif2:	adiw	XL,1			;skip first HALT
		sts	libmio_rampos_l,XL
		sts	libmio_rampos_h,XH

;decrement frame counter
		ldi	ZL,0x19			;set margin
		sts	zx_ram+0x28,ZL
		lds	ZL,zx_ram+0x34
		lds	ZH,zx_ram+0x35
		mov	XH,ZH
		lds	YL,libmio_nmi
		sbrc	YL,0
		sbiw	ZL,1
		andi	XH,0x80
		or	ZH,XH
		sts	zx_ram+0x34,ZL
		sts	zx_ram+0x35,ZH

		lds	ZL,libmio_keycode
		ldi	ZH,HIGH(libmio_zktable)
		lsl	ZL
		rol	ZH
		lpm	XL,Z+
		lpm	XH,Z+
		lds	ZL,libmio_kbdstate
		sbrc	ZL,2
		ori	XH,0x01
		sts	zx_ram+0x25,XL
		sts	zx_ram+0x26,XH
		cpi	XL,0xff
		breq	libmio_leset

		lds	ZL,zx_ram+0x3b
		ori	ZL,0x80			;set slow
		sts	zx_ram+0x3b,ZL

		lds	ZL,libmio_kwait
		sbrs	ZL,0
		rjmp	libmio_leset

		lds	XL,zx_ram+0x3b
		ori	XL,0x01
		sts	zx_ram+0x3b,XL
		sts	libmio_kwait,const_0

libmio_leset:	lds	ZL,libmio_keycode
		cpi	ZL,0xe9
		brne	libmio_lesetn
		lds	ZL,libmio_kbdstate
		sbrs	ZL,2
		rjmp	libmio_lesetn
		sbrs	ZL,4
		rjmp	libmio_lesetn
		out	DDDR,const_0
		jmp	0

libmio_lesetn:	rjmp	libmio_li_15

;-------------------------------------------------------------------------------
; LCD output
;-------------------------------------------------------------------------------
libmio_scrn:	lds	XL,zx_ram+0x3b
		sbrs	XL,7
		rjmp	libmio_fill

		clr	ZH
		sbrc	r19,2
		ldi	ZH,0x0f

		ldi	YL,0x80
		out	DPORT,ZH		;set to white
		ldi	XL,8
libmio_scrn_a:	out	DPIN,YL			;CP
		nop
		out	DPIN,YL			;/CP
		dec	XL
		brne	libmio_scrn_a

		lds	XL,libmio_rampos_l	;RAM pointer
		lds	XH,libmio_rampos_h
		mov	ZL,vline_l		;
		subi	ZL,24
		andi	ZL,0x07
		cpi	ZL,0x07
		in	YL,SREG
		bst	YL,1			;save flag

		ldi	ZH,HIGH(libmio_ctable*2)
		add	ZH,ZL

		ldi	YL,0x80			;CP pin
		push	r20			;save additional registers
		push	r21
		push	YH

		ldi	r21,66			;chars to do * 2

libmio_scrn_1:	ld	ZL,X+			;2 get char
		sbrc	ZL,6			;1
		rjmp	libmio_scrn_2		;1 bit 6 is set
		lpm	r20,Z			;3 get pixline

		sbrs	r19,2
		com	r20

		mov	YH,r20			;1 copy pixline for second nibble
		swap	YH
		andi	YH,0x0f			;1 mask unused bits
		out	DPORT,YH		;1 out 4 bits
		out	DPIN,YL			;CP
		andi	r20,0x0f		;1 mask
		out	DPIN,YL			;/CP
		out	DPORT,r20
		out	DPIN,YL			;CP
		subi	r21,2
		out	DPIN,YL			;/CP
		brne	libmio_scrn_1

libmio_scrn_2:	subi	r21,0xfb		;+5
		clr	ZH
		sbrc	r19,2
		ldi	ZH,0x0f

		out	DPORT,ZH

libmio_scrn_b:	out	DPIN,YL			;CP
		nop
		out	DPIN,YL			;/CP
		dec	r21
		brne	libmio_scrn_b
		sts	libmio_lastnib,ZH

		pop	YH			;2 restore Y-register
		pop	r21
		pop	r20

		brtc	libmio_li_15

		sts	libmio_rampos_l,XL
		sts	libmio_rampos_h,XH
;------------------------------------------------------------------------------
;the keyboard routine
;09 no char from keyboard
;26 key, but released
;43 key, state 1
;------------------------------------------------------------------------------
libmio_li_15:	pop	r19
		rjmp	libmio_keyb
