;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
libmio_vis_02:
		cpi	XL,231
		brne	libmio_vis_09		;no vsync start
		cbi	VSPORT,VSPIN
libmio_vis_05:	rjmp	libmio_vis_15

libmio_vis_09:	cpi	XL,233
		brne	libmio_vis_13		;no vsync stop
		sbi	VSPORT,VSPIN
		rjmp	libmio_vis_15

libmio_vis_13:	cpi	XL,7
		breq	libmio_vis_14		;2 end of frame
		rjmp	libmio_vis_15

libmio_vis_14:	clr	vline_l			;line_l=0
		clr	vline_h			;line_h=0
;decrement frame counter
		ldi	ZL,0x19			;set margin
		sts	zx_ram+0x28,ZL
		lds	ZL,zx_ram+0x34		;frame
		lds	ZH,zx_ram+0x35
		mov	XH,ZH
		lds	YL,libmio_nmi
		sbrc	YL,0
		sbiw	ZL,1
		andi	XH,0x80
		or	ZH,XH
		sts	zx_ram+0x34,ZL
		sts	zx_ram+0x35,ZH
libmio_isf1:	lds	XL,zx_ram+0x0c		;DFILE addr
		lds	XH,zx_ram+0x0d

		andi	XH,0x3f			;max 16K
		subi	XH,0xfe			;start at 0x0200

libmio_isf2:	adiw	XL,1			;skip first HALT
		sts	libmio_rampos_l,XL
		sts	libmio_rampos_h,XH

		lds	ZL,libmio_keycode
		ldi	ZH,HIGH(libmio_zktable)
		lsl	ZL
		rol	ZH
		lpm	XL,Z+
		lpm	XH,Z+
		lds	ZL,libmio_kbdstate
		sbrc	ZL,2
		ori	XH,0x01
		sts	zx_ram+0x25,XL
		sts	zx_ram+0x26,XH
		cpi	XL,0xff
		breq	libmio_veset

		lds	ZL,zx_ram+0x3b
		ori	ZL,0x80			;set slow
		sts	zx_ram+0x3b,ZL

		lds	ZL,libmio_kwait
		sbrs	ZL,0
		rjmp	libmio_veset

		lds	XL,zx_ram+0x3b
		ori	XL,0x01
		sts	zx_ram+0x3b,XL
		sts	libmio_kwait,const_0
libmio_veset:	lds	ZL,libmio_keycode
		cpi	ZL,0xe9
		brne	libmio_vesetn
		lds	ZL,libmio_kbdstate
		sbrs	ZL,2
		rjmp	libmio_vesetn
		sbrs	ZL,4
		rjmp	libmio_vesetn
		jmp	0
libmio_vesetn:
		rjmp	libmio_vis_15


libmio_bla:
libmio_bla_00:	lds	ZL,TCNT1L		;1 get timer
		cpi	ZL,libmio_vgastart+10	;1
		brcs	libmio_bla_00		;1 loop
libmio_bla_01:	cpi	ZL,libmio_vgastart+11
		brcs	libmio_bla_02
libmio_bla_02:	cpi	ZL,libmio_vgastart+12
		brcs	libmio_bla_03
libmio_bla_03:	cpi	ZL,libmio_vgastart+13
		brcs	libmio_bla_04
libmio_bla_04:	cpi	ZL,libmio_vgastart+14
		brcs	libmio_bla_05

libmio_bla_05:	ldi	ZL,0xff			;1 full
		ldi	YL,0x18
		sts	UCSR1B,YL
		ldi	YL,32			;1 chars to do

libmio_bla_06:	sts	UDR1,ZL			;2
		ldi	ZH,3			;1
libmio_bla_07:	dec	ZH			;1 (3)
		brne	libmio_bla_07		;2 (5)
		dec	YL			;1
		nop
		ldi	ZH,0x3f
		brne	libmio_bla_06		;2
;		sts	UDR1,ZH
		sts	UCSR1B,const_0		;disable
		rjmp	libmio_vg4

;-------------------------------------------------------------------------------
;video-interrupt (no registers destroyed, stack=13)
;save registers (25c)
;-------------------------------------------------------------------------------
libmio_bisr:	cbi	VPORT,7
		sbic	MODEPORT,MODEPIN
		reti
		push	ZH			;2 save Z-register
		push	ZL			;2 save Z-register
		push	YL			;2 save Y-register
		push	XH			;2 save X-register
		push	XL			;2 save X-register
		in	ZH,SREG			;1 save status
		push	ZH			;2

;-------------------------------------------------------------------------------
;count line up and set border (9c)
;-------------------------------------------------------------------------------
		add	vline_l,const_1		;1
		adc	vline_h,const_0		;1

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
libmio_ismode0:	movw	XL,vline_l
		lsr	XH
		ror	XL
		sbrc	XH,0			;1 skip if less than 256
		rjmp	libmio_ismode2		;2 no visible line
libmio_ismode1:	subi	XL,0x02
		brcs	libmio_bla
		cpi	XL,192			;1 max lines
		brcs	libmio_iss
		cpi	XL,194
		brcs	libmio_bla		;2 goto no image-line
libmio_ismode2:	rjmp	libmio_vis_02		;2 goto image line

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
libmio_iss:	lds	XL,zx_ram+0x3b
		sbrs	XL,7
		rjmp	libmio_vis_15

libmio_nmode:	lds	XL,libmio_rampos_l	;get RAM position
		lds	XH,libmio_rampos_h
		mov	ZL,vline_l		;
		subi	ZL,0x04
		andi	ZL,0x0f
		cpi	ZL,0x0f
		in	YL,SREG
		bst	YL,1

libmio_iss0:	lds	YL,TCNT1L		;1 get timer
		cpi	YL,libmio_vgastart-2	;1
		brcs	libmio_iss0		;1 loop
libmio_iss_01:	cpi	YL,libmio_vgastart-1
		brcs	libmio_iss_02
libmio_iss_02:	cpi	YL,libmio_vgastart
		brcs	libmio_iss_03
libmio_iss_03:	cpi	YL,libmio_vgastart+1
		brcs	libmio_iss_04
libmio_iss_04:	cpi	YL,libmio_vgastart+2
		brcs	libmio_iss_05

libmio_iss_05:	lsr	ZL
		ldi	ZH,HIGH(libmio_ctable*2)
		add	ZH,ZL
		ldi	YL,32			;chars to do
		ld	ZL,X+			;2
		nop
		nop
		sbrc	ZL,6			;1
		rjmp	libmio_vg3x		;1 vg2
		lpm	ZL,Z			;3
		ldi	YL,0x18
		sts	UCSR1B,YL
		sts	UDR1,ZL			;2
		ldi	YL,31

libmio_vg1:	ld	ZL,X+			;2
		sbrc	ZL,6			;1
		rjmp	libmio_vg3		;1 vg3
		nop				;1
		nop				;1
		lpm	ZL,Z			;3
		nop				;1
		sts	UDR1,ZL			;2
		nop				;1
		dec	YL			;1
		brne	libmio_vg1		;2
		adiw	XL,1

libmio_vg3:	cpi	YL,0			;1
		breq	libmio_vg3a		;1/2
libmio_vg3x:	ldi	ZH,0x18
		sts	UCSR1B,ZH
		ldi	ZL,0xff			;1
		sts	UDR1,ZL			;2
		nop
		nop
		nop
		nop
		nop
		dec	YL
		rjmp	libmio_vg3

libmio_vg3a:	ldi	YL,0x80
		sts	UDR1,YL			;2
		nop				;1
		sts	UCSR1B,const_0		;disable
		brts	libmio_vg5
libmio_vg4:	pop	ZH			;2 restore sreg
		out	SREG,ZH			;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

libmio_vg5:	sts	libmio_rampos_l,XL
		sts	libmio_rampos_h,XH

libmio_vis_15:
