;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

emu6_loopan:	z80_setnflag			;set N

emu6_loopaa:	andi	reg_f,flags_clrz	;clear Z
		mov	r16,reg_l
		or	r16,reg_h
		brne	emu6_loopaa1
		ori	reg_f,flags_setz	;set Z
		getpcbyte_m1 ZL			;12/13
		in	ZH,EEARL		;1
		ijmp				;2


emu6_loopaa1:	andi	reg_f,flags_clrz	;clear Z
		getpcbyte_m1 ZL			;12/13
		in	ZH,EEARL		;1
		ijmp				;2


emu6_loopns:	z80_setnflag			;set N

emu6_loop:	getpcbyte_m1 ZL			;12/13
		in	ZH,EEARL		;1
		ijmp				;2

emu6_sel:	getpcbyte ZL			;12/13
		ldi	ZH,HIGH(emu6_jtab)	;1
		ijmp				;2

; the level2 jump table
;------------------------------------------------------------------------------
.org (pc+255) & 0xff00

emu6_jtab:	rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop


		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_code_40
		rjmp	emu6_code_41
		rjmp	emu6_code_42
		rjmp	emu6_code_43
		rjmp	emu6_code_44
		rjmp	emu6_code_45
		rjmp	emu6_code_46
		rjmp	emu6_code_47
		rjmp	emu6_code_48
		rjmp	emu6_code_49
		rjmp	emu6_code_4a
		rjmp	emu6_code_4b
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_4d
		rjmp	emu6_code_46		;mirror of IM0
		rjmp	emu6_code_4f

		rjmp	emu6_code_50
		rjmp	emu6_code_51
		rjmp	emu6_code_52
		rjmp	emu6_code_53
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_45		;mirror of RETN
		rjmp	emu6_code_56
		rjmp	emu6_code_57
		rjmp	emu6_code_58
		rjmp	emu6_code_59
		rjmp	emu6_code_5a
		rjmp	emu6_code_5b
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_4d		;mirror of RETI
		rjmp	emu6_code_5e
		rjmp	emu6_code_5f

		rjmp	emu6_code_60
		rjmp	emu6_code_61
		rjmp	emu6_code_62
		rjmp	emu6_code_63
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_45		;mirror of RETN
		rjmp	emu6_code_46		;mirror of IM0
		rjmp	emu6_code_67
		rjmp	emu6_code_68
		rjmp	emu6_code_69
		rjmp	emu6_code_6a
		rjmp	emu6_code_6b
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_4d		;mirror of RETI
		rjmp	emu6_code_46		;mirror of IM0
		rjmp	emu6_code_6f

		rjmp	emu6_code_70
		rjmp	emu6_code_71
		rjmp	emu6_code_72
		rjmp	emu6_code_73
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_45		;mirror of RETN
		rjmp	emu6_code_56		;mirror of IM1
		rjmp	emu6_loop
		rjmp	emu6_code_78
		rjmp	emu6_code_79
		rjmp	emu6_code_7a
		rjmp	emu6_code_7b
		rjmp	emu6_code_44		;mirror of NEG
		rjmp	emu6_code_4d		;mirror of RETI
		rjmp	emu6_code_5e		;mirror of IM2
		rjmp	emu6_loop

		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_code_a0
		rjmp	emu6_code_a1
		rjmp	emu6_code_a2
		rjmp	emu6_code_a3
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_code_a8
		rjmp	emu6_code_a9
		rjmp	emu6_code_aa
		rjmp	emu6_code_ab
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_code_b0
		rjmp	emu6_code_b1
		rjmp	emu6_code_b2
		rjmp	emu6_code_b3
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_code_b8
		rjmp	emu6_code_b9
		rjmp	emu6_code_ba
		rjmp	emu6_code_bb
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop
		rjmp	emu6_loop

;------------------------------------------------------------------------------
; 0xed 0x40		IN B
;------------------------------------------------------------------------------
emu6_code_40:	movw	YL,reg_c
		call	emu_inbc
		mov	reg_b,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x41		OUT B
;------------------------------------------------------------------------------
emu6_code_41:	movw	YL,reg_c
		mov	r16,reg_b
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x42		SBC HL,BC
;------------------------------------------------------------------------------
emu6_code_42:	lsr	reg_f			;shift out carry
		sez
		sbc	reg_l,reg_c
		sbc	reg_h,reg_b
		in	reg_f,SREG
		rjmp	emu6_loopan		;2

;------------------------------------------------------------------------------
; 0xed 0x43		ld (nnnn),BC
;------------------------------------------------------------------------------
emu6_code_43:	getpcword XL,XH
		putmemword reg_c,reg_b,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x44		NEG
;------------------------------------------------------------------------------
emu6_code_44:	neg	reg_a
		in	reg_f,SREG
		z80_setnflag
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x45		RETN
;------------------------------------------------------------------------------
emu6_code_45:	set
		jmp	emu_rets		;2

;------------------------------------------------------------------------------
; 0xed 0x46		IM 0
;------------------------------------------------------------------------------
emu6_code_46:	sts	z80_imode,const_0
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x47		LD I,A
;------------------------------------------------------------------------------
emu6_code_47:	sts	zreg_i,reg_a
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x48		IN C
;------------------------------------------------------------------------------
emu6_code_48:	movw	YL,reg_c
		call	emu_inbc
		mov	reg_c,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x49		OUT C
;------------------------------------------------------------------------------
emu6_code_49:	movw	YL,reg_c
		mov	r16,reg_c
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x4a		ADC HL,BC
;------------------------------------------------------------------------------
emu6_code_4a:	lsr	reg_f			;shift carry
		adc	reg_l,reg_c
		adc	reg_h,reg_b
		in	reg_f,SREG
		z80_clrnflag
		rjmp	emu6_loopaa		;2

;------------------------------------------------------------------------------
; 0xed 0x4b		LD BC,(nnnn)
;------------------------------------------------------------------------------
emu6_code_4b:	getpcword XL,XH
		getmemword reg_c,reg_b,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x4d		RETI
;------------------------------------------------------------------------------
emu6_code_4d:	set
		jmp	emu_rets		;2

;------------------------------------------------------------------------------
; 0xed 0x4f		ld R,A
;------------------------------------------------------------------------------
emu6_code_4f:	sts	zreg_r,reg_a
		set_refresh
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x50		IN D
;------------------------------------------------------------------------------
emu6_code_50:	movw	YL,reg_c
		call	emu_inbc
		mov	reg_d,r16
		rjmp	emu6_loop		;2


;------------------------------------------------------------------------------
; 0xed 0x51		OUT D
;------------------------------------------------------------------------------
emu6_code_51:	movw	YL,reg_c
		mov	r16,reg_d
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x52		SBC HL,DE
;------------------------------------------------------------------------------
emu6_code_52:	lsr	reg_f
		sez
		sbc	reg_l,reg_e
		sbc	reg_h,reg_d
		in	reg_f,SREG
		rjmp	emu6_loopan		;2

;------------------------------------------------------------------------------
; 0xed 0x53		LD (nnnn),DE
;------------------------------------------------------------------------------
emu6_code_53:	getpcword XL,XH
		putmemword reg_e,reg_d,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x56		IM 1
;------------------------------------------------------------------------------
emu6_code_56:	sts	z80_imode,const_1
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x57		ld A,I
;------------------------------------------------------------------------------
emu6_code_57:	lds reg_a,zreg_i
		add	reg_a,const_0		;dummy operation to set flags
		in	r16,SREG
		andi	r16,0x06
		andi	reg_f,0x01
		or	reg_f,r16		;set S and Z
		z80_clrnflag
		lds	r16,z80_iflag
		sbrc	r16,0
		ori	reg_f,flags_setp	;set PV if int flag = 1
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x58		IN E
;------------------------------------------------------------------------------
emu6_code_58:	movw	YL,reg_c
		call	emu_inbc
		mov	reg_e,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x59		OUT E
;------------------------------------------------------------------------------
emu6_code_59:	movw	YL,reg_c
		mov	r16,reg_e
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x5a		ADC HL,DE
;------------------------------------------------------------------------------
emu6_code_5a:	lsr	reg_f
		adc	reg_l,reg_e
		adc	reg_h,reg_d
		in	reg_f,SREG
		z80_clrnflag
		rjmp	emu6_loopaa		;2

;------------------------------------------------------------------------------
; 0xed 0x5b		LD DE,(nnnn)
;------------------------------------------------------------------------------
emu6_code_5b:	getpcword XL,XH
		getmemword reg_e,reg_d,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x5e		IM 2
;------------------------------------------------------------------------------
emu6_code_5e:	ldi	r16,2
		sts	z80_imode,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x5f		LD A,R
;------------------------------------------------------------------------------
emu6_code_5f:	lds	r16,zreg_r
		andi	r16,0x80
		lds	reg_a,vsys_kwait
		eor	reg_a,vline_l
		andi	reg_a,0x7f
		or	reg_a,r16
;		add_refresh
		add	reg_a,const_0		;dummy operation to set flags
		in	r16,SREG
		andi	r16,0x06
		andi	reg_f,0x01
		or	reg_f,r16		;set S and Z
		z80_clrnflag
		lds	r16,z80_iflag
		sbrc	r16,0
		ori	reg_f,flags_setp	;set PV if int flag = 1
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x60		IN H
;------------------------------------------------------------------------------
emu6_code_60:	movw	YL,reg_c
		call	emu_inbc
		mov	reg_h,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x61		OUT H
;------------------------------------------------------------------------------
emu6_code_61:	movw	YL,reg_c
		mov	r16,reg_h
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x62		SBC HL,HL
;------------------------------------------------------------------------------
emu6_code_62:	lsr	reg_f
		sez
		sbc	reg_l,reg_l
		sbc	reg_h,reg_h
		in	reg_f,SREG
		rjmp	emu6_loopan		;2

;------------------------------------------------------------------------------
; 0xed 0x63		LD (nnnn),HL
;------------------------------------------------------------------------------
emu6_code_63:	jmp	emu_code_22

;------------------------------------------------------------------------------
; 0xed 0x67		RRD
;------------------------------------------------------------------------------
emu6_code_67:	getmembyte r16,reg_l,reg_h
		mov	r17,reg_a
		andi	reg_a,0xf0
		mov	r18,r16
		andi	r18,0x0f
		or	reg_a,r18
		swap	r16
		andi	r16,0x0f
		andi	r17,0x0f
		swap	r17
		or	r16,r17
		putmembyte r16,reg_l,reg_h
		mov	ZL,reg_a
		bst	reg_f,aflag_c		;store old carry
.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	reg_f,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	reg_f,Z
.endif
		bld	reg_f,aflag_c		;restore carry
		z80_clrnflag
		andi	reg_f,flags_clrh
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x68		IN L
;------------------------------------------------------------------------------
emu6_code_68:	movw	YL,reg_c
		call	emu_inbc
		mov	reg_l,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x69		OUT L
;------------------------------------------------------------------------------
emu6_code_69:	movw	YL,reg_c
		mov	r16,reg_l
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x6a		ADC HL,HL
;------------------------------------------------------------------------------
emu6_code_6a:	lsr	reg_f
		adc	reg_l,reg_l
		adc	reg_h,reg_h
		in	reg_f,SREG
		z80_clrnflag
		rjmp	emu6_loopaa		;2

;------------------------------------------------------------------------------
; 0xed 0x6b		LD HL,(nnnn)
;------------------------------------------------------------------------------
emu6_code_6b:	jmp	emu_code_2a

;------------------------------------------------------------------------------
; 0xed 0x6f		RLD
;------------------------------------------------------------------------------
emu6_code_6f:	getmembyte r16,reg_l,reg_h	;get M
		mov	r17,reg_a		;copy A
		andi	reg_a,0xf0		;preserve high nibble
		mov	r18,r16
		swap	r18
		andi	r18,0x0f
		or	reg_a,r18
		swap	r16
		andi	r16,0xf0
		andi	r17,0x0f
		or	r16,r17
		putmembyte r16,reg_l,reg_h
		mov	ZL,reg_a
		bst	reg_f,aflag_c		;store old carry
.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	reg_f,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	reg_f,Z
.endif
		bld	reg_f,aflag_c		;restore carry
		z80_clrnflag
		andi	reg_f,flags_clrh
		rjmp	emu6_loop		;2


;------------------------------------------------------------------------------
; 0xed 0x70		IN F
;------------------------------------------------------------------------------
emu6_code_70:	movw	YL,reg_c
		call	emu_inbc
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x71		OUT 0
;------------------------------------------------------------------------------
emu6_code_71:	movw	YL,reg_c
		mov	r16,const_0
		call	emu_out
		rjmp	emu6_loop		;2


;------------------------------------------------------------------------------
; 0xed 0x72		SBC HL,SP
;------------------------------------------------------------------------------
emu6_code_72:	lsr	reg_f
		sez
		sbc	reg_l,SP_L
		sbc	reg_h,SP_H
		in	reg_f,SREG
		rjmp	emu6_loopan		;2

;------------------------------------------------------------------------------
; 0xed 0x73		LD (nnnn),SP
;------------------------------------------------------------------------------
emu6_code_73:	getpcword XL,XH
		putmemword SP_L,SP_H,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x78		IN A
;------------------------------------------------------------------------------
emu6_code_78:	sbrc	reg_c,0
		rjmp	emu6_code_781

		ldi	ZH,HIGH(io_fe*2)
		mov	ZL,reg_b
		lpm	ZL,Z
		ldi	ZH,HIGH(vsys_kbuf)
		ld	ZL,Z
;		ldi	ZL,0xff
		mov	reg_a,ZL
		bst	reg_f,aflag_c

.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	reg_f,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	reg_f,Z
.endif

		bld	reg_f,aflag_c
		z80_clrnflag
		getpcbyte_m1 ZL			;12/13
		in	ZH,EEARL		;1
		ijmp				;2

emu6_code_781:	movw	YL,reg_c
		call	emu_inbc
		mov	reg_a,r16
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x79		OUT A
;------------------------------------------------------------------------------
emu6_code_79:	sbrc	reg_c,0
		rjmp	emu6_code_791

		sts	vsys_border,reg_a
		rjmp	emu6_loop

emu6_code_791:	movw	YL,reg_c
		mov	r16,reg_a
		call	emu_out
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0x7a		ADC HL,SP
;------------------------------------------------------------------------------
emu6_code_7a:	lsr	reg_f			;shift out carry
		adc	reg_l,SP_L
		adc	reg_h,SP_H
		in	reg_f,SREG
		z80_clrnflag
		rjmp	emu6_loopaa		;2

;------------------------------------------------------------------------------
; 0xed 0x7b		LD SP,(nnnn)
;------------------------------------------------------------------------------
emu6_code_7b:	getpcword XL,XH
		getmemword SP_L,SP_H,XL,XH
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa0		LDI
;------------------------------------------------------------------------------
emu6_code_a0:	getmembyte r16,reg_l,reg_h	;get (HL)
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		andi	reg_f,(flags_clrp & flags_clrh)		;clear PV and H
		z80_clrnflag			;clear N
		putmembyte r16,reg_e,reg_d	;put (DE)
		add	reg_e,const_1		;DE++
		adc	reg_d,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		breq	emu6_code_a01
		ori	reg_f,flags_setp	;set PV
emu6_code_a01:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa1		CPI
;------------------------------------------------------------------------------
emu6_code_a1:	andi	reg_f,flags_clrp	;clear PV
		getmembyte r16,reg_l,reg_h	;get M
		mov	r18,reg_a
		sub	r18,r16			;compare
		bst	reg_f,aflag_c		;store old carry
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore carry
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		breq	emu6_code_a11
		ori	reg_f,flags_setp	;set PV
emu6_code_a11:	rjmp	emu6_loopns		;goto loop

;------------------------------------------------------------------------------
; 0xed 0xa2		INI
;------------------------------------------------------------------------------
emu6_code_a2:	mov	r18,reg_f		;save old flag status
		movw	YL,reg_c		;LOW address
		call	emu_in
		putmembyte r16,reg_l,reg_h
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		sub	reg_b,const_1		;B--
		in	reg_f,SREG
		andi	reg_f,(flags_clrc & flags_clrh & flags_clrp)
emu6_code_a21:	sbrs	r16,7
		z80_clrnflag
		sbrc	r16,7
		z80_setnflag
		add	r16,const_1
		sbrc	r18,aflag_c
		add	r16,const_1
		brcc	emu6_code_a22
		ori	reg_f,(flags_setc | flags_seth)
emu6_code_a22:	andi	r16,0x07
		eor	r16,reg_b
		mov	ZL,r16
.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	ZL,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	ZL,Z
.endif
		bst	ZL,aflag_p
		bld	reg_f,aflag_p
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa3		OUTI
;------------------------------------------------------------------------------
emu6_code_a3:	getmembyte r16,reg_l,reg_h
		sub	reg_b,const_1		;B--
		in	reg_f,SREG
		movw	YL,reg_c		;LOW address
		call	emu_out
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		andi	reg_f,(flags_clrc & flags_clrh & flags_clrp)
emu6_code_a31:	sbrs	r16,7
		z80_clrnflag
		sbrc	r16,7
		z80_setnflag
		add	r16,reg_l
		brcc	emu6_code_a32
		ori	reg_f,(flags_setc | flags_seth)
emu6_code_a32:	andi	r16,0x07
		eor	r16,reg_b
		mov	ZL,r16

.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	ZL,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	ZL,Z
.endif

		bst	ZL,aflag_p
		bld	reg_f,aflag_p
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa8		LDD
;------------------------------------------------------------------------------
emu6_code_a8:	getmembyte r16,reg_l,reg_h	;get (HL)
		z80_clrnflag			;clear N
		andi	reg_f,(flags_clrp & flags_clrh)		;clear PV and H
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		putmembyte r16,reg_e,reg_d	;put (DE)
		sub	reg_e,const_1		;DE--
		sbc	reg_d,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		breq	emu6_code_a81
		ori	reg_f,flags_setp	;set PV
emu6_code_a81:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xa9		CPD
;------------------------------------------------------------------------------
emu6_code_a9:	getmembyte r16,reg_l,reg_h	;get M
		andi	reg_f,flags_clrp	;clear PV
		mov	r18,reg_a
		sub	r18,r16			;compare
		bst	reg_f,aflag_c		;store old carry
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore carry
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		breq	emu6_code_a91
		ori	reg_f,flags_setp	;set PV
emu6_code_a91:	rjmp	emu6_loopns		;goto loop

;------------------------------------------------------------------------------
; 0xed 0xaa		IND
;------------------------------------------------------------------------------
emu6_code_aa:	mov	r18,reg_f
		movw	YL,reg_c		;LOW address
		call	emu_in
		putmembyte r16,reg_l,reg_h
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		sub	reg_b,const_1		;B--
		in	reg_f,SREG
		andi	reg_f,(flags_clrc & flags_clrh & flags_clrp)
emu6_code_aa1:	sbrs	r16,7
		z80_clrnflag
		sbrc	r16,7
		z80_setnflag
		sbrs	r18,aflag_c
		sub	r16,const_1
		brcc	emu6_code_aa2
		ori	reg_f,(flags_setc | flags_seth)
emu6_code_aa2:	andi	r16,0x07
		eor	r16,reg_b
		mov	ZL,r16

.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	ZL,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	ZL,Z
.endif

		bst	ZL,aflag_p
		bld	reg_f,aflag_p
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xab		OUTD
;------------------------------------------------------------------------------
emu6_code_ab:	andi	reg_f,flags_clrz	;clear Z
		getmembyte r16,reg_l,reg_h
		sub	reg_b,const_1		;B--
		in	reg_f,SREG
		movw	YL,reg_c		;LOW address
		call	emu_out
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		andi	reg_f,(flags_clrc & flags_clrh & flags_clrp)
emu6_code_ab1:	sbrs	r16,7
		z80_clrnflag
		sbrc	r16,7
		z80_setnflag
		add	r16,reg_l
		brcc	emu6_code_ab2
		ori	reg_f,(flags_setc | flags_seth)
emu6_code_ab2:	andi	r16,0x07
		eor	r16,reg_b
		mov	ZL,r16

.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	ZL,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	ZL,Z
.endif

		bst	ZL,aflag_p
		bld	reg_f,aflag_p
		rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xb0		LDIR
;------------------------------------------------------------------------------
emu6_code_b0:	getmembyte r16,reg_l,reg_h	;get (HL)
		z80_clrnflag			;clear N
		andi	reg_f,(flags_clrp & flags_clrh)		;clear PV and H
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		putmembyte r16,reg_e,reg_d	;put (DE)
		add	reg_e,const_1		;DE++
		adc	reg_d,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		breq	emu6_code_b01
		ori	reg_f,flags_setp	;set PV
		sbiw	PC_L,2			;loop
emu6_code_b01:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xb1		CPIR
;------------------------------------------------------------------------------
emu6_code_b1:	getmembyte r16,reg_l,reg_h	;get M
		cp	reg_a,r16		;compare
		bst	reg_f,aflag_c		;save C flag
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore carry
		ori	reg_f,flags_setp	;set PV
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		brne	emu6_code_b11
		andi	reg_f,flags_clrp	;clear PV
		rjmp	emu6_loopns		;all done

emu6_code_b11:	sbrs	reg_f,aflag_z		;skip if found
		sbiw	PC_L,2			;must repeat
		rjmp	emu6_loopns

;------------------------------------------------------------------------------
; 0xed 0xb2		INIR
;------------------------------------------------------------------------------
emu6_code_b2:	mov	r18,reg_f		;save old flag status
		movw	YL,reg_c		;LOW address
		call	emu_in
		putmembyte r16,reg_l,reg_h
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		sub	reg_b,const_1		;B--
		in	reg_f,SREG
		andi	reg_f,(flags_clrc & flags_clrh & flags_clrp)
emu6_code_b21:	sbrs	r16,7
		z80_clrnflag
		sbrc	r16,7
		z80_setnflag
		add	r16,const_1
		sbrc	r18,aflag_c
		add	r16,const_1
		brcc	emu6_code_b22
		ori	reg_f,(flags_setc | flags_seth)
emu6_code_b22:	andi	r16,0x07
		eor	r16,reg_b
		mov	ZL,r16

.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	ZL,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	ZL,Z
.endif

		bst	ZL,aflag_p
		bld	reg_f,aflag_p
		cp	reg_b,const_0
		breq	emu6_code_b23
		sbiw	PC_L,2			;must repeat
emu6_code_b23:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xb3		OTIR
;------------------------------------------------------------------------------
emu6_code_b3:	getmembyte r16,reg_l,reg_h
		sub	reg_b,const_1		;B--
		in	reg_f,SREG
		movw	YL,reg_c		;LOW address
		call	emu_out
		add	reg_l,const_1		;HL++
		adc	reg_h,const_0
		andi	reg_f,(flags_clrc & flags_clrh & flags_clrp)
emu6_code_b31:	sbrs	r16,7
		z80_clrnflag
		sbrc	r16,7
		z80_setnflag
		add	r16,reg_l
		brcc	emu6_code_b32
		ori	reg_f,(flags_setc | flags_seth)
emu6_code_b32:	andi	r16,0x07
		eor	r16,reg_b
		mov	ZL,r16

.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	ZL,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	ZL,Z
.endif

		bst	ZL,aflag_p
		bld	reg_f,aflag_p
		cp	reg_b,const_0
		breq	emu6_code_b33
		sbiw	PC_L,2			;must repeat
emu6_code_b33:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xb8		LDDR
;------------------------------------------------------------------------------
emu6_code_b8:	getmembyte r16,reg_l,reg_h	;get (HL)
		z80_clrnflag			;clear N
		andi	reg_f,(flags_clrp & flags_clrh)		;clear PV and H
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		putmembyte r16,reg_e,reg_d	;put (DE)
		sub	reg_e,const_1		;DE--
		sbc	reg_d,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		breq	emu6_code_b81
		ori	reg_f,flags_setp	;set PV
		sbiw	PC_L,2			;loop
emu6_code_b81:	rjmp	emu6_loop		;2

;------------------------------------------------------------------------------
; 0xed 0xb9		CPDR
;------------------------------------------------------------------------------
emu6_code_b9:	getmembyte r16,reg_l,reg_h	;get M
		cp	reg_a,r16		;compare
		bst	reg_f,aflag_c		;save C flag
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore carry
		ori	reg_f,flags_setp	;set PV
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		sub	reg_c,const_1		;BC--
		sbc	reg_b,const_0
		brne	emu6_code_b91
		andi	reg_f,flags_clrp	;clear PV
		rjmp	emu6_loopns		;all done

emu6_code_b91:	sbrs	reg_f,aflag_z		;skip if found
		sbiw	PC_L,2			;must repeat
		rjmp	emu6_loopns

;------------------------------------------------------------------------------
; 0xed 0xba		INDR
;------------------------------------------------------------------------------
emu6_code_ba:	mov	r18,reg_f
		movw	YL,reg_c		;LOW address
		call	emu_in
		putmembyte r16,reg_l,reg_h
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		sub	reg_b,const_1		;B--
		in	reg_f,SREG
		andi	reg_f,(flags_clrc & flags_clrh & flags_clrp)
emu6_code_ba1:	sbrs	r16,7
		z80_clrnflag
		sbrc	r16,7
		z80_setnflag
		sbrs	r18,aflag_c
		sub	r16,const_1
		brcc	emu6_code_ba2
		ori	reg_f,(flags_setc | flags_seth)
emu6_code_ba2:	andi	r16,0x07
		eor	r16,reg_b
		mov	ZL,r16

.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	ZL,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	ZL,Z
.endif

		bst	ZL,aflag_p
		bld	reg_f,aflag_p
		cp	reg_b,const_0
		breq	emu6_code_ba3
		sbiw	PC_L,2			;must repeat
emu6_code_ba3:	rjmp	emu6_loop		;2


;------------------------------------------------------------------------------
; 0xed 0xbb		OTDR
;------------------------------------------------------------------------------
emu6_code_bb:	andi	reg_f,flags_clrz	;clear Z
		getmembyte r16,reg_l,reg_h
		sub	reg_b,const_1		;B--
		in	reg_f,SREG
		movw	YL,reg_c		;LOW address
		call	emu_out
		sub	reg_l,const_1		;HL--
		sbc	reg_h,const_0
		andi	reg_f,(flags_clrc & flags_clrh & flags_clrp)
emu6_code_bb1:	sbrs	r16,7
		z80_clrnflag
		sbrc	r16,7
		z80_setnflag
		add	r16,reg_l
		brcc	emu6_code_bb2
		ori	reg_f,(flags_setc | flags_seth)
emu6_code_bb2:	andi	r16,0x07
		eor	r16,reg_b
		mov	ZL,r16

.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	ZL,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	ZL,Z
.endif

		bst	ZL,aflag_p
		bld	reg_f,aflag_p
		cp	reg_b,const_0
		breq	emu6_code_bb3
		sbiw	PC_L,2			;must repeat
emu6_code_bb3:	rjmp	emu6_loop		;2

