;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

emu_int_llist:
.if use_refresh == 1
		andi	r19,0x7f
		lds	ZL,zreg_r
		andi	ZL,0x80
		or	r19,ZL
		sts	zreg_r,r19
.endif
		cbi	GPIOR0,go_flag
		cbi	GPIOR0,break_flag
		call	fsys_llist		;LOAD/SAVE
		cbi	GPIOR0,llist_flag	;clear flag
.if use_refresh == 1
		lds	r19,zreg_r
.endif
		jmp	emu_loop

;------------------------------------------------------------------------------
;RST
;------------------------------------------------------------------------------
emu_int:	sbiw	PC_L,1			;2 discard current byte
		sbic	GPIOR0,llist_flag	;skip if no llist
		rjmp	emu_int_llist

		sbis	GPIOR0,go_flag		;skip if go flag
		rjmp	emu_int_nogo

		;check for break address
		lds	ZL,mon_break_l
		lds	ZH,mon_break_h
		cp	ZL,PC_L
		brne	emu_int_noadr
		cp	ZH,PC_H
		brne	emu_int_noadr
		sbi	GPIOR0,break_flag
		rjmp	emu_int_nogo

emu_int_noadr:	ldi	ZH,HIGH(emu_jitab)	;1 following cycle is int
		out	EEARL,ZH
		ldi	ZH,HIGH(emu_jtab)	;1 next cycle is normal
		sbis	GPIOR0,int_flag
		jmp	emu_loopz
		cbi	GPIOR0,int_flag
		rjmp	emu_do_int_0

emu_int_nogo:	sbis	GPIOR0,break_flag
		rjmp	emu_do_int		;no monitor

.if use_refresh == 1
		andi	r19,0x7f
		lds	ZL,zreg_r
		andi	ZL,0x80
		or	r19,ZL
		sts	zreg_r,r19
.endif
		call	monitor
.if use_refresh == 1
		lds	r19,zreg_r
.endif
		sbic	GPIOR0,go_flag
		rjmp	emu_intstep		;do one step
		sbis	GPIOR0,break_flag
		rjmp	emu_do_int		;continue interrupt

emu_intstep:	ldi	ZH,HIGH(emu_jitab)	;1 following cycle is int
		out	EEARL,ZH
		ldi	ZH,HIGH(emu_jtab)	;1 next cycle is normal
		jmp	emu_loopz


emu_do_int:	sbis	GPIOR0,int_flag
		jmp	emu_loop
		cbi	GPIOR0,int_flag		;clear interrupt flag
		ldi	ZH,HIGH(emu_jtab)	;1 next cycle is normal
		out	EEARL,ZH
emu_do_int_0:	lds	r16,z80_iflag
		sbrs	r16,0
		jmp	emu_loop		;int is disabled, repeat last cmd
		sts	z80_iflag,const_0	;disable further INT
		lds	r16,z80_imode
		andi	r16,0x03
		cpi	r16,2
		brne	emu_int_mx
		lds	ZH,zreg_i
		call	emu_intvec		;get int vector
		mov	ZL,r16
		getmemword r0,r1,ZL,ZH		;get the jump address
		jmp	emu_intcall		;this inserts a call

emu_int_mx:	cpi	r16,1
		brne	emu_int_m0
		ldi	r16,0x38
		jmp	emu_rst			;do a RST38

emu_int_m0:	call	emu_intvec
		mov	ZL,r16
		in	ZH,EEARL
		ijmp


;------------------------------------------------------------------------------
; the level1 jump table for interrupt
;------------------------------------------------------------------------------

.org (pc+255) & 0xff00

emu_jitab:	rjmp	emu_int			;code 0x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int

		rjmp	emu_int			;code 1x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code 2x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code 3x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int

		rjmp	emu_int			;code 4x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code 5x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code 6x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code 7x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code 8x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code 9x
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code ax
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code bx
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code cx
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code dx
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code ex
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int


		rjmp	emu_int			;code fx
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int
		rjmp	emu_int

