;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


;Y=addr, r16=data
emu_in:		sbrc	YL,0
		rjmp	emu_in_1

		ldi	ZH,HIGH(io_fe*2)
		mov	ZL,YH
		lpm	r16,Z
		ldi	ZL,LOW(vsys_kbuf)
		ldi	ZH,HIGH(vsys_kbuf)
		add	ZL,r16
		adc	ZH,const_0
		ld	r16,Z
		lds	ZL,vsys_border
		bst	ZL,4
		bld	r16,6
		ret

emu_in_1:	sbrc	YL,5			;kempston joystick
		rjmp	emu_in_x
		lds	r16,vsys_kempston
		ret


emu_in_x:	ldi	r16,0xff		;empty port
		ret


;Y=addr, r16=data
emu_inbc:	cpi	YL,0xfe		;KBD
		brne	emu_inbc_k
		ldi	ZH,HIGH(io_fe*2)
		mov	ZL,YH
		lpm	r16,Z
		ldi	ZL,LOW(vsys_kbuf)
		ldi	ZH,HIGH(vsys_kbuf)
		add	ZL,r16
		adc	ZH,const_0
emu_inbc_1:	ld	r16,Z
		lds	ZL,vsys_border
		bst	ZL,4
		bld	r16,6
		mov	ZL,r16
		bst	reg_f,aflag_c
.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	reg_f,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	reg_f,Z
.endif

		bld	reg_f,aflag_c
		z80_clrnflag
		ret

emu_inbc_k:	sbrc	YL,5			;kempston joystick
		rjmp	emu_inbc_x
		lds	r16,vsys_kempston
		mov	ZL,r16
		bst	reg_f,aflag_c
.if rom_tables == 0
		ldi	ZH,HIGH(emu_flags_log)
		ld	reg_f,Z
.else
		ldi	ZH,HIGH(emu_flags_log*2)
		lpm	reg_f,Z
.endif
		bld	reg_f,aflag_c
		z80_clrnflag
		ret


emu_inbc_x:	ldi	r16,0xff		;empty port
		ori	reg_f,flags_setp
		ret


;YL/YH=addr, r16=data
emu_out:	cpi	YL,0xfe
		brne	emu_out_fd
		sts	vsys_border,r16
		ret

emu_out_fd:	ret

;get interrupt vector low
emu_intvec:	ldi	r16,0xff
		ret

