;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;copy ROM image into RAM
;------------------------------------------------------------------------------
emu_cprom:	ldi	ZL,LOW(romdata*2)
		ldi	ZH,HIGH(romdata*2)
		ldi	YL,0
		ldi	YH,0
emu_cprom1:	lpm	XL,Z+
		putmembyte	XL,YL,YH
		adiw	YL,1
		cpi	YH,0x40
		brne	emu_cprom1
		ret

;------------------------------------------------------------------------------
;init registers and start
;------------------------------------------------------------------------------
emu_start:	ldi	PC_L,0
		ldi	PC_H,0
		movw	reg_f,PC_L
		movw	reg_c,PC_L
		movw	reg_e,PC_L
		movw	reg_l,PC_L
		movw	SP_L,PC_L
		z80_clrnflag			;N flag
		cbi	GPIOR0,1		;INT clear
		ldi	XL,LOW(z80emu_ram)
		ldi	XH,HIGH(z80emu_ram)
		ldi	ZL,64
emu_start_1:	st	X+,const_0
		dec	ZL
		brne	emu_start_1
		ldi	ZH,HIGH(emu_jtab)	;1
		out	EEARL,ZH
		sts	mon_break,const_0

		ldi	ZL,LOW(emu_flagtab*2)
		ldi	ZH,high(emu_flagtab*2)
		ldi	YL,LOW(emu_flags_log)
		ldi	YH,HIGH(emu_flags_log)
		clr	XH
emu_start_2:	lpm	XL,Z+
		st	Y+,XL
		lpm	XL,Z+
		st	Y+,XL
		dec	XH
		brne	emu_start_2
		set_refresh			;initial R register value
		rjmp	emu_loop

