;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

; the level2 jump table
;------------------------------------------------------------------------------
.org (pc+255) & 0xff00

emu7_jtab:	rjmp	emu7_zloop		;2	0x00	NOP
		rjmp	emu7_zloop   ;code 01
		rjmp	emu7_zloop   ;code 02
		rjmp	emu7_zloop   ;code 03
		rjmp	emu7_zloop   ;code 04
		rjmp	emu7_zloop   ;code 05
		rjmp	emu7_zloop   ;code 06
		rjmp	emu7_zloop   ;code 07
		rjmp	emu7_zloop   ;code 08
		rjmp	emu7_code_09
		rjmp	emu7_zloop   ;code 0a
		rjmp	emu7_zloop   ;code 0b
		rjmp	emu7_zloop   ;code 0c
		rjmp	emu7_zloop   ;code 0d
		rjmp	emu7_zloop   ;code 0e
		rjmp	emu7_zloop   ;code 0f

		rjmp	emu7_zloop   ;code 10
		rjmp	emu7_zloop   ;code 11
		rjmp	emu7_zloop   ;code 12
		rjmp	emu7_zloop   ;code 13
		rjmp	emu7_zloop   ;code 14
		rjmp	emu7_zloop   ;code 15
		rjmp	emu7_zloop   ;code 16
		rjmp	emu7_zloop   ;code 17
		rjmp	emu7_zloop   ;code 18
		rjmp	emu7_code_19
		rjmp	emu7_zloop   ;code 1a
		rjmp	emu7_zloop   ;code 1b
		rjmp	emu7_zloop   ;code 1c
		rjmp	emu7_zloop   ;code 1d
		rjmp	emu7_zloop   ;code 1e
		rjmp	emu7_zloop   ;code 1f

		rjmp	emu7_zloop   ;code 20
		rjmp	emu7_code_21
		rjmp	emu7_code_22
		rjmp	emu7_code_23
		rjmp	emu7_code_24
		rjmp	emu7_code_25
		rjmp	emu7_code_26
		rjmp	emu7_zloop   ;code 27
		rjmp	emu7_zloop   ;code 28
		rjmp	emu7_code_29
		rjmp	emu7_code_2a
		rjmp	emu7_code_2b
		rjmp	emu7_code_2c
		rjmp	emu7_code_2d
		rjmp	emu7_code_2e
		rjmp	emu7_zloop   ;code 2f

		rjmp	emu7_zloop   ;code 30
		rjmp	emu7_zloop   ;code 31
		rjmp	emu7_zloop   ;code 32
		rjmp	emu7_zloop   ;code 33
		rjmp	emu7_code_34
		rjmp	emu7_code_35
		rjmp	emu7_code_36
		rjmp	emu7_zloop   ;code 37
		rjmp	emu7_zloop   ;code 38
		rjmp	emu7_code_39
		rjmp	emu7_zloop   ;code 3a
		rjmp	emu7_zloop   ;code 3b
		rjmp	emu7_zloop   ;code 3c
		rjmp	emu7_zloop   ;code 3d
		rjmp	emu7_zloop   ;code 3e
		rjmp	emu7_zloop   ;code 3f

		rjmp	emu7_zloop
		rjmp	emu7_zloop   ;code 41
		rjmp	emu7_zloop   ;code 42
		rjmp	emu7_zloop   ;code 43
		rjmp	emu7_code_44
		rjmp	emu7_code_45
		rjmp	emu7_code_46
		rjmp	emu7_zloop   ;code 47
		rjmp	emu7_zloop   ;code 48
		rjmp	emu7_zloop
		rjmp	emu7_zloop   ;code 4a
		rjmp	emu7_zloop   ;code 4b
		rjmp	emu7_code_4c
		rjmp	emu7_code_4d
		rjmp	emu7_code_4e
		rjmp	emu7_zloop   ;code 4f

		rjmp	emu7_zloop   ;code 50
		rjmp	emu7_zloop   ;code 51
		rjmp	emu7_zloop
		rjmp	emu7_zloop   ;code 53
		rjmp	emu7_code_54
		rjmp	emu7_code_55
		rjmp	emu7_code_56
		rjmp	emu7_zloop   ;code 57
		rjmp	emu7_zloop   ;code 58
		rjmp	emu7_zloop   ;code 59
		rjmp	emu7_zloop   ;code 5a
		rjmp	emu7_zloop
		rjmp	emu7_code_5c
		rjmp	emu7_code_5d
		rjmp	emu7_code_5e
		rjmp	emu7_zloop   ;code 5f

		rjmp	emu7_code_60
		rjmp	emu7_code_61
		rjmp	emu7_code_62
		rjmp	emu7_code_63
		rjmp	emu7_zloop	;LD IxH,IxH
		rjmp	emu7_code_65
		rjmp	emu7_code_66
		rjmp	emu7_code_67
		rjmp	emu7_code_68
		rjmp	emu7_code_69
		rjmp	emu7_code_6a
		rjmp	emu7_code_6b
		rjmp	emu7_code_6c
		rjmp	emu7_zloop	;LD IxL,IxL
		rjmp	emu7_code_6e
		rjmp	emu7_code_6f

		rjmp	emu7_code_70
		rjmp	emu7_code_71
		rjmp	emu7_code_72
		rjmp	emu7_code_73
		rjmp	emu7_code_74
		rjmp	emu7_code_75
		rjmp	emu7_zloop   ;code 76
		rjmp	emu7_code_77
		rjmp	emu7_zloop   ;code 78
		rjmp	emu7_zloop   ;code 79
		rjmp	emu7_zloop   ;code 7a
		rjmp	emu7_zloop   ;code 7b
		rjmp	emu7_code_7c
		rjmp	emu7_code_7d
		rjmp	emu7_code_7e
		rjmp	emu7_zloop

		rjmp	emu7_zloop   ;code 80
		rjmp	emu7_zloop   ;code 81
		rjmp	emu7_zloop   ;code 82
		rjmp	emu7_zloop   ;code 83
		rjmp	emu7_code_84
		rjmp	emu7_code_85
		rjmp	emu7_code_86
		rjmp	emu7_zloop   ;code 87
		rjmp	emu7_zloop   ;code 88
		rjmp	emu7_zloop   ;code 89
		rjmp	emu7_zloop   ;code 8a
		rjmp	emu7_zloop   ;code 8b
		rjmp	emu7_code_8c
		rjmp	emu7_code_8d
		rjmp	emu7_code_8e
		rjmp	emu7_zloop   ;code 8f

		rjmp	emu7_zloop   ;code 90
		rjmp	emu7_zloop   ;code 91
		rjmp	emu7_zloop   ;code 92
		rjmp	emu7_zloop   ;code 93
		rjmp	emu7_code_94
		rjmp	emu7_code_95
		rjmp	emu7_code_96
		rjmp	emu7_zloop   ;code 97
		rjmp	emu7_zloop   ;code 98
		rjmp	emu7_zloop   ;code 99
		rjmp	emu7_zloop   ;code 9a
		rjmp	emu7_zloop   ;code 9b
		rjmp	emu7_code_9c
		rjmp	emu7_code_9d
		rjmp	emu7_code_9e
		rjmp	emu7_zloop   ;code 9f

		rjmp	emu7_zloop   ;code a0
		rjmp	emu7_zloop   ;code a1
		rjmp	emu7_zloop   ;code a2
		rjmp	emu7_zloop   ;code a3
		rjmp	emu7_code_a4
		rjmp	emu7_code_a5
		rjmp	emu7_code_a6
		rjmp	emu7_zloop   ;code a7
		rjmp	emu7_zloop   ;code a8
		rjmp	emu7_zloop   ;code a9
		rjmp	emu7_zloop   ;code aa
		rjmp	emu7_zloop   ;code ab
		rjmp	emu7_code_ac
		rjmp	emu7_code_ad
		rjmp	emu7_code_ae
		rjmp	emu7_zloop   ;code af

		rjmp	emu7_zloop   ;code b0
		rjmp	emu7_zloop   ;code b1
		rjmp	emu7_zloop   ;code b2
		rjmp	emu7_zloop   ;code b3
		rjmp	emu7_code_b4
		rjmp	emu7_code_b5
		rjmp	emu7_code_b6
		rjmp	emu7_zloop   ;code b7
		rjmp	emu7_zloop   ;code b8
		rjmp	emu7_zloop   ;code b9
		rjmp	emu7_zloop   ;code ba
		rjmp	emu7_zloop   ;code bb
		rjmp	emu7_code_bc
		rjmp	emu7_code_bd
		rjmp	emu7_code_be
		rjmp	emu7_zloop   ;code bf

		rjmp	emu7_zloop   ;code c0
		rjmp	emu7_zloop   ;code c1
		rjmp	emu7_zloop   ;code c2
		rjmp	emu7_zloop   ;code c3
		rjmp	emu7_zloop   ;code c4
		rjmp	emu7_zloop   ;code c5
		rjmp	emu7_zloop   ;code c6
		rjmp	emu7_zloop   ;code c7
		rjmp	emu7_zloop   ;code c8
		rjmp	emu7_zloop   ;code c9
		rjmp	emu7_zloop   ;code ca
		rjmp	emu7_code_cb
		rjmp	emu7_zloop   ;code cc
		rjmp	emu7_zloop   ;code cd
		rjmp	emu7_zloop   ;code ce
		rjmp	emu7_zloop   ;code cf

		rjmp	emu7_zloop   ;code d0
		rjmp	emu7_zloop   ;code d1
		rjmp	emu7_zloop   ;code d2
		rjmp	emu7_zloop   ;code d3
		rjmp	emu7_zloop   ;code d4
		rjmp	emu7_zloop   ;code d5
		rjmp	emu7_zloop   ;code d6
		rjmp	emu7_zloop   ;code d7
		rjmp	emu7_zloop   ;code d8
		rjmp	emu7_zloop   ;code d9
		rjmp	emu7_zloop   ;code da
		rjmp	emu7_zloop   ;code db
		rjmp	emu7_zloop   ;code dc
		rjmp	emu7_zloop   ;code dd
		rjmp	emu7_zloop   ;code de
		rjmp	emu7_zloop   ;code df

		rjmp	emu7_zloop   ;code e0
		rjmp	emu7_code_e1
		rjmp	emu7_zloop   ;code e2
		rjmp	emu7_code_e3
		rjmp	emu7_zloop   ;code e4
		rjmp	emu7_code_e5
		rjmp	emu7_zloop   ;code e6
		rjmp	emu7_zloop   ;code e7
		rjmp	emu7_zloop   ;code e8
		rjmp	emu7_code_e9
		rjmp	emu7_zloop   ;code ea
		rjmp	emu7_zloop   ;code eb
		rjmp	emu7_zloop   ;code ec
		rjmp	emu7_zloop   ;code ed
		rjmp	emu7_zloop   ;code ee
		rjmp	emu7_zloop   ;code ef

		rjmp	emu7_zloop   ;code f0
		rjmp	emu7_zloop   ;code f1
		rjmp	emu7_zloop   ;code f2
		rjmp	emu7_zloop   ;code f3
		rjmp	emu7_zloop   ;code f4
		rjmp	emu7_zloop   ;code f5
		rjmp	emu7_zloop   ;code f6
		rjmp	emu7_zloop   ;code f7
		rjmp	emu7_zloop   ;code f8
		rjmp	emu7_code_f9
		rjmp	emu7_zloop   ;code fa
		rjmp	emu7_zloop   ;code fb
		rjmp	emu7_zloop   ;code fc
		rjmp	emu7_zloop   ;code fd
		rjmp	emu7_zloop   ;code fe
		rjmp	emu7_zloop   ;code ff

;------------------------------------------------------------------------------
; 0x09		ADD	Ix,BC
;------------------------------------------------------------------------------
emu7_code_09:	lsr	reg_f			;shift out C flag
		add	r0,reg_c
		adc	r1,reg_b
		in	r18,SREG
		rol	reg_f			;shift in C flag
		bst	r18,aflag_h
		bld	reg_f,aflag_h
		rjmp	emu7_loopnc

;------------------------------------------------------------------------------
; 0x19		ADD	Ix,DE
;------------------------------------------------------------------------------
emu7_code_19:	lsr	reg_f			;shift out C flag
		add	r0,reg_e
		adc	r1,reg_d
		in	r18,SREG
		rol	reg_f			;shift in C flag
		bst	r18,aflag_h
		bld	reg_f,aflag_h
		rjmp	emu7_loopnc

;------------------------------------------------------------------------------
; 0x21		LD 	Ix,nnnn
;------------------------------------------------------------------------------
emu7_code_21:	getpcword r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x22		LD 	(nnnn),Ix
;------------------------------------------------------------------------------
emu7_code_22:	getpcword XL,XH
		putmemword r0,r1,XL,XH
		rjmp	emu7_loopnw		;2 end of command

;------------------------------------------------------------------------------
; 0x23		INC	Ix
;------------------------------------------------------------------------------
emu7_code_23:	z80_inc16	r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x24		INC	IxH
;------------------------------------------------------------------------------
emu7_code_24:	z80_increg r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x25		DEC	IxH
;------------------------------------------------------------------------------
emu7_code_25:	z80_decreg r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x26		LD	IxH,nn
;------------------------------------------------------------------------------
emu7_code_26:	getpcbyte r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x29		ADD	Ix,Ix
;------------------------------------------------------------------------------
emu7_code_29:	lsr	reg_f			;shift out C flag
		add	r0,r0
		adc	r1,r1
		in	r18,SREG
		rol	reg_f			;shift in C flag
		bst	r18,aflag_h
		bld	reg_f,aflag_h
		rjmp	emu7_loopnc

;------------------------------------------------------------------------------
; 0x2a		LD 	Ix,(nnnn)
;------------------------------------------------------------------------------
emu7_code_2a:	getpcword XL,XH
		getmemword r0,r1,XL,XH
		rjmp	emu7_loop		;2 end of command

;------------------------------------------------------------------------------
; 0x2b		DEC	Ix
;------------------------------------------------------------------------------
emu7_code_2b:	z80_dec16	r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x2c		INC	IxL
;------------------------------------------------------------------------------
emu7_code_2c:	z80_increg r0
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x2d		DEC	IxL
;------------------------------------------------------------------------------
emu7_code_2d:	z80_decreg r0
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x2e		LD	IxL,nn
;------------------------------------------------------------------------------
emu7_code_2e:	getpcbyte r0
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x34		INC	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_34:	getpcbyte r17
		getidbyte r16,r17
		z80_increg r16
		putidbyte1 r16,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x35		DEC	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_35:	getpcbyte r17
		getidbyte r16,r17
		z80_decreg r16
		putidbyte1 r16,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x36		LD 	(Ix+d),nn
;------------------------------------------------------------------------------
emu7_code_36:	getpcword r17,r16
		putidbyte r16,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x39		ADD	Ix,SP
;------------------------------------------------------------------------------
emu7_code_39:	lsr	reg_f			;shift out C flag
		add	r0,SP_L
		adc	r1,SP_H
		in	r18,SREG
		rol	reg_f			;shift in C flag
		bst	r18,aflag_h
		bld	reg_f,aflag_h
		rjmp	emu7_loopnc

;------------------------------------------------------------------------------
; 0x44		LD	B,IxH
;------------------------------------------------------------------------------
emu7_code_44:	mov	reg_b,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x45		LD	B,IxL
;------------------------------------------------------------------------------
emu7_code_45:	mov	reg_b,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x46		LD	B,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_46:	getpcbyte r17
		getidbyte reg_b,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x4c		LD	C,IxH
;------------------------------------------------------------------------------
emu7_code_4c:	mov	reg_c,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x4d		LD	C,IxL
;------------------------------------------------------------------------------
emu7_code_4d:	mov	reg_c,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x4e		LD	C,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_4e:	getpcbyte r17
		getidbyte reg_c,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x54		LD	D,IxH
;------------------------------------------------------------------------------
emu7_code_54:	mov	reg_d,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x55		LD	D,IxL
;------------------------------------------------------------------------------
emu7_code_55:	mov	reg_d,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x56		LD	D,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_56:	getpcbyte r17
		getidbyte reg_d,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x5c		LD	E,IxH
;------------------------------------------------------------------------------
emu7_code_5c:	mov	reg_e,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x5d		LD	E,IxL
;------------------------------------------------------------------------------
emu7_code_5d:	mov	reg_e,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x5e		LD	E,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_5e:	getpcbyte r17
		getidbyte reg_e,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x60		LD	IxH,B
;------------------------------------------------------------------------------
emu7_code_60:	mov	r1,reg_b
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x61		LD	IxH,C
;------------------------------------------------------------------------------
emu7_code_61:	mov	r1,reg_c
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x62		LD	IxH,D
;------------------------------------------------------------------------------
emu7_code_62:	mov	r1,reg_d
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x63		LD	IxH,E
;------------------------------------------------------------------------------
emu7_code_63:	mov	r1,reg_e
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x64		LD	IxH,IxH
;------------------------------------------------------------------------------
;emu7_code_64:

;------------------------------------------------------------------------------
; 0x65		LD	IxH,IxL
;------------------------------------------------------------------------------
emu7_code_65:	mov	r1,r0
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x66		LD	H,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_66:	getpcbyte r17
		getidbyte reg_h,r17
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x67		LD	IxH,A
;------------------------------------------------------------------------------
emu7_code_67:	mov	r1,reg_a
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x68		LD	IxL,B
;------------------------------------------------------------------------------
emu7_code_68:	mov	r0,reg_b
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x69		LD	IxL,C
;------------------------------------------------------------------------------
emu7_code_69:	mov	r0,reg_c
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x6a		LD	IxL,D
;------------------------------------------------------------------------------
emu7_code_6a:	mov	r0,reg_d
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x6b		LD	IxL,E
;------------------------------------------------------------------------------
emu7_code_6b:	mov	r0,reg_e
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x6c		LD	IxL,IxH
;------------------------------------------------------------------------------
emu7_code_6c:	mov	r0,r1
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x6d		LD	IxL,IxL
;------------------------------------------------------------------------------
;emu7_code_6d:

;------------------------------------------------------------------------------
; 0x6e		LD	L,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_6e:	getpcbyte r17
		getidbyte reg_l,r17
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0x6f		LD	IxL,A
;------------------------------------------------------------------------------
emu7_code_6f:	mov	r0,reg_a
		rjmp	emu7_loop		;goto loop

;------------------------------------------------------------------------------
; 0x70		LD	(Ix+d),B
;------------------------------------------------------------------------------
emu7_code_70:	getpcbyte r17
		putidbyte reg_b,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x71		LD	(Ix+d),C
;------------------------------------------------------------------------------
emu7_code_71:	getpcbyte r17
		putidbyte reg_c,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x72		LD	(Ix+d),D
;------------------------------------------------------------------------------
emu7_code_72:	getpcbyte r17
		putidbyte reg_d,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x73		LD	(Ix+d),E
;------------------------------------------------------------------------------
emu7_code_73:	getpcbyte r17
		putidbyte reg_e,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x74		LD	(Ix+d),H
;------------------------------------------------------------------------------
emu7_code_74:	getpcbyte r17
		putidbyte reg_h,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x75		LD	(Ix+d),L
;------------------------------------------------------------------------------
emu7_code_75:	getpcbyte r17
		putidbyte reg_l,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x77		LD	(Ix+d),A
;------------------------------------------------------------------------------
emu7_code_77:	getpcbyte r17
		putidbyte reg_a,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x7c		LD	A,IxH
;------------------------------------------------------------------------------
emu7_code_7c:	mov	reg_a,r1
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x7d		LD	A,IxL
;------------------------------------------------------------------------------
emu7_code_7d:	mov	reg_a,r0
		rjmp	emu7_loopnw		;goto loop

;------------------------------------------------------------------------------
; 0x7e		LD	A,(Ix+d)
;------------------------------------------------------------------------------
emu7_code_7e:	getpcbyte r17
		getidbyte reg_a,r17
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0x84		ADD	IxH
;------------------------------------------------------------------------------
emu7_code_84:	reg_add	r1
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x85		ADD	IxL
;------------------------------------------------------------------------------
emu7_code_85:	reg_add	r0
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x86		ADD	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_86:	getpcbyte r17
		getidbyte r16,r17
		reg_add	r16
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8c		ADC	IxH
;------------------------------------------------------------------------------
emu7_code_8c:	reg_adc	r1
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8d		ADC	IxL
;------------------------------------------------------------------------------
emu7_code_8d:	reg_adc	r0
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x8e		ADC	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_8e:	getpcbyte r17
		getidbyte r16,r17
		reg_adc	r16
		jmp	emu_loopa

;------------------------------------------------------------------------------
; 0x94		SUB	IxH
;------------------------------------------------------------------------------
emu7_code_94:	reg_sub	r1
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x95		SUB	IxL
;------------------------------------------------------------------------------
emu7_code_95:	reg_sub	r0
		jmp	emu_loops		;2 goto loop

;------------------------------------------------------------------------------
; 0x96		SUB	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_96:	getpcbyte r17
		getidbyte r16,r17
		reg_sub	r16
		jmp	emu_loops		;2 goto loop

;------------------------------------------------------------------------------
; 0x9c		SBC	IxH
;------------------------------------------------------------------------------
emu7_code_9c:	reg_sbc	r1
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x9d		SBC	IxL
;------------------------------------------------------------------------------
emu7_code_9d:	reg_sbc	r0
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0x9e		SBC	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_9e:	getpcbyte r17
		getidbyte r16,r17
		reg_sbc	r16
		jmp	emu_loops		;2 goto loop

;------------------------------------------------------------------------------
; 0xa4		AND	IxH
;------------------------------------------------------------------------------
emu7_code_a4:	and	reg_a,r1
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xa5		AND	IxL
;------------------------------------------------------------------------------
emu7_code_a5:	and	reg_a,r0
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xa6		AND	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_a6:	getpcbyte r17
		getidbyte r16,r17
		and	reg_a,r16
		jmp	emu_and

;------------------------------------------------------------------------------
; 0xac		XOR	IxH
;------------------------------------------------------------------------------
emu7_code_ac:	eor	reg_a,r1
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xad		XOR	IxL
;------------------------------------------------------------------------------
emu7_code_ad:	eor	reg_a,r0
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xae		XOR	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_ae:	getpcbyte r17
		getidbyte r16,r17
		eor	reg_a,r16
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb4		OR	IxH
;------------------------------------------------------------------------------
emu7_code_b4:	or	reg_a,r1
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb5		OR	IxL
;------------------------------------------------------------------------------
emu7_code_b5:	or	reg_a,r0
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xb6		OR	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_b6:	getpcbyte r17
		getidbyte r16,r17
		or	reg_a,r16
		jmp	emu_or

;------------------------------------------------------------------------------
; 0xbc		CMP	IxH
;------------------------------------------------------------------------------
emu7_code_bc:	cp	reg_a,r1		;sub A
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xbd		CMP	IxL
;------------------------------------------------------------------------------
emu7_code_bd:	cp	reg_a,r0		;sub A
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xbe		CMP	(Ix+d)
;------------------------------------------------------------------------------
emu7_code_be:	getpcbyte	r17
		getidbyte	r16,r17
		reg_cmp	r16
		jmp	emu_loops

;------------------------------------------------------------------------------
; 0xcb		Bit commands
;------------------------------------------------------------------------------
emu7_code_cb:	jmp	emu8_sel		;goto loop

;------------------------------------------------------------------------------
; 0xe1		POP	Ix
;------------------------------------------------------------------------------
emu7_code_e1:	z80_pop		r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0xe3		EX (SP),Ix
;------------------------------------------------------------------------------
emu7_code_e3:	z80_exch r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0xe5		PUSH Ix
;------------------------------------------------------------------------------
emu7_code_e5:	z80_push	r0,r1
		rjmp	emu7_loop

;------------------------------------------------------------------------------
; 0xe9		JMP Ix
;------------------------------------------------------------------------------
emu7_code_e9:	movw	PC_L,r0
		rjmp	emu7_loopnw

;------------------------------------------------------------------------------
; 0xf9		LD	SP,Ix
;------------------------------------------------------------------------------
emu7_code_f9:	movw	SP_L,r0
		rjmp	emu7_loop


emu7_loopnc:	z80_clrnflag
emu7_loop:	st	Y,r0
		std	Y+1,r1
emu7_loopnw:	getpcbyte_m1 ZL			;12/13
		in	ZH,EEARL
		ijmp				;2

emu7_sel:	getpcbyte ZL			;12/13 cmd
		ldi	ZH,HIGH(emu7_jtab)	;1
		ijmp				;2

emu7_zloop:	in	ZH,EEARL
		ijmp				;2
