;################################################################################
;#										#
;# AX82 computer with ATmega644/1284						#
;# copyright (c) 2011-2012 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License as		#
;# published by the Free Software Foundation; either version 3 of		#
;# the License, or (at your option) any later version.				#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;--------------------------------------------------------------------------------
; common definitions
;--------------------------------------------------------------------------------
.set	clock = 24			;clock frequency (24/25/27 MHz)
.set	use_refresh = 0			;increment R register
.set	rom_tables = 0
.set	spectrum_mode = 1

.def	const_0 = r2
.def	const_1 = r3
.def	const_2 = r12
.def	const_10 = r13
.def	const_ff = r14
.def	reg_roml = r15

.include "/usr/local/include/avr/m644Pdef.inc"

.equ		vsys_kbuf	= 0x0100	;64 bytes vsys system RAM
.equ		vsys_ram	= 0x0120	;64 bytes vsys system RAM
.equ		z80emu_ram	= 0x0140	;32 bytes shadow register etc.
.equ		fsys_ram	= 0x0160	;64 bytes filesystem ram
.equ		stack		= 0x01ff	;stack
.equ		fsys_buffer	= 0x0200	;512 bytes filesystem buffer
.equ		sys_dfile	= 0x08		;system dfile high address
.equ		emu_flags_log	= 0x0e00	;logic flags (RAM copy)
.equ		emu_flags_rot	= 0x0f00	;rotation flags (RAM copy)


.include	"config/pin_config.inc"

;--------------------------------------------------------------------------------
; module specific definitions
;--------------------------------------------------------------------------------
.include	"emulator/definitions.inc"
.include	"vsys/definitions.inc"
.include	"vsys/timing.inc"
.include	"modules/definitions.inc"

;--------------------------------------------------------------------------------
; macro definitions
;--------------------------------------------------------------------------------
.include	"emulator/mem_macros.asm"
.include	"emulator/emu_macros.asm"

.CSEG
;--------------------------------------------------------------------------------
; here starts the code
;--------------------------------------------------------------------------------

.org 0x0000
		jmp	start
.org 0x0004
		.db 1,0				;System/version

.org OC1Baddr
		jmp	vint_vstart		;video interrupt VGA/TV

start:		cli				;disable video after jmp 0
		ldi	XL,0x00
		mov	const_0,XL
		ldi	XL,0x01
		mov	const_1,XL
		ldi	XL,0x02
		mov	const_2,XL
		ldi	XL,0x10
		mov	const_10,XL
		ldi	XL,0xff
		mov	const_ff,XL

		ldi	XL,0x08
		sts	WDTCSR,XL		;enable watchdog

		ldi	XL,HIGH(stack)
		out	SPH,XL
		ldi	XL,LOW(stack)
		out	SPL,XL
		out	SPCR,const_0		;disable SPI

		call	vsys_init		;activate video
		sei


		sts	vsys_view,const_1

		call	intro			;intro screen

		sts	vsys_view,const_1


;jlk:		rjmp	jlk
;		call	test3


		ldi	XL,0x00			;enable ROM writing
		mov	reg_roml,XL

		call	emu_cprom		;copy ROM into RAM

		ldi	XL,0x40			;disable ROM writing
		mov	reg_roml,XL

		sts	vsys_view,const_0

		ldi	XL,0x5c
		sts	mon_dump_h,XL
		sts	mon_dump_l,const_0
		ldi	XL,0xff
		sts	mon_break_h,XL
		sts	mon_break_l,XL

loop:		jmp	emu_start		;start emulator
		rjmp	loop


;--------------------------------------------------------------------------------
; the emulator engine
;--------------------------------------------------------------------------------
.include	"emulator/emulator_start.asm"
.include	"emulator/emulator_main.asm"
.include	"emulator/emulator_cb.asm"
.include	"emulator/emulator_xd.asm"
.include	"emulator/emulator_xdcb.asm"
.include	"emulator/emulator_ed.asm"
.include	"emulator/emulator_io.asm"
.include	"emulator/emulator_int.asm"
.include	"emulator/emulator_res.asm"

.org 0x2600

;--------------------------------------------------------------------------------
; misc. modules
;--------------------------------------------------------------------------------
.include	"modules/fsys.asm"
.include	"modules/fsys_add.asm"

.include	"modules/llist.asm"
.include	"modules/intro.asm"
.include	"modules/monitor.asm"

;--------------------------------------------------------------------------------
; video system / keyboard
;--------------------------------------------------------------------------------
.include	"vsys/init.asm"
.include	"vsys/substitution.asm"

.include	"vsys/vint_main.asm"
.include	"vsys/vint_frame.asm"

.include	"vsys/vint_tv0.asm"
.include	"vsys/vint_tv8.asm"
.include	"vsys/vint_vga0.asm"
.include	"vsys/vint_vga8.asm"

.include	"vsys/vint_keyboard.asm"

;--------------------------------------------------------------------------------
; some tables
;--------------------------------------------------------------------------------
.org 0x5100
.include	"tables/flagconv.inc"

.org 0x5200
.include	"tables/vad_table.inc"

.org 0x5400
vsys_ktables:
.include	"tables/keytable_de.inc"
vsys_zktable:
.include	"tables/zxkeys.inc"
vsys_kstab:
.include	"tables/kstable.inc"

.include	"tables/pktab.inc"
.include	"emulator/flags.asm"

.org 0x5800
vsys_ctable:
.include	"tables/cset.inc"

.org 0x5c00
kmatrix_spec:
.include	"tables/kmatrix_spec.inc"

romdata:
.org 0x6000
.include	"tables/romdata_spectrum.inc"

