
;-----------------------------------------------------------------------------
; read master boot record
;-----------------------------------------------------------------------------
fsys_rdmbr:	sts	fsys_sectnr3,const_0
		sts	fsys_sectnr2,const_0
		sts	fsys_sectnr1,const_0
		sts	fsys_sectnr0,const_0
		rcall	fsys_sread		;read sector into buffer
		lds	XL,zx_ram+0x1fe		;check MBR signature
		lds	XH,zx_ram+0x1ff
		cpi	XL,0x55
		brne	fsys_rdmbr_err
		cpi	XH,0xaa
		breq	fsys_rdmbr_0
fsys_rdmbr_err:	ldi	r16,0x01		;NO MBR
		ret

fsys_rdmbr_0:	ldi	YL,LOW(zx_ram+0x1c2)
		ldi	YH,HIGH(zx_ram+0x1c2)
		ldi	XH,4
		clr	r16			;OK
fsys_rdmbr_1:	ld	XL,Y
		cpi	XL,0x06			;FAT16
		breq	fsys_rdmbr_3
		adiw	YL,16
		dec	XH
		brne	fsys_rdmbr_1
		ldi	r16,0x02		;NO FAT16 partition
fsys_rdmbr_2:	ret
		;set address of boot sector
fsys_rdmbr_3:	ldd	XH,Y+4
		sts	fsys_sectnr0,XH
		ldd	XH,Y+5
		sts	fsys_sectnr1,XH
		ldd	XH,Y+6
		sts	fsys_sectnr2,XH
		ldd	XH,Y+7
		sts	fsys_sectnr3,XH
		ret

;-----------------------------------------------------------------------------
; read boot sector
;-----------------------------------------------------------------------------
fsys_rbs:	rcall	fsys_sread		;read sector into buffer
		lds	XL,zx_ram+0x0b
		cpi	XL,0x00			;only 512 bytes/sector allowed
		brne	fsys_rbs_err
		lds	XL,zx_ram+0x0c
		cpi	XL,0x02			;only 512 bytes/sector allowed
		breq	fsys_rbs_1

fsys_rbs_err:	ldi	r16,0x03		;wrong geometry
		ret

fsys_rbs_1:	lds	XL,zx_ram+0x0d		;sectors per cluster
		sts	fsys_clsec,XL		;store

		lds	XL,zx_ram+0x0e		;reserved sectors
		lds	XH,zx_ram+0x0f
		clr	YL
		clr	YH
		rcall	fsys_addsec		;add reserved sectors

		push	r16
		push	r17
		push	r18

		lds	r16,zx_ram+0x16	;sectors per FAT
		lds	r17,zx_ram+0x17
		lds	r18,zx_ram+0x10	;number of FAT copies

		mul	r16,r18
		movw	XL,r0
		clr	YL
		clr	YH
		mul	r17,r18
		add	XH,r0
		adc	YL,r1
		adc	YH,const_0
		pop	r18
		pop	r17
		pop	r16
		rcall	fsys_addsec		;add FAT sectors, we got the address of root directory
		ret

;-----------------------------------------------------------------------------
; read root directory
;-----------------------------------------------------------------------------
fsys_rdir:	rcall	fsys_sread2		;read sector into buffer
		ldi	YL,LOW(zx_ram)
		ldi	YH,HIGH(zx_ram)
fsys_rdir0_1:	ldi	ZL,LOW(fsys_dirent2*2)
		ldi	ZH,HIGH(fsys_dirent2*2)
		ld	XL,Y
		cpi	XL,0x00			;no entry
		breq	fsys_rdir_0		;continue with image searching
		push	YL
		push	YH
		ldi	XH,11			;bytes to compare
fsys_rdir0_2:	elpm	r0,Z+			;get ROM data
		ld	r1,Y+			;get buffer data
		cp	r0,r1			;compare
		breq	fsys_rdir0_3		;branch if equal
		pop	YH
		pop	YL
		adiw	YL,32			;next entry
		cpi	YH,HIGH(zx_ram)+4	;all done?
		brcs	fsys_rdir0_1		;branch if not
		rjmp	fsys_rdir_0		;not found

fsys_rdir0_3:	dec	XH			;bytes counter
		brne	fsys_rdir0_2		;next char
		pop	YH
		pop	YL
		push	r16
		push	r17
		push	r18

		ldd	r16,Y+0x1a		;offset
		ldd	r17,Y+0x1b
		ldi	r18,2
		sub	r16,r18
		sbc	r17,const_0

		lds	r18,fsys_clsec		;sectors per cluster
		mul	r16,r18
		movw	XL,r0
		clr	YL
		clr	YH
		mul	r17,r18
		add	XH,r0
		adc	YL,r1
		adc	YH,const_0
		ldi	r17,32			;sectors for directory
		cp	r17,r18			;check if cluster size is bigger
		brcc	fsys_rdir0_4
		mov	r17,r18
fsys_rdir0_4:	add	XL,r17
		adc	XH,const_0
		adc	YL,const_0
		adc	YH,const_0
		pop	r18
		pop	r17
		pop	r16
		lds	r8,fsys_sectnr0
		lds	r9,fsys_sectnr1
		lds	r10,fsys_sectnr2
		lds	r11,fsys_sectnr3
		rcall	fsys_addsec		;add offset
;		rcall	fsys_viewoffset
		ldi	r16,0xaa		;ROM image found
		ret


fsys_rdir_0:	rcall	fsys_sread2		;read sector into buffer
		ldi	YL,LOW(zx_ram)
		ldi	YH,HIGH(zx_ram)
fsys_rdir_1:	ldi	ZL,LOW(fsys_dirent*2)
		ldi	ZH,HIGH(fsys_dirent*2)
		lds	XL,vsys_mode
		andi	XL,0x07
		ldi	XH,12			;bytes per entry
		mul	XL,XH
		add	ZL,r0
		adc	ZH,r1
		ld	XL,Y
		cpi	XL,0x00			;no entry
		breq	fsys_rdir_err
		push	YL
		push	YH
		ldi	XH,11			;bytes to compare
fsys_rdir_2:	elpm	r0,Z+			;get ROM data
		ld	r1,Y+			;get buffer data
		cp	r0,r1			;compare
		breq	fsys_rdir_3		;branch if equal
		pop	YH
		pop	YL
		adiw	YL,32			;next entry
		cpi	YH,HIGH(zx_ram)+4	;all done?
		brcs	fsys_rdir_1		;branch if not

fsys_rdir_err:	ldi	r16,0x04		;file not found
		ret

fsys_rdir_3:	dec	XH			;bytes counter
		brne	fsys_rdir_2		;next char
		pop	YH
		pop	YL

		push	r16
		push	r17
		push	r18

		ldd	r16,Y+0x1a		;offset
		ldd	r17,Y+0x1b
		ldi	r18,2
		sub	r16,r18
		sbc	r17,const_0

		lds	r18,fsys_clsec		;sectors per cluster
		mul	r16,r18
		movw	XL,r0
		clr	YL
		clr	YH
		mul	r17,r18
		add	XH,r0
		adc	YL,r1
		adc	YH,const_0
		ldi	r17,32			;sectors for directory
		cp	r17,r18			;check if cluster size is bigger
		brcc	fsys_rdir_4
		mov	r17,r18
fsys_rdir_4:	add	XL,r17
		adc	XH,const_0
		adc	YL,const_0
		adc	YH,const_0
		pop	r18
		pop	r17
		pop	r16
		rcall	fsys_addsec		;add offset
;		rcall	fsys_viewoffset
		ret

