fsys_nfind:	clr	r16
		rcall	fsys_rdmbr		;read MBE
		cpi	r16,0x00
		brne	fsys_nfind_err
		rcall	fsys_rbs		;read Bootsector
		cpi	r16,0x00
		brne	fsys_nfind_err
		rcall	fsys_rdir		;read root directory
		cpi	r16,0x00
		brne	fsys_nfind_err
		rcall	fsys_rsize
		ret

fsys_nfind_err:	call	sys_hexout
		sts	fsys_status,const_0
		ret

;-----------------------------------------------------------------------------
; read sector
;-----------------------------------------------------------------------------
fsys_sread:	cbi	SPI_SPORT,SPI_SPIN	;activate
		rcall	fsys_write_ff2		;16 dummy clocks
		ldi	XL,0x51			;read (17) + 64
		rcall	fsys_wspi
		lds	XL,fsys_status
		sbrs	XL,2
		rjmp	fsys_sread_10		;no SDHC
		lds	XL,fsys_sectnr3
		rcall	fsys_wspi
		lds	XL,fsys_sectnr2
		rcall	fsys_wspi
		lds	XL,fsys_sectnr1
		rcall	fsys_wspi
		lds	XL,fsys_sectnr0
		rcall	fsys_wspi
fsys_sread_1:	ldi	XL,0x95			;dummy crc
		rcall	fsys_wspi
		clr	r0
fsys_sread_2:	rcall	fsys_write_ff
		cpi	XL,0xff
		brne	fsys_sread_3
		dec	r0
		brne	fsys_sread_2
fsys_sread_3:	rcall	fsys_waitsbt		;wait for start block token
		ldi	XH,0x00
		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
fsys_sread_4:	rcall	fsys_write_ff
		st	Y+,XL
		rcall	fsys_write_ff
		st	Y+,XL
		dec	XH
		brne	fsys_sread_4
		rcall	fsys_write_ff2
		sbi	SPI_SPORT,SPI_SPIN	;de-activate
		ret

fsys_sread_10:	lds	XL,fsys_sectnr2
		lds	XH,fsys_sectnr1
		lsl	XH
		rol	XL
		rcall	fsys_wspi
		mov	XL,XH
		lsr	XL
		lds	XH,fsys_sectnr0
		lsl	XH
		rol	XL
		rcall	fsys_wspi
		mov	XL,XH
		rcall	fsys_wspi
		clr	XL
		rcall	fsys_wspi
		rjmp	fsys_sread_1

;-----------------------------------------------------------------------------
; write sector
;-----------------------------------------------------------------------------
fsys_swrite:	cbi	SPI_SPORT,SPI_SPIN	;activate
		rcall	fsys_write_ff2		;16 dummy clocks
		ldi	XL,0x58			;write (24) + 64
		rcall	fsys_wspi
		lds	XL,fsys_status
		sbrs	XL,2
		rjmp	fsys_swrite_10		;no SDHC
		lds	XL,fsys_sectnr3
		rcall	fsys_wspi
		lds	XL,fsys_sectnr2
		rcall	fsys_wspi
		lds	XL,fsys_sectnr1
		rcall	fsys_wspi
		lds	XL,fsys_sectnr0
		rcall	fsys_wspi
fsys_swrite_1:	ldi	XL,0x95			;dummy crc
		rcall	fsys_wspi
		clr	r0
fsys_swrite_2:	rcall	fsys_write_ff
		cpi	XL,0xff
		brne	fsys_swrite_3
		dec	r0
		brne	fsys_swrite_2

fsys_swrite_3:	ldi	XL,0xfe			;start block token
		rcall	fsys_wspi
		ldi	XH,0x00
		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
fsys_swrite_4:	ld	XL,Y+
		rcall	fsys_wspi
		ld	XL,Y+
		rcall	fsys_wspi
		dec	XH
		brne	fsys_swrite_4
		rcall	fsys_write_ff2
fsas_swrite_5:	rcall	fsys_write_ff
		cpi	XL,0xff
		brne	fsas_swrite_5
		sbi	SPI_SPORT,SPI_SPIN	;de-activate
		ret

fsys_swrite_10:	lds	XL,fsys_sectnr2
		lds	XH,fsys_sectnr1
		lsl	XH
		rol	XL
		rcall	fsys_wspi
		mov	XL,XH
		lsr	XL
		lds	XH,fsys_sectnr0
		lsl	XH
		rol	XL
		rcall	fsys_wspi
		mov	XL,XH
		rcall	fsys_wspi
		clr	XL
		rcall	fsys_wspi
		rjmp	fsys_swrite_1

;-----------------------------------------------------------------------------
; read master boot record
;-----------------------------------------------------------------------------
fsys_rdmbr:	sts	fsys_sectnr3,const_0
		sts	fsys_sectnr2,const_0
		sts	fsys_sectnr1,const_0
		sts	fsys_sectnr0,const_0
		rcall	fsys_sread		;read sector into buffer
		lds	XL,fsys_buffer+0x1fe	;check MBR signature
		lds	XH,fsys_buffer+0x1ff
		cpi	XL,0x55
		brne	fsys_rdmbr_err
		cpi	XL,0x55
		breq	fsys_rdmbr_0
fsys_rdmbr_err:	ldi	r16,0x01		;NO MBR
		ret

fsys_rdmbr_0:	ldi	YL,LOW(fsys_buffer+0x1c2)
		ldi	YH,HIGH(fsys_buffer+0x1c2)
		ldi	XH,4
		clr	r16			;OK
fsys_rdmbr_1:	ld	XL,Y
		cpi	XL,0x06			;FAT16
		breq	fsys_rdmbr_3
		adiw	YL,16
		dec	XH
		brne	fsys_rdmbr_1
		ldi	r16,0x02		;NO FAT16 partition
fsys_rdmbr_2:	ret
		;set address of boot sector
fsys_rdmbr_3:	ldd	XH,Y+4
		sts	fsys_sectnr0,XH
		ldd	XH,Y+5
		sts	fsys_sectnr1,XH
		ldd	XH,Y+6
		sts	fsys_sectnr2,XH
		ldd	XH,Y+7
		sts	fsys_sectnr3,XH
		ret

;-----------------------------------------------------------------------------
; read boot sector
;-----------------------------------------------------------------------------
fsys_rbs:	rcall	fsys_sread		;read sector into buffer
		lds	XL,fsys_buffer+0x0b
		cpi	XL,0x00			;only 512 bytes/sector allowed
		brne	fsys_rbs_err
		lds	XL,fsys_buffer+0x0c
		cpi	XL,0x02			;only 512 bytes/sector allowed
		breq	fsys_rbs_1

fsys_rbs_err:	ldi	r16,0x03		;wrong geometry
		ret

fsys_rbs_1:	lds	XL,fsys_buffer+0x0d	;sectors per cluster
		sts	fsys_clsec,XL		;store

		lds	XL,fsys_buffer+0x0e	;reserved sectors
		lds	XH,fsys_buffer+0x0f
		clr	YL
		clr	YH
		rcall	fsys_addsec		;add reserved sectors

		push	r16
		push	r17
		push	r18

		lds	r16,fsys_buffer+0x16	;sectors per FAT
		lds	r17,fsys_buffer+0x17
		lds	r18,fsys_buffer+0x10	;number of FAT copies

		mul	r16,r18
		movw	XL,r0
		clr	YL
		clr	YH
		mul	r17,r18
		add	XH,r0
		adc	YL,r1
		adc	YH,const_0
		pop	r18
		pop	r17
		pop	r16
		rcall	fsys_addsec		;add FAT sectors, we got the address of root directory
		ret

;-----------------------------------------------------------------------------
; read root directory
;-----------------------------------------------------------------------------
fsys_rdir:	rcall	fsys_sread		;read sector into buffer
		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
fsys_rdir_1:	ldi	ZL,LOW(fsys_dirent*2)
		ldi	ZH,HIGH(fsys_dirent*2)
		ld	XL,Y
		cpi	XL,0x00			;no entry
		breq	fsys_rdir_err
		push	YL
		push	YH
		ldi	XH,11			;bytes to compare
fsys_rdir_2:	lpm	r0,Z+			;get ROM data
		ld	r1,Y+			;get buffer data
		cp	r0,r1			;compare
		breq	fsys_rdir_3		;branch if equal
		pop	YH
		pop	YL
		adiw	YL,32			;next entry
		cpi	YH,HIGH(fsys_buffer)+2	;all done?
		brcs	fsys_rdir_1		;branch if not

fsys_rdir_err:	ldi	r16,0x04		;file not found
		ret

fsys_rdir_3:	dec	XH			;bytes counter
		brne	fsys_rdir_2		;next char
		pop	YH
		pop	YL
		push	r16
		push	r17
		push	r18

		ldd	r16,Y+0x1a		;offset
		ldd	r17,Y+0x1b
		ldi	r18,2
		sub	r16,r18
		sbc	r17,const_0

		lds	r18,fsys_clsec
		mul	r16,r18
		movw	XL,r0
		clr	YL
		clr	YH
		mul	r17,r18
		add	XH,r0
		adc	YL,r1
		adc	YH,const_0
		ldi	r17,32			;sectors for directory
		cp	r17,r18			;check if cluster size is bigger
		brcc	fsys_rdir_4
		mov	r17,r18
fsys_rdir_4:	add	XL,r17
		adc	XH,const_0
		adc	YL,const_0
		adc	YH,const_0
		pop	r18
		pop	r17
		pop	r16
		lds	r8,fsys_sectnr0
		lds	r9,fsys_sectnr1
		lds	r10,fsys_sectnr2
		lds	r11,fsys_sectnr3
		rcall	fsys_addsec		;add offset
;		rcall	fsys_viewoffset
		ret

fsys_dirent:	.db	"AX82_IMGBIN",0x00

;-----------------------------------------------------------------------------
; read file size
;-----------------------------------------------------------------------------
fsys_rsize:	rcall	fsys_sread		;read sector into buffer
		lds	XL,fsys_buffer+11
		sts	fsys_maxtape,XL
		ldi	XL,0x01			;offset=1 (head sector)
		ldi	XH,0x00
		ldi	YL,0x00
		ldi	YH,0x00

		rcall	fsys_addsec		;add offset
		lds	XL,fsys_sectnr0
		sts	fsys_offset_l,XL
		lds	XL,fsys_sectnr1
		sts	fsys_offset_m,XL
		lds	XL,fsys_sectnr2
		sts	fsys_offset_h,XL
		lds	XL,fsys_sectnr3
		sts	fsys_offset_e,XL
		ret

;-----------------------------------------------------------------------------
; add sector offset
;-----------------------------------------------------------------------------
fsys_addsec:	push	r16
		lds	r16,fsys_sectnr0
		add	r16,XL
		sts	fsys_sectnr0,r16

		lds	r16,fsys_sectnr1
		adc	r16,XH
		sts	fsys_sectnr1,r16

		lds	r16,fsys_sectnr2
		adc	r16,YL
		sts	fsys_sectnr2,r16

		lds	r16,fsys_sectnr3
		adc	r16,YH
		sts	fsys_sectnr3,r16
		pop	r16
		ret


fsys_viewoffset1:
		push	r16
		lds	r16,fsys_offset_e
		call	sys_hexout
		lds	r16,fsys_offset_h
		call	sys_hexout
		lds	r16,fsys_offset_m
		call	sys_hexout
		lds	r16,fsys_offset_l
		call	sys_hexout
		pop	r16
		ret

fsys_viewoffset:
		push	r16
		lds	r16,fsys_sectnr3
		call	sys_hexout
		lds	r16,fsys_sectnr2
		call	sys_hexout
		lds	r16,fsys_sectnr1
		call	sys_hexout
		lds	r16,fsys_sectnr0
		call	sys_hexout
		pop	r16
		call	vsys_waitkey
		ret
