
intro:		sts	vsys_view,const_1
		sts	vsys_border,const_0
		sei
		ldi	XL,0x05
		sts	vsys_color,XL
		ldi	r19,0x20
		rcall	sys_clear		;clear screen

		rcall	intro_logo

		ldi	XL,0x28
		sts	vsys_color,XL

		ldi	XL,2
		ldi	XH,10
		ldi	ZL,LOW(intro_text*2)
		ldi	ZH,HIGH(intro_text*2)
		rcall	sys_textxy

		ldi	XL,0x05
		sts	vsys_color,XL

		ldi	XL,2
		ldi	XH,13
		ldi	ZL,LOW(text_test1*2)
		ldi	ZH,HIGH(text_test1*2)
		rcall	sys_textxy
		rcall	test1
		rcall	sys_checkerr

		ldi	XL,0x05
		sts	vsys_color,XL


		ldi	XL,2
		ldi	XH,14
		ldi	ZL,LOW(text_test2*2)
		ldi	ZH,HIGH(text_test2*2)
		rcall	sys_textxy
		rcall	test2
		rcall	sys_checkerr

		ldi	XL,0x05
		sts	vsys_color,XL

		ldi	XL,2
		ldi	XH,15
		ldi	ZL,LOW(text_test3*2)
		ldi	ZH,HIGH(text_test3*2)
		rcall	sys_textxy
		rcall	test3
		rcall	sys_checkerr

		ldi	XL,240
		sts	vsys_wait,XL

testloop:	lds	XL,vsys_keycode
		cpi	XL,0x00
		brne	testloop_1
		lds	XL,vsys_wait
		cpi	XL,0
		brne	testloop

testloop_1:	call	fsys_init

		ldi	XL,120
		sts	vsys_wait,XL

testloop_2:	lds	XL,vsys_wait
		cpi	XL,0
		brne	testloop_2

		ret


intro_frame:	clr	XL
		clr	XH
		rcall	sys_gotoxy
		ldi	r19,'#'		;upleft corner
		rcall	sys_char
		rcall	sys_char
		rcall	intro_out30
		ldi	r18,22
intro_frame_1:	ldi	r19,'#'
		rcall	sys_char
		ldi	r19,' '
		rcall	intro_out30
		ldi	r19,'#'
		rcall	sys_char
		dec	r18
		brne	intro_frame_1
		ldi	r19,'#'		;upleft corner
		rcall	sys_char
		rcall	sys_char

intro_out30:	ldi	r17,30
intro_out30_1:	rcall	sys_char
		dec	r17
		brne	intro_out30_1
		ret

intro_logo:	ldi	XL,0x07
		sts	vsys_color,XL
		ldi	XL,1
		ldi	XH,2
		ldi	ZL,LOW(logo_text1*2)
		ldi	ZH,HIGH(logo_text1*2)
		rcall	sys_textxy

		ldi	XL,0x06
		sts	vsys_color,XL
		ldi	XL,1
		ldi	XH,3
		ldi	ZL,LOW(logo_text2*2)
		ldi	ZH,HIGH(logo_text2*2)
		rcall	sys_textxy

		ldi	XL,0x05
		sts	vsys_color,XL
		ldi	XL,1
		ldi	XH,4
		ldi	ZL,LOW(logo_text3*2)
		ldi	ZH,HIGH(logo_text3*2)
		rcall	sys_textxy

		ldi	XL,0x04
		sts	vsys_color,XL
		ldi	XL,1
		ldi	XH,5
		ldi	ZL,LOW(logo_text4*2)
		ldi	ZH,HIGH(logo_text4*2)
		rcall	sys_textxy

		ldi	XL,0x03
		sts	vsys_color,XL
		ldi	XL,1
		ldi	XH,6
		ldi	ZL,LOW(logo_text5*2)
		ldi	ZH,HIGH(logo_text5*2)
		rcall	sys_textxy

		ldi	XL,0x02
		sts	vsys_color,XL
		ldi	XL,1
		ldi	XH,7
		ldi	ZL,LOW(logo_text6*2)
		ldi	ZH,HIGH(logo_text6*2)
		rcall	sys_textxy

		ldi	XL,0x01
		sts	vsys_color,XL
		ldi	XL,1
		ldi	XH,8
		ldi	ZL,LOW(logo_text7*2)
		ldi	ZH,HIGH(logo_text7*2)
		rcall	sys_textxy

		ldi	XL,0x07
		sts	vsys_color,XL

		ret
;------------------------------------------------------------------------------
; RAM-TEST 1 (eigene Adresse einzeln)
;------------------------------------------------------------------------------
test1:		mov	reg_roml,const_0
		ldi	XL,0
		ldi	XH,0
test1_l1:	putmembyte XL,XL,XH
		mov	YL,XL
		com	YL
		out	PORTC,YL
		nop
		nop
		nop
		nop
		getmembyte YL,XL,XH
		cp	XL,YL
		brne	test1_f1
		add	XL,const_1
		adc	XH,const_0
		brcc	test1_l1
		ldi	r16,0
		ret
test1_f1:	ldi	r16,0xff
		mov	YH,XL
		ret


;------------------------------------------------------------------------------
; RAM-TEST 2 (eigene Adresse LOW)
;------------------------------------------------------------------------------
test2:		mov	reg_roml,const_0
		ldi	XL,0
		ldi	XH,0
test2_l1:	putmembyte XL,XL,XH
		add	XL,const_1
		adc	XH,const_0
		brcc	test2_l1
		ldi	XL,0
		ldi	XH,0
test2_l2:	getmembyte YL,XL,XH
		cp	XL,YL
		brne	test2_f1
		add	XL,const_1
		adc	XH,const_0
		brcc	test2_l2
		ldi	r16,0
		ret
test2_f1:	ldi	r16,1
		mov	YH,XL
		ret

;------------------------------------------------------------------------------
; RAM-TEST 3 (eigene Adresse HIGH)
;------------------------------------------------------------------------------
test3:		mov	reg_roml,const_0
		ldi	XL,0
		ldi	XH,0
test3_l1:	putmembyte XL,XL,XH
		add	XL,const_1
		adc	XH,const_0
		brcc	test3_l1
		ldi	XL,0
		ldi	XH,0
test3_l2:	getmembyte YL,XL,XH
		cp	XL,YL
		brne	test3_f1
		add	XL,const_1
		adc	XH,const_0
		brcc	test3_l2
		ldi	r16,0
		ret
test3_f1:	ldi	r16,1
		mov	YH,XL
		ret

logo_text1:	.db "  {{{   {   {    {{{    {{{  ",0x00
logo_text2:	.db " {   {  {   {   {   {  {   { ",0x00
logo_text3:	.db " {   {   { {    {   {     {  ",0x00
logo_text4:	.db " {   {    {      {{{     {   ",0x00
logo_text5:	.db " {{{{{   { {    {   {   {    ",0x00
logo_text6:	.db " {   {  {   {   {   {  {     ",0x00
logo_text7:	.db " {   {  {   {    {{{   {{{{{ ",0x00



intro_text:
	.db	"V0.35 (c) 2014 Joerg Wolfram",0x00,0x00

text_test1:
	.db	"Test1: ",0x00

text_test2:
	.db	"Test2: ",0x00

text_test3:
	.db	"Test3: ",0x00

text_test4:
	.db	"Test4: ",0x00


text_pass:
	.db	"PASS  ",0x00,0x00
	
text_fail:
	.db	"FAIL  ",0x00,0x00

;-----------------------------------------------------------------------------------
; clear system screen
; R19=char
;-----------------------------------------------------------------------------------
sys_clear:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		lds	ZL,vsys_color
		ldi	YH,sys_dfile		;video mem
		ldi	YL,0
		ldi	XH,24
sys_vclear_1:	ldi	XL,32
sys_vclear_2:	st	Y+,r19
		st	Y+,ZL
		dec	XL
		brne	sys_vclear_2
		dec	XH
		brne	sys_vclear_1
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret

;-----------------------------------------------------------------------------------
; set write coords
; XL=X   XH=Y
;-----------------------------------------------------------------------------------
sys_gotoxy:	sts	vsys_xpos,XL
		sts	vsys_ypos,XH
		ret

sys_space:	ldi	r19,0x20

		;write char r19
sys_char:	push	XL
		push	XH
		push	YL
		push	YH
		push	ZL
		lds	XL,vsys_xpos
		lds	XH,vsys_ypos
		cpi	XL,32
		brcs	sys_char_0
		clr	XL
		inc	XH
sys_char_0:	cpi	XH,24
		brcs	sys_char_1
		clr	XH
sys_char_1:	ldi	YL,0
		ldi	YH,sys_dfile
		ldi	ZL,64
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0
		add	YL,XL
		adc	YH,const_0
		st	Y+,r19
		lds	ZL,vsys_color
		st	Y+,ZL
		inc	XL			;next X
		sts	vsys_xpos,XL
		sts	vsys_ypos,XH
		pop	ZL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret


		;write a bit 6 terminated string from flash to screen
sys_textxy:	rcall	sys_gotoxy
sys_flashtext:	lpm	r19,Z+
		cpi	r19,0x00
		breq	sys_ftext_1
		rcall	sys_char		;write to screen
		rjmp	sys_flashtext
sys_ftext_1:	ret


sys_hexout:	push	r16
		push	r19
		mov	r19,r16
		swap	r19
		andi	r19,0x0f
		subi	r19,0xd0
		cpi	r19,0x3a
		brcs	sys_hexout_1
		subi	r19,0xf9
sys_hexout_1:	rcall	sys_char
		mov	r19,r16
		andi	r19,0x0f
		subi	r19,0xd0
		cpi	r19,0x3a
		brcs	sys_hexout_2
		subi	r19,0xf9
sys_hexout_2:	rcall	sys_char
		pop	r19
		pop	r16
		ret


sys_checkerr:	cpi	r16,0x00		;PASS
		brne	sys_checkerr_1
		ldi	XL,0x04
		sts	vsys_color,XL
		ldi	ZL,LOW(text_pass*2)
		ldi	ZH,HIGH(text_pass*2)
		rcall	sys_flashtext
		ret

sys_checkerr_1:	ldi	ZL,LOW(text_fail*2)
		ldi	ZH,HIGH(text_fail*2)
		push	XL
		ldi	XL,0x02
		sts	vsys_color,XL
		pop	XL
		rcall	sys_flashtext
		mov	r16,XH
		rcall	sys_hexout
		mov	r16,XL
		rcall	sys_hexout
		ldi	r19,' '
		rcall	sys_char
		mov	r16,YH			;soll
		rcall	sys_hexout
		ldi	r19,'-'
		rcall	sys_char
		ldi	r19,'>'
		rcall	sys_char
		mov	r16,YL			;ist
		rcall	sys_hexout
		ret
