;################################################################################
;#										#
;# fsys - file system library							#
;# copyright (c) 2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU  General Public				#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU  General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


fsys_sc_init:	lds	XL,vsys_border
		sts	mon_tborder,XL
		sts	vsys_border,const_0
		ldi	XL,0x05
		sts	vsys_color,XL
		sts	vsys_view,const_1
		ldi	r19,0x00
		jmp	sys_clear

;------------------------------------------------------------------------------
; LLIST
;------------------------------------------------------------------------------
fsys_llist:	push	r20
		rcall	fsys_sc_init
		ldi	ZL,LOW(fsys_lftxt0*2)
		ldi	ZH,HIGH(fsys_lftxt0*2)
fsys_ll_head:	clr	XL
		clr	XH
		call	sys_textxy
;		call	fsys_viewoffset1

		sts	fsys_selfile,const_0		;first file selected

		lds	XL,fsys_status
		sbrc	XL,7
		rjmp	fsys_llist_lp

fsys_llist_err:	ldi	ZL,LOW(fsys_lntxt*2)
		ldi	ZH,HIGH(fsys_lntxt*2)
		ldi	XL,0x10
		sts	vsys_color,XL
		ldi	XL,12
		ldi	XH,12
		call	sys_textxy
fsys_llist_e1:	call	vsys_waitkey
		cpi	r16,0xed			;ESC = end
		brne	fsys_llist_e1
		rjmp	fsys_llist_end

fsys_llist_lp:	ldi	XL,0x38
		sts	vsys_color,XL
		ldi	ZL,LOW(fsys_ltxt*2)
		ldi	ZH,HIGH(fsys_ltxt*2)
		clr	XL
		ldi	XH,2
		call	sys_textxy
		lds	r18,fsys_tapenr		;tape number
		rcall	fsys_dec3

		ldi	r19,'/'
		rcall	sys_char

		lds	r18,fsys_maxtape	;max. tape number
		rcall	fsys_dec3

		rcall	fsys_fl_view		;show file list
		rjmp	fsys_llist_lp1

fsys_llist_ld:	lds	XL,fsys_selfile
		sts	fsys_filenr,XL
		call	fsys_readfile
		jmp	fsys_llist_lp

fsys_llist_sv:	lds	XL,fsys_selfile
		sts	fsys_filenr,XL
		rcall	fsys_fname
		call	fsys_writefile
		jmp	fsys_llist_lp



fsys_llist_lp1:	call	vsys_waitkey
		cpi	r16,'L'				;load
		breq	fsys_llist_ld
		cpi	r16,'S'				;save
		breq	fsys_llist_sv
		cpi	r16,0xe4			;up
		breq	fsys_ll_pf			;prev file
		cpi	r16,0xe5			;down
		breq	fsys_ll_nf			;next file
		cpi	r16,0xe7			;page up
		breq	fsys_ll_pu
		cpi	r16,0xe6			;page down
		breq	fsys_ll_pd
		cpi	r16,0xe9			;delete file
		breq	fsys_ll_fdel
		cpi	r16,0xee			;delete all
		breq	fsys_ll_adel
		cpi	r16,0xe2			;left
		breq	fsys_ll_cb0			;clear bit 0
		cpi	r16,0xe3			;down
		breq	fsys_ll_sb0			;set bit 0
		cpi	r16,0xed			;exit
		brne	fsys_llist_lp1

fsys_llist_end:	sts	vsys_keycode,const_0
		sts	vsys_view,const_0
		lds	XL,mon_tborder
		sts	vsys_border,XL
		pop	r20
		jmp	monitor_end_2

fsys_ll_pu:	lds	ZL,fsys_tapenr
		lds	ZH,fsys_maxtape
		inc	ZL
		cp	ZH,ZL
		brcc	fsys_ll_pu1
		clr	ZL
fsys_ll_pu1:	sts	fsys_tapenr,ZL
		rjmp	fsys_llist_lp

fsys_ll_pd:	lds	ZL,fsys_tapenr
		lds	ZH,fsys_maxtape
		sub	ZL,const_1
		brcc	fsys_ll_pu1
		mov	ZL,ZH
		rjmp	fsys_ll_pu1

fsys_ll_pf:	lds	XL,fsys_selfile
		subi	XL,0x02

fsys_ll_pf1:	andi	XL,0x1f
		sts	fsys_selfile,XL
		rjmp	fsys_llist_lp

fsys_ll_nf:	lds	XL,fsys_selfile
		subi	XL,0xfe
		rjmp	fsys_ll_pf1

fsys_ll_cb0:	lds	XL,fsys_selfile
		andi	XL,0xfe
		rjmp	fsys_ll_pf1

fsys_ll_sb0:	lds	XL,fsys_selfile
		ori	XL,0x01
		rjmp	fsys_ll_pf1

fsys_ll_adel:	rjmp	fsys_ll_adelx

fsys_ll_fdel:	rcall	fsys_askfc
		sbrs	r20,0			;Y/N
		rjmp	fsys_llist_lp
		lds	XL,fsys_selfile
		sts	fsys_filenr,XL
		rcall	fsys_delfile
		rjmp	fsys_llist_lp

fsys_ll_adelx:	rcall	fsys_askfa
		sbrs	r20,0			;Y/N
		rjmp	fsys_llist_lp

		sts	fsys_filenr,const_0	;start file number
fsys_ll_adel_1:	rcall	fsys_delfile
		lds	XL,fsys_filenr
		inc	XL
		sts	fsys_filenr,XL
		cpi	XL,32
		brcs	fsys_ll_adel_1
		sts	fsys_filenr,const_0	;start file number
		rjmp	fsys_llist_lp

;-------------------------------------------------------------------------------
; view filelist, r17=inverse entry (set to 0xff if no inverse entry sould be shown)
;-------------------------------------------------------------------------------
fsys_fl_view:	sts	fsys_filenr,const_0		;start file number
		ldi	XL,0
		ldi	XH,4
		call	sys_gotoxy

fsys_fl_5:	ldi	r16,0x38		;black on white
		sts	vsys_color,r16
		lds	r18,fsys_filenr		;file number
		ldi	r19,0x30		;'0'
fsys_fl_6:	cpi	r18,10
		brcs	fsys_fl_7
		subi	r18,10
		inc	r19
		rjmp	fsys_fl_6
fsys_fl_7:	call	sys_char

		ldi	r19,0x30		;'0'
		add	r19,r18
		call	sys_char
		lds	XL,vsys_xpos
		inc	XL
		sts	vsys_xpos,XL

		call	fsys_rname		;get name
		ldi	XL,0x05
		lds	ZL,fsys_selfile
		lds	ZH,fsys_filenr
		cp	ZL,ZH
		brne	fsys_fl_8
		ldi	XL,0x28
fsys_fl_8:	sts	vsys_color,XL
		ldi	YL,LOW(fsys_buffer)
		ldi	YH,HIGH(fsys_buffer)
		ldi	r18,12
fsys_fl_9:	ld	r19,Y+
		andi	r19,0x7f
		call	sys_char
		dec	r18
		brne	fsys_fl_9
;		call	fsys_viewoffset

		lds	XL,vsys_xpos
		lds	XH,vsys_ypos

		lds	r18,fsys_filenr	;file number
		clr	XL
		sbrs	r18,0
		ldi	XL,16
		sbrc	r18,0
		inc	XH
		sts	vsys_xpos,XL
		sts	vsys_ypos,XH

		inc	r18
		sts	fsys_filenr,r18
		cpi	r18,32
		breq	fsys_fl_9a
		rjmp	fsys_fl_5
fsys_fl_9a:	sts	fsys_filenr,const_0

		ldi	r16,0x07
		sts	vsys_color,r16
		ldi	ZL,LOW(fsys_ftxt*2)	;file name
		ldi	ZH,HIGH(fsys_ftxt*2)
		ldi	XL,0
		ldi	XH,21
		call	sys_textxy
		ldi	r16,0x38
		sts	vsys_color,r16
		ldi	YL,LOW(fsys_buf2)
		ldi	YH,HIGH(fsys_buf2)
		ldi	XH,12
fsys_fl_10:	ld	r19,Y+
		call	sys_char
		dec	XH
		brne	fsys_fl_10
		ret

;-------------------------------------------------------------------------------
; output r18 decimal
;-------------------------------------------------------------------------------
fsys_dec3:	ldi	r19,0x30		;'0'
fsys_dec3_1:	cpi	r18,100
		brcs	fsys_dec3_2
		subi	r18,100
		inc	r19
		rjmp	fsys_dec3_1
fsys_dec3_2:	call	sys_char

		ldi	r19,0x30		;'0'
fsys_dec3_3:	cpi	r18,10
		brcs	fsys_dec3_4
		subi	r18,10
		inc	r19
		rjmp	fsys_dec3_3
fsys_dec3_4:	call	sys_char

		ldi	r19,0x30		;'0'
		add	r19,r18
		jmp	sys_char

;-------------------------------------------------------------------------------
; ask for all clear
;-------------------------------------------------------------------------------
fsys_askfa:	ldi	ZL,LOW(fsys_lask2*2)
		ldi	ZH,HIGH(fsys_lask2*2)
		rjmp	fsys_askfc_0

;-------------------------------------------------------------------------------
; ask for file clear
;-------------------------------------------------------------------------------
fsys_askfc:	ldi	ZL,LOW(fsys_lask1*2)
		ldi	ZH,HIGH(fsys_lask1*2)
fsys_askfc_0:	ldi	r16,0x30
		sts	vsys_color,r16
		ldi	XL,0
		ldi	XH,23
		call	sys_textxy
fsys_askfc_1:	call	vsys_waitkey
		ldi	r20,0
		cpi	r16,'n'			;no
		breq	fsys_askfc_2
		ldi	r20,1
		cpi	r16,'y'			;yes
		breq	fsys_askfc_2
		rjmp	fsys_askfc_1
fsys_askfc_2:

;-------------------------------------------------------------------------------
; ask for file clear
;-------------------------------------------------------------------------------
fsys_ll_clow:	ldi	XL,0
		ldi	XH,23
		ldi	ZL,LOW(fsys_lask0*2)
		ldi	ZH,HIGH(fsys_lask0*2)
		ldi	r16,0x00
		sts	vsys_color,r16
		jmp	sys_textxy

;-------------------------------------------------------------------------------
; Edit file name
;-------------------------------------------------------------------------------
fsys_fname:	ldi	XL,6
		ldi	XH,21
		call	sys_gotoxy
		ldi	r16,0x38
		sts	vsys_color,r16
		ldi	YL,LOW(fsys_buf2+12)
		ldi	YH,HIGH(fsys_buf2+12)
		ldi	ZL,13
fsys_fname_f1:	ld	XL,-Y
		dec	ZL
		breq	fsys_fname_f2		;all done
		cpi	XL,0x20
		breq	fsys_fname_f1
fsys_fname_f2:

fsys_fname_1:	rcall	fsys_fnview
fsys_fname_2:	call	vsys_waitkey
		cpi	r16,0xec			;backspace
		breq	fsys_fname_b
		cpi	r16,0xe2			;left
		breq	fsys_fname_l
		cpi	r16,0xe3			;right
		breq	fsys_fname_r
		cpi	r16,0xea			;enter
		breq	fsys_fname_e

		cpi	r16,0x20			;limit
		brcs	fsys_fname_2
		cpi	r16,'z'+1
		brcc	fsys_fname_2

		cpi	ZL,10
		brcc	fsys_fname_2
		rcall	fsys_fnins
		rjmp	fsys_fname_1


fsys_fname_l:	cpi	ZL,0
		breq	fsys_fname_2
		dec	ZL
		rjmp	fsys_fname_1

fsys_fname_r:	cpi	ZL,12
		breq	fsys_fname_2
		inc	ZL
		rjmp	fsys_fname_1

fsys_fname_e:	ldi	ZL,16
		rcall	fsys_fnview
		ret

fsys_fname_b:	cpi	ZL,0
		breq	fsys_fname_2
		rcall	fsys_fndel
		rjmp	fsys_fname_1

fsys_fnins:	ldi	YL,LOW(fsys_buf2+12)
		ldi	YH,HIGH(fsys_buf2+12)
		movw	XL,YL
		adiw	XL,1
		ldi	r18,11
		sub	r18,ZL
fsys_fnins_1:	ld	r19,-Y
		st	-X,r19
		sub	r18,const_1
		brcc	fsys_fnins_1
		st	-X,r16
		inc	ZL
		ret

fsys_fndel:	ldi	YL,LOW(fsys_buf2)
		ldi	YH,HIGH(fsys_buf2)
		add	YL,ZL
		movw	XL,YL
		sbiw	XL,1
		ldi	r18,12
		sub	r18,ZL
fsys_fndel_1:	ld	r19,Y+
		st	X+,r19
		sub	r18,const_1
		brcc	fsys_fndel_1
		ldi	r19,0x20
		st	X+,r19
		dec	ZL
		ret


fsys_fnview:	ldi	XL,6
		ldi	XH,21
		call	sys_gotoxy
		ldi	r16,0x38
		sts	vsys_color,r16
		ldi	YL,LOW(fsys_buf2)
		ldi	YH,HIGH(fsys_buf2)
		ldi	XH,0
fsys_fnv_10:	ldi	r16,0x38
		sts	vsys_color,r16
		cp	XH,ZL			;active pos
		breq	fsys_fnv_12
		ld	r19,Y+
		call	sys_char
		inc	XH
		cpi	XH,13
		brne	fsys_fnv_10
		ret
fsys_fnv_12:	ldi	r16,0xb0
		sts	vsys_color,r16
		ldi	r19,'L'
		call	sys_char
		inc	XH
		cpi	XH,13
		brne	fsys_fnv_10
		ret


;-------------------------------------------------------------------------------
; some text
;-------------------------------------------------------------------------------
fsys_ltxt:	.db	"FILES ON TAPE ",0x00,0x00

fsys_lntxt:	.db	" NO MEDIA ",0x00,0x00

fsys_letxt:	.db	"<PRESS A KEY>",0x00

fsys_lask0:	.db	"                            ",0x00,0x00
fsys_lask1:	.db	" DELETE FILE? (Y/N) ",0x00,0x00
fsys_lask2:	.db	" DELETE ALL? (Y/N) ",0x00

fsys_lftxt0:	.db	"Tape Manager  ",0x00,0x00

fsys_ftxt:	.db	"File: ",0x00,0x00


