#!/usr/bin/perl
#################################################################################
#										#
# screenshot tool for avr-chipbasic2						#
# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 3		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
use POSIX;
use Fcntl;

$binfile="48k.bin";
$csetfile=">../tables/cset.inc";

$dlen = -s $binfile;

open (BREAD, $binfile);
binmode(BREAD);

seek(BREAD,15616,0);
open (DWRITE,$csetfile);
for($i=0;$i<2048;$i++)
{
	$plines[$i]=0;
}

for($i=0;$i<32;$i++)
{
	for($j=0;$j<8;$j++)
	{
		$normal=0;
		$invers=255-$normal;
		$plines[$i+256*$j]=$normal;
		$plines[$i+256*$j+128]=$invers;
	}
}


for($i=32;$i<128;$i++)
{
	for($j=0;$j<8;$j++)
	{
		read(BREAD,$ibyte,1);
		$normal=ord($ibyte);
		if($i==123)
		{
			$normal=255;
		}
		if($i==124)
		{
			$normal=255>>$j;
		}
		if($i==125)
		{
			$normal=255>>(8-$j);
		}
		
		
		$invers=255-$normal;
		$plines[$i+256*$j]=$normal;
		$plines[$i+256*$j+128]=$invers;
	}
}
for($i=0;$i<2048;$i++)
{
	if(($i%16)==0)
	{
		$bs=$i;
		$cstart=$i%256;
		$cline=($i-$cstart)/256+1;
		print DWRITE "\t\t.db ";
	}
	$iwert=$plines[$i];
	if($iwert==0)
	{
		print DWRITE "0x00";
	}
	else
	{
		printf DWRITE "%#2.2x",$iwert;
	}
	if(($i%16)<15)
	{
		print DWRITE ",";
	}
	else
	{
		printf DWRITE "\t; Line:%d Char:%#2.2x\n",$cline,$cstart;
	}
	
}


close(DWRITE);

close(BREAD);
