;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;--------------------------------------------------------------------------------
; video mode definitions for TV (PAL mode)
;--------------------------------------------------------------------------------
.if clock == 24
	.equ	vsys_counter_t = 1536		;24MHz / Fhor
	.equ	vsys_hint_t = 252		;horizontal INT
	.equ	vsys_hstart_t = 38		;horizontal data start
	.equ	vsys_hslen_t = 112		;HSYNC length
	.equ	vsys_bend_t = 36		;border end
	.equ	vsys_brate = 47			;(f*2)-1 for 31,25KHz
.endif

.if clock == 25
	.equ	vsys_counter_t = 1600		;25MHz / Fhor
	.equ	vsys_hint_t = 284		;horizontal INT
	.equ	vsys_hstart_t = 70		;horizontal data start
	.equ	vsys_hslen_t = 112		;HSYNC length
	.equ	vsys_bend_t = 36
	.equ	vsys_brate = 49			;(f*2)-1 for 31,25KHz
.endif

.if clock == 27
	.equ	vsys_counter_t = 1728		;27MHz / Fhor
	.equ	vsys_hint_t = 302		;horizontal INT
	.equ	vsys_hstart_t = 88		;horizontal data start
	.equ	vsys_hslen_t = 112		;HSYNC length
	.equ	vsys_bend_t = 36
	.equ	vsys_brate = 53			;(f*2)-1 for 31,25KHz
.endif

.equ	vsys_vstart_t = 241
.equ	vsys_vstop_t = 244
.equ	vsys_vbstart_t = 13
.equ	vsys_vbstop_t = 230
.equ	vsys_vlines_t = 313


;--------------------------------------------------------------------------------
; video mode definitions for VGA
;--------------------------------------------------------------------------------
.equ	vsys_counter_v = 800		;25MHz / Fhor
.equ	vsys_hslen_v = 92
.equ	vsys_hint_v = 109
.equ	vsys_hstart_v = 154

.equ	vsys_vstart_v = 226
.equ	vsys_vstop_v = 228
.equ	vsys_vbstart_v = 237
.equ	vsys_vbstop_v = 224
.equ	vsys_vlines_v = 263
.equ	vsys_bend_v = 17

