;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2012 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

vint_frame:	ldi	XL,0xff
		mov	vline_l,XL		;line_l=0
		mov	vline_h,XL		;line_h=0
;decrement frame counter
		lds	XL,vsys_wait
		dec	XL
		sts	vsys_wait,XL

		ldi	XL,HIGH(emu_jitab)
		out	EEARL,XL

		ldi	XH,0x7f
		lds	XL,vsys_wait
		sbrc	XL,5
		ldi	XH,0xff
		sts	vsys_blink,XH

		lds	XL,vsys_keycode
		cpi	XL,0xf5			;reset
		brne	vint_frame_nr
		ldi	XL,HIGH(emu_jrtab)
		out	EEARL,XL
		rjmp	vint_frame_1

vint_frame_nr:	cpi	XL,0xee			;CTRL-ALT-DEL
		brne	vint_frame_1
		lds	XH,vsys_kbdstate
		sbrs	XH,2
		rjmp	vint_frame_1
vint_frame_res:	cli				;disable further interrupts
		rjmp	vint_frame_res

vint_frame_1:	lds	XH,vsys_view
		sbrc	XH,0
		rjmp	vint_frame_sys		;special view

;--------------------------------------------------------------------------------
; vint handling for normal mode
;--------------------------------------------------------------------------------
vint_frame_nm:	call	vsys_skeys_sp

vint_frame_2:	sbi	GPIOR0,int_flag
		lds	XL,vsys_keycode
		cpi	XL,0xfc			;mon?
		brne	vint_frame_3
		sbi	GPIOR0,break_flag
		cbi	GPIOR0,go_flag
		ldi	XH,HIGH(emu_jitab)
		out	EEARL,XH
vint_frame_3:
		cpi	XL,0xf9			;llist?
		brne	vint_frame_4
		sbi	GPIOR0,llist_flag
		ldi	XH,HIGH(emu_jitab)
		out	EEARL,XH
vint_frame_4:
		sbic	GPIOR0,7		;check mode
		rjmp	vint_frame_10		;TV

		ldi	ZL,LOW(vint_vg0)
		ldi	ZH,HIGH(vint_vg0)
		rjmp	vint_frame_15

vint_frame_10:	ldi	ZL,LOW(vint_tv0)
		ldi	ZH,HIGH(vint_tv0)

vint_frame_15:	out	GPIOR1,ZL
		out	GPIOR2,ZH

vint_pkbd:;	call	vsys_setkeys		;fill key buffer
		jmp	vsys_keyb

vint_frame_sys:	ldi	XL,0x00
		ldi	XH,sys_dfile
		sts	vsys_rampos_l,XL
		sts	vsys_rampos_h,XH

		sbic	GPIOR0,7
		rjmp	vint_frame_mt		;TV

vint_frame_mv:	ldi	ZL,LOW(vint_vg8)
		ldi	ZH,HIGH(vint_vg8)
		out	GPIOR1,ZL
		out	GPIOR2,ZH
		rjmp	vint_pkbd

vint_frame_mt:	ldi	ZL,LOW(vint_tv8)
		ldi	ZH,HIGH(vint_tv8)
		out	GPIOR1,ZL
		out	GPIOR2,ZH
		rjmp	vint_pkbd
