;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


vint_tv0_nv:	mov	ZL,XL			;1 copy table pointer
		ldi	ZH,HIGH(vint_tv0_jtab)
		ijmp

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_tv0:	movw	XL,vline_l
		sbrc	vline_h,0		;1 skip if less than 256
		rjmp	vint_tv0_nv		;2 no visible line
		cpi	XL,192			;1 max lines
		brcc	vint_tv0_nv

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_tv0_10:;	rjmp	vint_tv0_end

vint_tv0_sy0:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,vsys_hstart_t	;1
		brcs	vint_tv0_sy0		;1 loop
vint_tv0_sy_01:	cpi	XL,vsys_hstart_t+1
		brcs	vint_tv0_sy_02
vint_tv0_sy_02:	cpi	XL,vsys_hstart_t+2
		brcs	vint_tv0_sy_03
vint_tv0_sy_03:	cpi	XL,vsys_hstart_t+3
		brcs	vint_tv0_sy_04
vint_tv0_sy_04:	cpi	XL,vsys_hstart_t+4
		brcs	vint_tv0_sy_05
vint_tv0_sy_05:

vint_tv0_vout:	push	r16			;2
		lds	r16,vsys_blink		;2 00/ff
		movw	ZL,vline_l		;2
		lsl	ZL			;1
		rol	ZH			;1
		lsl	ZL			;1
		rol	ZH			;1
		andi	ZH,0x03			;1
		subi	ZH,0x5c			;1
		lpm	XL,Z+			;3
		lpm	XH,Z+			;3
		lpm	YH,Z+			;3
		ldi	YL,32			;1

		sbi	PORTB,2			;2 enable DISPLAY

vint_tv0_vl:	nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		out	PORTA,XL		;1 LOW address
		out	PIND,const_2		;1 register
		out	PORTA,XH		;1 HIGH address PIXDATA
		out	PIND,const_2		;1 switch back register signal
		nop				;1
		nop				;1
		in	ZL,PINC			;1 get PIXDATA
		out	PORTA,YH		;1 HIGH address ATTRDATA
		inc	XL			;1 prepare next LOW addr
		nop				;1
		nop				;1
		in	ZH,PINC			;1 get ATTRDATA
		out	PORTA,ZL		;1 out PIXDATA (C6)
		and	ZH,r16			;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		dec	YL			;1
		out	PORTA,ZH		;1 OUT ATTRDATA (C7)
		brne	vint_tv0_vl		;2

		nop
		nop
		pop	r16
		nop
		nop

		cbi	PORTB,2			;2 disable display
		lds	YL,vsys_border		;set output to border
		out	PORTA,YL

vint_tv0_22:	mov	YH,vline_l		;
		andi	YH,0x07
		cpi	YH,0x07
		rjmp	vsys_keyb
		breq	vint_tv0_vkey

		pop	XL			;2
		out	SREG,XL			;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

vint_tv0_vkey:	rjmp	vsys_keyb

.org (PC+255) & 0xff00
;-------------------------------------------------------------------------------
;jump table
;-------------------------------------------------------------------------------
vint_tv0_jtab:	rjmp	vsys_keyb		;0
		rjmp	vsys_keyb		;1
		rjmp	vsys_keyb		;2
		rjmp	vsys_keyb		;3
		rjmp	vsys_keyb		;4
		rjmp	vsys_keyb		;5
		rjmp	vsys_keyb		;6
		rjmp	vsys_keyb		;7
		rjmp	vsys_keyb		;8
		rjmp	vsys_keyb		;9
		rjmp	vsys_keyb		;10
		rjmp	vsys_keyb		;11
		rjmp	vsys_keyb		;12
		rjmp	vint_tv0_bs		;13 vertical border start
		rjmp	vsys_keyb		;14
		rjmp	vsys_keyb		;15

		rjmp	vsys_keyb		;16
		rjmp	vsys_keyb		;17
		rjmp	vsys_keyb		;18
		rjmp	vsys_keyb		;19
		rjmp	vsys_keyb		;20
		rjmp	vsys_keyb		;21
		rjmp	vsys_keyb		;22
		rjmp	vsys_keyb		;23
		rjmp	vsys_keyb		;24
		rjmp	vsys_keyb		;25
		rjmp	vsys_keyb		;26
		rjmp	vsys_keyb		;27
		rjmp	vsys_keyb		;28
		rjmp	vsys_keyb		;29
		rjmp	vsys_keyb		;30
		rjmp	vsys_keyb		;31

		rjmp	vsys_keyb		;32
		rjmp	vsys_keyb		;33
		rjmp	vsys_keyb		;34
		rjmp	vsys_keyb		;35
		rjmp	vsys_keyb		;36
		rjmp	vsys_keyb		;37
		rjmp	vsys_keyb		;38
		rjmp	vsys_keyb		;39
		rjmp	vsys_keyb		;40
		rjmp	vsys_keyb		;41
		rjmp	vsys_keyb		;42
		rjmp	vsys_keyb		;43
		rjmp	vsys_keyb		;44
		rjmp	vsys_keyb		;45
		rjmp	vsys_keyb		;46
		rjmp	vsys_keyb		;47

		rjmp	vsys_keyb		;48
		rjmp	vsys_keyb		;49
		rjmp	vsys_keyb		;50
		rjmp	vsys_keyb		;51
		rjmp	vsys_keyb		;52
		rjmp	vsys_keyb		;53
		rjmp	vsys_keyb		;54
		rjmp	vsys_keyb		;55
		rjmp	vsys_keyb		;56
		rjmp	vint_frame		;57 frame end (PAL)
		rjmp	vsys_keyb		;58
		rjmp	vsys_keyb		;59
		rjmp	vsys_keyb		;60
		rjmp	vsys_keyb		;61
		rjmp	vsys_keyb		;62
		rjmp	vsys_keyb		;63

		rjmp	vsys_keyb		;64
		rjmp	vsys_keyb		;65
		rjmp	vsys_keyb		;66
		rjmp	vsys_keyb		;67
		rjmp	vsys_keyb		;68
		rjmp	vsys_keyb		;69
		rjmp	vsys_keyb		;70
		rjmp	vsys_keyb		;71
		rjmp	vsys_keyb		;72
		rjmp	vsys_keyb		;73
		rjmp	vsys_keyb		;74
		rjmp	vsys_keyb		;75
		rjmp	vsys_keyb		;76
		rjmp	vsys_keyb		;77
		rjmp	vsys_keyb		;78
		rjmp	vsys_keyb		;79

		rjmp	vsys_keyb		;80
		rjmp	vsys_keyb		;81
		rjmp	vsys_keyb		;82
		rjmp	vsys_keyb		;83
		rjmp	vsys_keyb		;84
		rjmp	vsys_keyb		;85
		rjmp	vsys_keyb		;86
		rjmp	vsys_keyb		;87
		rjmp	vsys_keyb		;88
		rjmp	vsys_keyb		;89
		rjmp	vsys_keyb		;90
		rjmp	vsys_keyb		;91
		rjmp	vsys_keyb		;92
		rjmp	vsys_keyb		;93
		rjmp	vsys_keyb		;94
		rjmp	vsys_keyb		;95

		rjmp	vsys_keyb		;96
		rjmp	vsys_keyb		;97
		rjmp	vsys_keyb		;98
		rjmp	vsys_keyb		;99
		rjmp	vsys_keyb		;100
		rjmp	vsys_keyb		;101
		rjmp	vsys_keyb		;102
		rjmp	vsys_keyb		;103
		rjmp	vsys_keyb		;104
		rjmp	vsys_keyb		;105
		rjmp	vsys_keyb		;106
		rjmp	vsys_keyb		;107
		rjmp	vsys_keyb		;108
		rjmp	vsys_keyb		;109
		rjmp	vsys_keyb		;110
		rjmp	vsys_keyb		;111

		rjmp	vsys_keyb		;112
		rjmp	vsys_keyb		;113
		rjmp	vsys_keyb		;114
		rjmp	vsys_keyb		;115
		rjmp	vsys_keyb		;116
		rjmp	vsys_keyb		;117
		rjmp	vsys_keyb		;118
		rjmp	vsys_keyb		;119
		rjmp	vsys_keyb		;120
		rjmp	vsys_keyb		;121
		rjmp	vsys_keyb		;122
		rjmp	vsys_keyb		;123
		rjmp	vsys_keyb		;124
		rjmp	vsys_keyb		;125
		rjmp	vsys_keyb		;126
		rjmp	vsys_keyb		;127

		rjmp	vsys_keyb		;128
		rjmp	vsys_keyb		;129
		rjmp	vsys_keyb		;130
		rjmp	vsys_keyb		;131
		rjmp	vsys_keyb		;132
		rjmp	vsys_keyb		;133
		rjmp	vsys_keyb		;134
		rjmp	vsys_keyb		;135
		rjmp	vsys_keyb		;136
		rjmp	vsys_keyb		;137
		rjmp	vsys_keyb		;138
		rjmp	vsys_keyb		;139
		rjmp	vsys_keyb		;140
		rjmp	vsys_keyb		;141
		rjmp	vsys_keyb		;142
		rjmp	vsys_keyb		;143

		rjmp	vsys_keyb		;144
		rjmp	vsys_keyb		;145
		rjmp	vsys_keyb		;146
		rjmp	vsys_keyb		;147
		rjmp	vsys_keyb		;148
		rjmp	vsys_keyb		;149
		rjmp	vsys_keyb		;150
		rjmp	vsys_keyb		;151
		rjmp	vsys_keyb		;152
		rjmp	vsys_keyb		;153
		rjmp	vsys_keyb		;154
		rjmp	vsys_keyb		;155
		rjmp	vsys_keyb		;156
		rjmp	vsys_keyb		;157
		rjmp	vsys_keyb		;158
		rjmp	vsys_keyb		;159

		rjmp	vsys_keyb		;160
		rjmp	vsys_keyb		;161
		rjmp	vsys_keyb		;162
		rjmp	vsys_keyb		;163
		rjmp	vsys_keyb		;164
		rjmp	vsys_keyb		;165
		rjmp	vsys_keyb		;166
		rjmp	vsys_keyb		;167
		rjmp	vsys_keyb		;168
		rjmp	vsys_keyb		;169
		rjmp	vsys_keyb		;170
		rjmp	vsys_keyb		;171
		rjmp	vsys_keyb		;172
		rjmp	vsys_keyb		;173
		rjmp	vsys_keyb		;174
		rjmp	vsys_keyb		;175

		rjmp	vsys_keyb		;176
		rjmp	vsys_keyb		;177
		rjmp	vsys_keyb		;178
		rjmp	vsys_keyb		;179
		rjmp	vsys_keyb		;180
		rjmp	vsys_keyb		;181
		rjmp	vsys_keyb		;182
		rjmp	vsys_keyb		;183
		rjmp	vsys_keyb		;184
		rjmp	vsys_keyb		;185
		rjmp	vsys_keyb		;186
		rjmp	vsys_keyb		;187
		rjmp	vsys_keyb		;188
		rjmp	vsys_keyb		;189
		rjmp	vsys_keyb		;190
		rjmp	vsys_keyb		;191

		rjmp	vsys_keyb		;192 -> begin offscreen
		rjmp	vint_tv0_ksens		;193 clock=0
		rjmp	vint_tv0_kclk1		;194 clock=1
		rjmp	vint_tv0_load		;195 load register
		rjmp	vint_tv0_shift		;196 set shift mode
		rjmp	vint_tv0_kclkt		;197 set to input
		rjmp	vint_tv0_ksens		;198 get bit 7 and set to 0
		rjmp	vint_tv0_kclk1		;199 clock out next bit
		rjmp	vint_tv0_kclkt		;200 set to input
		rjmp	vint_tv0_ksens		;201 get bit 6 and set to 0
		rjmp	vint_tv0_kclk1		;202 clock out next bit
		rjmp	vint_tv0_kclkt		;203 set to input
		rjmp	vint_tv0_ksens		;204 get bit 5 and set to 0
		rjmp	vint_tv0_kclk1		;205 clock out next bit
		rjmp	vint_tv0_kclkt		;206 set to input
		rjmp	vint_tv0_ksens		;207 get bit 4 and set to 0

		rjmp	vint_tv0_kclk1		;208 clock out next bit
		rjmp	vint_tv0_kclkt		;209 set to input
		rjmp	vint_tv0_ksens		;210 get bit 3 and set to 0
		rjmp	vint_tv0_kclk1		;211 clock out next bit
		rjmp	vint_tv0_kclkt		;212 set to input
		rjmp	vint_tv0_ksens		;213 get bit 2 and set to 0
		rjmp	vint_tv0_kclk1		;214 clock out next bit
		rjmp	vint_tv0_kclkt		;215 set to input
		rjmp	vint_tv0_ksens		;216 get bit 1 and set to 0
		rjmp	vint_tv0_kclk1		;217 clock out next bit
		rjmp	vint_tv0_kclkt		;218 set to input
		rjmp	vint_tv0_ksens		;219 get bit 0 and set to 0
		rjmp	vint_tv0_ktran		;220 transfer data
		rjmp	vsys_keyb		;221
		rjmp	vsys_keyb		;222
		rjmp	vsys_keyb		;223

		rjmp	vsys_keyb		;224
		rjmp	vsys_keyb		;225
		rjmp	vsys_keyb		;226
		rjmp	vsys_keyb		;227
		rjmp	vsys_keyb		;228
		rjmp	vsys_keyb		;229
		rjmp	vsys_keyb		;230
		rjmp	vsys_keyb		;231
		rjmp	vint_tv0_be		;232	vertical border end
		rjmp	vsys_keyb		;233
		rjmp	vsys_keyb		;234
		rjmp	vsys_keyb		;235
		rjmp	vsys_keyb		;236
		rjmp	vsys_keyb		;237
		rjmp	vsys_keyb		;238
		rjmp	vsys_keyb		;239

		rjmp	vsys_keyb		;240
		rjmp	vint_tv0_vs		;241	vertical sync start
		rjmp	vsys_keyb		;242
		rjmp	vsys_keyb		;243
		rjmp	vint_tv0_ve		;244	vertical sync end
		rjmp	vsys_keyb		;245
		rjmp	vsys_keyb		;246
		rjmp	vsys_keyb		;247
		rjmp	vsys_keyb		;248
		rjmp	vsys_keyb		;249
		rjmp	vsys_keyb		;250
		rjmp	vsys_keyb		;251
		rjmp	vsys_keyb		;252
		rjmp	vsys_keyb		;253
		rjmp	vsys_keyb		;254
		rjmp	vsys_keyb		;255


vint_tv0_vs:	cbi	PORTD,7
		ldi	XL,0x82
		sts	TCCR1A,XL
		rjmp	vsys_keyb

vint_tv0_ve:	sbi	PORTD,7
		ldi	XL,0xc2
		sts	TCCR1A,XL
		rjmp	vsys_keyb

vint_tv0_bs:	ldi	XL,0x33
		sts	TCCR2A,XL
		rjmp	vsys_keyb

vint_tv0_be:	ldi	XL,0x03
		sts	TCCR2A,XL
		cbi	PORTD,6			;OFF
		rjmp	vsys_keyb

vint_tv0_load:	cbi	PORTD,2			;SH/LD
		sbi	DDRD,2			;set to output
		rjmp	vsys_keyb

vint_tv0_shift:	sbi	PORTD,2			;SH/LD
		rjmp	vsys_keyb

vint_tv0_kclk1:	sbi	PORTD,3
		rjmp	vsys_keyb

vint_tv0_kclkt:	cbi	DDRD,3			;clock tristate
		rjmp	vsys_keyb

vint_tv0_ksens:	lds	XL,vsys_ktemp
		lsl	XL
		sbic	PIND,3
		inc	XL
		sts	vsys_ktemp,XL
		cbi	PORTD,3			;clock 0
		sbi	DDRD,3			;output
		rjmp	vsys_keyb

vint_tv0_ktran:	lds	XL,vsys_ktemp
		ldi	YH,0xbf
		sbrs	XL,6
		eor	XL,YH
		sts	vsys_kempston,XL
		rjmp	vsys_keyb
