;################################################################################
;#										#
;# vsys - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
vint_vg8:	movw	XL,vline_l
		lsr	XH
		ror	XL
		sbrc	XH,0			;1 skip if less than 256
		rjmp	vint_vg8_01		;2 no visible line
		cpi	XL,192			;1 max lines
		brcs	vint_vg8_10

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
vint_vg8_01:	cpi	XL,vsys_vstart_v
		brne	vint_vg8_02		;no vsync start
		cbi	PORTD,7
		rjmp	vint_vg8_end

vint_vg8_02:	cpi	XL,vsys_vstop_v
		brne	vint_vg8_03		;no vsync stop
		sbi	PORTD,7
		rjmp	vint_vg8_end

vint_vg8_03:	cpi	XL,vsys_vbstart_v
		brne	vint_vg8_04		;no border start
		ldi	XL,0x33
		sts	TCCR2A,XL
		rjmp	vint_vg8_end

vint_vg8_04:	cpi	XL,vsys_vbstop_v
		brne	vint_vg8_05		;no border stop
		ldi	XL,0x03
		sts	TCCR2A,XL
		cbi	PORTD,6			;OFF
		rjmp	vint_vg8_end

vint_vg8_05:	cpi	XL,7
		breq	vint_vg8_06		;2 end of frame
		rjmp	vint_vg8_end

vint_vg8_06:	jmp	vint_frame

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vint_vg8_10:

vint_vg8_sy0:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,vsys_hstart_v	;1
		brcs	vint_vg8_sy0		;1 loop
vint_vg8_sy_01:	cpi	XL,vsys_hstart_v+1
		brcs	vint_vg8_sy_02
vint_vg8_sy_02:	cpi	XL,vsys_hstart_v+2
		brcs	vint_vg8_sy_03
vint_vg8_sy_03:	cpi	XL,vsys_hstart_v+3
		brcs	vint_vg8_sy_04
vint_vg8_sy_04:	cpi	XL,vsys_hstart_v+4
		brcs	vint_vg8_sy_05
vint_vg8_sy_05:

vint_vg8_mon:	push	r16			;2
		lds	r16,vsys_blink		;2 00/ff
		mov	ZH,vline_l		;2
		lsr	ZH			;1
		andi	ZH,0x07			;1
		subi	ZH,256-HIGH(vsys_ctable*2)	;1
		lds	XL,vsys_rampos_l	;2
		lds	XH,vsys_rampos_h	;2
		ldi	YL,32			;1
		nop				;1 filling
		nop				;1 filling
		nop				;1 filling
		nop				;1 filling
;		nop				;1 filling
;		nop				;1 filling
;		nop				;1 filling
;		nop				;1 filling
;		nop				;1 filling
		sbi	PORTB,2			;2 enable DISPLAY

vint_vg8_vl:	nop				;1 filling
		ld	ZL,X+			;2 get char
		ld	YH,X+			;2 get attr
		lpm	ZL,Z			;3 get pixl
		out	PORTA,ZL		;1 out PIXDATA (C6)
		and	YH,r16			;1
		nop				;1
		dec	YL			;1
		nop				;1
		out	PORTA,YH		;1 OUT ATTRDATA (C7)
		brne	vint_vg8_vl		;2

		cbi	PORTB,2			;2 disable display
		lds	YL,vsys_border
		out	PORTA,YL
		pop	r16

		mov	ZH,vline_l		;2
		andi	ZH,0x0f			;1
		cpi	ZH,0x0f			;1
		brne	vint_vg8_e1		;1
		sts	vsys_rampos_l,XL	;2
		sts	vsys_rampos_h,XH	;2
vint_vg8_end:	jmp	vsys_keyb

vint_vg8_e1:	pop	XL
		out	SREG,XL			;1 put back
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		reti				;4 thats all

