#!/usr/bin/perl
#################################################################################
#										#
# data generator								#
# copyright (c) 2010-2017 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 3		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
use POSIX;
use Fcntl;

$infile=$ARGV[0];
$datfile=">".$ARGV[1];
$head=$ARGV[2];

$dlen=(-s $infile);

printf "IN: $infile ($dlen bytes)\n";

open (BREAD, $infile);
	read(BREAD,$ftext,$dlen);
close(BREAD);

$zpos=0;

$whead="HTTP/1.1 200 OK\nContent-length: $dlen\nContent-type: text/html\n\n";

if($head eq"web_busy")
{
#	$whead="HTTP/1.1 200 OX\nContent-length: $dlen\nContent-type: text/html\n\n";
}


$wdata=$whead.$ftext;

while((length($wdata) % 16) > 0)
{
	$wdata.=" ";
}
$wlen=length($wdata);

$zpos=0;
$vpos=0;

for($i=0;$i<$wlen-5;$i++)
{
	if(substr($wdata,$i,5) eq "44444")
	{
		$zpos=$i;
	}
}

for($i=0;$i<$wlen-7;$i++)
{
	if(substr($wdata,$i,7) eq "zzzzzzz")
	{
		$vpos=$i;
	}
}




open (DWRITE,$datfile);

if($zpos > 0)
{
	print DWRITE "#define ".uc($head)."_ZPOS $zpos\n\n"; 
}

if($vpos > 0)
{
	print DWRITE "#define ".uc($head)."_VPOS $vpos\n\n"; 
}

print DWRITE "char ".$head."[$wlen] = {";

for($i=0;$i<($wlen);$i++)
{
	if(($i%16)==0)
	{
		printf DWRITE "// %d\n\t\t",$i;
	}
	printf DWRITE "0x%02X",ord(substr($wdata,$i,1));
	if($i<(($wlen)-1))
	{
		print DWRITE ",";
	}
}
print DWRITE "};\n";

close(DWRITE);

#print $wdata;
