//###############################################################################
//#										#
//# UPROG2 universal programmer							#
//#										#
//# copyright (c) 2010-2016 Joerg Wolfram (joerg@jcwolfram.de)			#
//#										#
//#										#
//# This program is free software; you can redistribute it and/or		#
//# modify it under the terms of the GNU General Public License			#
//# as published by the Free Software Foundation; either version 3		#
//# of the License, or (at your option) any later version.			#
//#										#
//# This program is distributed in the hope that it will be useful,		#
//# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
//# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
//# General Public License for more details.					#
//#										#
//# You should have received a copy of the GNU General Public			#
//# License along with this library// if not, write to the			#
//# Free Software Foundation, Inc., 59 Temple Place - Suite 330,		#
//# Boston, MA 02111-1307, USA.							#
//#										#
//###############################################################################

#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<termios.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/ipc.h>
#include<sys/shm.h>

#include <main.h>
#include <devices.h>
#include <algorithm.h>
#include <wires.h>

extern int daemon_task(void);
extern int webserver(void);
extern int webserver2(void);

int main(int argc, char *argv[])
{
	int ii,jj,pids,shmid;
	pid_t mypid;
	int errcode=0;
	servermode=0;
	
	force_exit=0;

	is_error=0;
	jj=0;
	do
	{
		jj++;
	}while(strncmp("END",valid_devices[jj].name,20) != 0);
	
	jj-=3;	//sub common functions

	//try to allocate memory for programming data
	memory = malloc(ROFFSET * 2 * sizeof(unsigned char));

	if(memory == NULL)
	{
		printf("No memory available\n");
		return 1;
	}
	
	pids=getpids("uprog2");

	printf("\n");
	printf("#################################################################################\n");
	printf("#                                                                               #\n");
	printf("#  UNI-Programmer UPROG2 V1.28                                                  #\n");
	printf("#                                                                               #\n");
	printf("#  (c) 2012-2017 Joerg Wolfram                                                  #\n");
	printf("#                                                                               #\n");
	printf("#  usage: uprog2 device -commands [file/data]                                   #\n");
	printf("#         uprog2 KILL                            kill active daemon             #\n");
	printf("#         uprog2 LIST                            for device list                #\n");
	printf("#         uprog2 device -help                    for device specific commands   #\n");
	printf("#                                                                               #\n");
	printf("#     0 types in database                                                       #\n",jj);
	printf("#                                                                               #\n");
	printf("#################################################################################\n");

	if(argc < 2)
	{
		printf("\nNot enough parameters. \nusage: uprog model -commands [file/data]\n\n");
		return 1;
	}

	if(pids > 2)
	{
		printf("\nuprog2 is already started. Cannot start another instance.\n\n");
		return 1;
	}

	if(strncmp(argv[1],"LIST",4) == 0)
	{
		list_devices();
		return(0);	
	}


	if(strncmp(argv[1],"WEBGUI",6) == 0)
	{
		servermode=1;
		webserver2();
		force_exit=1;
	}

	if((strncmp(argv[1],"KILL",4) != 0) && (force_exit == 0))
	{

		if(pids == 1)
		{
			printf("\nuprog2 daemon is not active, starting daemon and searching for programmer...\n\n");		

			mypid=fork();
		
			if(mypid == 0)
			{
				return(daemon_task());
			}
			else
			{	//wait until daemon is active
				usleep(200000);
			}
		}
	}

#if DEBUG_OUTPUT == 1
		printf("!!! DEBUG MODE ACTIVATED !!!\n\n");
#endif

	shmid=shmget(1887699,SHM_SIZE,0);
	if(shmid < 0) 
	{
		printf("Shared memory segment is not available. Possible daemon is not active.\n\n"); return 1;
	}
	
	shm=shmat(shmid,NULL,0);
	if(shm == (unsigned char *) -1)
	{
		printf("Cannot attach memory segment.\n\n"); return 1;
	}

	//wait for deamon to find a programmer
	usleep(10000);
	while(shm[0] == 0) usleep(1000);
	
	
	if(shm[0] == 0x1f)
	{
		printf("No programmer found, aborting\n\n"); 
		shm[0]=1;					//force exit
		shmdt(shm);
		return 1;
	}

	if(shm[2] == 2)
	{
		printf(">> USB programmer is active.\n\n"); 
		shm[0]=1;					//send ACK to daemon
		interface_type=2;
	}

	if(shm[2] == 1)
	{
		printf(">> Bluetooth programmer is active.\n\n"); 
		shm[0]=1;					//send ACK to daemon
		interface_type=1;
	}


	//now search par 1 for a valid device
	jj=0;
	dev_found=0;
	do
	{
		if(strncmp(argv[1],valid_devices[jj].name,20) == 0)
		{
			dev_found = 1;
			algo_nr=valid_devices[jj].algo;
			strncpy(name,valid_devices[jj].name,20);
			for(ii=0;ii<19;ii++)
			{
				param[ii]=valid_devices[jj].par[ii];
			}
		}
		jj++;
	}while(strncmp("END",valid_devices[jj].name,20) != 0);

	if(force_exit == 1)
	{
		algo_nr=101;
		dev_found=1;
		printf("force exit from webserver\n");
	}

	if(algo_nr == 100)
	{
		list_devices();
		return(0);
	}

	if(dev_found == 0)
	{
		printf("no supported model found\n\n");
		return 1;
	}


	if(algo_nr < 80)
	{
//		printf("ALGO: 0 \n",algo_nr);
		printf("***  can be programmed with:  ***\n\n",name,cables[algo_nr]);
	}	

	// (dummy)devices >99 (LIST,KILL,WSERVER) need no command
	if((algo_nr < 100) || (algo_nr > 109))
	{
		cmd_found = 0;
		if(argc > 2)
		{
			//search for cmd string
			if (strncmp(argv[2],"-",1) == 0)
			{
				strncpy(cmd,argv[2],80);
				cmd_found = 1;
			}
		}

		if(cmd_found == 0)
		{
			printf("no command selected\n\n");
			return 1;
		}
	}

	//check for file
	file_found = 0;		//no file
	have_expar = 0;		//no parameter
	
	if(argc > 3)
	{
		if(strncmp("0x",argv[3],2) == 0)
		{
			sscanf(strndup(argv[3],10),"0",&expar);
			printf("PARAM  =  0x0\n",expar);
			have_expar=1;
		}
		else if(strncmp("d:",argv[3],2) == 0)
		{
			sscanf(strndup(argv[3]+2,10),"0",&expar);
			printf("PARAM  =  0\n",expar);
			have_expar=1;
		}			
		else
		{
			file_found=1;				//we have a filename
			file_mode=0;				//Motorola S-Record
			strncpy(sfile,argv[3],280);
			if(strstr(sfile,".hex")) file_mode=1;	//Intel hex	
			if(strstr(sfile,".HEX")) file_mode=1;	//Intel hex	
			datei=fopen(sfile,"r");
			if(datei != NULL)
			{
				fclose(datei);
				file_found=2;		//we can read the file
			}
		}	
	}

	
	if(algo_nr == 110)
	{
		tfile_found=1;				//we have a filename
		tfile_mode=0;				//Motorola S-Record
		strncpy(tfile,argv[4],280);
		if(strstr(tfile,".hex")) tfile_mode=1;	//Intel hex	
		if(strstr(tfile,".HEX")) tfile_mode=1;	//Intel hex	
		datei=fopen(tfile,"r");
		if(tdatei != NULL)
		{
			fclose(tdatei);
			tfile_found=2;		//we can read the file
		}
	}


	if(algo_nr < 100)
	{
		errcode=read_info();
		if(errcode == 0) read_volt();
		if(errcode == 0) check_update();
		if(errcode == 0) prg_comm(0x0f,100,100,0,0,0,0,0,0);
	}
//	bt_test();

	if(errcode == 0)
	{
		switch (algo_nr)
		{
			case 1:		errcode=prog_s08();		break;
			case 2:		errcode=prog_r8c();		break;
			case 3:		errcode=prog_avr();		break;
			case 4:		errcode=prog_msp430a();		break;
			case 5:		errcode=prog_msp430b();		break;
			case 6:		errcode=prog_s12xe();		break;
			case 7:		errcode=prog_s12xd();		break;
			case 8:		errcode=prog_stm8();		break;
			case 9:		errcode=prog_c2000();		break;
			case 10:	errcode=prog_dspic33();		break;
			case 11:	errcode=prog_s12xs();		break;
			case 12:	errcode=prog_nec2();		break;
			case 13:	errcode=prog_rl78();		break;
			case 14:	errcode=prog_pic16a();		break;
			case 15:	errcode=prog_pic16b();		break;
			case 16:	errcode=prog_ppcbam();		break;
			case 17:	errcode=prog_pic18a();		break;
			case 18:	errcode=prog_dspic30();		break;
			case 20:	errcode=prog_st7f();		break;
			case 21:	errcode=prog_i2c();		break;
			case 22:	errcode=prog_spiflash();	break;
			case 23:	errcode=prog_dataflash();	break;



			case 30:	errcode=prog_xc9500();		break;
			case 31:	errcode=prog_cc25xx();		break;
			case 32:	errcode=prog_psoc4();		break;
			case 33:	errcode=prog_stm32swd();	break;	//f0
			case 34:	errcode=prog_stm32swd();	break;	//f1
			case 35:	errcode=prog_stm32swd();	break;	//f2
			case 36:	errcode=prog_stm32swd();	break;	//f3
			case 37:	errcode=prog_stm32swd();	break;	//f4
			case 38:	errcode=prog_pic16a();		break;	//pic12
			case 40:	errcode=prog_atxmega();		break;


			case 43:	errcode=prog_mlx363();		break;
			case 44:	errcode=prog_ppcjtag();		break;
			case 45:	errcode=prog_ppcjtag2();	break;

			case 47:	errcode=prog_spieeprom();	break;
			case 97:	errcode=prog_fgen();		break;
			case 96:	errcode=prog_la1m();		break;
			case 95:	errcode=prog_la100k();		break;
			case 94:	errcode=prog_la10k();		break;

			case 101:	printf("Shutting down daemon and disconnect programmer...\n");
					shm[0]=0x2f;
					break;

			case 99:	update();			//update
					break;

			case 104:	errcode=webserver2();		//webserver mode
					break;

			case 110:	errcode=s19tohex();		//dataset converter mode
					break;

			default:
			printf("WRONG ALGORITHM\n");
		}
		
	}
	if((algo_nr < 101) && (errcode != 0x9f))
	{
		prg_comm(0xfa,0,0,0,0,0,0,0,0);	//set back to 3,3V mode
	}

	if(errcode == 0x9f)
	{
		printf("FATAL: CONNECTION TO PROGRAMMER LOST!\n");
		printf("   <<< PLEASE RESET PROGRAMMER >>>\n");
	}

	free(memory);
	return 0;
}
