;################################################################################
;#										#
;# Z80 emulator									#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;--------------------------------------------------------------------------------
; optimization flags
;--------------------------------------------------------------------------------
.def		PC_L = r24
.def		PC_H = r25
.def		SP_L = r4
.def		SP_H = r5

.def		reg_f = r20
.def		reg_a = r21
.def		reg_l = r22
.def		reg_h = r23

.def		reg_c = r8
.def		reg_b = r9
.def		reg_e = r10
.def		reg_d = r11

;ATMega flags
.equ		aflag_c = 0		;carry
.equ		aflag_z = 1		;zero
.equ		aflag_p = 3		;P/V
.equ		aflag_s = 2		;signum
.equ		aflag_h = 5		;half carry
.equ		nflag = 0

.equ		flags_setc = 0x01
.equ		flags_clrc = 0xfe
.equ		flags_setz = 0x02
.equ		flags_clrz = 0xfd
.equ		flags_sets = 0x04
.equ		flags_clrs = 0xfb
.equ		flags_seth = 0x20
.equ		flags_clrh = 0xdf
.equ		flags_setp = 0x08
.equ		flags_clrp = 0xf7


.equ		zreg_c1		= z80emu_ram+0
.equ		zreg_b1		= z80emu_ram+1
.equ		zreg_e1		= z80emu_ram+2
.equ		zreg_d1		= z80emu_ram+3
.equ		zreg_l1		= z80emu_ram+4
.equ		zreg_h1		= z80emu_ram+5
.equ		zreg_f1		= z80emu_ram+6
.equ		zreg_a1		= z80emu_ram+7
.equ		zreg_r		= z80emu_ram+8
.equ		zreg_i		= z80emu_ram+9
.equ		zreg_ixl	= z80emu_ram+10
.equ		zreg_ixh	= z80emu_ram+11
.equ		zreg_iyl	= z80emu_ram+12
.equ		zreg_iyh	= z80emu_ram+13

.equ		z80_iflag	= z80emu_ram+14
.equ		z80_iflagtemp	= z80emu_ram+15
.equ		z80_imode	= z80emu_ram+16
.equ		z80_fsave	= z80emu_ram+17
