;################################################################################
;#										#
;# Z80 emulator		 							#
;# copyright (c) 2009-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;--------------------------------------------------------------------------------
; memory handling
;--------------------------------------------------------------------------------
.macro getpcbyte
		getmembyte	@0,PC_L,PC_H	;10/11
		adiw	PC_L,1			;2 increment PC
.endmacro

.macro getpcbyte_m1
		getmembyte	@0,PC_L,PC_H	;10/11
		inc_refresh			;refresh register
		adiw	PC_L,1			;2 increment PC
.endmacro

.macro getpcword
		getmembyte	@0,PC_L,PC_H
		adiw	PC_L,1			;2 increment PC
		getmembyte	@1,PC_L,PC_H
		adiw	PC_L,1			;2 increment PC
.endmacro

.macro getidbyte
		movw	XL,r0			;2 index register
		add	XL,@1
		adc	XH,const_0
		sbrc	@1,7
		dec	XH
		getmembyte	@0,XL,XH
.endmacro

.macro putidbyte
		movw	XL,r0			;2 index register
		add	XL,@1
		adc	XH,const_0
		sbrc	@1,7
		dec	XH
		putmembyte	@0,XL,XH
.endmacro

.macro putidbyte1
		putmembyte	@0,XL,XH
.endmacro


;--------------------------------------------------------------------------------
; N flag
;--------------------------------------------------------------------------------
.macro z80_setnflag
		sbi	GPIOR0,nflag
.endm

.macro z80_clrnflag
		cbi	GPIOR0,nflag
.endm

;--------------------------------------------------------------------------------
; shift and rotate
;--------------------------------------------------------------------------------
.macro z80_rlc1
		bst	@0,7			;1 save bit 7 for further use
		lsl	@0			;1
		bld	@0,0			;1
.endm


.macro z80_rl1
		bst	@0,7			;1 save bit 7 for new carry
		lsr	reg_f			;1
		rol	@0			;1
.endm

.macro z80_rrc1
		bst	@0,0			;1
		lsr	@0			;1
		bld	@0,7			;1
.endm

.macro z80_rr1
		bst	@0,0			;1 new carry
		lsr	reg_f			;1
		ror	@0			;1
.endm

.macro z80_sla1
		bst	@0,7
		lsl	@0			;1
.endm

.macro z80_sls1
		bst	@0,7
		lsl	@0			;1
		or	@0,const_1
.endm

.macro z80_sra1
		mov	r18,@0
		lsl	r18
		bst	@0,0
		ror	@0			;1
.endm

.macro z80_srl1
		bst	@0,0
		lsr	@0			;1
.endm



.macro z80_rlc
		z80_rlc1 @0
		mov	ZL,@0			;1
.endm

.macro z80_rl
		z80_rl1 @0
		mov	ZL,@0			;1
.endm

.macro z80_rrc
		z80_rrc1 @0
		mov	ZL,@0			;1
.endm

.macro z80_rr
		z80_rr1 @0
		mov	ZL,@0			;1
.endm

.macro z80_sla
		z80_sla1 @0
		mov	ZL,@0			;1
.endm

.macro z80_sls
		z80_sls1 @0
		mov	ZL,@0			;1
.endm

.macro z80_sra
		z80_sra1 @0
		mov	ZL,@0			;1
.endm

.macro z80_srl
		z80_srl1 @0
		mov	ZL,@0			;1
.endm


;--------------------------------------------------------------------------------
; bit functions
;--------------------------------------------------------------------------------
.macro z80_bit
		mov	r18,@0
		andi	r18,@1
		jmp	emu_and1
.endm

.macro z80_res
		ldi	r18,255-(1<<@1)
		and	@0,r18
.endm

.macro z80_set
		ldi	r18,1<<@1
		or	@0,r18
.endm

;--------------------------------------------------------------------------------
; 8 bit arithmetic / logic
;--------------------------------------------------------------------------------
.macro reg_add
		add	reg_a,@0
.endm

.macro reg_adc
		lsr	reg_f			;shift out carry
		adc	reg_a,@0
.endm

.macro reg_sub
		sub	reg_a,@0
.endm

.macro reg_sbc
		lsr	reg_f			;shift out carry
		sez				;set zero flag
		sbc	reg_a,@0
.endm

.macro reg_cmp
		cp	reg_a,@0
.endm

.macro z80_increg
		bst	reg_f,aflag_c		;save old carry
		add	@0,const_1		;+1
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore old carry
		z80_clrnflag
.endm

.macro z80_decreg
		bst	reg_f,aflag_c		;save old carry
		sub	@0,const_1		;+1
		in	reg_f,SREG
		bld	reg_f,aflag_c		;restore old carry
		z80_setnflag
.endm


;--------------------------------------------------------------------------------
; 16 bit arithmetic
;--------------------------------------------------------------------------------
.macro z80_inc16
		add	@0,const_1		;+1
		adc	@1,const_0
.endm

.macro z80_dec16
		sub	@0,const_1		;+1
		sbc	@1,const_0
.endm

.macro z80_add16
		lsr	reg_f			;shift out carry
		add	reg_l,@0
		adc	reg_h,@1
		in	r18,SREG
		rol	reg_f			;shift in new carry
		bst	r18,aflag_h
		bld	reg_f,aflag_h
		z80_clrnflag			;clear N flag
.endm

.macro z80_adc16
		lsr	reg_f			;shift out carry
		adc	reg_l,@0
		adc	reg_h,@1
		in	reg_f,SREG
		cpse	reg_l,reg_h
		andi	reg_f,flags_clrz
		z80_clrnflag			;clear N flag
.endm

.macro z80_sbc16
		lsr	reg_f			;shift out carry
		clz
		sbc	reg_l,@0
		sbc	reg_h,@1
		in	reg_f,SREG
		z80_setnflag			;clear N flag
.endm


;--------------------------------------------------------------------------------
; stack functions
;--------------------------------------------------------------------------------
.macro z80_push
		sub	SP_L,const_1
		sbc	SP_H,const_0
		putmembyte	@1,SP_L,SP_H
		sub	SP_L,const_1
		sbc	SP_H,const_0
		putmembyte	@0,SP_L,SP_H
.endm

.macro z80_pop
		getmembyte	@0,SP_L,SP_H
		add	SP_L,const_1
		adc	SP_H,const_0
		getmembyte	@1,SP_L,SP_H
		add	SP_L,const_1
		adc	SP_H,const_0
.endm

.macro z80_exch
		getmembyte	r16,SP_L,SP_H
		add	SP_L,const_1
		adc	SP_H,const_0
		getmembyte	r17,SP_L,SP_H
		putmembyte	@1,SP_L,SP_H
		sub	SP_L,const_1
		sbc	SP_H,const_0
		putmembyte	@0,SP_L,SP_H
		movw	@0,r16
.endm

;--------------------------------------------------------------------------------
; R register functions
;--------------------------------------------------------------------------------
.macro inc_refresh
	.if use_refresh == 1
		inc	r19
	.endif
.endm

.macro set_refresh
	.if use_refresh == 1
		mov	r19,reg_a
	.endif
.endm

.macro add_refresh
	.if use_refresh == 1
		andi	reg_a,0x80		;bit 7 never changes by refresh
		andi	r19,0x7f		;limit counter
		or	reg_a,r19		;add counter
	.endif
.endm
